# CDMClient
**CDM - Centralized Download Manager Client**
CDMClient is the client application for the [CDM Server](https://github.com/radaron/CDMServer/tree/master).

This client communicates with the CDM Server to periodically send the download status from Transmission and check for new torrent files to download. If new torrents are available, they are downloaded and added to Transmission using the `transmission-rpc` library.

## Installation

### Install or Upgrade the Package
Run the following command to install or upgrade CDMClient:
```shell
python3 -m pip install --upgrade CDMClient --user
```

### Create a Systemd Service
To set up CDMClient as a systemd service, execute the following commands:

1. Create the service file:
   ```shell
   echo "[Unit]
   Description=cdm-client service
   After=multi-user.target
   Conflicts=getty@tty1.service

   [Service]
   User=${USER}
   Type=simple
   Environment=LC_ALL=C.UTF-8
   Environment=LANG=C.UTF-8
   ExecStart=${HOME}/.local/bin/cdm-client
   Restart=on-failure
   RestartSec=3

   [Install]
   WantedBy=multi-user.target" | sudo tee /etc/systemd/system/cdm-client.service
   ```

2. Reload systemd and enable the service:
   ```shell
   sudo systemctl daemon-reload
   sudo systemctl enable cdm-client.service
   sudo systemctl start cdm-client.service
   ```

### Add automatic update (optional)
To keep CDMClient updated automatically, you can add a cron job. Run:
```shell
crontab -e
```
Then add the following line to the crontab file:
```shell
0 3 * * * /usr/bin/python3 -m pip install --upgrade CDMClient --user && systemctl restart cdm-client.service
```

## Configuration
The configuration file is located at:
```~/.config/cdm_client/config.ini```

This file is automatically generated when the service starts. Below is an example configuration:

```ini
[connection]
server_host = "https://cdm.test.com"
api_key = "1409d6ed79280aadcbe20f8f21981e89"
rpc_user = "admin"
rpc_password = "admin"
```

### Configuration Details:
- **`server_host`**: The full URL of the CDM Server (e.g., `https://cdm.server.com`).
- **`api_key`**: The API key generated when adding a new device on the CDM Server's devices page. Refer to the [Devices Page Documentation](https://github.com/radaron/CDMServer/blob/master/doc/USAGE.md#devices-page).
- **`rpc_user`** and **`rpc_password`**: Required only if Transmission RPC authentication is enabled. See the [Transmission RPC Configuration Guide](https://help.ubuntu.com/community/TransmissionHowTo) for more details.

## Viewing Logs
To monitor the service logs, use the following command:
```shell
journalctl -fu cdm-client
```