# Copyright 2016 Game Server Services, Inc. or its affiliates. All Rights
# Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License").
# You may not use this file except in compliance with the License.
# A copy of the License is located at
#
#  http://www.apache.org/licenses/LICENSE-2.0
#
# or in the "license" file accompanying this file. This file is distributed
# on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
# express or implied. See the License for the specific language governing
# permissions and limitations under the License.

from __future__ import annotations

from ..core.model import *
from .model import *


class DescribeNamespacesResult(core.Gs2Result):
    items: List[Namespace] = None
    next_page_token: str = None

    def with_items(self, items: List[Namespace]) -> DescribeNamespacesResult:
        self.items = items
        return self

    def with_next_page_token(self, next_page_token: str) -> DescribeNamespacesResult:
        self.next_page_token = next_page_token
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[DescribeNamespacesResult]:
        if data is None:
            return None
        return DescribeNamespacesResult()\
            .with_items(None if data.get('items') is None else [
                Namespace.from_dict(data.get('items')[i])
                for i in range(len(data.get('items')))
            ])\
            .with_next_page_token(data.get('nextPageToken'))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "items": None if self.items is None else [
                self.items[i].to_dict() if self.items[i] else None
                for i in range(len(self.items))
            ],
            "nextPageToken": self.next_page_token,
        }


class CreateNamespaceResult(core.Gs2Result):
    item: Namespace = None

    def with_item(self, item: Namespace) -> CreateNamespaceResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[CreateNamespaceResult]:
        if data is None:
            return None
        return CreateNamespaceResult()\
            .with_item(Namespace.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class GetNamespaceStatusResult(core.Gs2Result):
    status: str = None

    def with_status(self, status: str) -> GetNamespaceStatusResult:
        self.status = status
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[GetNamespaceStatusResult]:
        if data is None:
            return None
        return GetNamespaceStatusResult()\
            .with_status(data.get('status'))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "status": self.status,
        }


class GetNamespaceResult(core.Gs2Result):
    item: Namespace = None

    def with_item(self, item: Namespace) -> GetNamespaceResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[GetNamespaceResult]:
        if data is None:
            return None
        return GetNamespaceResult()\
            .with_item(Namespace.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class UpdateNamespaceResult(core.Gs2Result):
    item: Namespace = None

    def with_item(self, item: Namespace) -> UpdateNamespaceResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[UpdateNamespaceResult]:
        if data is None:
            return None
        return UpdateNamespaceResult()\
            .with_item(Namespace.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class DeleteNamespaceResult(core.Gs2Result):
    item: Namespace = None

    def with_item(self, item: Namespace) -> DeleteNamespaceResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[DeleteNamespaceResult]:
        if data is None:
            return None
        return DeleteNamespaceResult()\
            .with_item(Namespace.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class GetServiceVersionResult(core.Gs2Result):
    item: str = None

    def with_item(self, item: str) -> GetServiceVersionResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[GetServiceVersionResult]:
        if data is None:
            return None
        return GetServiceVersionResult()\
            .with_item(data.get('item'))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item,
        }


class DumpUserDataByUserIdResult(core.Gs2Result):

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[DumpUserDataByUserIdResult]:
        if data is None:
            return None
        return DumpUserDataByUserIdResult()\

    def to_dict(self) -> Dict[str, Any]:
        return {
        }


class CheckDumpUserDataByUserIdResult(core.Gs2Result):
    url: str = None

    def with_url(self, url: str) -> CheckDumpUserDataByUserIdResult:
        self.url = url
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[CheckDumpUserDataByUserIdResult]:
        if data is None:
            return None
        return CheckDumpUserDataByUserIdResult()\
            .with_url(data.get('url'))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "url": self.url,
        }


class CleanUserDataByUserIdResult(core.Gs2Result):

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[CleanUserDataByUserIdResult]:
        if data is None:
            return None
        return CleanUserDataByUserIdResult()\

    def to_dict(self) -> Dict[str, Any]:
        return {
        }


class CheckCleanUserDataByUserIdResult(core.Gs2Result):

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[CheckCleanUserDataByUserIdResult]:
        if data is None:
            return None
        return CheckCleanUserDataByUserIdResult()\

    def to_dict(self) -> Dict[str, Any]:
        return {
        }


class PrepareImportUserDataByUserIdResult(core.Gs2Result):
    upload_token: str = None
    upload_url: str = None

    def with_upload_token(self, upload_token: str) -> PrepareImportUserDataByUserIdResult:
        self.upload_token = upload_token
        return self

    def with_upload_url(self, upload_url: str) -> PrepareImportUserDataByUserIdResult:
        self.upload_url = upload_url
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[PrepareImportUserDataByUserIdResult]:
        if data is None:
            return None
        return PrepareImportUserDataByUserIdResult()\
            .with_upload_token(data.get('uploadToken'))\
            .with_upload_url(data.get('uploadUrl'))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "uploadToken": self.upload_token,
            "uploadUrl": self.upload_url,
        }


class ImportUserDataByUserIdResult(core.Gs2Result):

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[ImportUserDataByUserIdResult]:
        if data is None:
            return None
        return ImportUserDataByUserIdResult()\

    def to_dict(self) -> Dict[str, Any]:
        return {
        }


class CheckImportUserDataByUserIdResult(core.Gs2Result):
    url: str = None

    def with_url(self, url: str) -> CheckImportUserDataByUserIdResult:
        self.url = url
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[CheckImportUserDataByUserIdResult]:
        if data is None:
            return None
        return CheckImportUserDataByUserIdResult()\
            .with_url(data.get('url'))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "url": self.url,
        }


class DescribeWalletsResult(core.Gs2Result):
    items: List[Wallet] = None
    next_page_token: str = None

    def with_items(self, items: List[Wallet]) -> DescribeWalletsResult:
        self.items = items
        return self

    def with_next_page_token(self, next_page_token: str) -> DescribeWalletsResult:
        self.next_page_token = next_page_token
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[DescribeWalletsResult]:
        if data is None:
            return None
        return DescribeWalletsResult()\
            .with_items(None if data.get('items') is None else [
                Wallet.from_dict(data.get('items')[i])
                for i in range(len(data.get('items')))
            ])\
            .with_next_page_token(data.get('nextPageToken'))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "items": None if self.items is None else [
                self.items[i].to_dict() if self.items[i] else None
                for i in range(len(self.items))
            ],
            "nextPageToken": self.next_page_token,
        }


class DescribeWalletsByUserIdResult(core.Gs2Result):
    items: List[Wallet] = None
    next_page_token: str = None

    def with_items(self, items: List[Wallet]) -> DescribeWalletsByUserIdResult:
        self.items = items
        return self

    def with_next_page_token(self, next_page_token: str) -> DescribeWalletsByUserIdResult:
        self.next_page_token = next_page_token
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[DescribeWalletsByUserIdResult]:
        if data is None:
            return None
        return DescribeWalletsByUserIdResult()\
            .with_items(None if data.get('items') is None else [
                Wallet.from_dict(data.get('items')[i])
                for i in range(len(data.get('items')))
            ])\
            .with_next_page_token(data.get('nextPageToken'))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "items": None if self.items is None else [
                self.items[i].to_dict() if self.items[i] else None
                for i in range(len(self.items))
            ],
            "nextPageToken": self.next_page_token,
        }


class GetWalletResult(core.Gs2Result):
    item: Wallet = None

    def with_item(self, item: Wallet) -> GetWalletResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[GetWalletResult]:
        if data is None:
            return None
        return GetWalletResult()\
            .with_item(Wallet.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class GetWalletByUserIdResult(core.Gs2Result):
    item: Wallet = None

    def with_item(self, item: Wallet) -> GetWalletByUserIdResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[GetWalletByUserIdResult]:
        if data is None:
            return None
        return GetWalletByUserIdResult()\
            .with_item(Wallet.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class DepositByUserIdResult(core.Gs2Result):
    item: Wallet = None

    def with_item(self, item: Wallet) -> DepositByUserIdResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[DepositByUserIdResult]:
        if data is None:
            return None
        return DepositByUserIdResult()\
            .with_item(Wallet.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class WithdrawResult(core.Gs2Result):
    item: Wallet = None
    withdraw_transactions: List[DepositTransaction] = None

    def with_item(self, item: Wallet) -> WithdrawResult:
        self.item = item
        return self

    def with_withdraw_transactions(self, withdraw_transactions: List[DepositTransaction]) -> WithdrawResult:
        self.withdraw_transactions = withdraw_transactions
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[WithdrawResult]:
        if data is None:
            return None
        return WithdrawResult()\
            .with_item(Wallet.from_dict(data.get('item')))\
            .with_withdraw_transactions(None if data.get('withdrawTransactions') is None else [
                DepositTransaction.from_dict(data.get('withdrawTransactions')[i])
                for i in range(len(data.get('withdrawTransactions')))
            ])

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
            "withdrawTransactions": None if self.withdraw_transactions is None else [
                self.withdraw_transactions[i].to_dict() if self.withdraw_transactions[i] else None
                for i in range(len(self.withdraw_transactions))
            ],
        }


class WithdrawByUserIdResult(core.Gs2Result):
    item: Wallet = None
    withdraw_transactions: List[DepositTransaction] = None

    def with_item(self, item: Wallet) -> WithdrawByUserIdResult:
        self.item = item
        return self

    def with_withdraw_transactions(self, withdraw_transactions: List[DepositTransaction]) -> WithdrawByUserIdResult:
        self.withdraw_transactions = withdraw_transactions
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[WithdrawByUserIdResult]:
        if data is None:
            return None
        return WithdrawByUserIdResult()\
            .with_item(Wallet.from_dict(data.get('item')))\
            .with_withdraw_transactions(None if data.get('withdrawTransactions') is None else [
                DepositTransaction.from_dict(data.get('withdrawTransactions')[i])
                for i in range(len(data.get('withdrawTransactions')))
            ])

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
            "withdrawTransactions": None if self.withdraw_transactions is None else [
                self.withdraw_transactions[i].to_dict() if self.withdraw_transactions[i] else None
                for i in range(len(self.withdraw_transactions))
            ],
        }


class DepositByStampSheetResult(core.Gs2Result):
    item: Wallet = None

    def with_item(self, item: Wallet) -> DepositByStampSheetResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[DepositByStampSheetResult]:
        if data is None:
            return None
        return DepositByStampSheetResult()\
            .with_item(Wallet.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class WithdrawByStampTaskResult(core.Gs2Result):
    item: Wallet = None
    withdraw_transactions: List[DepositTransaction] = None
    new_context_stack: str = None

    def with_item(self, item: Wallet) -> WithdrawByStampTaskResult:
        self.item = item
        return self

    def with_withdraw_transactions(self, withdraw_transactions: List[DepositTransaction]) -> WithdrawByStampTaskResult:
        self.withdraw_transactions = withdraw_transactions
        return self

    def with_new_context_stack(self, new_context_stack: str) -> WithdrawByStampTaskResult:
        self.new_context_stack = new_context_stack
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[WithdrawByStampTaskResult]:
        if data is None:
            return None
        return WithdrawByStampTaskResult()\
            .with_item(Wallet.from_dict(data.get('item')))\
            .with_withdraw_transactions(None if data.get('withdrawTransactions') is None else [
                DepositTransaction.from_dict(data.get('withdrawTransactions')[i])
                for i in range(len(data.get('withdrawTransactions')))
            ])\
            .with_new_context_stack(data.get('newContextStack'))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
            "withdrawTransactions": None if self.withdraw_transactions is None else [
                self.withdraw_transactions[i].to_dict() if self.withdraw_transactions[i] else None
                for i in range(len(self.withdraw_transactions))
            ],
            "newContextStack": self.new_context_stack,
        }


class DescribeEventsByUserIdResult(core.Gs2Result):
    items: List[Event] = None
    next_page_token: str = None

    def with_items(self, items: List[Event]) -> DescribeEventsByUserIdResult:
        self.items = items
        return self

    def with_next_page_token(self, next_page_token: str) -> DescribeEventsByUserIdResult:
        self.next_page_token = next_page_token
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[DescribeEventsByUserIdResult]:
        if data is None:
            return None
        return DescribeEventsByUserIdResult()\
            .with_items(None if data.get('items') is None else [
                Event.from_dict(data.get('items')[i])
                for i in range(len(data.get('items')))
            ])\
            .with_next_page_token(data.get('nextPageToken'))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "items": None if self.items is None else [
                self.items[i].to_dict() if self.items[i] else None
                for i in range(len(self.items))
            ],
            "nextPageToken": self.next_page_token,
        }


class GetEventByTransactionIdResult(core.Gs2Result):
    item: Event = None

    def with_item(self, item: Event) -> GetEventByTransactionIdResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[GetEventByTransactionIdResult]:
        if data is None:
            return None
        return GetEventByTransactionIdResult()\
            .with_item(Event.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class VerifyReceiptResult(core.Gs2Result):
    item: Event = None

    def with_item(self, item: Event) -> VerifyReceiptResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[VerifyReceiptResult]:
        if data is None:
            return None
        return VerifyReceiptResult()\
            .with_item(Event.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class VerifyReceiptByUserIdResult(core.Gs2Result):
    item: Event = None

    def with_item(self, item: Event) -> VerifyReceiptByUserIdResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[VerifyReceiptByUserIdResult]:
        if data is None:
            return None
        return VerifyReceiptByUserIdResult()\
            .with_item(Event.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class VerifyReceiptByStampTaskResult(core.Gs2Result):
    item: Event = None
    new_context_stack: str = None

    def with_item(self, item: Event) -> VerifyReceiptByStampTaskResult:
        self.item = item
        return self

    def with_new_context_stack(self, new_context_stack: str) -> VerifyReceiptByStampTaskResult:
        self.new_context_stack = new_context_stack
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[VerifyReceiptByStampTaskResult]:
        if data is None:
            return None
        return VerifyReceiptByStampTaskResult()\
            .with_item(Event.from_dict(data.get('item')))\
            .with_new_context_stack(data.get('newContextStack'))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
            "newContextStack": self.new_context_stack,
        }


class DescribeSubscriptionStatusesResult(core.Gs2Result):
    items: List[SubscriptionStatus] = None

    def with_items(self, items: List[SubscriptionStatus]) -> DescribeSubscriptionStatusesResult:
        self.items = items
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[DescribeSubscriptionStatusesResult]:
        if data is None:
            return None
        return DescribeSubscriptionStatusesResult()\
            .with_items(None if data.get('items') is None else [
                SubscriptionStatus.from_dict(data.get('items')[i])
                for i in range(len(data.get('items')))
            ])

    def to_dict(self) -> Dict[str, Any]:
        return {
            "items": None if self.items is None else [
                self.items[i].to_dict() if self.items[i] else None
                for i in range(len(self.items))
            ],
        }


class DescribeSubscriptionStatusesByUserIdResult(core.Gs2Result):
    items: List[SubscriptionStatus] = None

    def with_items(self, items: List[SubscriptionStatus]) -> DescribeSubscriptionStatusesByUserIdResult:
        self.items = items
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[DescribeSubscriptionStatusesByUserIdResult]:
        if data is None:
            return None
        return DescribeSubscriptionStatusesByUserIdResult()\
            .with_items(None if data.get('items') is None else [
                SubscriptionStatus.from_dict(data.get('items')[i])
                for i in range(len(data.get('items')))
            ])

    def to_dict(self) -> Dict[str, Any]:
        return {
            "items": None if self.items is None else [
                self.items[i].to_dict() if self.items[i] else None
                for i in range(len(self.items))
            ],
        }


class GetSubscriptionStatusResult(core.Gs2Result):
    item: SubscriptionStatus = None

    def with_item(self, item: SubscriptionStatus) -> GetSubscriptionStatusResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[GetSubscriptionStatusResult]:
        if data is None:
            return None
        return GetSubscriptionStatusResult()\
            .with_item(SubscriptionStatus.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class GetSubscriptionStatusByUserIdResult(core.Gs2Result):
    item: SubscriptionStatus = None

    def with_item(self, item: SubscriptionStatus) -> GetSubscriptionStatusByUserIdResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[GetSubscriptionStatusByUserIdResult]:
        if data is None:
            return None
        return GetSubscriptionStatusByUserIdResult()\
            .with_item(SubscriptionStatus.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class AllocateSubscriptionStatusResult(core.Gs2Result):
    item: SubscriptionStatus = None

    def with_item(self, item: SubscriptionStatus) -> AllocateSubscriptionStatusResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[AllocateSubscriptionStatusResult]:
        if data is None:
            return None
        return AllocateSubscriptionStatusResult()\
            .with_item(SubscriptionStatus.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class AllocateSubscriptionStatusByUserIdResult(core.Gs2Result):
    item: SubscriptionStatus = None

    def with_item(self, item: SubscriptionStatus) -> AllocateSubscriptionStatusByUserIdResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[AllocateSubscriptionStatusByUserIdResult]:
        if data is None:
            return None
        return AllocateSubscriptionStatusByUserIdResult()\
            .with_item(SubscriptionStatus.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class TakeoverSubscriptionStatusResult(core.Gs2Result):
    item: SubscriptionStatus = None

    def with_item(self, item: SubscriptionStatus) -> TakeoverSubscriptionStatusResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[TakeoverSubscriptionStatusResult]:
        if data is None:
            return None
        return TakeoverSubscriptionStatusResult()\
            .with_item(SubscriptionStatus.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class TakeoverSubscriptionStatusByUserIdResult(core.Gs2Result):
    item: SubscriptionStatus = None

    def with_item(self, item: SubscriptionStatus) -> TakeoverSubscriptionStatusByUserIdResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[TakeoverSubscriptionStatusByUserIdResult]:
        if data is None:
            return None
        return TakeoverSubscriptionStatusByUserIdResult()\
            .with_item(SubscriptionStatus.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class DescribeRefundHistoriesByUserIdResult(core.Gs2Result):
    items: List[RefundHistory] = None
    next_page_token: str = None

    def with_items(self, items: List[RefundHistory]) -> DescribeRefundHistoriesByUserIdResult:
        self.items = items
        return self

    def with_next_page_token(self, next_page_token: str) -> DescribeRefundHistoriesByUserIdResult:
        self.next_page_token = next_page_token
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[DescribeRefundHistoriesByUserIdResult]:
        if data is None:
            return None
        return DescribeRefundHistoriesByUserIdResult()\
            .with_items(None if data.get('items') is None else [
                RefundHistory.from_dict(data.get('items')[i])
                for i in range(len(data.get('items')))
            ])\
            .with_next_page_token(data.get('nextPageToken'))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "items": None if self.items is None else [
                self.items[i].to_dict() if self.items[i] else None
                for i in range(len(self.items))
            ],
            "nextPageToken": self.next_page_token,
        }


class DescribeRefundHistoriesByDateResult(core.Gs2Result):
    items: List[RefundHistory] = None
    next_page_token: str = None

    def with_items(self, items: List[RefundHistory]) -> DescribeRefundHistoriesByDateResult:
        self.items = items
        return self

    def with_next_page_token(self, next_page_token: str) -> DescribeRefundHistoriesByDateResult:
        self.next_page_token = next_page_token
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[DescribeRefundHistoriesByDateResult]:
        if data is None:
            return None
        return DescribeRefundHistoriesByDateResult()\
            .with_items(None if data.get('items') is None else [
                RefundHistory.from_dict(data.get('items')[i])
                for i in range(len(data.get('items')))
            ])\
            .with_next_page_token(data.get('nextPageToken'))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "items": None if self.items is None else [
                self.items[i].to_dict() if self.items[i] else None
                for i in range(len(self.items))
            ],
            "nextPageToken": self.next_page_token,
        }


class GetRefundHistoryResult(core.Gs2Result):
    item: RefundHistory = None

    def with_item(self, item: RefundHistory) -> GetRefundHistoryResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[GetRefundHistoryResult]:
        if data is None:
            return None
        return GetRefundHistoryResult()\
            .with_item(RefundHistory.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class DescribeStoreContentModelsResult(core.Gs2Result):
    items: List[StoreContentModel] = None

    def with_items(self, items: List[StoreContentModel]) -> DescribeStoreContentModelsResult:
        self.items = items
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[DescribeStoreContentModelsResult]:
        if data is None:
            return None
        return DescribeStoreContentModelsResult()\
            .with_items(None if data.get('items') is None else [
                StoreContentModel.from_dict(data.get('items')[i])
                for i in range(len(data.get('items')))
            ])

    def to_dict(self) -> Dict[str, Any]:
        return {
            "items": None if self.items is None else [
                self.items[i].to_dict() if self.items[i] else None
                for i in range(len(self.items))
            ],
        }


class GetStoreContentModelResult(core.Gs2Result):
    item: StoreContentModel = None

    def with_item(self, item: StoreContentModel) -> GetStoreContentModelResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[GetStoreContentModelResult]:
        if data is None:
            return None
        return GetStoreContentModelResult()\
            .with_item(StoreContentModel.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class DescribeStoreContentModelMastersResult(core.Gs2Result):
    items: List[StoreContentModelMaster] = None
    next_page_token: str = None

    def with_items(self, items: List[StoreContentModelMaster]) -> DescribeStoreContentModelMastersResult:
        self.items = items
        return self

    def with_next_page_token(self, next_page_token: str) -> DescribeStoreContentModelMastersResult:
        self.next_page_token = next_page_token
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[DescribeStoreContentModelMastersResult]:
        if data is None:
            return None
        return DescribeStoreContentModelMastersResult()\
            .with_items(None if data.get('items') is None else [
                StoreContentModelMaster.from_dict(data.get('items')[i])
                for i in range(len(data.get('items')))
            ])\
            .with_next_page_token(data.get('nextPageToken'))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "items": None if self.items is None else [
                self.items[i].to_dict() if self.items[i] else None
                for i in range(len(self.items))
            ],
            "nextPageToken": self.next_page_token,
        }


class CreateStoreContentModelMasterResult(core.Gs2Result):
    item: StoreContentModelMaster = None

    def with_item(self, item: StoreContentModelMaster) -> CreateStoreContentModelMasterResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[CreateStoreContentModelMasterResult]:
        if data is None:
            return None
        return CreateStoreContentModelMasterResult()\
            .with_item(StoreContentModelMaster.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class GetStoreContentModelMasterResult(core.Gs2Result):
    item: StoreContentModelMaster = None

    def with_item(self, item: StoreContentModelMaster) -> GetStoreContentModelMasterResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[GetStoreContentModelMasterResult]:
        if data is None:
            return None
        return GetStoreContentModelMasterResult()\
            .with_item(StoreContentModelMaster.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class UpdateStoreContentModelMasterResult(core.Gs2Result):
    item: StoreContentModelMaster = None

    def with_item(self, item: StoreContentModelMaster) -> UpdateStoreContentModelMasterResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[UpdateStoreContentModelMasterResult]:
        if data is None:
            return None
        return UpdateStoreContentModelMasterResult()\
            .with_item(StoreContentModelMaster.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class DeleteStoreContentModelMasterResult(core.Gs2Result):
    item: StoreContentModelMaster = None

    def with_item(self, item: StoreContentModelMaster) -> DeleteStoreContentModelMasterResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[DeleteStoreContentModelMasterResult]:
        if data is None:
            return None
        return DeleteStoreContentModelMasterResult()\
            .with_item(StoreContentModelMaster.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class DescribeStoreSubscriptionContentModelsResult(core.Gs2Result):
    items: List[StoreSubscriptionContentModel] = None

    def with_items(self, items: List[StoreSubscriptionContentModel]) -> DescribeStoreSubscriptionContentModelsResult:
        self.items = items
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[DescribeStoreSubscriptionContentModelsResult]:
        if data is None:
            return None
        return DescribeStoreSubscriptionContentModelsResult()\
            .with_items(None if data.get('items') is None else [
                StoreSubscriptionContentModel.from_dict(data.get('items')[i])
                for i in range(len(data.get('items')))
            ])

    def to_dict(self) -> Dict[str, Any]:
        return {
            "items": None if self.items is None else [
                self.items[i].to_dict() if self.items[i] else None
                for i in range(len(self.items))
            ],
        }


class GetStoreSubscriptionContentModelResult(core.Gs2Result):
    item: StoreSubscriptionContentModel = None

    def with_item(self, item: StoreSubscriptionContentModel) -> GetStoreSubscriptionContentModelResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[GetStoreSubscriptionContentModelResult]:
        if data is None:
            return None
        return GetStoreSubscriptionContentModelResult()\
            .with_item(StoreSubscriptionContentModel.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class DescribeStoreSubscriptionContentModelMastersResult(core.Gs2Result):
    items: List[StoreSubscriptionContentModelMaster] = None
    next_page_token: str = None

    def with_items(self, items: List[StoreSubscriptionContentModelMaster]) -> DescribeStoreSubscriptionContentModelMastersResult:
        self.items = items
        return self

    def with_next_page_token(self, next_page_token: str) -> DescribeStoreSubscriptionContentModelMastersResult:
        self.next_page_token = next_page_token
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[DescribeStoreSubscriptionContentModelMastersResult]:
        if data is None:
            return None
        return DescribeStoreSubscriptionContentModelMastersResult()\
            .with_items(None if data.get('items') is None else [
                StoreSubscriptionContentModelMaster.from_dict(data.get('items')[i])
                for i in range(len(data.get('items')))
            ])\
            .with_next_page_token(data.get('nextPageToken'))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "items": None if self.items is None else [
                self.items[i].to_dict() if self.items[i] else None
                for i in range(len(self.items))
            ],
            "nextPageToken": self.next_page_token,
        }


class CreateStoreSubscriptionContentModelMasterResult(core.Gs2Result):
    item: StoreSubscriptionContentModelMaster = None

    def with_item(self, item: StoreSubscriptionContentModelMaster) -> CreateStoreSubscriptionContentModelMasterResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[CreateStoreSubscriptionContentModelMasterResult]:
        if data is None:
            return None
        return CreateStoreSubscriptionContentModelMasterResult()\
            .with_item(StoreSubscriptionContentModelMaster.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class GetStoreSubscriptionContentModelMasterResult(core.Gs2Result):
    item: StoreSubscriptionContentModelMaster = None

    def with_item(self, item: StoreSubscriptionContentModelMaster) -> GetStoreSubscriptionContentModelMasterResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[GetStoreSubscriptionContentModelMasterResult]:
        if data is None:
            return None
        return GetStoreSubscriptionContentModelMasterResult()\
            .with_item(StoreSubscriptionContentModelMaster.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class UpdateStoreSubscriptionContentModelMasterResult(core.Gs2Result):
    item: StoreSubscriptionContentModelMaster = None

    def with_item(self, item: StoreSubscriptionContentModelMaster) -> UpdateStoreSubscriptionContentModelMasterResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[UpdateStoreSubscriptionContentModelMasterResult]:
        if data is None:
            return None
        return UpdateStoreSubscriptionContentModelMasterResult()\
            .with_item(StoreSubscriptionContentModelMaster.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class DeleteStoreSubscriptionContentModelMasterResult(core.Gs2Result):
    item: StoreSubscriptionContentModelMaster = None

    def with_item(self, item: StoreSubscriptionContentModelMaster) -> DeleteStoreSubscriptionContentModelMasterResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[DeleteStoreSubscriptionContentModelMasterResult]:
        if data is None:
            return None
        return DeleteStoreSubscriptionContentModelMasterResult()\
            .with_item(StoreSubscriptionContentModelMaster.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class ExportMasterResult(core.Gs2Result):
    item: CurrentModelMaster = None

    def with_item(self, item: CurrentModelMaster) -> ExportMasterResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[ExportMasterResult]:
        if data is None:
            return None
        return ExportMasterResult()\
            .with_item(CurrentModelMaster.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class GetCurrentModelMasterResult(core.Gs2Result):
    item: CurrentModelMaster = None

    def with_item(self, item: CurrentModelMaster) -> GetCurrentModelMasterResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[GetCurrentModelMasterResult]:
        if data is None:
            return None
        return GetCurrentModelMasterResult()\
            .with_item(CurrentModelMaster.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class PreUpdateCurrentModelMasterResult(core.Gs2Result):
    upload_token: str = None
    upload_url: str = None

    def with_upload_token(self, upload_token: str) -> PreUpdateCurrentModelMasterResult:
        self.upload_token = upload_token
        return self

    def with_upload_url(self, upload_url: str) -> PreUpdateCurrentModelMasterResult:
        self.upload_url = upload_url
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[PreUpdateCurrentModelMasterResult]:
        if data is None:
            return None
        return PreUpdateCurrentModelMasterResult()\
            .with_upload_token(data.get('uploadToken'))\
            .with_upload_url(data.get('uploadUrl'))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "uploadToken": self.upload_token,
            "uploadUrl": self.upload_url,
        }


class UpdateCurrentModelMasterResult(core.Gs2Result):
    item: CurrentModelMaster = None

    def with_item(self, item: CurrentModelMaster) -> UpdateCurrentModelMasterResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[UpdateCurrentModelMasterResult]:
        if data is None:
            return None
        return UpdateCurrentModelMasterResult()\
            .with_item(CurrentModelMaster.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class UpdateCurrentModelMasterFromGitHubResult(core.Gs2Result):
    item: CurrentModelMaster = None

    def with_item(self, item: CurrentModelMaster) -> UpdateCurrentModelMasterFromGitHubResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[UpdateCurrentModelMasterFromGitHubResult]:
        if data is None:
            return None
        return UpdateCurrentModelMasterFromGitHubResult()\
            .with_item(CurrentModelMaster.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class DescribeDailyTransactionHistoriesByCurrencyResult(core.Gs2Result):
    items: List[DailyTransactionHistory] = None
    next_page_token: str = None

    def with_items(self, items: List[DailyTransactionHistory]) -> DescribeDailyTransactionHistoriesByCurrencyResult:
        self.items = items
        return self

    def with_next_page_token(self, next_page_token: str) -> DescribeDailyTransactionHistoriesByCurrencyResult:
        self.next_page_token = next_page_token
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[DescribeDailyTransactionHistoriesByCurrencyResult]:
        if data is None:
            return None
        return DescribeDailyTransactionHistoriesByCurrencyResult()\
            .with_items(None if data.get('items') is None else [
                DailyTransactionHistory.from_dict(data.get('items')[i])
                for i in range(len(data.get('items')))
            ])\
            .with_next_page_token(data.get('nextPageToken'))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "items": None if self.items is None else [
                self.items[i].to_dict() if self.items[i] else None
                for i in range(len(self.items))
            ],
            "nextPageToken": self.next_page_token,
        }


class DescribeDailyTransactionHistoriesResult(core.Gs2Result):
    items: List[DailyTransactionHistory] = None
    next_page_token: str = None

    def with_items(self, items: List[DailyTransactionHistory]) -> DescribeDailyTransactionHistoriesResult:
        self.items = items
        return self

    def with_next_page_token(self, next_page_token: str) -> DescribeDailyTransactionHistoriesResult:
        self.next_page_token = next_page_token
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[DescribeDailyTransactionHistoriesResult]:
        if data is None:
            return None
        return DescribeDailyTransactionHistoriesResult()\
            .with_items(None if data.get('items') is None else [
                DailyTransactionHistory.from_dict(data.get('items')[i])
                for i in range(len(data.get('items')))
            ])\
            .with_next_page_token(data.get('nextPageToken'))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "items": None if self.items is None else [
                self.items[i].to_dict() if self.items[i] else None
                for i in range(len(self.items))
            ],
            "nextPageToken": self.next_page_token,
        }


class GetDailyTransactionHistoryResult(core.Gs2Result):
    item: DailyTransactionHistory = None

    def with_item(self, item: DailyTransactionHistory) -> GetDailyTransactionHistoryResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[GetDailyTransactionHistoryResult]:
        if data is None:
            return None
        return GetDailyTransactionHistoryResult()\
            .with_item(DailyTransactionHistory.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }


class DescribeUnusedBalancesResult(core.Gs2Result):
    items: List[UnusedBalance] = None
    next_page_token: str = None

    def with_items(self, items: List[UnusedBalance]) -> DescribeUnusedBalancesResult:
        self.items = items
        return self

    def with_next_page_token(self, next_page_token: str) -> DescribeUnusedBalancesResult:
        self.next_page_token = next_page_token
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[DescribeUnusedBalancesResult]:
        if data is None:
            return None
        return DescribeUnusedBalancesResult()\
            .with_items(None if data.get('items') is None else [
                UnusedBalance.from_dict(data.get('items')[i])
                for i in range(len(data.get('items')))
            ])\
            .with_next_page_token(data.get('nextPageToken'))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "items": None if self.items is None else [
                self.items[i].to_dict() if self.items[i] else None
                for i in range(len(self.items))
            ],
            "nextPageToken": self.next_page_token,
        }


class GetUnusedBalanceResult(core.Gs2Result):
    item: UnusedBalance = None

    def with_item(self, item: UnusedBalance) -> GetUnusedBalanceResult:
        self.item = item
        return self

    def get(self, key, default=None):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return default

    def __getitem__(self, key):
        items = self.to_dict()
        if key in items.keys():
            return items[key]
        return None

    @staticmethod
    def from_dict(
        data: Dict[str, Any],
    ) -> Optional[GetUnusedBalanceResult]:
        if data is None:
            return None
        return GetUnusedBalanceResult()\
            .with_item(UnusedBalance.from_dict(data.get('item')))

    def to_dict(self) -> Dict[str, Any]:
        return {
            "item": self.item.to_dict() if self.item else None,
        }