"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataSource = exports.AccessType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const grafana_datasource_1 = require("./imports/grafana-datasource");
/**
 * Mode for accessing a data source.
 * @see https://grafana.com/docs/grafana/latest/administration/provisioning/#example-data-source-config-file
 */
var AccessType;
(function (AccessType) {
    /**
     * Access via proxy.
     */
    AccessType["PROXY"] = "proxy";
    /**
     * Access directly (via server or browser in UI).
     */
    AccessType["DIRECT"] = "direct";
})(AccessType || (exports.AccessType = AccessType = {}));
/**
 * A Grafana data source.
 * @see https://grafana.com/docs/grafana/latest/administration/provisioning/#example-data-source-config-file
 */
class DataSource extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.name = props.name;
        new grafana_datasource_1.GrafanaDataSource(this, 'Resource', {
            metadata: {
                labels: props.labels,
                namespace: props.namespace,
            },
            spec: {
                name: props.name,
                datasources: [{
                        name: props.name,
                        type: props.type,
                        access: props.access,
                        url: props.url,
                    }],
            },
        });
    }
}
exports.DataSource = DataSource;
_a = JSII_RTTI_SYMBOL_1;
DataSource[_a] = { fqn: "cdk8s-grafana.DataSource", version: "0.1.724" };
//# sourceMappingURL=data:application/json;base64,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