# Ardent SDK

Python SDK for Ardent AI - Simplify your data engineering tasks.

## Installation

```bash
pip install ardent-sdk
```

## Quick Start

### Working with Jobs

```python
from ardent import ArdentClient

# Using context manager
with ArdentClient("your-public-key", "your-secret-key") as client:
    # Create a new job
    job = client.create_job("Create a hello world program")

    # Execute the job
    result = client.execute_job(
        jobID=job["id"],
        message="Create a hello world program",
        files_share_name=job["files_share_name"],
        userID=job["userID"]
    )
    print(result)
```

### Working with Data Connectors

```python
from ardent import ArdentClient

with ArdentClient("your-public-key", "your-secret-key") as client:
    # Setup a complete data connector (create -> discover -> select -> index)
    connector = client.setup_connector(
        service_name="postgresql",
        connection_details={
            "host": "localhost",
            "port": 5432,
            "database": "mydb",
            "username": "user",
            "password": "pass"
        },
        name="Production PostgreSQL",
        selected_paths=["public.users", "public.orders"]
    )

    # Delete a connector when done
    client.delete_connector(connector["id"])
```

## Error Handling

The SDK provides several exception types:
- `ArdentError`: Base exception class
- `ArdentAPIError`: Raised when API requests fail
- `ArdentAuthError`: Raised for authentication issues
- `ArdentValidationError`: Raised for invalid input

## License

This project is licensed under the MIT License - see the LICENSE file for details.
