define([
  'codemirror/lib/codemirror',
  'codemirror/addon/mode/simple'
], function (CodeMirror) {
  'use strict';

  function createBuiltinRegularExpression(words) {
    return new RegExp(words.join('(?!\\\\[(),.]?|[\\w@]+)|') + '(?!\\\\[(),.]?|[\\w@]+)', 'm');
  }

  /* To update this list, use */
  /* >>> from pari_utils.parser import gp_functions */
  /* >>> from textwrap import wrap */
  /* >>> print('\n'.join(wrap(str(list(gp_functions()))[1:-1], initial_indent='    ', subsequent_indent='    '))) */
  var builtin = createBuiltinRegularExpression([
    'Catalan', 'Col', 'Colrev', 'Euler', 'I', 'List', 'Map', 'Mat',
    'Mod', 'O', 'Pi', 'Pol', 'Polrev', 'Qfb', 'Ser', 'Set', 'Str',
    'Strchr', 'Strexpand', 'Strprintf', 'Strtex', 'Vec', 'Vecrev',
    'Vecsmall', 'abs', 'acos', 'acosh', 'addhelp', 'addprimes', 'agm',
    'airy', 'alarm', 'algadd', 'algalgtobasis', 'algaut', 'algb',
    'algbasis', 'algbasistoalg', 'algcenter', 'algcentralproj',
    'algchar', 'algcharpoly', 'algdegree', 'algdep', 'algdim',
    'algdisc', 'algdivl', 'algdivr', 'alggroup', 'alggroupcenter',
    'alghasse', 'alghassef', 'alghassei', 'algindex', 'alginit',
    'alginv', 'alginvbasis', 'algisassociative', 'algiscommutative',
    'algisdivision', 'algisdivl', 'algisinv', 'algisramified',
    'algissemisimple', 'algissimple', 'algissplit', 'alglatadd',
    'alglatcontains', 'alglatelement', 'alglathnf', 'alglatindex',
    'alglatinter', 'alglatlefttransporter', 'alglatmul',
    'alglatrighttransporter', 'alglatsubset', 'algmakeintegral',
    'algmul', 'algmultable', 'algneg', 'algnorm', 'algpoleval',
    'algpow', 'algprimesubalg', 'algquotient', 'algradical',
    'algramifiedplaces', 'algrandom', 'algrelmultable',
    'algsimpledec', 'algsplit', 'algsplittingdata',
    'algsplittingfield', 'algsqr', 'algsub', 'algsubalg',
    'algtableinit', 'algtensor', 'algtomatrix', 'algtrace', 'algtype',
    'alias', 'allocatemem', 'apply', 'arg', 'arity', 'asin', 'asinh',
    'asympnum', 'asympnumraw', 'atan', 'atanh', 'bernfrac', 'bernpol',
    'bernreal', 'bernvec', 'besselh1', 'besselh2', 'besseli',
    'besselj', 'besseljh', 'besselk', 'besseln', 'bessely',
    'bestappr', 'bestapprPade', 'bestapprnf', 'bezout', 'bezoutres',
    'bigomega', 'binary', 'binomial', 'bitand', 'bitneg',
    'bitnegimply', 'bitor', 'bitprecision', 'bittest', 'bitxor',
    'bnfcertify', 'bnfdecodemodule', 'bnfinit', 'bnfisintnorm',
    'bnfisnorm', 'bnfisprincipal', 'bnfissunit', 'bnfisunit',
    'bnflog', 'bnflogdegree', 'bnflogef', 'bnfnarrow', 'bnfsignunit',
    'bnfsunit', 'bnfunits', 'bnrL1', 'bnrchar', 'bnrclassfield',
    'bnrclassno', 'bnrclassnolist', 'bnrconductor',
    'bnrconductorofchar', 'bnrdisc', 'bnrdisclist', 'bnrgaloisapply',
    'bnrgaloismatrix', 'bnrinit', 'bnrisconductor', 'bnrisgalois',
    'bnrisprincipal', 'bnrmap', 'bnrrootnumber', 'bnrstark', 'break',
    'call', 'ceil', 'centerlift', 'characteristic', 'charconj',
    'chardiv', 'chareval', 'chargalois', 'charker', 'charmul',
    'charorder', 'charpoly', 'charpow', 'chinese', 'cmp', 'component',
    'concat', 'conj', 'conjvec', 'content', 'contfrac',
    'contfraceval', 'contfracinit', 'contfracpnqn', 'core',
    'coredisc', 'cos', 'cosh', 'cotan', 'cotanh', 'default',
    'denominator', 'deriv', 'derivn', 'derivnum', 'diffop', 'digits',
    'dilog', 'dirdiv', 'direuler', 'dirmul', 'dirpowers',
    'dirpowerssum', 'dirzetak', 'divisors', 'divisorslenstra',
    'divrem', 'eint1', 'ellE', 'ellK', 'ellL1', 'elladd', 'ellak',
    'ellan', 'ellanalyticrank', 'ellap', 'ellbil', 'ellbsd',
    'ellcard', 'ellchangecurve', 'ellchangepoint',
    'ellchangepointinv', 'ellconvertname', 'elldivpol', 'elleisnum',
    'elleta', 'ellformaldifferential', 'ellformalexp', 'ellformallog',
    'ellformalpoint', 'ellformalw', 'ellfromeqn', 'ellfromj',
    'ellgenerators', 'ellglobalred', 'ellgroup', 'ellheegner',
    'ellheight', 'ellheightmatrix', 'ellidentify', 'ellinit',
    'ellintegralmodel', 'ellisdivisible', 'ellisogeny',
    'ellisogenyapply', 'ellisomat', 'ellisoncurve', 'ellisotree',
    'ellissupersingular', 'ellj', 'elllocalred', 'elllog',
    'elllseries', 'ellminimaldisc', 'ellminimalmodel',
    'ellminimaltwist', 'ellmoddegree', 'ellmodulareqn', 'ellmul',
    'ellneg', 'ellnonsingularmultiple', 'ellorder', 'ellordinate',
    'ellpadicL', 'ellpadicbsd', 'ellpadicfrobenius', 'ellpadicheight',
    'ellpadicheightmatrix', 'ellpadiclambdamu', 'ellpadiclog',
    'ellpadicregulator', 'ellpadics2', 'ellperiods', 'ellpointtoz',
    'ellpow', 'ellratpoints', 'ellrootno', 'ellsea', 'ellsearch',
    'ellsigma', 'ellsub', 'elltamagawa', 'elltaniyama',
    'elltatepairing', 'elltors', 'elltwist', 'ellweilcurve',
    'ellweilpairing', 'ellwp', 'ellxn', 'ellzeta', 'ellztopoint',
    'erfc', 'errname', 'error', 'eta', 'eulerfrac', 'eulerianpol',
    'eulerphi', 'eulerpol', 'eulervec', 'eval', 'exp', 'expm1',
    'exponent', 'export', 'exportall', 'extern', 'externstr',
    'factor', 'factorback', 'factorcantor', 'factorff', 'factorial',
    'factorint', 'factormod', 'factormodDDF', 'factormodSQF',
    'factornf', 'factorpadic', 'ffcompomap', 'ffembed', 'ffextend',
    'fffrobenius', 'ffgen', 'ffinit', 'ffinvmap', 'fflog', 'ffmap',
    'ffmaprel', 'ffnbirred', 'fforder', 'ffprimroot', 'fft', 'fftinv',
    'fibonacci', 'fileclose', 'fileextern', 'fileflush', 'fileopen',
    'fileread', 'filereadstr', 'filewrite', 'filewrite1', 'floor',
    'fold', 'for', 'forcomposite', 'fordiv', 'fordivfactored',
    'foreach', 'forell', 'forfactored', 'forpart', 'forperm',
    'forprime', 'forprimestep', 'forqfvec', 'forsquarefree',
    'forstep', 'forsubgroup', 'forsubset', 'forvec', 'frac',
    'fromdigits', 'galoischardet', 'galoischarpoly',
    'galoischartable', 'galoisconjclasses', 'galoisexport',
    'galoisfixedfield', 'galoisgetgroup', 'galoisgetname',
    'galoisgetpol', 'galoisidentify', 'galoisinit', 'galoisisabelian',
    'galoisisnormal', 'galoispermtopol', 'galoissubcyclo',
    'galoissubfields', 'galoissubgroups', 'gamma', 'gammah',
    'gammamellininv', 'gammamellininvasymp', 'gammamellininvinit',
    'gcd', 'gcdext', 'genus2red', 'getabstime', 'getcache', 'getenv',
    'getheap', 'getlocalbitprec', 'getlocalprec', 'getrand',
    'getstack', 'gettime', 'getwalltime', 'global', 'halfgcd',
    'hammingweight', 'hilbert', 'hyperellcharpoly',
    'hyperellpadicfrobenius', 'hyperellratpoints', 'hypergeom',
    'hyperu', 'idealadd', 'idealaddtoone', 'idealappr',
    'idealchinese', 'idealcoprime', 'idealdiv', 'idealdown',
    'idealfactor', 'idealfactorback', 'idealfrobenius', 'idealhnf',
    'idealintersect', 'idealinv', 'idealismaximal', 'idealispower',
    'ideallist', 'ideallistarch', 'ideallog', 'idealmin', 'idealmul',
    'idealnorm', 'idealnumden', 'idealpow', 'idealprimedec',
    'idealprincipalunits', 'idealramgroups', 'idealred',
    'idealredmodpower', 'idealstar', 'idealtwoelt', 'idealval', 'if',
    'iferr', 'imag', 'incgam', 'incgamc', 'inline', 'input',
    'install', 'intcirc', 'intformal', 'intfuncinit', 'intnum',
    'intnumgauss', 'intnumgaussinit', 'intnuminit', 'intnumromb',
    'isfundamental', 'ispolygonal', 'ispower', 'ispowerful',
    'isprime', 'isprimepower', 'ispseudoprime', 'ispseudoprimepower',
    'issquare', 'issquarefree', 'istotient', 'kill', 'kronecker',
    'lambertw', 'laurentseries', 'lcm', 'length', 'lex', 'lfun',
    'lfunabelianrelinit', 'lfunan', 'lfunartin', 'lfuncheckfeq',
    'lfunconductor', 'lfuncost', 'lfuncreate', 'lfundiv', 'lfundual',
    'lfunetaquo', 'lfungenus2', 'lfunhardy', 'lfuninit', 'lfunlambda',
    'lfunmf', 'lfunmfspec', 'lfunmul', 'lfunorderzero', 'lfunqf',
    'lfunrootres', 'lfunshift', 'lfunsympow', 'lfuntheta',
    'lfunthetacost', 'lfunthetainit', 'lfuntwist', 'lfunzeros',
    'lift', 'liftall', 'liftint', 'liftpol', 'limitnum', 'lindep',
    'listcreate', 'listinsert', 'listkill', 'listpop', 'listput',
    'listsort', 'lngamma', 'local', 'localbitprec', 'localprec',
    'log', 'log1p', 'logint', 'mapdelete', 'mapget', 'mapisdefined',
    'mapput', 'matadjoint', 'matalgtobasis', 'matbasistoalg',
    'matcompanion', 'matconcat', 'matdet', 'matdetint', 'matdetmod',
    'matdiagonal', 'mateigen', 'matfrobenius', 'mathess',
    'mathilbert', 'mathnf', 'mathnfmod', 'mathnfmodid',
    'mathouseholder', 'matid', 'matimage', 'matimagecompl',
    'matimagemod', 'matindexrank', 'matintersect', 'matinverseimage',
    'matinvmod', 'matisdiagonal', 'matker', 'matkerint', 'matkermod',
    'matmuldiagonal', 'matmultodiagonal', 'matpascal', 'matpermanent',
    'matqr', 'matrank', 'matreduce', 'matrix', 'matrixqz', 'matsize',
    'matsnf', 'matsolve', 'matsolvemod', 'matsupplement',
    'mattranspose', 'max', 'mfDelta', 'mfEH', 'mfEk', 'mfTheta',
    'mfatkin', 'mfatkineigenvalues', 'mfatkininit', 'mfbasis', 'mfbd',
    'mfbracket', 'mfcoef', 'mfcoefs', 'mfconductor', 'mfcosets',
    'mfcuspisregular', 'mfcusps', 'mfcuspval', 'mfcuspwidth',
    'mfderiv', 'mfderivE2', 'mfdescribe', 'mfdim', 'mfdiv',
    'mfeigenbasis', 'mfeigensearch', 'mfeisenstein', 'mfembed',
    'mfeval', 'mffields', 'mffromell', 'mffrometaquo', 'mffromlfun',
    'mffromqf', 'mfgaloisprojrep', 'mfgaloistype', 'mfhecke',
    'mfheckemat', 'mfinit', 'mfisCM', 'mfisequal', 'mfisetaquo',
    'mfkohnenbasis', 'mfkohnenbijection', 'mfkohneneigenbasis',
    'mflinear', 'mfmanin', 'mfmul', 'mfnumcusps', 'mfparams',
    'mfperiodpol', 'mfperiodpolbasis', 'mfpetersson', 'mfpow',
    'mfsearch', 'mfshift', 'mfshimura', 'mfslashexpansion', 'mfspace',
    'mfsplit', 'mfsturm', 'mfsymbol', 'mfsymboleval', 'mftaylor',
    'mftobasis', 'mftocoset', 'mftonew', 'mftraceform', 'mftwist',
    'min', 'minpoly', 'modreverse', 'moebius', 'msatkinlehner',
    'mscosets', 'mscuspidal', 'msdim', 'mseisenstein', 'mseval',
    'msfarey', 'msfromcusp', 'msfromell', 'msfromhecke', 'msgetlevel',
    'msgetsign', 'msgetweight', 'mshecke', 'msinit', 'msissymbol',
    'mslattice', 'msnew', 'msomseval', 'mspadicL', 'mspadicinit',
    'mspadicmoments', 'mspadicseries', 'mspathgens', 'mspathlog',
    'mspetersson', 'mspolygon', 'msqexpansion', 'mssplit', 'msstar',
    'mstooms', 'my', 'newtonpoly', 'next', 'nextprime',
    'nfalgtobasis', 'nfbasis', 'nfbasistoalg', 'nfcertify',
    'nfcompositum', 'nfdetint', 'nfdisc', 'nfdiscfactors', 'nfeltadd',
    'nfeltdiv', 'nfeltdiveuc', 'nfeltdivmodpr', 'nfeltdivrem',
    'nfeltembed', 'nfeltmod', 'nfeltmul', 'nfeltmulmodpr',
    'nfeltnorm', 'nfeltpow', 'nfeltpowmodpr', 'nfeltreduce',
    'nfeltreducemodpr', 'nfeltsign', 'nfelttrace', 'nfeltval',
    'nffactor', 'nffactorback', 'nffactormod', 'nfgaloisapply',
    'nfgaloisconj', 'nfgrunwaldwang', 'nfhilbert', 'nfhnf',
    'nfhnfmod', 'nfinit', 'nfisideal', 'nfisincl', 'nfisisom',
    'nfislocalpower', 'nfkermodpr', 'nfmodpr', 'nfmodprinit',
    'nfmodprlift', 'nfnewprec', 'nfpolsturm', 'nfroots', 'nfrootsof1',
    'nfsnf', 'nfsolvemodpr', 'nfsplitting', 'nfsubfields',
    'nfsubfieldscm', 'nfsubfieldsmax', 'norm', 'norml2', 'normlp',
    'numbpart', 'numdiv', 'numerator', 'numtoperm', 'omega', 'oo',
    'padicappr', 'padicfields', 'padicprec', 'parapply', 'pareval',
    'parfor', 'parforeach', 'parforprime', 'parforprimestep',
    'parforvec', 'parploth', 'parplothexport', 'parselect', 'parsum',
    'partitions', 'parvector', 'permcycles', 'permorder', 'permsign',
    'permtonum', 'plot', 'plotbox', 'plotclip', 'plotcolor',
    'plotcopy', 'plotcursor', 'plotdraw', 'plotexport', 'ploth',
    'plothexport', 'plothraw', 'plothrawexport', 'plothsizes',
    'plotinit', 'plotkill', 'plotlines', 'plotlinetype', 'plotmove',
    'plotpoints', 'plotpointsize', 'plotpointtype', 'plotrbox',
    'plotrecth', 'plotrecthraw', 'plotrline', 'plotrmove',
    'plotrpoint', 'plotscale', 'plotstring', 'polchebyshev',
    'polclass', 'polcoef', 'polcoeff', 'polcompositum', 'polcyclo',
    'polcyclofactors', 'poldegree', 'poldisc', 'poldiscfactors',
    'poldiscreduced', 'polgalois', 'polgraeffe', 'polhensellift',
    'polhermite', 'polinterpolate', 'poliscyclo', 'poliscycloprod',
    'polisirreducible', 'pollaguerre', 'pollead', 'pollegendre',
    'polmodular', 'polrecip', 'polred', 'polredabs', 'polredbest',
    'polredord', 'polresultant', 'polresultantext', 'polroots',
    'polrootsbound', 'polrootsff', 'polrootsmod', 'polrootspadic',
    'polrootsreal', 'polsturm', 'polsubcyclo', 'polsylvestermatrix',
    'polsym', 'poltchebi', 'polteichmuller', 'poltschirnhaus',
    'polylog', 'polylogmult', 'polzagier', 'powers', 'precision',
    'precprime', 'prime', 'primecert', 'primecertexport',
    'primecertisvalid', 'primepi', 'primes', 'print', 'print1',
    'printf', 'printp', 'printsep', 'printsep1', 'printtex', 'prod',
    'prodeuler', 'prodeulerrat', 'prodinf', 'prodnumrat', 'psdraw',
    'psi', 'psploth', 'psplothraw', 'qfauto', 'qfautoexport',
    'qfbclassno', 'qfbcompraw', 'qfbhclassno', 'qfbil', 'qfbnucomp',
    'qfbnupow', 'qfbpowraw', 'qfbprimeform', 'qfbred', 'qfbredsl2',
    'qfbsolve', 'qfeval', 'qfgaussred', 'qfisom', 'qfisominit',
    'qfjacobi', 'qflll', 'qflllgram', 'qfminim', 'qfnorm', 'qforbits',
    'qfparam', 'qfperfection', 'qfrep', 'qfsign', 'qfsolve',
    'quadclassunit', 'quaddisc', 'quadgen', 'quadhilbert', 'quadpoly',
    'quadray', 'quadregulator', 'quadunit', 'ramanujantau', 'random',
    'randomprime', 'read', 'readstr', 'readvec', 'real',
    'removeprimes', 'return', 'rnfalgtobasis', 'rnfbasis',
    'rnfbasistoalg', 'rnfcharpoly', 'rnfconductor', 'rnfdedekind',
    'rnfdet', 'rnfdisc', 'rnfeltabstorel', 'rnfeltdown', 'rnfeltnorm',
    'rnfeltreltoabs', 'rnfelttrace', 'rnfeltup', 'rnfequation',
    'rnfhnfbasis', 'rnfidealabstorel', 'rnfidealdown',
    'rnfidealfactor', 'rnfidealhnf', 'rnfidealmul', 'rnfidealnormabs',
    'rnfidealnormrel', 'rnfidealprimedec', 'rnfidealreltoabs',
    'rnfidealtwoelt', 'rnfidealup', 'rnfinit', 'rnfisabelian',
    'rnfisfree', 'rnfislocalcyclo', 'rnfisnorm', 'rnfisnorminit',
    'rnfkummer', 'rnflllgram', 'rnfnormgroup', 'rnfpolred',
    'rnfpolredabs', 'rnfpolredbest', 'rnfpseudobasis', 'rnfsteinitz',
    'rootsof1', 'round', 'select', 'self', 'seralgdep', 'serchop',
    'serconvol', 'serlaplace', 'serprec', 'serreverse', 'setbinop',
    'setintersect', 'setisset', 'setminus', 'setrand', 'setsearch',
    'setunion', 'shift', 'shiftmul', 'sigma', 'sign', 'simplify',
    'sin', 'sinc', 'sinh', 'sizebyte', 'sizedigit', 'solve',
    'solvestep', 'sqr', 'sqrt', 'sqrtint', 'sqrtn', 'sqrtnint',
    'stirling', 'strchr', 'strexpand', 'strjoin', 'strprintf',
    'strsplit', 'strtex', 'strtime', 'subgrouplist', 'subst',
    'substpol', 'substvec', 'sum', 'sumalt', 'sumdedekind',
    'sumdigits', 'sumdiv', 'sumdivmult', 'sumeulerrat', 'sumformal',
    'suminf', 'sumnum', 'sumnumap', 'sumnumapinit', 'sumnuminit',
    'sumnumlagrange', 'sumnumlagrangeinit', 'sumnummonien',
    'sumnummonieninit', 'sumnumrat', 'sumpos', 'system', 'tan',
    'tanh', 'taylor', 'teichmuller', 'theta', 'thetanullk', 'thue',
    'thueinit', 'trace', 'trap', 'truncate', 'type', 'unexport',
    'unexportall', 'uninline', 'until', 'valuation', 'varhigher',
    'variable', 'variables', 'varlower', 'vecextract', 'vecmax',
    'vecmin', 'vecprod', 'vecsearch', 'vecsort', 'vecsum', 'vector',
    'vectorsmall', 'vectorv', 'version', 'warning', 'weber', 'while',
    'write', 'write1', 'writebin', 'writetex', 'zeta', 'zetahurwitz',
    'zetamult', 'zetamultall', 'zetamultconvert', 'zetamultdual',
    'znchar', 'zncharconductor', 'znchardecompose', 'znchargauss',
    'zncharinduce', 'zncharisodd', 'znchartokronecker',
    'znchartoprimitive', 'znconreychar', 'znconreyconductor',
    'znconreyexp', 'znconreylog', 'zncoppersmith', 'znlog', 'znorder',
    'znprimroot', 'znstar'
  ]);

  var all = /(?:.)/;
  var comment = /(?:\\\\.*)/;
  var literals = /(?:")/;
  var numbers = /(?:\d*\.?\d+(?![\w@\\]))/;

  CodeMirror.defineSimpleMode('gp', {
    start: [
      {regex: comment, token: 'comment'},
      {regex: /\/\*/, token: 'comment', next: 'comment'},
      {regex: literals, token: 'string', next: 'string'},
      {regex: builtin, token: 'keyword'},
      {regex: numbers, token: 'number'},
      {regex: all, token: null}
    ],
    string: [
      {regex: /(?:[^\\"']|\\.)*?"/, token: 'string', next: 'start'},
      {regex: /.*/, token: 'string'}
    ],
    // The multi-line comment state.
    comment: [
      {regex: /.*?\*\//, token: "comment", next: "start"},
      {regex: /.*/, token: "comment"}
    ],
    meta: {lineComment: '\\\\', electricInput: all, dontIndentStates: ['comment']}


  })

  CodeMirror.defineMIME('text/x-pari-gp', 'gp');

});
