# Contributing to Nessie

Thanks for wanting to contribute to the development of  **Nessie**! I really appreciate it. The goal of Nessie is to be a fast and flexible friends-of-friends group finder which provides all the functionality to build high quality group catalogues with minimal effort.

**Please read through the following guidelines before reporting a bug/issue or submitting a pull request.**

Following these guidelines helps communicate that you respect the time of the developers managing and developing Nessie. It also allows us to better evaluate the issue.

----------

## Welcome Contributions

Things that we are happy to have help with include:

-   Documentation (if you find something is not clearly written or find typos)
-   Examples
-   Additional functionality such as post-processing
-   Additional properties for groups
-   Any open issues
-   Reporting bugs
-   Suggestions for features or improvements

This is not an exhaustive list.

Any requests to change core functionality should be carefully considered. This would require a lot of careful work and probably a lot of interaction with the lead maintainers. Do not submit any PRs that break core functionality without starting a dialogue with the lead developer—these will be deleted.  **Please raise an issue before submitting any PRs.**

----------

## Ground Rules

### Behavior Expectations

-   Be respectful and constructive in all interactions.
-   Assume good intent and be patient with others.
-   Keep discussions focused and relevant to the project.

----------

## Bugs

When reporting a bug please use the template below. Bugs that are reported that don't follow this template will be closed with a message saying you should have used the template. And then you'll feel silly.


### Template


---
  
 **Summary:**
*A clear and concise description of what the bug is.*

**Environment:**
	Nessie version:
	Python/R version:
	Operating System:


**Steps to Reproduce:**
*Describe the steps to reproduce the behavior*
  

**Expected Behavior**
 *A clear and concise description of what you expected to happen*

  **Actual Behavior**
 *What actually happened instead?*

 
**Additional Context**
*Add any other context about the problem here, such as logs, screenshots, or links to related issues.*

 
**Minimal Reproducible Example (if applicable)**
*Paste or link to a minimal example that reproduces the issue.*

---



----------

## Contributions

### Your First Contribution

If you're new to open source, welcome! Here are some good places to start:

-   Issues labeled  `good first issue`  or  `help wanted`
-   Documentation fixes or improvements
-   Small enhancements or bug fixes

Helpful resources:
If you've never contributed to a open source project here are some helpful tutorials:
[http://makeapullrequest.com/](http://makeapullrequest.com/) 
[http://www.firsttimersonly.com/](http://www.firsttimersonly.com/)
 [How to Contribute to an Open Source Project on GitHub](https://egghead.io/series/how-to-contribute-to-an-open-source-project-on-github).

----------

## Getting Started

For larger contributions:

1.  Fork the repository
2.  Create a new branch for your changes
3.  Make your changes
4.  Ensure code style and formatting is consistent
5.  Run tests if applicable
6.  Submit a pull request with a clear description

----------

## How to Suggest a Feature or Enhancement

If you have an idea for a feature:

-   Open an issue describing the feature
-   Explain why it’s needed and how it might work
-   Be open to discussion and feedback

We aim to keep Nessie lightweight and focused, so not all suggestions may be accepted.

----------

## Code Review Process

-   Pull requests are reviewed by the core team.
-   Feedback will be provided within a reasonable timeframe.
-   If no activity occurs within two weeks, the PR may be closed.
-   Contributors do not receive commit access automatically.
