# Homebrew Tap Cross-Repository Access Setup

This document provides instructions for setting up the GitHub Personal Access Token required for automated Homebrew formula updates.

## Overview

The automated Homebrew formula update workflow requires a GitHub Personal Access Token (PAT) to access and modify the `ScottRyanHoward/homebrew-riveter` repository from the main `riveter` repository.

## Token Setup Instructions

### 1. Create GitHub Personal Access Token

1. Go to GitHub Settings → Developer settings → Personal access tokens → Fine-grained tokens
2. Click "Generate new token"
3. Configure the token with the following settings:

**Basic Information:**
- **Token name**: `riveter-homebrew-tap-access`
- **Description**: `Token for automated Homebrew formula updates in homebrew-riveter repository`
- **Expiration**: 90 days (recommended for security)

**Repository access:**
- **Selected repositories**: `ScottRyanHoward/homebrew-riveter`

**Permissions:**
- **Contents**: Write (required to modify formula files)
- **Metadata**: Read (required to access repository information)
- **Pull requests**: Write (optional, for future PR-based updates)

### 2. Add Token to Repository Secrets

1. Navigate to the main riveter repository: `https://github.com/riveter/riveter`
2. Go to Settings → Secrets and variables → Actions
3. Click "New repository secret"
4. Configure the secret:
   - **Name**: `HOMEBREW_TAP_TOKEN`
   - **Value**: The token generated in step 1
5. Click "Add secret"

### 3. Verify Token Access

The workflow includes automatic token validation that will:
- Check if the `HOMEBREW_TAP_TOKEN` secret exists
- Verify the token has access to the `ScottRyanHoward/homebrew-riveter` repository
- Test the token's write permissions

If validation fails, the workflow will provide detailed error messages and troubleshooting steps.

## Security Considerations

### Token Permissions

The token is configured with minimal required permissions:
- **Repository scope**: Limited to `ScottRyanHoward/homebrew-riveter` only
- **Permission scope**: Only Contents (write) and Metadata (read)
- **No access**: To other repositories, user data, or organization settings

### Token Rotation

For security best practices:
- **Expiration**: Set token to expire every 90 days
- **Rotation**: Create calendar reminders to rotate the token before expiration
- **Monitoring**: GitHub will send notifications before token expiration

### Access Logging

- All token usage is logged in GitHub's audit logs
- Repository access and modifications are tracked
- Failed authentication attempts are recorded

## Troubleshooting

### Common Issues

#### Token Not Found
```
❌ HOMEBREW_TAP_TOKEN secret not found
```

**Solution**: Verify the secret is added to the repository with the exact name `HOMEBREW_TAP_TOKEN`.

#### Access Denied
```
❌ Token does not have access to homebrew-riveter repository
```

**Solutions**:
1. Verify the token has access to `ScottRyanHoward/homebrew-riveter`
2. Check that Contents (write) permission is granted
3. Ensure the token is not expired
4. Regenerate the token if necessary

#### Permission Denied During Push
```
❌ Failed to push formula update
```

**Solutions**:
1. Verify the token has Contents (write) permission
2. Check if the repository has branch protection rules
3. Ensure the token is not expired

### Testing Token Access

You can manually test token access using curl:

```bash
# Test repository access
curl -H "Authorization: token YOUR_TOKEN" \
  https://api.github.com/repos/ScottRyanHoward/homebrew-riveter

# Test write permissions (list contents)
curl -H "Authorization: token YOUR_TOKEN" \
  https://api.github.com/repos/ScottRyanHoward/homebrew-riveter/contents/Formula
```

## Workflow Integration

### Automatic Triggers

The formula update workflow is triggered:
1. **Automatically**: After successful completion of the Release workflow
2. **Manually**: Via workflow_dispatch with version input

### Manual Execution

To manually trigger a formula update:

1. Go to Actions → Update Homebrew Formula
2. Click "Run workflow"
3. Enter the version tag (e.g., `v1.2.3`)
4. Optionally enable "Force update" to update even if no changes detected

### Workflow Dependencies

The update workflow requires:
- Successful completion of the Release workflow (for automatic triggers)
- Binary assets uploaded to GitHub release
- Valid `HOMEBREW_TAP_TOKEN` secret
- Access to `ScottRyanHoward/homebrew-riveter` repository

## Maintenance

### Regular Tasks

1. **Token Rotation** (every 90 days):
   - Generate new token with same permissions
   - Update `HOMEBREW_TAP_TOKEN` secret
   - Test workflow execution

2. **Permission Review** (quarterly):
   - Verify token still has minimal required permissions
   - Check for any unauthorized access in audit logs
   - Review repository access scope

3. **Workflow Testing** (after changes):
   - Test manual workflow execution
   - Verify automatic triggers work correctly
   - Check formula validation and syntax

### Emergency Procedures

#### Token Compromise
1. Immediately revoke the compromised token in GitHub settings
2. Generate a new token with same permissions
3. Update the repository secret
4. Review audit logs for unauthorized activity

#### Workflow Failure
1. Check workflow logs for specific error messages
2. Verify token permissions and expiration
3. Test token access manually using curl commands
4. Re-run workflow after resolving issues

## Related Documentation

- [GitHub Personal Access Tokens Documentation](https://docs.github.com/en/authentication/keeping-your-account-and-data-secure/creating-a-personal-access-token)
- [GitHub Actions Secrets Documentation](https://docs.github.com/en/actions/security-guides/encrypted-secrets)
- [Homebrew Formula Development](https://docs.brew.sh/Formula-Cookbook)
