# Rule Pack Guide

This guide provides detailed information about all available rule packs in Riveter, including their purpose, coverage, and usage examples.

## Table of Contents

- [Cloud Security Best Practices](#cloud-security-best-practices)
- [CIS Benchmarks](#cis-benchmarks)
- [Well-Architected Frameworks](#well-architected-frameworks)
- [Compliance Standards](#compliance-standards)
- [Container & Kubernetes Security](#container--kubernetes-security)
- [Multi-Cloud Security](#multi-cloud-security)
- [General Compliance](#general-compliance)

## Cloud Security Best Practices

### AWS Security (`aws-security`)

**Purpose**: Validates AWS infrastructure against security best practices and common misconfigurations.

**Coverage**: 26 rules covering EC2, S3, RDS, VPC, IAM, CloudTrail, KMS, Lambda, and ALB.

**Key Areas**:
- **EC2 Security**: No public IPs in production, encrypted EBS volumes, approved instance types, required tags
- **S3 Security**: Bucket encryption, public access controls, versioning, access logging
- **RDS Security**: Encryption at rest, backup settings, Multi-AZ for production, no public access
- **VPC Security**: Security group restrictions, VPC Flow Logs, private subnets
- **IAM Security**: Policy restrictions, MFA requirements, least privilege
- **CloudTrail**: Logging enabled, log file validation, S3 bucket security
- **KMS**: Key rotation, appropriate key usage
- **Lambda**: Environment variable encryption, VPC configuration

**Usage**:
```bash
# Basic AWS security validation
riveter scan -p aws-security -t main.tf

# Combine with other AWS rule packs
riveter scan -p aws-security -p cis-aws -p aws-well-architected -t main.tf
```

### GCP Security (`gcp-security`)

**Purpose**: Validates Google Cloud Platform infrastructure against security best practices.

**Coverage**: 29 rules covering Compute Engine, Cloud Storage, Cloud SQL, VPC, IAM, and Cloud KMS.

**Key Areas**:
- **Compute Engine**: OS Login enabled, no external IPs in production, Shielded VM features, disk encryption
- **Cloud Storage**: Uniform bucket-level access, encryption at rest, public access prevention, versioning
- **Cloud SQL**: SSL/TLS required, automated backups, no public IP, encryption at rest
- **VPC/Networking**: VPC Flow Logs, firewall rules restrictions, Private Google Access, Cloud NAT
- **IAM**: Service account key rotation, no primitive roles, Workload Identity for GKE
- **Cloud KMS**: Key rotation enabled, key purpose defined

**Usage**:
```bash
# Basic GCP security validation
riveter scan -p gcp-security -t main.tf

# Combine with GCP compliance
riveter scan -p gcp-security -p cis-gcp -p gcp-well-architected -t main.tf
```

### Azure Security (`azure-security`)

**Purpose**: Validates Microsoft Azure infrastructure against security best practices.

**Coverage**: 28 rules covering VMs, Storage Accounts, SQL Databases, Key Vault, and Network Security Groups.

**Key Areas**:
- **Virtual Machines**: Disk encryption, no public IPs in production, managed identities, required tags
- **Storage Accounts**: HTTPS only, encryption at rest, no public access, soft delete enabled
- **SQL Databases**: TDE enabled, firewall rules, threat detection, backup retention
- **Network Security Groups**: No wide-open rules, required descriptions, flow logs
- **Key Vault**: Soft delete enabled, purge protection, private endpoints
- **Azure AD/IAM**: Managed identities preferred, no wildcard permissions

**Usage**:
```bash
# Basic Azure security validation
riveter scan -p azure-security -t main.tf

# Combine with Azure compliance
riveter scan -p azure-security -p cis-azure -p azure-well-architected -t main.tf
```

## CIS Benchmarks

### CIS AWS (`cis-aws`)

**Purpose**: Implements CIS AWS Foundations Benchmark v1.4.0 controls.

**Coverage**: 22 rules covering Identity, Storage, Logging, and Networking.

**Control Sections**:
- **Section 1**: Identity and Access Management
- **Section 2**: Storage (S3)
- **Section 3**: Logging (CloudTrail, CloudWatch)
- **Section 4**: Monitoring
- **Section 5**: Networking (VPC, Security Groups)

**Usage**:
```bash
riveter scan -p cis-aws -t main.tf
```

### CIS Azure (`cis-azure`)

**Purpose**: Implements CIS Azure Foundations Benchmark v1.3.0 controls.

**Coverage**: 34 rules covering Identity, Security Center, Storage, Database, Logging, Networking, VMs, and Key Vault.

**Control Sections**:
- **Section 1**: Identity and Access Management
- **Section 2**: Security Center
- **Section 3**: Storage Accounts
- **Section 4**: Database Services
- **Section 5**: Logging and Monitoring
- **Section 6**: Networking
- **Section 7**: Virtual Machines
- **Section 8**: Key Vault

**Usage**:
```bash
riveter scan -p cis-azure -t main.tf
```

### CIS GCP (`cis-gcp`)

**Purpose**: Implements CIS Google Cloud Platform Foundation Benchmark v1.3.0 controls.

**Coverage**: 43 rules covering IAM, Logging, Monitoring, Networking, VMs, Storage, and Cloud SQL.

**Control Sections**:
- **Section 1**: Identity and Access Management (10-12 rules)
- **Section 2**: Logging and Monitoring (8-10 rules)
- **Section 3**: Networking (6-8 rules)
- **Section 4**: Virtual Machines (4-5 rules)
- **Section 5**: Storage (4-5 rules)
- **Section 6**: Cloud SQL Database Services (3-4 rules)

**Usage**:
```bash
riveter scan -p cis-gcp -t main.tf
```

## Well-Architected Frameworks

### AWS Well-Architected (`aws-well-architected`)

**Purpose**: Validates infrastructure against AWS Well-Architected Framework principles across all 6 pillars.

**Coverage**: 34 rules covering Operational Excellence, Security, Reliability, Performance Efficiency, Cost Optimization, and Sustainability.

**Pillars**:
- **Operational Excellence** (6-8 rules): CloudWatch alarms, Auto Scaling policies, resource tagging, change management
- **Security** (6-8 rules): Complements aws-security pack, AWS Config, GuardDuty, Security Hub
- **Reliability** (6-8 rules): Multi-AZ deployments, Auto Scaling groups, health checks, backup strategies
- **Performance Efficiency** (4-6 rules): CloudFront, ElastiCache, EBS optimization, Lambda configuration
- **Cost Optimization** (4-6 rules): Cost allocation tags, lifecycle policies, right-sizing
- **Sustainability** (2-4 rules): Region selection, resource utilization, serverless adoption

**Usage**:
```bash
riveter scan -p aws-well-architected -t main.tf
```

### Azure Well-Architected (`azure-well-architected`)

**Purpose**: Validates infrastructure against Microsoft Azure Well-Architected Framework across 5 pillars.

**Coverage**: 35 rules covering Cost Optimization, Operational Excellence, Performance Efficiency, Reliability, and Security.

**Pillars**:
- **Cost Optimization** (6-8 rules): Resource tagging, VM sizing, storage tiers, reserved capacity
- **Operational Excellence** (6-8 rules): Monitoring, automation, update management, naming conventions
- **Performance Efficiency** (6-8 rules): CDN usage, Redis cache, premium storage, autoscaling
- **Reliability** (6-8 rules): Availability zones, backup policies, geo-replication, health probes
- **Security** (6-8 rules): Complements cis-azure, Security Center, Defender for Cloud, private endpoints

**Usage**:
```bash
riveter scan -p azure-well-architected -t main.tf
```

### GCP Well-Architected (`gcp-well-architected`)

**Purpose**: Validates infrastructure against Google Cloud Architecture Framework across 5 pillars.

**Coverage**: 30 rules covering Operational Excellence, Security, Reliability, Performance, and Cost Optimization.

**Pillars**:
- **Operational Excellence** (5-7 rules): Cloud Monitoring, Cloud Logging, Error Reporting, resource labels
- **Security** (5-7 rules): Complements gcp-security, Security Command Center, VPC Service Controls, Binary Authorization
- **Reliability** (5-7 rules): Regional resources, health checks, managed instance groups, Cloud SQL HA
- **Performance** (5-7 rules): Cloud CDN, Memorystore, SSD persistent disks, machine types
- **Cost Optimization** (5-7 rules): Resource labels for billing, committed use discounts, preemptible VMs, storage classes

**Usage**:
```bash
riveter scan -p gcp-well-architected -t main.tf
```

## Compliance Standards

### AWS HIPAA (`aws-hipaa`)

**Purpose**: Validates AWS infrastructure for HIPAA compliance in healthcare environments.

**Coverage**: 35 rules covering Encryption, Access Controls, Audit Logging, Network Security, and Backup/Recovery.

**Compliance Areas**:
- **Encryption** (8-10 rules): S3 encryption, RDS encryption, EBS encryption, KMS key management, SSL/TLS in transit
- **Access Controls** (6-8 rules): IAM policies, MFA requirements, least privilege, service control policies
- **Audit Logging** (5-7 rules): CloudTrail enabled, S3 access logging, VPC Flow Logs, RDS audit logs
- **Network Security** (4-6 rules): VPC isolation, security groups, NACLs, private subnets for PHI
- **Backup and Recovery** (2-4 rules): RDS automated backups, S3 versioning, backup retention periods

**HIPAA Control References**: Each rule includes references to specific HIPAA controls (e.g., 164.312(a)(2)(iv)).

**Usage**:
```bash
# Healthcare infrastructure validation
riveter scan -p aws-hipaa -t healthcare-infrastructure/

# Combine with general AWS security
riveter scan -p aws-hipaa -p aws-security -t healthcare-infrastructure/
```

### Azure HIPAA (`azure-hipaa`)

**Purpose**: Validates Azure infrastructure for HIPAA compliance in healthcare environments.

**Coverage**: 30 rules covering Encryption, Access Controls, Audit Logging, Network Security, and Backup/Recovery.

**Compliance Areas**:
- **Encryption** (6-8 rules): Storage encryption, SQL TDE, disk encryption, Key Vault usage, HTTPS enforcement
- **Access Controls** (5-7 rules): Azure AD authentication, RBAC assignments, managed identities, conditional access
- **Audit Logging** (4-6 rules): Activity logs, diagnostic settings, storage logging, SQL auditing
- **Network Security** (3-5 rules): NSG rules, private endpoints, VNet isolation, service endpoints
- **Backup and Recovery** (2-4 rules): VM backups, SQL backups, geo-redundancy

**Usage**:
```bash
# Healthcare infrastructure validation
riveter scan -p azure-hipaa -t healthcare-infrastructure/

# Combine with general Azure security
riveter scan -p azure-hipaa -p azure-security -t healthcare-infrastructure/
```

### AWS PCI-DSS (`aws-pci-dss`)

**Purpose**: Validates AWS infrastructure for PCI-DSS compliance in payment processing environments.

**Coverage**: 40 rules covering Network Segmentation, Encryption, Access Control, Logging/Monitoring, and Vulnerability Management.

**PCI-DSS Requirements**:
- **Network Segmentation** (8-10 rules): VPC design, security groups, NACLs, cardholder data environment isolation
- **Encryption** (7-9 rules): Data at rest encryption, data in transit encryption, key management, certificate management
- **Access Control** (6-8 rules): IAM policies, MFA enforcement, unique user IDs, access reviews
- **Logging and Monitoring** (5-7 rules): CloudTrail, CloudWatch, GuardDuty, log retention, audit trails
- **Vulnerability Management** (4-6 rules): Systems Manager patching, Inspector assessments, security groups

**PCI-DSS Control References**: Each rule includes references to specific PCI-DSS requirements (e.g., 1.2.1, 3.4).

**Usage**:
```bash
# Payment processing infrastructure validation
riveter scan -p aws-pci-dss -t payment-infrastructure/

# Focus on cardholder data environment
riveter scan -p aws-pci-dss -t cde-infrastructure/ --output-format sarif
```

## Container & Kubernetes Security

### Kubernetes Security (`kubernetes-security`)

**Purpose**: Validates Kubernetes and container security across EKS, AKS, and GKE.

**Coverage**: 40 rules covering Pod Security, RBAC, Network Policies, Secrets Management, and Image Security.

**Security Areas**:
- **Pod Security** (8-10 rules): No privileged containers, read-only root filesystem, non-root users, security contexts, resource limits
- **RBAC** (6-8 rules): Role bindings, service accounts, cluster roles, namespace isolation
- **Network Policies** (6-8 rules): Default deny policies, ingress rules, egress rules, pod-to-pod communication
- **Secrets Management** (5-7 rules): External secrets, encryption at rest, no hardcoded secrets, secret rotation
- **Image Security** (5-7 rules): Image scanning, trusted registries, image pull policies, vulnerability management

**Multi-Cloud Support**: Works across EKS (AWS), AKS (Azure), and GKE (GCP).

**Usage**:
```bash
# Kubernetes security validation
riveter scan -p kubernetes-security -t k8s-infrastructure/

# Combine with cloud-specific security
riveter scan -p kubernetes-security -p aws-security -t eks-infrastructure/
riveter scan -p kubernetes-security -p azure-security -t aks-infrastructure/
riveter scan -p kubernetes-security -p gcp-security -t gke-infrastructure/
```

## Multi-Cloud Security

### Multi-Cloud Security (`multi-cloud-security`)

**Purpose**: Enforces common security patterns across AWS, Azure, and GCP.

**Coverage**: 40 rules covering Encryption, Network Security, IAM, Logging, and Monitoring across all three cloud providers.

**Security Patterns**:
- **Encryption** (10-12 rules): Storage encryption, database encryption, disk encryption, key management (all providers)
- **Network Security** (10-12 rules): Firewall rules, private networking, VPN/interconnect (all providers)
- **IAM** (8-10 rules): Least privilege, service accounts, MFA (all providers)
- **Logging** (8-10 rules): Audit logging, access logging, log retention (all providers)
- **Monitoring** (4-6 rules): Alerting, metrics (all providers)

**Provider Detection**: Automatically detects cloud provider from resource types and applies appropriate validations.

**Usage**:
```bash
# Multi-cloud infrastructure validation
riveter scan -p multi-cloud-security -t infrastructure/

# Combine with provider-specific packs
riveter scan -p multi-cloud-security -p aws-security -p gcp-security -p azure-security -t infrastructure/
```

## General Compliance

### SOC 2 Security (`soc2-security`)

**Purpose**: Validates infrastructure against SOC 2 Security Trust Service Criteria.

**Coverage**: 28 rules covering Access Control, Authentication, Network Security, Encryption, and Monitoring across AWS, Azure, and GCP.

**Trust Service Criteria**:
- **Access Control**: User access management, privilege escalation prevention
- **Authentication**: Multi-factor authentication, strong password policies
- **Network Security**: Network segmentation, secure communications
- **Encryption**: Data protection at rest and in transit
- **Monitoring**: Security event logging and monitoring

**Usage**:
```bash
riveter scan -p soc2-security -t main.tf
```

## Rule Pack Combinations

### Recommended Combinations

**AWS Complete Security**:
```bash
riveter scan -p aws-security -p cis-aws -p aws-well-architected -t main.tf
```

**GCP Complete Security**:
```bash
riveter scan -p gcp-security -p cis-gcp -p gcp-well-architected -t main.tf
```

**Azure Complete Security**:
```bash
riveter scan -p azure-security -p cis-azure -p azure-well-architected -t main.tf
```

**Healthcare Compliance**:
```bash
riveter scan -p aws-hipaa -p azure-hipaa -p soc2-security -t healthcare-infrastructure/
```

**Payment Processing Compliance**:
```bash
riveter scan -p aws-pci-dss -p soc2-security -t payment-infrastructure/
```

**Multi-Cloud Complete**:
```bash
riveter scan -p multi-cloud-security -p kubernetes-security -p soc2-security -t infrastructure/
```

## Rule Pack Metadata

Each rule pack includes comprehensive metadata:

```yaml
metadata:
  name: rule-pack-name
  version: 1.0.0
  description: Human-readable description
  author: Riveter Team
  created: 2024-10-27
  updated: 2024-10-27
  dependencies: []
  tags: [relevant, tags]
  min_riveter_version: 0.1.0
```

## Rule Metadata

Each rule includes detailed metadata:

```yaml
metadata:
  tags: [categorization, tags]
  references: [documentation-urls]
  # Compliance-specific metadata
  cis_control: "1.1"           # For CIS rules
  hipaa_control: "164.312(a)"  # For HIPAA rules
  pci_requirement: "1.2.1"     # For PCI-DSS rules
  pillar: "Security"           # For Well-Architected rules
```

## Getting Help

For questions about specific rule packs:

1. Check the rule pack file directly in `rule_packs/`
2. Review the metadata and references in each rule
3. Use `riveter validate-rule-pack <pack-file>` to validate rule pack syntax
4. Use `riveter list-rule-packs` to see all available packs

For technical support, see the main [README.md](../README.md) or open an issue on GitHub.
