from dagster_ray.kuberay.utils import normalize_k8s_label_values


def test_normalize_k8s_label_values(snapshot):
    assert snapshot == normalize_k8s_label_values(
        {
            "foo": "bar",
            "my/label": "my/value",
            "user": "daniel@my.org",
            "user-dirty": "daniel!`~@my.org",
            "alphanumeric": "abc123",
            "long": 64 * "a",
            "badstart": "-foo",
            "badstart_after_initial_replace": "@foo",
        }
    )


def test_normalize_k8s_label_values_important_labels():
    assert normalize_k8s_label_values({"dagster/run-id": "12345"}) == {"dagster/run-id": "12345"}
