import datetime
from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union, cast
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..models.run_status import RunStatus

if TYPE_CHECKING:
    from ..models.run_response_input_values_type_0 import RunResponseInputValuesType0
    from ..models.run_response_output_data_type_0 import RunResponseOutputDataType0
    from ..models.run_response_run_message_history_type_0_item import RunResponseRunMessageHistoryType0Item


T = TypeVar("T", bound="RunResponse")


@_attrs_define
class RunResponse:
    """Run response schema

    Attributes:
        workflow_id (UUID):
        machine_id (Union[None, UUID]):
        id (UUID):
        user_id (UUID):
        status (RunStatus):
        error (Union[None, list[str]]):
        output_data (Union['RunResponseOutputDataType0', None]):
        output_attachment_ids (Union[None, list[str]]):
        run_message_history (Union[None, list['RunResponseRunMessageHistoryType0Item']]):
        input_values (Union['RunResponseInputValuesType0', None]):
        created_at (datetime.datetime):
    """

    workflow_id: UUID
    machine_id: Union[None, UUID]
    id: UUID
    user_id: UUID
    status: RunStatus
    error: Union[None, list[str]]
    output_data: Union["RunResponseOutputDataType0", None]
    output_attachment_ids: Union[None, list[str]]
    run_message_history: Union[None, list["RunResponseRunMessageHistoryType0Item"]]
    input_values: Union["RunResponseInputValuesType0", None]
    created_at: datetime.datetime
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        from ..models.run_response_input_values_type_0 import RunResponseInputValuesType0
        from ..models.run_response_output_data_type_0 import RunResponseOutputDataType0

        workflow_id = str(self.workflow_id)

        machine_id: Union[None, str]
        if isinstance(self.machine_id, UUID):
            machine_id = str(self.machine_id)
        else:
            machine_id = self.machine_id

        id = str(self.id)

        user_id = str(self.user_id)

        status = self.status.value

        error: Union[None, list[str]]
        if isinstance(self.error, list):
            error = self.error

        else:
            error = self.error

        output_data: Union[None, dict[str, Any]]
        if isinstance(self.output_data, RunResponseOutputDataType0):
            output_data = self.output_data.to_dict()
        else:
            output_data = self.output_data

        output_attachment_ids: Union[None, list[str]]
        if isinstance(self.output_attachment_ids, list):
            output_attachment_ids = self.output_attachment_ids

        else:
            output_attachment_ids = self.output_attachment_ids

        run_message_history: Union[None, list[dict[str, Any]]]
        if isinstance(self.run_message_history, list):
            run_message_history = []
            for run_message_history_type_0_item_data in self.run_message_history:
                run_message_history_type_0_item = run_message_history_type_0_item_data.to_dict()
                run_message_history.append(run_message_history_type_0_item)

        else:
            run_message_history = self.run_message_history

        input_values: Union[None, dict[str, Any]]
        if isinstance(self.input_values, RunResponseInputValuesType0):
            input_values = self.input_values.to_dict()
        else:
            input_values = self.input_values

        created_at = self.created_at.isoformat()

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "workflow_id": workflow_id,
                "machine_id": machine_id,
                "id": id,
                "user_id": user_id,
                "status": status,
                "error": error,
                "output_data": output_data,
                "output_attachment_ids": output_attachment_ids,
                "run_message_history": run_message_history,
                "input_values": input_values,
                "created_at": created_at,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.run_response_input_values_type_0 import RunResponseInputValuesType0
        from ..models.run_response_output_data_type_0 import RunResponseOutputDataType0
        from ..models.run_response_run_message_history_type_0_item import RunResponseRunMessageHistoryType0Item

        d = dict(src_dict)
        workflow_id = UUID(d.pop("workflow_id"))

        def _parse_machine_id(data: object) -> Union[None, UUID]:
            if data is None:
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                machine_id_type_0 = UUID(data)

                return machine_id_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, UUID], data)

        machine_id = _parse_machine_id(d.pop("machine_id"))

        id = UUID(d.pop("id"))

        user_id = UUID(d.pop("user_id"))

        status = RunStatus(d.pop("status"))

        def _parse_error(data: object) -> Union[None, list[str]]:
            if data is None:
                return data
            try:
                if not isinstance(data, list):
                    raise TypeError()
                error_type_0 = cast(list[str], data)

                return error_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, list[str]], data)

        error = _parse_error(d.pop("error"))

        def _parse_output_data(data: object) -> Union["RunResponseOutputDataType0", None]:
            if data is None:
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                output_data_type_0 = RunResponseOutputDataType0.from_dict(data)

                return output_data_type_0
            except:  # noqa: E722
                pass
            return cast(Union["RunResponseOutputDataType0", None], data)

        output_data = _parse_output_data(d.pop("output_data"))

        def _parse_output_attachment_ids(data: object) -> Union[None, list[str]]:
            if data is None:
                return data
            try:
                if not isinstance(data, list):
                    raise TypeError()
                output_attachment_ids_type_0 = cast(list[str], data)

                return output_attachment_ids_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, list[str]], data)

        output_attachment_ids = _parse_output_attachment_ids(d.pop("output_attachment_ids"))

        def _parse_run_message_history(data: object) -> Union[None, list["RunResponseRunMessageHistoryType0Item"]]:
            if data is None:
                return data
            try:
                if not isinstance(data, list):
                    raise TypeError()
                run_message_history_type_0 = []
                _run_message_history_type_0 = data
                for run_message_history_type_0_item_data in _run_message_history_type_0:
                    run_message_history_type_0_item = RunResponseRunMessageHistoryType0Item.from_dict(
                        run_message_history_type_0_item_data
                    )

                    run_message_history_type_0.append(run_message_history_type_0_item)

                return run_message_history_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, list["RunResponseRunMessageHistoryType0Item"]], data)

        run_message_history = _parse_run_message_history(d.pop("run_message_history"))

        def _parse_input_values(data: object) -> Union["RunResponseInputValuesType0", None]:
            if data is None:
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                input_values_type_0 = RunResponseInputValuesType0.from_dict(data)

                return input_values_type_0
            except:  # noqa: E722
                pass
            return cast(Union["RunResponseInputValuesType0", None], data)

        input_values = _parse_input_values(d.pop("input_values"))

        created_at = isoparse(d.pop("created_at"))

        run_response = cls(
            workflow_id=workflow_id,
            machine_id=machine_id,
            id=id,
            user_id=user_id,
            status=status,
            error=error,
            output_data=output_data,
            output_attachment_ids=output_attachment_ids,
            run_message_history=run_message_history,
            input_values=input_values,
            created_at=created_at,
        )

        run_response.additional_properties = d
        return run_response

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
