# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['FlowArgs', 'Flow']

@pulumi.input_type
class FlowArgs:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Flow resource.
        :param pulumi.Input[builtins.str] actions: Actions of the flow.
        :param pulumi.Input[builtins.str] name: Name of the flow.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Actions of the flow.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the flow.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _FlowState:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Flow resources.
        :param pulumi.Input[builtins.str] actions: Actions of the flow.
        :param pulumi.Input[builtins.str] name: Name of the flow.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Actions of the flow.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the flow.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("auth0:index/flow:Flow")
class Flow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        With this resource, you can create and manage Flows for a tenant.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_auth0 as auth0

        # Example:
        my_flow = auth0.Flow("my_flow",
            actions=json.dumps([{
                "action": "UPDATE_USER",
                "alias": "user meta data",
                "allow_failure": False,
                "id": "update_user_PmSa",
                "mask_output": False,
                "params": {
                    "changes": {
                        "user_metadata": {
                            "full_name": "{{fields.full_name}}",
                        },
                    },
                    "connection_id": "<vault_connection_id>",
                    "user_id": "{{context.user.user_id}}",
                },
                "type": "AUTH0",
            }]),
            name="Flow KYC update data")
        ```

        ## Import

        This resource can be imported using the flow ID.

        Example:

        ```sh
        $ pulumi import auth0:index/flow:Flow my_flow "af_4JwsAjokf6DpK8xJCkTRjK"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] actions: Actions of the flow.
        :param pulumi.Input[builtins.str] name: Name of the flow.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FlowArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With this resource, you can create and manage Flows for a tenant.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_auth0 as auth0

        # Example:
        my_flow = auth0.Flow("my_flow",
            actions=json.dumps([{
                "action": "UPDATE_USER",
                "alias": "user meta data",
                "allow_failure": False,
                "id": "update_user_PmSa",
                "mask_output": False,
                "params": {
                    "changes": {
                        "user_metadata": {
                            "full_name": "{{fields.full_name}}",
                        },
                    },
                    "connection_id": "<vault_connection_id>",
                    "user_id": "{{context.user.user_id}}",
                },
                "type": "AUTH0",
            }]),
            name="Flow KYC update data")
        ```

        ## Import

        This resource can be imported using the flow ID.

        Example:

        ```sh
        $ pulumi import auth0:index/flow:Flow my_flow "af_4JwsAjokf6DpK8xJCkTRjK"
        ```

        :param str resource_name: The name of the resource.
        :param FlowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlowArgs.__new__(FlowArgs)

            __props__.__dict__["actions"] = actions
            __props__.__dict__["name"] = name
        super(Flow, __self__).__init__(
            'auth0:index/flow:Flow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None) -> 'Flow':
        """
        Get an existing Flow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] actions: Actions of the flow.
        :param pulumi.Input[builtins.str] name: Name of the flow.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlowState.__new__(_FlowState)

        __props__.__dict__["actions"] = actions
        __props__.__dict__["name"] = name
        return Flow(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Actions of the flow.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the flow.
        """
        return pulumi.get(self, "name")

