# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetFederatedSettingsIdentityProvidersResult',
    'AwaitableGetFederatedSettingsIdentityProvidersResult',
    'get_federated_settings_identity_providers',
    'get_federated_settings_identity_providers_output',
]

@pulumi.output_type
class GetFederatedSettingsIdentityProvidersResult:
    """
    A collection of values returned by getFederatedSettingsIdentityProviders.
    """
    def __init__(__self__, federation_settings_id=None, id=None, idp_types=None, protocols=None, results=None):
        if federation_settings_id and not isinstance(federation_settings_id, str):
            raise TypeError("Expected argument 'federation_settings_id' to be a str")
        pulumi.set(__self__, "federation_settings_id", federation_settings_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if idp_types and not isinstance(idp_types, list):
            raise TypeError("Expected argument 'idp_types' to be a list")
        pulumi.set(__self__, "idp_types", idp_types)
        if protocols and not isinstance(protocols, list):
            raise TypeError("Expected argument 'protocols' to be a list")
        pulumi.set(__self__, "protocols", protocols)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)

    @property
    @pulumi.getter(name="federationSettingsId")
    def federation_settings_id(self) -> str:
        """
        Unique 24-hexadecimal digit string that identifies the federated authentication configuration.
        """
        return pulumi.get(self, "federation_settings_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idpTypes")
    def idp_types(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "idp_types")

    @property
    @pulumi.getter
    def protocols(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetFederatedSettingsIdentityProvidersResultResult']:
        """
        Includes cloudProviderSnapshot object for each item detailed in the results array section.
        * `totalCount` - Count of the total number of items in the result set. It may be greater than the number of objects in the results array if the entire result set is paginated.
        """
        return pulumi.get(self, "results")


class AwaitableGetFederatedSettingsIdentityProvidersResult(GetFederatedSettingsIdentityProvidersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFederatedSettingsIdentityProvidersResult(
            federation_settings_id=self.federation_settings_id,
            id=self.id,
            idp_types=self.idp_types,
            protocols=self.protocols,
            results=self.results)


def get_federated_settings_identity_providers(federation_settings_id: Optional[str] = None,
                                              idp_types: Optional[Sequence[str]] = None,
                                              protocols: Optional[Sequence[str]] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFederatedSettingsIdentityProvidersResult:
    """
    ## # Data Source: get_federated_settings_identity_providers

    `get_federated_settings_identity_providers` provides an Federated Settings Identity Providers datasource. Atlas Cloud Federated Settings Identity Providers provides federated settings outputs for the configured Identity Providers.

    Note: This implementation returns a maximum of 100 results.


    :param str federation_settings_id: Unique 24-hexadecimal digit string that identifies the federated authentication configuration.
    :param Sequence[str] idp_types: The types of the target identity providers. Valid values are `WORKFORCE` and `WORKLOAD`.
    :param Sequence[str] protocols: The protocols of the target identity providers. Valid values are `SAML` and `OIDC`.
    """
    __args__ = dict()
    __args__['federationSettingsId'] = federation_settings_id
    __args__['idpTypes'] = idp_types
    __args__['protocols'] = protocols
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getFederatedSettingsIdentityProviders:getFederatedSettingsIdentityProviders', __args__, opts=opts, typ=GetFederatedSettingsIdentityProvidersResult).value

    return AwaitableGetFederatedSettingsIdentityProvidersResult(
        federation_settings_id=pulumi.get(__ret__, 'federation_settings_id'),
        id=pulumi.get(__ret__, 'id'),
        idp_types=pulumi.get(__ret__, 'idp_types'),
        protocols=pulumi.get(__ret__, 'protocols'),
        results=pulumi.get(__ret__, 'results'))
def get_federated_settings_identity_providers_output(federation_settings_id: Optional[pulumi.Input[str]] = None,
                                                     idp_types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                                     protocols: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFederatedSettingsIdentityProvidersResult]:
    """
    ## # Data Source: get_federated_settings_identity_providers

    `get_federated_settings_identity_providers` provides an Federated Settings Identity Providers datasource. Atlas Cloud Federated Settings Identity Providers provides federated settings outputs for the configured Identity Providers.

    Note: This implementation returns a maximum of 100 results.


    :param str federation_settings_id: Unique 24-hexadecimal digit string that identifies the federated authentication configuration.
    :param Sequence[str] idp_types: The types of the target identity providers. Valid values are `WORKFORCE` and `WORKLOAD`.
    :param Sequence[str] protocols: The protocols of the target identity providers. Valid values are `SAML` and `OIDC`.
    """
    __args__ = dict()
    __args__['federationSettingsId'] = federation_settings_id
    __args__['idpTypes'] = idp_types
    __args__['protocols'] = protocols
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('mongodbatlas:index/getFederatedSettingsIdentityProviders:getFederatedSettingsIdentityProviders', __args__, opts=opts, typ=GetFederatedSettingsIdentityProvidersResult)
    return __ret__.apply(lambda __response__: GetFederatedSettingsIdentityProvidersResult(
        federation_settings_id=pulumi.get(__response__, 'federation_settings_id'),
        id=pulumi.get(__response__, 'id'),
        idp_types=pulumi.get(__response__, 'idp_types'),
        protocols=pulumi.get(__response__, 'protocols'),
        results=pulumi.get(__response__, 'results')))
