# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetFlexRestoreJobResult',
    'AwaitableGetFlexRestoreJobResult',
    'get_flex_restore_job',
    'get_flex_restore_job_output',
]

@pulumi.output_type
class GetFlexRestoreJobResult:
    """
    A collection of values returned by getFlexRestoreJob.
    """
    def __init__(__self__, delivery_type=None, expiration_date=None, id=None, name=None, project_id=None, restore_finished_date=None, restore_job_id=None, restore_scheduled_date=None, snapshot_finished_date=None, snapshot_id=None, snapshot_url=None, status=None, target_deployment_item_name=None, target_project_id=None):
        if delivery_type and not isinstance(delivery_type, str):
            raise TypeError("Expected argument 'delivery_type' to be a str")
        pulumi.set(__self__, "delivery_type", delivery_type)
        if expiration_date and not isinstance(expiration_date, str):
            raise TypeError("Expected argument 'expiration_date' to be a str")
        pulumi.set(__self__, "expiration_date", expiration_date)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if restore_finished_date and not isinstance(restore_finished_date, str):
            raise TypeError("Expected argument 'restore_finished_date' to be a str")
        pulumi.set(__self__, "restore_finished_date", restore_finished_date)
        if restore_job_id and not isinstance(restore_job_id, str):
            raise TypeError("Expected argument 'restore_job_id' to be a str")
        pulumi.set(__self__, "restore_job_id", restore_job_id)
        if restore_scheduled_date and not isinstance(restore_scheduled_date, str):
            raise TypeError("Expected argument 'restore_scheduled_date' to be a str")
        pulumi.set(__self__, "restore_scheduled_date", restore_scheduled_date)
        if snapshot_finished_date and not isinstance(snapshot_finished_date, str):
            raise TypeError("Expected argument 'snapshot_finished_date' to be a str")
        pulumi.set(__self__, "snapshot_finished_date", snapshot_finished_date)
        if snapshot_id and not isinstance(snapshot_id, str):
            raise TypeError("Expected argument 'snapshot_id' to be a str")
        pulumi.set(__self__, "snapshot_id", snapshot_id)
        if snapshot_url and not isinstance(snapshot_url, str):
            raise TypeError("Expected argument 'snapshot_url' to be a str")
        pulumi.set(__self__, "snapshot_url", snapshot_url)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if target_deployment_item_name and not isinstance(target_deployment_item_name, str):
            raise TypeError("Expected argument 'target_deployment_item_name' to be a str")
        pulumi.set(__self__, "target_deployment_item_name", target_deployment_item_name)
        if target_project_id and not isinstance(target_project_id, str):
            raise TypeError("Expected argument 'target_project_id' to be a str")
        pulumi.set(__self__, "target_project_id", target_project_id)

    @property
    @pulumi.getter(name="deliveryType")
    def delivery_type(self) -> str:
        return pulumi.get(self, "delivery_type")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> str:
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Human-readable label that identifies the flex cluster whose snapshot you want to restore.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="restoreFinishedDate")
    def restore_finished_date(self) -> str:
        return pulumi.get(self, "restore_finished_date")

    @property
    @pulumi.getter(name="restoreJobId")
    def restore_job_id(self) -> str:
        return pulumi.get(self, "restore_job_id")

    @property
    @pulumi.getter(name="restoreScheduledDate")
    def restore_scheduled_date(self) -> str:
        return pulumi.get(self, "restore_scheduled_date")

    @property
    @pulumi.getter(name="snapshotFinishedDate")
    def snapshot_finished_date(self) -> str:
        return pulumi.get(self, "snapshot_finished_date")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> str:
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter(name="snapshotUrl")
    def snapshot_url(self) -> str:
        return pulumi.get(self, "snapshot_url")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="targetDeploymentItemName")
    def target_deployment_item_name(self) -> str:
        return pulumi.get(self, "target_deployment_item_name")

    @property
    @pulumi.getter(name="targetProjectId")
    def target_project_id(self) -> str:
        return pulumi.get(self, "target_project_id")


class AwaitableGetFlexRestoreJobResult(GetFlexRestoreJobResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlexRestoreJobResult(
            delivery_type=self.delivery_type,
            expiration_date=self.expiration_date,
            id=self.id,
            name=self.name,
            project_id=self.project_id,
            restore_finished_date=self.restore_finished_date,
            restore_job_id=self.restore_job_id,
            restore_scheduled_date=self.restore_scheduled_date,
            snapshot_finished_date=self.snapshot_finished_date,
            snapshot_id=self.snapshot_id,
            snapshot_url=self.snapshot_url,
            status=self.status,
            target_deployment_item_name=self.target_deployment_item_name,
            target_project_id=self.target_project_id)


def get_flex_restore_job(name: Optional[str] = None,
                         project_id: Optional[str] = None,
                         restore_job_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlexRestoreJobResult:
    """
    ## # Data Source: get_flex_restore_job

    `get_flex_restore_job` describes a flex restore job.

    ## Example Usage

    ### S
    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    restore_job = mongodbatlas.get_flex_restore_job(project_id=project_id,
        name=example_cluster["name"],
        restore_job_id=restore_job_id)
    restore_jobs = mongodbatlas.get_flex_restore_jobs(project_id=project_id,
        name=example_cluster["name"])
    pulumi.export("mongodbatlasFlexRestoreJob", restore_job.name)
    pulumi.export("mongodbatlasFlexRestoreJobs", [restore_job.restore_job_id for restoreJob in restore_jobs.results])
    ```


    :param str name: Human-readable label that identifies the flex cluster whose snapshot you want to restore.
    :param str project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['restoreJobId'] = restore_job_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getFlexRestoreJob:getFlexRestoreJob', __args__, opts=opts, typ=GetFlexRestoreJobResult).value

    return AwaitableGetFlexRestoreJobResult(
        delivery_type=pulumi.get(__ret__, 'delivery_type'),
        expiration_date=pulumi.get(__ret__, 'expiration_date'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        restore_finished_date=pulumi.get(__ret__, 'restore_finished_date'),
        restore_job_id=pulumi.get(__ret__, 'restore_job_id'),
        restore_scheduled_date=pulumi.get(__ret__, 'restore_scheduled_date'),
        snapshot_finished_date=pulumi.get(__ret__, 'snapshot_finished_date'),
        snapshot_id=pulumi.get(__ret__, 'snapshot_id'),
        snapshot_url=pulumi.get(__ret__, 'snapshot_url'),
        status=pulumi.get(__ret__, 'status'),
        target_deployment_item_name=pulumi.get(__ret__, 'target_deployment_item_name'),
        target_project_id=pulumi.get(__ret__, 'target_project_id'))
def get_flex_restore_job_output(name: Optional[pulumi.Input[str]] = None,
                                project_id: Optional[pulumi.Input[str]] = None,
                                restore_job_id: Optional[pulumi.Input[str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFlexRestoreJobResult]:
    """
    ## # Data Source: get_flex_restore_job

    `get_flex_restore_job` describes a flex restore job.

    ## Example Usage

    ### S
    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    restore_job = mongodbatlas.get_flex_restore_job(project_id=project_id,
        name=example_cluster["name"],
        restore_job_id=restore_job_id)
    restore_jobs = mongodbatlas.get_flex_restore_jobs(project_id=project_id,
        name=example_cluster["name"])
    pulumi.export("mongodbatlasFlexRestoreJob", restore_job.name)
    pulumi.export("mongodbatlasFlexRestoreJobs", [restore_job.restore_job_id for restoreJob in restore_jobs.results])
    ```


    :param str name: Human-readable label that identifies the flex cluster whose snapshot you want to restore.
    :param str project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['restoreJobId'] = restore_job_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('mongodbatlas:index/getFlexRestoreJob:getFlexRestoreJob', __args__, opts=opts, typ=GetFlexRestoreJobResult)
    return __ret__.apply(lambda __response__: GetFlexRestoreJobResult(
        delivery_type=pulumi.get(__response__, 'delivery_type'),
        expiration_date=pulumi.get(__response__, 'expiration_date'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id'),
        restore_finished_date=pulumi.get(__response__, 'restore_finished_date'),
        restore_job_id=pulumi.get(__response__, 'restore_job_id'),
        restore_scheduled_date=pulumi.get(__response__, 'restore_scheduled_date'),
        snapshot_finished_date=pulumi.get(__response__, 'snapshot_finished_date'),
        snapshot_id=pulumi.get(__response__, 'snapshot_id'),
        snapshot_url=pulumi.get(__response__, 'snapshot_url'),
        status=pulumi.get(__response__, 'status'),
        target_deployment_item_name=pulumi.get(__response__, 'target_deployment_item_name'),
        target_project_id=pulumi.get(__response__, 'target_project_id')))
