# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetResourcePoliciesResult',
    'AwaitableGetResourcePoliciesResult',
    'get_resource_policies',
    'get_resource_policies_output',
]

@pulumi.output_type
class GetResourcePoliciesResult:
    """
    A collection of values returned by getResourcePolicies.
    """
    def __init__(__self__, id=None, org_id=None, resource_policies=None, results=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if resource_policies and not isinstance(resource_policies, list):
            raise TypeError("Expected argument 'resource_policies' to be a list")
        pulumi.set(__self__, "resource_policies", resource_policies)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> str:
        """
        Unique 24-hexadecimal digit string that identifies the organization that contains your projects. Use the /orgs endpoint to retrieve all organizations to which the authenticated user has access.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="resourcePolicies")
    @_utilities.deprecated("""This parameter is deprecated. Please transition to `results`.""")
    def resource_policies(self) -> Sequence['outputs.GetResourcePoliciesResourcePolicyResult']:
        return pulumi.get(self, "resource_policies")

    @property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetResourcePoliciesResultResult']:
        """
        List of documents that MongoDB Cloud returns for this request.
        """
        return pulumi.get(self, "results")


class AwaitableGetResourcePoliciesResult(GetResourcePoliciesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourcePoliciesResult(
            id=self.id,
            org_id=self.org_id,
            resource_policies=self.resource_policies,
            results=self.results)


def get_resource_policies(org_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourcePoliciesResult:
    """
    ## Example Usage


    :param str org_id: Unique 24-hexadecimal digit string that identifies the organization that contains your projects. Use the /orgs endpoint to retrieve all organizations to which the authenticated user has access.
    """
    __args__ = dict()
    __args__['orgId'] = org_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getResourcePolicies:getResourcePolicies', __args__, opts=opts, typ=GetResourcePoliciesResult).value

    return AwaitableGetResourcePoliciesResult(
        id=pulumi.get(__ret__, 'id'),
        org_id=pulumi.get(__ret__, 'org_id'),
        resource_policies=pulumi.get(__ret__, 'resource_policies'),
        results=pulumi.get(__ret__, 'results'))
def get_resource_policies_output(org_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourcePoliciesResult]:
    """
    ## Example Usage


    :param str org_id: Unique 24-hexadecimal digit string that identifies the organization that contains your projects. Use the /orgs endpoint to retrieve all organizations to which the authenticated user has access.
    """
    __args__ = dict()
    __args__['orgId'] = org_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('mongodbatlas:index/getResourcePolicies:getResourcePolicies', __args__, opts=opts, typ=GetResourcePoliciesResult)
    return __ret__.apply(lambda __response__: GetResourcePoliciesResult(
        id=pulumi.get(__response__, 'id'),
        org_id=pulumi.get(__response__, 'org_id'),
        resource_policies=pulumi.get(__response__, 'resource_policies'),
        results=pulumi.get(__response__, 'results')))
