# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSearchDeploymentResult',
    'AwaitableGetSearchDeploymentResult',
    'get_search_deployment',
    'get_search_deployment_output',
]

@pulumi.output_type
class GetSearchDeploymentResult:
    """
    A collection of values returned by getSearchDeployment.
    """
    def __init__(__self__, cluster_name=None, id=None, project_id=None, specs=None, state_name=None):
        if cluster_name and not isinstance(cluster_name, str):
            raise TypeError("Expected argument 'cluster_name' to be a str")
        pulumi.set(__self__, "cluster_name", cluster_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if specs and not isinstance(specs, list):
            raise TypeError("Expected argument 'specs' to be a list")
        pulumi.set(__self__, "specs", specs)
        if state_name and not isinstance(state_name, str):
            raise TypeError("Expected argument 'state_name' to be a str")
        pulumi.set(__self__, "state_name", state_name)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        """
        Label that identifies the cluster to return the search nodes for.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique 24-hexadecimal digit string that identifies the search deployment.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        Unique 24-hexadecimal digit string that identifies your project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def specs(self) -> Sequence['outputs.GetSearchDeploymentSpecResult']:
        """
        List of settings that configure the search nodes for your cluster. This list is currently limited to defining a single element.
        """
        return pulumi.get(self, "specs")

    @property
    @pulumi.getter(name="stateName")
    def state_name(self) -> str:
        """
        Human-readable label that indicates the current operating condition of this search deployment.
        """
        return pulumi.get(self, "state_name")


class AwaitableGetSearchDeploymentResult(GetSearchDeploymentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSearchDeploymentResult(
            cluster_name=self.cluster_name,
            id=self.id,
            project_id=self.project_id,
            specs=self.specs,
            state_name=self.state_name)


def get_search_deployment(cluster_name: Optional[str] = None,
                          project_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSearchDeploymentResult:
    """
    ## # Data Source: SearchDeployment

    `SearchDeployment` describes a search node deployment.

    ## Example Usage


    :param str cluster_name: Label that identifies the cluster to return the search nodes for.
    :param str project_id: Unique 24-hexadecimal digit string that identifies your project.
    """
    __args__ = dict()
    __args__['clusterName'] = cluster_name
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getSearchDeployment:getSearchDeployment', __args__, opts=opts, typ=GetSearchDeploymentResult).value

    return AwaitableGetSearchDeploymentResult(
        cluster_name=pulumi.get(__ret__, 'cluster_name'),
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        specs=pulumi.get(__ret__, 'specs'),
        state_name=pulumi.get(__ret__, 'state_name'))
def get_search_deployment_output(cluster_name: Optional[pulumi.Input[str]] = None,
                                 project_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSearchDeploymentResult]:
    """
    ## # Data Source: SearchDeployment

    `SearchDeployment` describes a search node deployment.

    ## Example Usage


    :param str cluster_name: Label that identifies the cluster to return the search nodes for.
    :param str project_id: Unique 24-hexadecimal digit string that identifies your project.
    """
    __args__ = dict()
    __args__['clusterName'] = cluster_name
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('mongodbatlas:index/getSearchDeployment:getSearchDeployment', __args__, opts=opts, typ=GetSearchDeploymentResult)
    return __ret__.apply(lambda __response__: GetSearchDeploymentResult(
        cluster_name=pulumi.get(__response__, 'cluster_name'),
        id=pulumi.get(__response__, 'id'),
        project_id=pulumi.get(__response__, 'project_id'),
        specs=pulumi.get(__response__, 'specs'),
        state_name=pulumi.get(__response__, 'state_name')))
