# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetStreamConnectionResult',
    'AwaitableGetStreamConnectionResult',
    'get_stream_connection',
    'get_stream_connection_output',
]

@pulumi.output_type
class GetStreamConnectionResult:
    """
    A collection of values returned by getStreamConnection.
    """
    def __init__(__self__, authentication=None, aws=None, bootstrap_servers=None, cluster_name=None, config=None, connection_name=None, db_role_to_execute=None, id=None, instance_name=None, networking=None, project_id=None, security=None, type=None):
        if authentication and not isinstance(authentication, dict):
            raise TypeError("Expected argument 'authentication' to be a dict")
        pulumi.set(__self__, "authentication", authentication)
        if aws and not isinstance(aws, dict):
            raise TypeError("Expected argument 'aws' to be a dict")
        pulumi.set(__self__, "aws", aws)
        if bootstrap_servers and not isinstance(bootstrap_servers, str):
            raise TypeError("Expected argument 'bootstrap_servers' to be a str")
        pulumi.set(__self__, "bootstrap_servers", bootstrap_servers)
        if cluster_name and not isinstance(cluster_name, str):
            raise TypeError("Expected argument 'cluster_name' to be a str")
        pulumi.set(__self__, "cluster_name", cluster_name)
        if config and not isinstance(config, dict):
            raise TypeError("Expected argument 'config' to be a dict")
        pulumi.set(__self__, "config", config)
        if connection_name and not isinstance(connection_name, str):
            raise TypeError("Expected argument 'connection_name' to be a str")
        pulumi.set(__self__, "connection_name", connection_name)
        if db_role_to_execute and not isinstance(db_role_to_execute, dict):
            raise TypeError("Expected argument 'db_role_to_execute' to be a dict")
        pulumi.set(__self__, "db_role_to_execute", db_role_to_execute)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_name and not isinstance(instance_name, str):
            raise TypeError("Expected argument 'instance_name' to be a str")
        pulumi.set(__self__, "instance_name", instance_name)
        if networking and not isinstance(networking, dict):
            raise TypeError("Expected argument 'networking' to be a dict")
        pulumi.set(__self__, "networking", networking)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if security and not isinstance(security, dict):
            raise TypeError("Expected argument 'security' to be a dict")
        pulumi.set(__self__, "security", security)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def authentication(self) -> 'outputs.GetStreamConnectionAuthenticationResult':
        """
        User credentials required to connect to a Kafka cluster. Includes the authentication type, as well as the parameters for that authentication mode. See authentication.
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter
    def aws(self) -> 'outputs.GetStreamConnectionAwsResult':
        """
        The configuration for AWS Lambda connection. See AWS
        """
        return pulumi.get(self, "aws")

    @property
    @pulumi.getter(name="bootstrapServers")
    def bootstrap_servers(self) -> str:
        """
        Comma separated list of server addresses.
        """
        return pulumi.get(self, "bootstrap_servers")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        """
        Name of the cluster configured for this connection.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def config(self) -> Mapping[str, str]:
        """
        A map of Kafka key-value pairs for optional configuration. This is a flat object, and keys can have '.' characters.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> str:
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter(name="dbRoleToExecute")
    def db_role_to_execute(self) -> 'outputs.GetStreamConnectionDbRoleToExecuteResult':
        """
        The name of a Built in or Custom DB Role to connect to an Atlas Cluster. See DBRoleToExecute.
        """
        return pulumi.get(self, "db_role_to_execute")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter
    def networking(self) -> 'outputs.GetStreamConnectionNetworkingResult':
        """
        Networking Access Type can either be `PUBLIC` (default) or `VPC`. See networking.
        """
        return pulumi.get(self, "networking")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def security(self) -> 'outputs.GetStreamConnectionSecurityResult':
        """
        Properties for the secure transport connection to Kafka. For SSL, this can include the trusted certificate to use. See security.
        """
        return pulumi.get(self, "security")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Selected networking type. Either `PUBLIC`, `VPC` or `PRIVATE_LINK`. Defaults to `PUBLIC`.
        """
        return pulumi.get(self, "type")


class AwaitableGetStreamConnectionResult(GetStreamConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamConnectionResult(
            authentication=self.authentication,
            aws=self.aws,
            bootstrap_servers=self.bootstrap_servers,
            cluster_name=self.cluster_name,
            config=self.config,
            connection_name=self.connection_name,
            db_role_to_execute=self.db_role_to_execute,
            id=self.id,
            instance_name=self.instance_name,
            networking=self.networking,
            project_id=self.project_id,
            security=self.security,
            type=self.type)


def get_stream_connection(connection_name: Optional[str] = None,
                          instance_name: Optional[str] = None,
                          project_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamConnectionResult:
    """
    ## # Data Source: StreamConnection

    `StreamConnection` describes a stream connection.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    example = mongodbatlas.get_stream_connection(project_id="<PROJECT_ID>",
        instance_name="<INSTANCE_NAME>",
        connection_name="<CONNECTION_NAME>")
    ```


    :param str connection_name: Human-readable label that identifies the stream connection. In the case of the Sample type, this is the name of the sample source.
    :param str instance_name: Human-readable label that identifies the stream instance.
    :param str project_id: Unique 24-hexadecimal digit string that identifies your project.
    """
    __args__ = dict()
    __args__['connectionName'] = connection_name
    __args__['instanceName'] = instance_name
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getStreamConnection:getStreamConnection', __args__, opts=opts, typ=GetStreamConnectionResult).value

    return AwaitableGetStreamConnectionResult(
        authentication=pulumi.get(__ret__, 'authentication'),
        aws=pulumi.get(__ret__, 'aws'),
        bootstrap_servers=pulumi.get(__ret__, 'bootstrap_servers'),
        cluster_name=pulumi.get(__ret__, 'cluster_name'),
        config=pulumi.get(__ret__, 'config'),
        connection_name=pulumi.get(__ret__, 'connection_name'),
        db_role_to_execute=pulumi.get(__ret__, 'db_role_to_execute'),
        id=pulumi.get(__ret__, 'id'),
        instance_name=pulumi.get(__ret__, 'instance_name'),
        networking=pulumi.get(__ret__, 'networking'),
        project_id=pulumi.get(__ret__, 'project_id'),
        security=pulumi.get(__ret__, 'security'),
        type=pulumi.get(__ret__, 'type'))
def get_stream_connection_output(connection_name: Optional[pulumi.Input[str]] = None,
                                 instance_name: Optional[pulumi.Input[str]] = None,
                                 project_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStreamConnectionResult]:
    """
    ## # Data Source: StreamConnection

    `StreamConnection` describes a stream connection.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    example = mongodbatlas.get_stream_connection(project_id="<PROJECT_ID>",
        instance_name="<INSTANCE_NAME>",
        connection_name="<CONNECTION_NAME>")
    ```


    :param str connection_name: Human-readable label that identifies the stream connection. In the case of the Sample type, this is the name of the sample source.
    :param str instance_name: Human-readable label that identifies the stream instance.
    :param str project_id: Unique 24-hexadecimal digit string that identifies your project.
    """
    __args__ = dict()
    __args__['connectionName'] = connection_name
    __args__['instanceName'] = instance_name
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('mongodbatlas:index/getStreamConnection:getStreamConnection', __args__, opts=opts, typ=GetStreamConnectionResult)
    return __ret__.apply(lambda __response__: GetStreamConnectionResult(
        authentication=pulumi.get(__response__, 'authentication'),
        aws=pulumi.get(__response__, 'aws'),
        bootstrap_servers=pulumi.get(__response__, 'bootstrap_servers'),
        cluster_name=pulumi.get(__response__, 'cluster_name'),
        config=pulumi.get(__response__, 'config'),
        connection_name=pulumi.get(__response__, 'connection_name'),
        db_role_to_execute=pulumi.get(__response__, 'db_role_to_execute'),
        id=pulumi.get(__response__, 'id'),
        instance_name=pulumi.get(__response__, 'instance_name'),
        networking=pulumi.get(__response__, 'networking'),
        project_id=pulumi.get(__response__, 'project_id'),
        security=pulumi.get(__response__, 'security'),
        type=pulumi.get(__response__, 'type')))
