# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OnlineArchiveArgs', 'OnlineArchive']

@pulumi.input_type
class OnlineArchiveArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[str],
                 coll_name: pulumi.Input[str],
                 criteria: pulumi.Input['OnlineArchiveCriteriaArgs'],
                 db_name: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 collection_type: Optional[pulumi.Input[str]] = None,
                 data_expiration_rule: Optional[pulumi.Input['OnlineArchiveDataExpirationRuleArgs']] = None,
                 data_process_region: Optional[pulumi.Input['OnlineArchiveDataProcessRegionArgs']] = None,
                 partition_fields: Optional[pulumi.Input[Sequence[pulumi.Input['OnlineArchivePartitionFieldArgs']]]] = None,
                 paused: Optional[pulumi.Input[bool]] = None,
                 schedule: Optional[pulumi.Input['OnlineArchiveScheduleArgs']] = None,
                 sync_creation: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a OnlineArchive resource.
        :param pulumi.Input[str] cluster_name: Name of the cluster that contains the collection.
        :param pulumi.Input[str] coll_name: Name of the collection.
        :param pulumi.Input['OnlineArchiveCriteriaArgs'] criteria: Criteria to use for archiving data. See criteria.
        :param pulumi.Input[str] db_name: Name of the database that contains the collection.
        :param pulumi.Input[str] project_id: The unique ID for the project
        :param pulumi.Input[str] collection_type: Type of MongoDB collection that you want to return. This value can be "TIMESERIES" or "STANDARD". Default is "STANDARD".
        :param pulumi.Input['OnlineArchiveDataExpirationRuleArgs'] data_expiration_rule: Rule for specifying when data should be deleted from the archive. See data expiration rule.
        :param pulumi.Input['OnlineArchiveDataProcessRegionArgs'] data_process_region: Settings to configure the region where you wish to store your archived data. See data process region. This field is immutable hence cannot be updated.
        :param pulumi.Input[Sequence[pulumi.Input['OnlineArchivePartitionFieldArgs']]] partition_fields: Fields to use to partition data. You can specify up to two frequently queried fields (or up to three fields when one of them is `date_field`) to use for partitioning data. Queries that don’t contain the specified fields require a full collection scan of all archived documents, which takes longer and increases your costs. To learn more about how partition improves query performance, see [Data Structure in S3](https://docs.mongodb.com/datalake/admin/optimize-query-performance/#data-structure-in-s3). The value of a partition field can be up to a maximum of 700 characters. Documents with values exceeding 700 characters are not archived. See partition fields.
        :param pulumi.Input[bool] paused: State of the online archive. This is required for pausing an active online archive or resuming a paused online archive. If the collection has another active online archive, the resume request fails.
        :param pulumi.Input['OnlineArchiveScheduleArgs'] schedule: Regular frequency and duration when archiving process occurs. See schedule.
        :param pulumi.Input[bool] sync_creation: Flag that indicates whether the provider will wait for the state of the online archive to reach `IDLE` or `ACTIVE` when creating an online archive. Defaults to `false`.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "coll_name", coll_name)
        pulumi.set(__self__, "criteria", criteria)
        pulumi.set(__self__, "db_name", db_name)
        pulumi.set(__self__, "project_id", project_id)
        if collection_type is not None:
            pulumi.set(__self__, "collection_type", collection_type)
        if data_expiration_rule is not None:
            pulumi.set(__self__, "data_expiration_rule", data_expiration_rule)
        if data_process_region is not None:
            pulumi.set(__self__, "data_process_region", data_process_region)
        if partition_fields is not None:
            pulumi.set(__self__, "partition_fields", partition_fields)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if sync_creation is not None:
            pulumi.set(__self__, "sync_creation", sync_creation)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[str]:
        """
        Name of the cluster that contains the collection.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="collName")
    def coll_name(self) -> pulumi.Input[str]:
        """
        Name of the collection.
        """
        return pulumi.get(self, "coll_name")

    @coll_name.setter
    def coll_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "coll_name", value)

    @property
    @pulumi.getter
    def criteria(self) -> pulumi.Input['OnlineArchiveCriteriaArgs']:
        """
        Criteria to use for archiving data. See criteria.
        """
        return pulumi.get(self, "criteria")

    @criteria.setter
    def criteria(self, value: pulumi.Input['OnlineArchiveCriteriaArgs']):
        pulumi.set(self, "criteria", value)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Input[str]:
        """
        Name of the database that contains the collection.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The unique ID for the project
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="collectionType")
    def collection_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of MongoDB collection that you want to return. This value can be "TIMESERIES" or "STANDARD". Default is "STANDARD".
        """
        return pulumi.get(self, "collection_type")

    @collection_type.setter
    def collection_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collection_type", value)

    @property
    @pulumi.getter(name="dataExpirationRule")
    def data_expiration_rule(self) -> Optional[pulumi.Input['OnlineArchiveDataExpirationRuleArgs']]:
        """
        Rule for specifying when data should be deleted from the archive. See data expiration rule.
        """
        return pulumi.get(self, "data_expiration_rule")

    @data_expiration_rule.setter
    def data_expiration_rule(self, value: Optional[pulumi.Input['OnlineArchiveDataExpirationRuleArgs']]):
        pulumi.set(self, "data_expiration_rule", value)

    @property
    @pulumi.getter(name="dataProcessRegion")
    def data_process_region(self) -> Optional[pulumi.Input['OnlineArchiveDataProcessRegionArgs']]:
        """
        Settings to configure the region where you wish to store your archived data. See data process region. This field is immutable hence cannot be updated.
        """
        return pulumi.get(self, "data_process_region")

    @data_process_region.setter
    def data_process_region(self, value: Optional[pulumi.Input['OnlineArchiveDataProcessRegionArgs']]):
        pulumi.set(self, "data_process_region", value)

    @property
    @pulumi.getter(name="partitionFields")
    def partition_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OnlineArchivePartitionFieldArgs']]]]:
        """
        Fields to use to partition data. You can specify up to two frequently queried fields (or up to three fields when one of them is `date_field`) to use for partitioning data. Queries that don’t contain the specified fields require a full collection scan of all archived documents, which takes longer and increases your costs. To learn more about how partition improves query performance, see [Data Structure in S3](https://docs.mongodb.com/datalake/admin/optimize-query-performance/#data-structure-in-s3). The value of a partition field can be up to a maximum of 700 characters. Documents with values exceeding 700 characters are not archived. See partition fields.
        """
        return pulumi.get(self, "partition_fields")

    @partition_fields.setter
    def partition_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OnlineArchivePartitionFieldArgs']]]]):
        pulumi.set(self, "partition_fields", value)

    @property
    @pulumi.getter
    def paused(self) -> Optional[pulumi.Input[bool]]:
        """
        State of the online archive. This is required for pausing an active online archive or resuming a paused online archive. If the collection has another active online archive, the resume request fails.
        """
        return pulumi.get(self, "paused")

    @paused.setter
    def paused(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "paused", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['OnlineArchiveScheduleArgs']]:
        """
        Regular frequency and duration when archiving process occurs. See schedule.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['OnlineArchiveScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="syncCreation")
    def sync_creation(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag that indicates whether the provider will wait for the state of the online archive to reach `IDLE` or `ACTIVE` when creating an online archive. Defaults to `false`.
        """
        return pulumi.get(self, "sync_creation")

    @sync_creation.setter
    def sync_creation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sync_creation", value)


@pulumi.input_type
class _OnlineArchiveState:
    def __init__(__self__, *,
                 archive_id: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 coll_name: Optional[pulumi.Input[str]] = None,
                 collection_type: Optional[pulumi.Input[str]] = None,
                 criteria: Optional[pulumi.Input['OnlineArchiveCriteriaArgs']] = None,
                 data_expiration_rule: Optional[pulumi.Input['OnlineArchiveDataExpirationRuleArgs']] = None,
                 data_process_region: Optional[pulumi.Input['OnlineArchiveDataProcessRegionArgs']] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 partition_fields: Optional[pulumi.Input[Sequence[pulumi.Input['OnlineArchivePartitionFieldArgs']]]] = None,
                 paused: Optional[pulumi.Input[bool]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input['OnlineArchiveScheduleArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 sync_creation: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering OnlineArchive resources.
        :param pulumi.Input[str] archive_id: ID of the online archive.
        :param pulumi.Input[str] cluster_name: Name of the cluster that contains the collection.
        :param pulumi.Input[str] coll_name: Name of the collection.
        :param pulumi.Input[str] collection_type: Type of MongoDB collection that you want to return. This value can be "TIMESERIES" or "STANDARD". Default is "STANDARD".
        :param pulumi.Input['OnlineArchiveCriteriaArgs'] criteria: Criteria to use for archiving data. See criteria.
        :param pulumi.Input['OnlineArchiveDataExpirationRuleArgs'] data_expiration_rule: Rule for specifying when data should be deleted from the archive. See data expiration rule.
        :param pulumi.Input['OnlineArchiveDataProcessRegionArgs'] data_process_region: Settings to configure the region where you wish to store your archived data. See data process region. This field is immutable hence cannot be updated.
        :param pulumi.Input[str] db_name: Name of the database that contains the collection.
        :param pulumi.Input[Sequence[pulumi.Input['OnlineArchivePartitionFieldArgs']]] partition_fields: Fields to use to partition data. You can specify up to two frequently queried fields (or up to three fields when one of them is `date_field`) to use for partitioning data. Queries that don’t contain the specified fields require a full collection scan of all archived documents, which takes longer and increases your costs. To learn more about how partition improves query performance, see [Data Structure in S3](https://docs.mongodb.com/datalake/admin/optimize-query-performance/#data-structure-in-s3). The value of a partition field can be up to a maximum of 700 characters. Documents with values exceeding 700 characters are not archived. See partition fields.
        :param pulumi.Input[bool] paused: State of the online archive. This is required for pausing an active online archive or resuming a paused online archive. If the collection has another active online archive, the resume request fails.
        :param pulumi.Input[str] project_id: The unique ID for the project
        :param pulumi.Input['OnlineArchiveScheduleArgs'] schedule: Regular frequency and duration when archiving process occurs. See schedule.
        :param pulumi.Input[str] state: Status of the online archive. Valid values are: Pending, Archiving, Idle, Pausing, Paused, Orphaned and Deleted
        :param pulumi.Input[bool] sync_creation: Flag that indicates whether the provider will wait for the state of the online archive to reach `IDLE` or `ACTIVE` when creating an online archive. Defaults to `false`.
        """
        if archive_id is not None:
            pulumi.set(__self__, "archive_id", archive_id)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if coll_name is not None:
            pulumi.set(__self__, "coll_name", coll_name)
        if collection_type is not None:
            pulumi.set(__self__, "collection_type", collection_type)
        if criteria is not None:
            pulumi.set(__self__, "criteria", criteria)
        if data_expiration_rule is not None:
            pulumi.set(__self__, "data_expiration_rule", data_expiration_rule)
        if data_process_region is not None:
            pulumi.set(__self__, "data_process_region", data_process_region)
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if partition_fields is not None:
            pulumi.set(__self__, "partition_fields", partition_fields)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if sync_creation is not None:
            pulumi.set(__self__, "sync_creation", sync_creation)

    @property
    @pulumi.getter(name="archiveId")
    def archive_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the online archive.
        """
        return pulumi.get(self, "archive_id")

    @archive_id.setter
    def archive_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "archive_id", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the cluster that contains the collection.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="collName")
    def coll_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the collection.
        """
        return pulumi.get(self, "coll_name")

    @coll_name.setter
    def coll_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "coll_name", value)

    @property
    @pulumi.getter(name="collectionType")
    def collection_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of MongoDB collection that you want to return. This value can be "TIMESERIES" or "STANDARD". Default is "STANDARD".
        """
        return pulumi.get(self, "collection_type")

    @collection_type.setter
    def collection_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collection_type", value)

    @property
    @pulumi.getter
    def criteria(self) -> Optional[pulumi.Input['OnlineArchiveCriteriaArgs']]:
        """
        Criteria to use for archiving data. See criteria.
        """
        return pulumi.get(self, "criteria")

    @criteria.setter
    def criteria(self, value: Optional[pulumi.Input['OnlineArchiveCriteriaArgs']]):
        pulumi.set(self, "criteria", value)

    @property
    @pulumi.getter(name="dataExpirationRule")
    def data_expiration_rule(self) -> Optional[pulumi.Input['OnlineArchiveDataExpirationRuleArgs']]:
        """
        Rule for specifying when data should be deleted from the archive. See data expiration rule.
        """
        return pulumi.get(self, "data_expiration_rule")

    @data_expiration_rule.setter
    def data_expiration_rule(self, value: Optional[pulumi.Input['OnlineArchiveDataExpirationRuleArgs']]):
        pulumi.set(self, "data_expiration_rule", value)

    @property
    @pulumi.getter(name="dataProcessRegion")
    def data_process_region(self) -> Optional[pulumi.Input['OnlineArchiveDataProcessRegionArgs']]:
        """
        Settings to configure the region where you wish to store your archived data. See data process region. This field is immutable hence cannot be updated.
        """
        return pulumi.get(self, "data_process_region")

    @data_process_region.setter
    def data_process_region(self, value: Optional[pulumi.Input['OnlineArchiveDataProcessRegionArgs']]):
        pulumi.set(self, "data_process_region", value)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the database that contains the collection.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="partitionFields")
    def partition_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OnlineArchivePartitionFieldArgs']]]]:
        """
        Fields to use to partition data. You can specify up to two frequently queried fields (or up to three fields when one of them is `date_field`) to use for partitioning data. Queries that don’t contain the specified fields require a full collection scan of all archived documents, which takes longer and increases your costs. To learn more about how partition improves query performance, see [Data Structure in S3](https://docs.mongodb.com/datalake/admin/optimize-query-performance/#data-structure-in-s3). The value of a partition field can be up to a maximum of 700 characters. Documents with values exceeding 700 characters are not archived. See partition fields.
        """
        return pulumi.get(self, "partition_fields")

    @partition_fields.setter
    def partition_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OnlineArchivePartitionFieldArgs']]]]):
        pulumi.set(self, "partition_fields", value)

    @property
    @pulumi.getter
    def paused(self) -> Optional[pulumi.Input[bool]]:
        """
        State of the online archive. This is required for pausing an active online archive or resuming a paused online archive. If the collection has another active online archive, the resume request fails.
        """
        return pulumi.get(self, "paused")

    @paused.setter
    def paused(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "paused", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique ID for the project
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['OnlineArchiveScheduleArgs']]:
        """
        Regular frequency and duration when archiving process occurs. See schedule.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['OnlineArchiveScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the online archive. Valid values are: Pending, Archiving, Idle, Pausing, Paused, Orphaned and Deleted
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="syncCreation")
    def sync_creation(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag that indicates whether the provider will wait for the state of the online archive to reach `IDLE` or `ACTIVE` when creating an online archive. Defaults to `false`.
        """
        return pulumi.get(self, "sync_creation")

    @sync_creation.setter
    def sync_creation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sync_creation", value)


class OnlineArchive(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 coll_name: Optional[pulumi.Input[str]] = None,
                 collection_type: Optional[pulumi.Input[str]] = None,
                 criteria: Optional[pulumi.Input[Union['OnlineArchiveCriteriaArgs', 'OnlineArchiveCriteriaArgsDict']]] = None,
                 data_expiration_rule: Optional[pulumi.Input[Union['OnlineArchiveDataExpirationRuleArgs', 'OnlineArchiveDataExpirationRuleArgsDict']]] = None,
                 data_process_region: Optional[pulumi.Input[Union['OnlineArchiveDataProcessRegionArgs', 'OnlineArchiveDataProcessRegionArgsDict']]] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 partition_fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OnlineArchivePartitionFieldArgs', 'OnlineArchivePartitionFieldArgsDict']]]]] = None,
                 paused: Optional[pulumi.Input[bool]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[Union['OnlineArchiveScheduleArgs', 'OnlineArchiveScheduleArgsDict']]] = None,
                 sync_creation: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        ## # Resource: OnlineArchive

        `OnlineArchive` resource provides access to create, edit, pause and resume an online archive for a collection.

        > **NOTE:** Groups and projects are synonymous terms. You may find group_id in the official documentation.

        > **IMPORTANT:** The collection must exists before performing an online archive.

        > **IMPORTANT:** There are fields that are immutable after creation, i.e if `date_field` value does not exist in the collection, the online archive state will be pending forever, and this field cannot be updated, that means a destroy is required, known error `ONLINE_ARCHIVE_CANNOT_MODIFY_FIELD`

        > **IMPORTANT:** Support for Online Archive on `GCP` is available in Private Preview. To request access and participate in the Private Preview release of this feature, complete the [sign-up form](https://www.mongodb.com/products/platform/atlas-online-archive#promo).

        ## Example Usage

        ### S
        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.OnlineArchive("test",
            project_id=project_id,
            cluster_name=cluster_name,
            coll_name=collection_name,
            db_name=database_name,
            partition_fields=[
                {
                    "field_name": "dateField",
                    "order": 0,
                },
                {
                    "field_name": "firstName",
                    "order": 1,
                },
                {
                    "field_name": "lastName",
                    "order": 2,
                },
            ],
            criteria={
                "type": "DATE",
                "date_field": "dateField",
                "expire_after_days": 5,
            },
            schedule={
                "type": "DAILY",
                "end_hour": 1,
                "end_minute": 1,
                "start_hour": 1,
                "start_minute": 1,
            })
        ```

        For custom criteria example

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.OnlineArchive("test",
            project_id=project_id,
            cluster_name=cluster_name,
            coll_name=collection_name,
            db_name=database_name,
            partition_fields=[
                {
                    "field_name": "firstName",
                    "order": 0,
                },
                {
                    "field_name": "secondName",
                    "order": 1,
                },
            ],
            criteria={
                "type": "CUSTOM",
                "query": "{ \\"department\\": \\"engineering\\" }",
            })
        ```

        Defining custom provider and region example

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.OnlineArchive("test",
            project_id=project_id,
            cluster_name=cluster_name,
            coll_name=collection_name,
            db_name=database_name,
            data_process_region={
                "cloud_provider": "AZURE",
                "region": "US_EAST_2",
            },
            partition_fields=[{
                "field_name": "firstName",
                "order": 0,
            }],
            criteria={
                "type": "CUSTOM",
                "query": "{ \\"department\\": \\"engineering\\" }",
            })
        ```

        ## Import

        See [MongoDB Atlas API](https://docs.atlas.mongodb.com/reference/api/online-archive-create-one/) Documentation for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_name: Name of the cluster that contains the collection.
        :param pulumi.Input[str] coll_name: Name of the collection.
        :param pulumi.Input[str] collection_type: Type of MongoDB collection that you want to return. This value can be "TIMESERIES" or "STANDARD". Default is "STANDARD".
        :param pulumi.Input[Union['OnlineArchiveCriteriaArgs', 'OnlineArchiveCriteriaArgsDict']] criteria: Criteria to use for archiving data. See criteria.
        :param pulumi.Input[Union['OnlineArchiveDataExpirationRuleArgs', 'OnlineArchiveDataExpirationRuleArgsDict']] data_expiration_rule: Rule for specifying when data should be deleted from the archive. See data expiration rule.
        :param pulumi.Input[Union['OnlineArchiveDataProcessRegionArgs', 'OnlineArchiveDataProcessRegionArgsDict']] data_process_region: Settings to configure the region where you wish to store your archived data. See data process region. This field is immutable hence cannot be updated.
        :param pulumi.Input[str] db_name: Name of the database that contains the collection.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OnlineArchivePartitionFieldArgs', 'OnlineArchivePartitionFieldArgsDict']]]] partition_fields: Fields to use to partition data. You can specify up to two frequently queried fields (or up to three fields when one of them is `date_field`) to use for partitioning data. Queries that don’t contain the specified fields require a full collection scan of all archived documents, which takes longer and increases your costs. To learn more about how partition improves query performance, see [Data Structure in S3](https://docs.mongodb.com/datalake/admin/optimize-query-performance/#data-structure-in-s3). The value of a partition field can be up to a maximum of 700 characters. Documents with values exceeding 700 characters are not archived. See partition fields.
        :param pulumi.Input[bool] paused: State of the online archive. This is required for pausing an active online archive or resuming a paused online archive. If the collection has another active online archive, the resume request fails.
        :param pulumi.Input[str] project_id: The unique ID for the project
        :param pulumi.Input[Union['OnlineArchiveScheduleArgs', 'OnlineArchiveScheduleArgsDict']] schedule: Regular frequency and duration when archiving process occurs. See schedule.
        :param pulumi.Input[bool] sync_creation: Flag that indicates whether the provider will wait for the state of the online archive to reach `IDLE` or `ACTIVE` when creating an online archive. Defaults to `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OnlineArchiveArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: OnlineArchive

        `OnlineArchive` resource provides access to create, edit, pause and resume an online archive for a collection.

        > **NOTE:** Groups and projects are synonymous terms. You may find group_id in the official documentation.

        > **IMPORTANT:** The collection must exists before performing an online archive.

        > **IMPORTANT:** There are fields that are immutable after creation, i.e if `date_field` value does not exist in the collection, the online archive state will be pending forever, and this field cannot be updated, that means a destroy is required, known error `ONLINE_ARCHIVE_CANNOT_MODIFY_FIELD`

        > **IMPORTANT:** Support for Online Archive on `GCP` is available in Private Preview. To request access and participate in the Private Preview release of this feature, complete the [sign-up form](https://www.mongodb.com/products/platform/atlas-online-archive#promo).

        ## Example Usage

        ### S
        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.OnlineArchive("test",
            project_id=project_id,
            cluster_name=cluster_name,
            coll_name=collection_name,
            db_name=database_name,
            partition_fields=[
                {
                    "field_name": "dateField",
                    "order": 0,
                },
                {
                    "field_name": "firstName",
                    "order": 1,
                },
                {
                    "field_name": "lastName",
                    "order": 2,
                },
            ],
            criteria={
                "type": "DATE",
                "date_field": "dateField",
                "expire_after_days": 5,
            },
            schedule={
                "type": "DAILY",
                "end_hour": 1,
                "end_minute": 1,
                "start_hour": 1,
                "start_minute": 1,
            })
        ```

        For custom criteria example

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.OnlineArchive("test",
            project_id=project_id,
            cluster_name=cluster_name,
            coll_name=collection_name,
            db_name=database_name,
            partition_fields=[
                {
                    "field_name": "firstName",
                    "order": 0,
                },
                {
                    "field_name": "secondName",
                    "order": 1,
                },
            ],
            criteria={
                "type": "CUSTOM",
                "query": "{ \\"department\\": \\"engineering\\" }",
            })
        ```

        Defining custom provider and region example

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.OnlineArchive("test",
            project_id=project_id,
            cluster_name=cluster_name,
            coll_name=collection_name,
            db_name=database_name,
            data_process_region={
                "cloud_provider": "AZURE",
                "region": "US_EAST_2",
            },
            partition_fields=[{
                "field_name": "firstName",
                "order": 0,
            }],
            criteria={
                "type": "CUSTOM",
                "query": "{ \\"department\\": \\"engineering\\" }",
            })
        ```

        ## Import

        See [MongoDB Atlas API](https://docs.atlas.mongodb.com/reference/api/online-archive-create-one/) Documentation for more information.

        :param str resource_name: The name of the resource.
        :param OnlineArchiveArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OnlineArchiveArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 coll_name: Optional[pulumi.Input[str]] = None,
                 collection_type: Optional[pulumi.Input[str]] = None,
                 criteria: Optional[pulumi.Input[Union['OnlineArchiveCriteriaArgs', 'OnlineArchiveCriteriaArgsDict']]] = None,
                 data_expiration_rule: Optional[pulumi.Input[Union['OnlineArchiveDataExpirationRuleArgs', 'OnlineArchiveDataExpirationRuleArgsDict']]] = None,
                 data_process_region: Optional[pulumi.Input[Union['OnlineArchiveDataProcessRegionArgs', 'OnlineArchiveDataProcessRegionArgsDict']]] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 partition_fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OnlineArchivePartitionFieldArgs', 'OnlineArchivePartitionFieldArgsDict']]]]] = None,
                 paused: Optional[pulumi.Input[bool]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[Union['OnlineArchiveScheduleArgs', 'OnlineArchiveScheduleArgsDict']]] = None,
                 sync_creation: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OnlineArchiveArgs.__new__(OnlineArchiveArgs)

            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            if coll_name is None and not opts.urn:
                raise TypeError("Missing required property 'coll_name'")
            __props__.__dict__["coll_name"] = coll_name
            __props__.__dict__["collection_type"] = collection_type
            if criteria is None and not opts.urn:
                raise TypeError("Missing required property 'criteria'")
            __props__.__dict__["criteria"] = criteria
            __props__.__dict__["data_expiration_rule"] = data_expiration_rule
            __props__.__dict__["data_process_region"] = data_process_region
            if db_name is None and not opts.urn:
                raise TypeError("Missing required property 'db_name'")
            __props__.__dict__["db_name"] = db_name
            __props__.__dict__["partition_fields"] = partition_fields
            __props__.__dict__["paused"] = paused
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["sync_creation"] = sync_creation
            __props__.__dict__["archive_id"] = None
            __props__.__dict__["state"] = None
        super(OnlineArchive, __self__).__init__(
            'mongodbatlas:index/onlineArchive:OnlineArchive',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            archive_id: Optional[pulumi.Input[str]] = None,
            cluster_name: Optional[pulumi.Input[str]] = None,
            coll_name: Optional[pulumi.Input[str]] = None,
            collection_type: Optional[pulumi.Input[str]] = None,
            criteria: Optional[pulumi.Input[Union['OnlineArchiveCriteriaArgs', 'OnlineArchiveCriteriaArgsDict']]] = None,
            data_expiration_rule: Optional[pulumi.Input[Union['OnlineArchiveDataExpirationRuleArgs', 'OnlineArchiveDataExpirationRuleArgsDict']]] = None,
            data_process_region: Optional[pulumi.Input[Union['OnlineArchiveDataProcessRegionArgs', 'OnlineArchiveDataProcessRegionArgsDict']]] = None,
            db_name: Optional[pulumi.Input[str]] = None,
            partition_fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OnlineArchivePartitionFieldArgs', 'OnlineArchivePartitionFieldArgsDict']]]]] = None,
            paused: Optional[pulumi.Input[bool]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            schedule: Optional[pulumi.Input[Union['OnlineArchiveScheduleArgs', 'OnlineArchiveScheduleArgsDict']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            sync_creation: Optional[pulumi.Input[bool]] = None) -> 'OnlineArchive':
        """
        Get an existing OnlineArchive resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] archive_id: ID of the online archive.
        :param pulumi.Input[str] cluster_name: Name of the cluster that contains the collection.
        :param pulumi.Input[str] coll_name: Name of the collection.
        :param pulumi.Input[str] collection_type: Type of MongoDB collection that you want to return. This value can be "TIMESERIES" or "STANDARD". Default is "STANDARD".
        :param pulumi.Input[Union['OnlineArchiveCriteriaArgs', 'OnlineArchiveCriteriaArgsDict']] criteria: Criteria to use for archiving data. See criteria.
        :param pulumi.Input[Union['OnlineArchiveDataExpirationRuleArgs', 'OnlineArchiveDataExpirationRuleArgsDict']] data_expiration_rule: Rule for specifying when data should be deleted from the archive. See data expiration rule.
        :param pulumi.Input[Union['OnlineArchiveDataProcessRegionArgs', 'OnlineArchiveDataProcessRegionArgsDict']] data_process_region: Settings to configure the region where you wish to store your archived data. See data process region. This field is immutable hence cannot be updated.
        :param pulumi.Input[str] db_name: Name of the database that contains the collection.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OnlineArchivePartitionFieldArgs', 'OnlineArchivePartitionFieldArgsDict']]]] partition_fields: Fields to use to partition data. You can specify up to two frequently queried fields (or up to three fields when one of them is `date_field`) to use for partitioning data. Queries that don’t contain the specified fields require a full collection scan of all archived documents, which takes longer and increases your costs. To learn more about how partition improves query performance, see [Data Structure in S3](https://docs.mongodb.com/datalake/admin/optimize-query-performance/#data-structure-in-s3). The value of a partition field can be up to a maximum of 700 characters. Documents with values exceeding 700 characters are not archived. See partition fields.
        :param pulumi.Input[bool] paused: State of the online archive. This is required for pausing an active online archive or resuming a paused online archive. If the collection has another active online archive, the resume request fails.
        :param pulumi.Input[str] project_id: The unique ID for the project
        :param pulumi.Input[Union['OnlineArchiveScheduleArgs', 'OnlineArchiveScheduleArgsDict']] schedule: Regular frequency and duration when archiving process occurs. See schedule.
        :param pulumi.Input[str] state: Status of the online archive. Valid values are: Pending, Archiving, Idle, Pausing, Paused, Orphaned and Deleted
        :param pulumi.Input[bool] sync_creation: Flag that indicates whether the provider will wait for the state of the online archive to reach `IDLE` or `ACTIVE` when creating an online archive. Defaults to `false`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OnlineArchiveState.__new__(_OnlineArchiveState)

        __props__.__dict__["archive_id"] = archive_id
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["coll_name"] = coll_name
        __props__.__dict__["collection_type"] = collection_type
        __props__.__dict__["criteria"] = criteria
        __props__.__dict__["data_expiration_rule"] = data_expiration_rule
        __props__.__dict__["data_process_region"] = data_process_region
        __props__.__dict__["db_name"] = db_name
        __props__.__dict__["partition_fields"] = partition_fields
        __props__.__dict__["paused"] = paused
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["state"] = state
        __props__.__dict__["sync_creation"] = sync_creation
        return OnlineArchive(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="archiveId")
    def archive_id(self) -> pulumi.Output[str]:
        """
        ID of the online archive.
        """
        return pulumi.get(self, "archive_id")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[str]:
        """
        Name of the cluster that contains the collection.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="collName")
    def coll_name(self) -> pulumi.Output[str]:
        """
        Name of the collection.
        """
        return pulumi.get(self, "coll_name")

    @property
    @pulumi.getter(name="collectionType")
    def collection_type(self) -> pulumi.Output[str]:
        """
        Type of MongoDB collection that you want to return. This value can be "TIMESERIES" or "STANDARD". Default is "STANDARD".
        """
        return pulumi.get(self, "collection_type")

    @property
    @pulumi.getter
    def criteria(self) -> pulumi.Output['outputs.OnlineArchiveCriteria']:
        """
        Criteria to use for archiving data. See criteria.
        """
        return pulumi.get(self, "criteria")

    @property
    @pulumi.getter(name="dataExpirationRule")
    def data_expiration_rule(self) -> pulumi.Output[Optional['outputs.OnlineArchiveDataExpirationRule']]:
        """
        Rule for specifying when data should be deleted from the archive. See data expiration rule.
        """
        return pulumi.get(self, "data_expiration_rule")

    @property
    @pulumi.getter(name="dataProcessRegion")
    def data_process_region(self) -> pulumi.Output['outputs.OnlineArchiveDataProcessRegion']:
        """
        Settings to configure the region where you wish to store your archived data. See data process region. This field is immutable hence cannot be updated.
        """
        return pulumi.get(self, "data_process_region")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Output[str]:
        """
        Name of the database that contains the collection.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="partitionFields")
    def partition_fields(self) -> pulumi.Output[Sequence['outputs.OnlineArchivePartitionField']]:
        """
        Fields to use to partition data. You can specify up to two frequently queried fields (or up to three fields when one of them is `date_field`) to use for partitioning data. Queries that don’t contain the specified fields require a full collection scan of all archived documents, which takes longer and increases your costs. To learn more about how partition improves query performance, see [Data Structure in S3](https://docs.mongodb.com/datalake/admin/optimize-query-performance/#data-structure-in-s3). The value of a partition field can be up to a maximum of 700 characters. Documents with values exceeding 700 characters are not archived. See partition fields.
        """
        return pulumi.get(self, "partition_fields")

    @property
    @pulumi.getter
    def paused(self) -> pulumi.Output[bool]:
        """
        State of the online archive. This is required for pausing an active online archive or resuming a paused online archive. If the collection has another active online archive, the resume request fails.
        """
        return pulumi.get(self, "paused")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The unique ID for the project
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional['outputs.OnlineArchiveSchedule']]:
        """
        Regular frequency and duration when archiving process occurs. See schedule.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Status of the online archive. Valid values are: Pending, Archiving, Idle, Pausing, Paused, Orphaned and Deleted
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="syncCreation")
    def sync_creation(self) -> pulumi.Output[Optional[bool]]:
        """
        Flag that indicates whether the provider will wait for the state of the online archive to reach `IDLE` or `ACTIVE` when creating an online archive. Defaults to `false`.
        """
        return pulumi.get(self, "sync_creation")

