# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerlessInstanceArgs', 'ServerlessInstance']

@pulumi.input_type
class ServerlessInstanceArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[str],
                 provider_settings_backing_provider_name: pulumi.Input[str],
                 provider_settings_provider_name: pulumi.Input[str],
                 provider_settings_region_name: pulumi.Input[str],
                 auto_indexing: Optional[pulumi.Input[bool]] = None,
                 continuous_backup_enabled: Optional[pulumi.Input[bool]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessInstanceLinkArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 state_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessInstanceTagArgs']]]] = None,
                 termination_protection_enabled: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a ServerlessInstance resource.
        :param pulumi.Input[str] project_id: The ID of the organization or project you want to create the serverless instance within.
        :param pulumi.Input[str] provider_settings_backing_provider_name: Cloud service provider on which MongoDB Cloud provisioned the serverless instance.
        :param pulumi.Input[str] provider_settings_provider_name: Cloud service provider that applies to the provisioned the serverless instance.
        :param pulumi.Input[str] provider_settings_region_name: Human-readable label that identifies the physical location of your MongoDB serverless instance. The region you choose can affect network latency for clients accessing your databases.
        :param pulumi.Input[bool] auto_indexing: Flag that indicates whether the serverless instance uses [Serverless Auto Indexing](https://www.mongodb.com/docs/atlas/performance-advisor/auto-index-serverless/). This parameter defaults to true.
        :param pulumi.Input[bool] continuous_backup_enabled: Flag that indicates whether the serverless instance uses [Serverless Continuous Backup](https://www.mongodb.com/docs/atlas/configure-serverless-backup). If this parameter is false or not used, the serverless instance uses [Basic Backup](https://www.mongodb.com/docs/atlas/configure-serverless-backup).
        :param pulumi.Input[str] name: Human-readable label that identifies the serverless instance.
        :param pulumi.Input[str] state_name: Stage of deployment of this serverless instance when the resource made its request.
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessInstanceTagArgs']]] tags: Set that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the cluster. See below.
        :param pulumi.Input[bool] termination_protection_enabled: Flag that indicates whether termination protection is enabled on the cluster. If set to true, MongoDB Cloud won't delete the cluster. If set to false, MongoDB Cloud will delete the cluster.
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "provider_settings_backing_provider_name", provider_settings_backing_provider_name)
        pulumi.set(__self__, "provider_settings_provider_name", provider_settings_provider_name)
        pulumi.set(__self__, "provider_settings_region_name", provider_settings_region_name)
        if auto_indexing is not None:
            warnings.warn("""This parameter is deprecated and will be removed in March 2025. For more details see https://registry.terraform.io/providers/mongodb/mongodbatlas/latest/docs/guides/serverless-shared-migration-guide.""", DeprecationWarning)
            pulumi.log.warn("""auto_indexing is deprecated: This parameter is deprecated and will be removed in March 2025. For more details see https://registry.terraform.io/providers/mongodb/mongodbatlas/latest/docs/guides/serverless-shared-migration-guide.""")
        if auto_indexing is not None:
            pulumi.set(__self__, "auto_indexing", auto_indexing)
        if continuous_backup_enabled is not None:
            warnings.warn("""This parameter is deprecated and will be removed in March 2025. For more details see https://registry.terraform.io/providers/mongodb/mongodbatlas/latest/docs/guides/serverless-shared-migration-guide.""", DeprecationWarning)
            pulumi.log.warn("""continuous_backup_enabled is deprecated: This parameter is deprecated and will be removed in March 2025. For more details see https://registry.terraform.io/providers/mongodb/mongodbatlas/latest/docs/guides/serverless-shared-migration-guide.""")
        if continuous_backup_enabled is not None:
            pulumi.set(__self__, "continuous_backup_enabled", continuous_backup_enabled)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if state_name is not None:
            pulumi.set(__self__, "state_name", state_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termination_protection_enabled is not None:
            pulumi.set(__self__, "termination_protection_enabled", termination_protection_enabled)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The ID of the organization or project you want to create the serverless instance within.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="providerSettingsBackingProviderName")
    def provider_settings_backing_provider_name(self) -> pulumi.Input[str]:
        """
        Cloud service provider on which MongoDB Cloud provisioned the serverless instance.
        """
        return pulumi.get(self, "provider_settings_backing_provider_name")

    @provider_settings_backing_provider_name.setter
    def provider_settings_backing_provider_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "provider_settings_backing_provider_name", value)

    @property
    @pulumi.getter(name="providerSettingsProviderName")
    def provider_settings_provider_name(self) -> pulumi.Input[str]:
        """
        Cloud service provider that applies to the provisioned the serverless instance.
        """
        return pulumi.get(self, "provider_settings_provider_name")

    @provider_settings_provider_name.setter
    def provider_settings_provider_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "provider_settings_provider_name", value)

    @property
    @pulumi.getter(name="providerSettingsRegionName")
    def provider_settings_region_name(self) -> pulumi.Input[str]:
        """
        Human-readable label that identifies the physical location of your MongoDB serverless instance. The region you choose can affect network latency for clients accessing your databases.
        """
        return pulumi.get(self, "provider_settings_region_name")

    @provider_settings_region_name.setter
    def provider_settings_region_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "provider_settings_region_name", value)

    @property
    @pulumi.getter(name="autoIndexing")
    @_utilities.deprecated("""This parameter is deprecated and will be removed in March 2025. For more details see https://registry.terraform.io/providers/mongodb/mongodbatlas/latest/docs/guides/serverless-shared-migration-guide.""")
    def auto_indexing(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag that indicates whether the serverless instance uses [Serverless Auto Indexing](https://www.mongodb.com/docs/atlas/performance-advisor/auto-index-serverless/). This parameter defaults to true.
        """
        return pulumi.get(self, "auto_indexing")

    @auto_indexing.setter
    def auto_indexing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_indexing", value)

    @property
    @pulumi.getter(name="continuousBackupEnabled")
    @_utilities.deprecated("""This parameter is deprecated and will be removed in March 2025. For more details see https://registry.terraform.io/providers/mongodb/mongodbatlas/latest/docs/guides/serverless-shared-migration-guide.""")
    def continuous_backup_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag that indicates whether the serverless instance uses [Serverless Continuous Backup](https://www.mongodb.com/docs/atlas/configure-serverless-backup). If this parameter is false or not used, the serverless instance uses [Basic Backup](https://www.mongodb.com/docs/atlas/configure-serverless-backup).
        """
        return pulumi.get(self, "continuous_backup_enabled")

    @continuous_backup_enabled.setter
    def continuous_backup_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "continuous_backup_enabled", value)

    @property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessInstanceLinkArgs']]]]:
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessInstanceLinkArgs']]]]):
        pulumi.set(self, "links", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable label that identifies the serverless instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="stateName")
    def state_name(self) -> Optional[pulumi.Input[str]]:
        """
        Stage of deployment of this serverless instance when the resource made its request.
        """
        return pulumi.get(self, "state_name")

    @state_name.setter
    def state_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessInstanceTagArgs']]]]:
        """
        Set that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the cluster. See below.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessInstanceTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="terminationProtectionEnabled")
    def termination_protection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag that indicates whether termination protection is enabled on the cluster. If set to true, MongoDB Cloud won't delete the cluster. If set to false, MongoDB Cloud will delete the cluster.
        """
        return pulumi.get(self, "termination_protection_enabled")

    @termination_protection_enabled.setter
    def termination_protection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "termination_protection_enabled", value)


@pulumi.input_type
class _ServerlessInstanceState:
    def __init__(__self__, *,
                 auto_indexing: Optional[pulumi.Input[bool]] = None,
                 connection_strings_private_endpoint_srvs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 connection_strings_standard_srv: Optional[pulumi.Input[str]] = None,
                 continuous_backup_enabled: Optional[pulumi.Input[bool]] = None,
                 create_date: Optional[pulumi.Input[str]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessInstanceLinkArgs']]]] = None,
                 mongo_db_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 provider_settings_backing_provider_name: Optional[pulumi.Input[str]] = None,
                 provider_settings_provider_name: Optional[pulumi.Input[str]] = None,
                 provider_settings_region_name: Optional[pulumi.Input[str]] = None,
                 state_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessInstanceTagArgs']]]] = None,
                 termination_protection_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering ServerlessInstance resources.
        :param pulumi.Input[bool] auto_indexing: Flag that indicates whether the serverless instance uses [Serverless Auto Indexing](https://www.mongodb.com/docs/atlas/performance-advisor/auto-index-serverless/). This parameter defaults to true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] connection_strings_private_endpoint_srvs: List of Serverless Private Endpoint Connections
        :param pulumi.Input[str] connection_strings_standard_srv: Public `mongodb+srv://` connection string that you can use to connect to this serverless instance.
        :param pulumi.Input[bool] continuous_backup_enabled: Flag that indicates whether the serverless instance uses [Serverless Continuous Backup](https://www.mongodb.com/docs/atlas/configure-serverless-backup). If this parameter is false or not used, the serverless instance uses [Basic Backup](https://www.mongodb.com/docs/atlas/configure-serverless-backup).
        :param pulumi.Input[str] create_date: Timestamp that indicates when MongoDB Cloud created the serverless instance. The timestamp displays in the ISO 8601 date and time format in UTC.
        :param pulumi.Input[str] mongo_db_version: Version of MongoDB that the serverless instance runs, in `<major version>`.`<minor version>` format.
        :param pulumi.Input[str] name: Human-readable label that identifies the serverless instance.
        :param pulumi.Input[str] project_id: The ID of the organization or project you want to create the serverless instance within.
        :param pulumi.Input[str] provider_settings_backing_provider_name: Cloud service provider on which MongoDB Cloud provisioned the serverless instance.
        :param pulumi.Input[str] provider_settings_provider_name: Cloud service provider that applies to the provisioned the serverless instance.
        :param pulumi.Input[str] provider_settings_region_name: Human-readable label that identifies the physical location of your MongoDB serverless instance. The region you choose can affect network latency for clients accessing your databases.
        :param pulumi.Input[str] state_name: Stage of deployment of this serverless instance when the resource made its request.
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessInstanceTagArgs']]] tags: Set that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the cluster. See below.
        :param pulumi.Input[bool] termination_protection_enabled: Flag that indicates whether termination protection is enabled on the cluster. If set to true, MongoDB Cloud won't delete the cluster. If set to false, MongoDB Cloud will delete the cluster.
        """
        if auto_indexing is not None:
            warnings.warn("""This parameter is deprecated and will be removed in March 2025. For more details see https://registry.terraform.io/providers/mongodb/mongodbatlas/latest/docs/guides/serverless-shared-migration-guide.""", DeprecationWarning)
            pulumi.log.warn("""auto_indexing is deprecated: This parameter is deprecated and will be removed in March 2025. For more details see https://registry.terraform.io/providers/mongodb/mongodbatlas/latest/docs/guides/serverless-shared-migration-guide.""")
        if auto_indexing is not None:
            pulumi.set(__self__, "auto_indexing", auto_indexing)
        if connection_strings_private_endpoint_srvs is not None:
            pulumi.set(__self__, "connection_strings_private_endpoint_srvs", connection_strings_private_endpoint_srvs)
        if connection_strings_standard_srv is not None:
            pulumi.set(__self__, "connection_strings_standard_srv", connection_strings_standard_srv)
        if continuous_backup_enabled is not None:
            warnings.warn("""This parameter is deprecated and will be removed in March 2025. For more details see https://registry.terraform.io/providers/mongodb/mongodbatlas/latest/docs/guides/serverless-shared-migration-guide.""", DeprecationWarning)
            pulumi.log.warn("""continuous_backup_enabled is deprecated: This parameter is deprecated and will be removed in March 2025. For more details see https://registry.terraform.io/providers/mongodb/mongodbatlas/latest/docs/guides/serverless-shared-migration-guide.""")
        if continuous_backup_enabled is not None:
            pulumi.set(__self__, "continuous_backup_enabled", continuous_backup_enabled)
        if create_date is not None:
            pulumi.set(__self__, "create_date", create_date)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if mongo_db_version is not None:
            pulumi.set(__self__, "mongo_db_version", mongo_db_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if provider_settings_backing_provider_name is not None:
            pulumi.set(__self__, "provider_settings_backing_provider_name", provider_settings_backing_provider_name)
        if provider_settings_provider_name is not None:
            pulumi.set(__self__, "provider_settings_provider_name", provider_settings_provider_name)
        if provider_settings_region_name is not None:
            pulumi.set(__self__, "provider_settings_region_name", provider_settings_region_name)
        if state_name is not None:
            pulumi.set(__self__, "state_name", state_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termination_protection_enabled is not None:
            pulumi.set(__self__, "termination_protection_enabled", termination_protection_enabled)

    @property
    @pulumi.getter(name="autoIndexing")
    @_utilities.deprecated("""This parameter is deprecated and will be removed in March 2025. For more details see https://registry.terraform.io/providers/mongodb/mongodbatlas/latest/docs/guides/serverless-shared-migration-guide.""")
    def auto_indexing(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag that indicates whether the serverless instance uses [Serverless Auto Indexing](https://www.mongodb.com/docs/atlas/performance-advisor/auto-index-serverless/). This parameter defaults to true.
        """
        return pulumi.get(self, "auto_indexing")

    @auto_indexing.setter
    def auto_indexing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_indexing", value)

    @property
    @pulumi.getter(name="connectionStringsPrivateEndpointSrvs")
    def connection_strings_private_endpoint_srvs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Serverless Private Endpoint Connections
        """
        return pulumi.get(self, "connection_strings_private_endpoint_srvs")

    @connection_strings_private_endpoint_srvs.setter
    def connection_strings_private_endpoint_srvs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "connection_strings_private_endpoint_srvs", value)

    @property
    @pulumi.getter(name="connectionStringsStandardSrv")
    def connection_strings_standard_srv(self) -> Optional[pulumi.Input[str]]:
        """
        Public `mongodb+srv://` connection string that you can use to connect to this serverless instance.
        """
        return pulumi.get(self, "connection_strings_standard_srv")

    @connection_strings_standard_srv.setter
    def connection_strings_standard_srv(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_strings_standard_srv", value)

    @property
    @pulumi.getter(name="continuousBackupEnabled")
    @_utilities.deprecated("""This parameter is deprecated and will be removed in March 2025. For more details see https://registry.terraform.io/providers/mongodb/mongodbatlas/latest/docs/guides/serverless-shared-migration-guide.""")
    def continuous_backup_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag that indicates whether the serverless instance uses [Serverless Continuous Backup](https://www.mongodb.com/docs/atlas/configure-serverless-backup). If this parameter is false or not used, the serverless instance uses [Basic Backup](https://www.mongodb.com/docs/atlas/configure-serverless-backup).
        """
        return pulumi.get(self, "continuous_backup_enabled")

    @continuous_backup_enabled.setter
    def continuous_backup_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "continuous_backup_enabled", value)

    @property
    @pulumi.getter(name="createDate")
    def create_date(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp that indicates when MongoDB Cloud created the serverless instance. The timestamp displays in the ISO 8601 date and time format in UTC.
        """
        return pulumi.get(self, "create_date")

    @create_date.setter
    def create_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_date", value)

    @property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessInstanceLinkArgs']]]]:
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessInstanceLinkArgs']]]]):
        pulumi.set(self, "links", value)

    @property
    @pulumi.getter(name="mongoDbVersion")
    def mongo_db_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of MongoDB that the serverless instance runs, in `<major version>`.`<minor version>` format.
        """
        return pulumi.get(self, "mongo_db_version")

    @mongo_db_version.setter
    def mongo_db_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mongo_db_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable label that identifies the serverless instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the organization or project you want to create the serverless instance within.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="providerSettingsBackingProviderName")
    def provider_settings_backing_provider_name(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud service provider on which MongoDB Cloud provisioned the serverless instance.
        """
        return pulumi.get(self, "provider_settings_backing_provider_name")

    @provider_settings_backing_provider_name.setter
    def provider_settings_backing_provider_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_settings_backing_provider_name", value)

    @property
    @pulumi.getter(name="providerSettingsProviderName")
    def provider_settings_provider_name(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud service provider that applies to the provisioned the serverless instance.
        """
        return pulumi.get(self, "provider_settings_provider_name")

    @provider_settings_provider_name.setter
    def provider_settings_provider_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_settings_provider_name", value)

    @property
    @pulumi.getter(name="providerSettingsRegionName")
    def provider_settings_region_name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable label that identifies the physical location of your MongoDB serverless instance. The region you choose can affect network latency for clients accessing your databases.
        """
        return pulumi.get(self, "provider_settings_region_name")

    @provider_settings_region_name.setter
    def provider_settings_region_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_settings_region_name", value)

    @property
    @pulumi.getter(name="stateName")
    def state_name(self) -> Optional[pulumi.Input[str]]:
        """
        Stage of deployment of this serverless instance when the resource made its request.
        """
        return pulumi.get(self, "state_name")

    @state_name.setter
    def state_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessInstanceTagArgs']]]]:
        """
        Set that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the cluster. See below.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessInstanceTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="terminationProtectionEnabled")
    def termination_protection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag that indicates whether termination protection is enabled on the cluster. If set to true, MongoDB Cloud won't delete the cluster. If set to false, MongoDB Cloud will delete the cluster.
        """
        return pulumi.get(self, "termination_protection_enabled")

    @termination_protection_enabled.setter
    def termination_protection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "termination_protection_enabled", value)


class ServerlessInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_indexing: Optional[pulumi.Input[bool]] = None,
                 continuous_backup_enabled: Optional[pulumi.Input[bool]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessInstanceLinkArgs', 'ServerlessInstanceLinkArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 provider_settings_backing_provider_name: Optional[pulumi.Input[str]] = None,
                 provider_settings_provider_name: Optional[pulumi.Input[str]] = None,
                 provider_settings_region_name: Optional[pulumi.Input[str]] = None,
                 state_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessInstanceTagArgs', 'ServerlessInstanceTagArgsDict']]]]] = None,
                 termination_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        **WARNING:** This resource is deprecated and will be removed in January 2026. For more details, see Migration Guide: Transition out of Serverless Instances and Shared-tier clusters.

        `ServerlessInstance` provides a Serverless Instance resource. This allows serverless instances to be created.

        > **NOTE:**  Serverless instances do not support some Atlas features at this time.
        For a full list of unsupported features, see [Serverless Instance Limitations](https://docs.atlas.mongodb.com/reference/serverless-instance-limitations/).

        ## Example Usage

        ### Basic
        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.ServerlessInstance("test",
            project_id="<PROJECT_ID>",
            name="<SERVERLESS_INSTANCE_NAME>",
            provider_settings_backing_provider_name="AWS",
            provider_settings_provider_name="SERVERLESS",
            provider_settings_region_name="US_EAST_1")
        ```

        **NOTE:**  `ServerlessInstance` and `PrivatelinkEndpointServiceServerless` resources have a circular dependency in some respects.\\
        That is, the `serverless_instance` must exist before the `privatelink_endpoint_service` can be created,\\
        and the `privatelink_endpoint_service` must exist before the `serverless_instance` gets its respective `connection_strings_private_endpoint_srv` values.

        Because of this, the `serverless_instance` data source has particular value as a source of the `connection_strings_private_endpoint_srv`.\\
        When using the data_source in-tandem with the afforementioned resources, we can create and retrieve the `connection_strings_private_endpoint_srv` in a single `pulumi up`.

        Follow this example to setup private connection to a serverless instance using aws vpc and get the connection strings in a single `pulumi up`

        ## Import

        Serverless Instance can be imported using the group ID and serverless instance name, in the format `GROUP_ID-SERVERLESS_INSTANCE_NAME`, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/serverlessInstance:ServerlessInstance my_serverless_instance 1112222b3bf99403840e8934-My Serverless Instance
        ```

        For more information see: [MongoDB Atlas API - Serverless Instance](https://docs.atlas.mongodb.com/reference/api/serverless-instances/) Documentation.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_indexing: Flag that indicates whether the serverless instance uses [Serverless Auto Indexing](https://www.mongodb.com/docs/atlas/performance-advisor/auto-index-serverless/). This parameter defaults to true.
        :param pulumi.Input[bool] continuous_backup_enabled: Flag that indicates whether the serverless instance uses [Serverless Continuous Backup](https://www.mongodb.com/docs/atlas/configure-serverless-backup). If this parameter is false or not used, the serverless instance uses [Basic Backup](https://www.mongodb.com/docs/atlas/configure-serverless-backup).
        :param pulumi.Input[str] name: Human-readable label that identifies the serverless instance.
        :param pulumi.Input[str] project_id: The ID of the organization or project you want to create the serverless instance within.
        :param pulumi.Input[str] provider_settings_backing_provider_name: Cloud service provider on which MongoDB Cloud provisioned the serverless instance.
        :param pulumi.Input[str] provider_settings_provider_name: Cloud service provider that applies to the provisioned the serverless instance.
        :param pulumi.Input[str] provider_settings_region_name: Human-readable label that identifies the physical location of your MongoDB serverless instance. The region you choose can affect network latency for clients accessing your databases.
        :param pulumi.Input[str] state_name: Stage of deployment of this serverless instance when the resource made its request.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessInstanceTagArgs', 'ServerlessInstanceTagArgsDict']]]] tags: Set that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the cluster. See below.
        :param pulumi.Input[bool] termination_protection_enabled: Flag that indicates whether termination protection is enabled on the cluster. If set to true, MongoDB Cloud won't delete the cluster. If set to false, MongoDB Cloud will delete the cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerlessInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        **WARNING:** This resource is deprecated and will be removed in January 2026. For more details, see Migration Guide: Transition out of Serverless Instances and Shared-tier clusters.

        `ServerlessInstance` provides a Serverless Instance resource. This allows serverless instances to be created.

        > **NOTE:**  Serverless instances do not support some Atlas features at this time.
        For a full list of unsupported features, see [Serverless Instance Limitations](https://docs.atlas.mongodb.com/reference/serverless-instance-limitations/).

        ## Example Usage

        ### Basic
        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.ServerlessInstance("test",
            project_id="<PROJECT_ID>",
            name="<SERVERLESS_INSTANCE_NAME>",
            provider_settings_backing_provider_name="AWS",
            provider_settings_provider_name="SERVERLESS",
            provider_settings_region_name="US_EAST_1")
        ```

        **NOTE:**  `ServerlessInstance` and `PrivatelinkEndpointServiceServerless` resources have a circular dependency in some respects.\\
        That is, the `serverless_instance` must exist before the `privatelink_endpoint_service` can be created,\\
        and the `privatelink_endpoint_service` must exist before the `serverless_instance` gets its respective `connection_strings_private_endpoint_srv` values.

        Because of this, the `serverless_instance` data source has particular value as a source of the `connection_strings_private_endpoint_srv`.\\
        When using the data_source in-tandem with the afforementioned resources, we can create and retrieve the `connection_strings_private_endpoint_srv` in a single `pulumi up`.

        Follow this example to setup private connection to a serverless instance using aws vpc and get the connection strings in a single `pulumi up`

        ## Import

        Serverless Instance can be imported using the group ID and serverless instance name, in the format `GROUP_ID-SERVERLESS_INSTANCE_NAME`, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/serverlessInstance:ServerlessInstance my_serverless_instance 1112222b3bf99403840e8934-My Serverless Instance
        ```

        For more information see: [MongoDB Atlas API - Serverless Instance](https://docs.atlas.mongodb.com/reference/api/serverless-instances/) Documentation.

        :param str resource_name: The name of the resource.
        :param ServerlessInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerlessInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_indexing: Optional[pulumi.Input[bool]] = None,
                 continuous_backup_enabled: Optional[pulumi.Input[bool]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessInstanceLinkArgs', 'ServerlessInstanceLinkArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 provider_settings_backing_provider_name: Optional[pulumi.Input[str]] = None,
                 provider_settings_provider_name: Optional[pulumi.Input[str]] = None,
                 provider_settings_region_name: Optional[pulumi.Input[str]] = None,
                 state_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessInstanceTagArgs', 'ServerlessInstanceTagArgsDict']]]]] = None,
                 termination_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerlessInstanceArgs.__new__(ServerlessInstanceArgs)

            __props__.__dict__["auto_indexing"] = auto_indexing
            __props__.__dict__["continuous_backup_enabled"] = continuous_backup_enabled
            __props__.__dict__["links"] = links
            __props__.__dict__["name"] = name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if provider_settings_backing_provider_name is None and not opts.urn:
                raise TypeError("Missing required property 'provider_settings_backing_provider_name'")
            __props__.__dict__["provider_settings_backing_provider_name"] = provider_settings_backing_provider_name
            if provider_settings_provider_name is None and not opts.urn:
                raise TypeError("Missing required property 'provider_settings_provider_name'")
            __props__.__dict__["provider_settings_provider_name"] = provider_settings_provider_name
            if provider_settings_region_name is None and not opts.urn:
                raise TypeError("Missing required property 'provider_settings_region_name'")
            __props__.__dict__["provider_settings_region_name"] = provider_settings_region_name
            __props__.__dict__["state_name"] = state_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["termination_protection_enabled"] = termination_protection_enabled
            __props__.__dict__["connection_strings_private_endpoint_srvs"] = None
            __props__.__dict__["connection_strings_standard_srv"] = None
            __props__.__dict__["create_date"] = None
            __props__.__dict__["mongo_db_version"] = None
        super(ServerlessInstance, __self__).__init__(
            'mongodbatlas:index/serverlessInstance:ServerlessInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_indexing: Optional[pulumi.Input[bool]] = None,
            connection_strings_private_endpoint_srvs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            connection_strings_standard_srv: Optional[pulumi.Input[str]] = None,
            continuous_backup_enabled: Optional[pulumi.Input[bool]] = None,
            create_date: Optional[pulumi.Input[str]] = None,
            links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessInstanceLinkArgs', 'ServerlessInstanceLinkArgsDict']]]]] = None,
            mongo_db_version: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            provider_settings_backing_provider_name: Optional[pulumi.Input[str]] = None,
            provider_settings_provider_name: Optional[pulumi.Input[str]] = None,
            provider_settings_region_name: Optional[pulumi.Input[str]] = None,
            state_name: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessInstanceTagArgs', 'ServerlessInstanceTagArgsDict']]]]] = None,
            termination_protection_enabled: Optional[pulumi.Input[bool]] = None) -> 'ServerlessInstance':
        """
        Get an existing ServerlessInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_indexing: Flag that indicates whether the serverless instance uses [Serverless Auto Indexing](https://www.mongodb.com/docs/atlas/performance-advisor/auto-index-serverless/). This parameter defaults to true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] connection_strings_private_endpoint_srvs: List of Serverless Private Endpoint Connections
        :param pulumi.Input[str] connection_strings_standard_srv: Public `mongodb+srv://` connection string that you can use to connect to this serverless instance.
        :param pulumi.Input[bool] continuous_backup_enabled: Flag that indicates whether the serverless instance uses [Serverless Continuous Backup](https://www.mongodb.com/docs/atlas/configure-serverless-backup). If this parameter is false or not used, the serverless instance uses [Basic Backup](https://www.mongodb.com/docs/atlas/configure-serverless-backup).
        :param pulumi.Input[str] create_date: Timestamp that indicates when MongoDB Cloud created the serverless instance. The timestamp displays in the ISO 8601 date and time format in UTC.
        :param pulumi.Input[str] mongo_db_version: Version of MongoDB that the serverless instance runs, in `<major version>`.`<minor version>` format.
        :param pulumi.Input[str] name: Human-readable label that identifies the serverless instance.
        :param pulumi.Input[str] project_id: The ID of the organization or project you want to create the serverless instance within.
        :param pulumi.Input[str] provider_settings_backing_provider_name: Cloud service provider on which MongoDB Cloud provisioned the serverless instance.
        :param pulumi.Input[str] provider_settings_provider_name: Cloud service provider that applies to the provisioned the serverless instance.
        :param pulumi.Input[str] provider_settings_region_name: Human-readable label that identifies the physical location of your MongoDB serverless instance. The region you choose can affect network latency for clients accessing your databases.
        :param pulumi.Input[str] state_name: Stage of deployment of this serverless instance when the resource made its request.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessInstanceTagArgs', 'ServerlessInstanceTagArgsDict']]]] tags: Set that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the cluster. See below.
        :param pulumi.Input[bool] termination_protection_enabled: Flag that indicates whether termination protection is enabled on the cluster. If set to true, MongoDB Cloud won't delete the cluster. If set to false, MongoDB Cloud will delete the cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerlessInstanceState.__new__(_ServerlessInstanceState)

        __props__.__dict__["auto_indexing"] = auto_indexing
        __props__.__dict__["connection_strings_private_endpoint_srvs"] = connection_strings_private_endpoint_srvs
        __props__.__dict__["connection_strings_standard_srv"] = connection_strings_standard_srv
        __props__.__dict__["continuous_backup_enabled"] = continuous_backup_enabled
        __props__.__dict__["create_date"] = create_date
        __props__.__dict__["links"] = links
        __props__.__dict__["mongo_db_version"] = mongo_db_version
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["provider_settings_backing_provider_name"] = provider_settings_backing_provider_name
        __props__.__dict__["provider_settings_provider_name"] = provider_settings_provider_name
        __props__.__dict__["provider_settings_region_name"] = provider_settings_region_name
        __props__.__dict__["state_name"] = state_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["termination_protection_enabled"] = termination_protection_enabled
        return ServerlessInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoIndexing")
    @_utilities.deprecated("""This parameter is deprecated and will be removed in March 2025. For more details see https://registry.terraform.io/providers/mongodb/mongodbatlas/latest/docs/guides/serverless-shared-migration-guide.""")
    def auto_indexing(self) -> pulumi.Output[bool]:
        """
        Flag that indicates whether the serverless instance uses [Serverless Auto Indexing](https://www.mongodb.com/docs/atlas/performance-advisor/auto-index-serverless/). This parameter defaults to true.
        """
        return pulumi.get(self, "auto_indexing")

    @property
    @pulumi.getter(name="connectionStringsPrivateEndpointSrvs")
    def connection_strings_private_endpoint_srvs(self) -> pulumi.Output[Sequence[str]]:
        """
        List of Serverless Private Endpoint Connections
        """
        return pulumi.get(self, "connection_strings_private_endpoint_srvs")

    @property
    @pulumi.getter(name="connectionStringsStandardSrv")
    def connection_strings_standard_srv(self) -> pulumi.Output[str]:
        """
        Public `mongodb+srv://` connection string that you can use to connect to this serverless instance.
        """
        return pulumi.get(self, "connection_strings_standard_srv")

    @property
    @pulumi.getter(name="continuousBackupEnabled")
    @_utilities.deprecated("""This parameter is deprecated and will be removed in March 2025. For more details see https://registry.terraform.io/providers/mongodb/mongodbatlas/latest/docs/guides/serverless-shared-migration-guide.""")
    def continuous_backup_enabled(self) -> pulumi.Output[bool]:
        """
        Flag that indicates whether the serverless instance uses [Serverless Continuous Backup](https://www.mongodb.com/docs/atlas/configure-serverless-backup). If this parameter is false or not used, the serverless instance uses [Basic Backup](https://www.mongodb.com/docs/atlas/configure-serverless-backup).
        """
        return pulumi.get(self, "continuous_backup_enabled")

    @property
    @pulumi.getter(name="createDate")
    def create_date(self) -> pulumi.Output[str]:
        """
        Timestamp that indicates when MongoDB Cloud created the serverless instance. The timestamp displays in the ISO 8601 date and time format in UTC.
        """
        return pulumi.get(self, "create_date")

    @property
    @pulumi.getter
    def links(self) -> pulumi.Output[Sequence['outputs.ServerlessInstanceLink']]:
        return pulumi.get(self, "links")

    @property
    @pulumi.getter(name="mongoDbVersion")
    def mongo_db_version(self) -> pulumi.Output[str]:
        """
        Version of MongoDB that the serverless instance runs, in `<major version>`.`<minor version>` format.
        """
        return pulumi.get(self, "mongo_db_version")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Human-readable label that identifies the serverless instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The ID of the organization or project you want to create the serverless instance within.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="providerSettingsBackingProviderName")
    def provider_settings_backing_provider_name(self) -> pulumi.Output[str]:
        """
        Cloud service provider on which MongoDB Cloud provisioned the serverless instance.
        """
        return pulumi.get(self, "provider_settings_backing_provider_name")

    @property
    @pulumi.getter(name="providerSettingsProviderName")
    def provider_settings_provider_name(self) -> pulumi.Output[str]:
        """
        Cloud service provider that applies to the provisioned the serverless instance.
        """
        return pulumi.get(self, "provider_settings_provider_name")

    @property
    @pulumi.getter(name="providerSettingsRegionName")
    def provider_settings_region_name(self) -> pulumi.Output[str]:
        """
        Human-readable label that identifies the physical location of your MongoDB serverless instance. The region you choose can affect network latency for clients accessing your databases.
        """
        return pulumi.get(self, "provider_settings_region_name")

    @property
    @pulumi.getter(name="stateName")
    def state_name(self) -> pulumi.Output[str]:
        """
        Stage of deployment of this serverless instance when the resource made its request.
        """
        return pulumi.get(self, "state_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.ServerlessInstanceTag']]]:
        """
        Set that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the cluster. See below.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="terminationProtectionEnabled")
    def termination_protection_enabled(self) -> pulumi.Output[bool]:
        """
        Flag that indicates whether termination protection is enabled on the cluster. If set to true, MongoDB Cloud won't delete the cluster. If set to false, MongoDB Cloud will delete the cluster.
        """
        return pulumi.get(self, "termination_protection_enabled")

