# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StreamConnectionArgs', 'StreamConnection']

@pulumi.input_type
class StreamConnectionArgs:
    def __init__(__self__, *,
                 connection_name: pulumi.Input[str],
                 instance_name: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 authentication: Optional[pulumi.Input['StreamConnectionAuthenticationArgs']] = None,
                 aws: Optional[pulumi.Input['StreamConnectionAwsArgs']] = None,
                 bootstrap_servers: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 db_role_to_execute: Optional[pulumi.Input['StreamConnectionDbRoleToExecuteArgs']] = None,
                 networking: Optional[pulumi.Input['StreamConnectionNetworkingArgs']] = None,
                 security: Optional[pulumi.Input['StreamConnectionSecurityArgs']] = None):
        """
        The set of arguments for constructing a StreamConnection resource.
        :param pulumi.Input[str] connection_name: Human-readable label that identifies the stream connection. In the case of the Sample type, this is the name of the sample source.
        :param pulumi.Input[str] instance_name: Human-readable label that identifies the stream instance.
        :param pulumi.Input[str] project_id: Unique 24-hexadecimal digit string that identifies your project.
        :param pulumi.Input[str] type: Type of connection. Can be `Cluster`, `Kafka`, `Sample`, or `AWSLambda`.
        """
        pulumi.set(__self__, "connection_name", connection_name)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "type", type)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if bootstrap_servers is not None:
            pulumi.set(__self__, "bootstrap_servers", bootstrap_servers)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if db_role_to_execute is not None:
            pulumi.set(__self__, "db_role_to_execute", db_role_to_execute)
        if networking is not None:
            pulumi.set(__self__, "networking", networking)
        if security is not None:
            pulumi.set(__self__, "security", security)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Input[str]:
        """
        Human-readable label that identifies the stream connection. In the case of the Sample type, this is the name of the sample source.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Input[str]:
        """
        Human-readable label that identifies the stream instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        Unique 24-hexadecimal digit string that identifies your project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of connection. Can be `Cluster`, `Kafka`, `Sample`, or `AWSLambda`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input['StreamConnectionAuthenticationArgs']]:
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input['StreamConnectionAuthenticationArgs']]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter
    def aws(self) -> Optional[pulumi.Input['StreamConnectionAwsArgs']]:
        return pulumi.get(self, "aws")

    @aws.setter
    def aws(self, value: Optional[pulumi.Input['StreamConnectionAwsArgs']]):
        pulumi.set(self, "aws", value)

    @property
    @pulumi.getter(name="bootstrapServers")
    def bootstrap_servers(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "bootstrap_servers")

    @bootstrap_servers.setter
    def bootstrap_servers(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bootstrap_servers", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="dbRoleToExecute")
    def db_role_to_execute(self) -> Optional[pulumi.Input['StreamConnectionDbRoleToExecuteArgs']]:
        return pulumi.get(self, "db_role_to_execute")

    @db_role_to_execute.setter
    def db_role_to_execute(self, value: Optional[pulumi.Input['StreamConnectionDbRoleToExecuteArgs']]):
        pulumi.set(self, "db_role_to_execute", value)

    @property
    @pulumi.getter
    def networking(self) -> Optional[pulumi.Input['StreamConnectionNetworkingArgs']]:
        return pulumi.get(self, "networking")

    @networking.setter
    def networking(self, value: Optional[pulumi.Input['StreamConnectionNetworkingArgs']]):
        pulumi.set(self, "networking", value)

    @property
    @pulumi.getter
    def security(self) -> Optional[pulumi.Input['StreamConnectionSecurityArgs']]:
        return pulumi.get(self, "security")

    @security.setter
    def security(self, value: Optional[pulumi.Input['StreamConnectionSecurityArgs']]):
        pulumi.set(self, "security", value)


@pulumi.input_type
class _StreamConnectionState:
    def __init__(__self__, *,
                 authentication: Optional[pulumi.Input['StreamConnectionAuthenticationArgs']] = None,
                 aws: Optional[pulumi.Input['StreamConnectionAwsArgs']] = None,
                 bootstrap_servers: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 db_role_to_execute: Optional[pulumi.Input['StreamConnectionDbRoleToExecuteArgs']] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 networking: Optional[pulumi.Input['StreamConnectionNetworkingArgs']] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 security: Optional[pulumi.Input['StreamConnectionSecurityArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering StreamConnection resources.
        :param pulumi.Input[str] connection_name: Human-readable label that identifies the stream connection. In the case of the Sample type, this is the name of the sample source.
        :param pulumi.Input[str] instance_name: Human-readable label that identifies the stream instance.
        :param pulumi.Input[str] project_id: Unique 24-hexadecimal digit string that identifies your project.
        :param pulumi.Input[str] type: Type of connection. Can be `Cluster`, `Kafka`, `Sample`, or `AWSLambda`.
        """
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if bootstrap_servers is not None:
            pulumi.set(__self__, "bootstrap_servers", bootstrap_servers)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if db_role_to_execute is not None:
            pulumi.set(__self__, "db_role_to_execute", db_role_to_execute)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if networking is not None:
            pulumi.set(__self__, "networking", networking)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if security is not None:
            pulumi.set(__self__, "security", security)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input['StreamConnectionAuthenticationArgs']]:
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input['StreamConnectionAuthenticationArgs']]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter
    def aws(self) -> Optional[pulumi.Input['StreamConnectionAwsArgs']]:
        return pulumi.get(self, "aws")

    @aws.setter
    def aws(self, value: Optional[pulumi.Input['StreamConnectionAwsArgs']]):
        pulumi.set(self, "aws", value)

    @property
    @pulumi.getter(name="bootstrapServers")
    def bootstrap_servers(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "bootstrap_servers")

    @bootstrap_servers.setter
    def bootstrap_servers(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bootstrap_servers", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable label that identifies the stream connection. In the case of the Sample type, this is the name of the sample source.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter(name="dbRoleToExecute")
    def db_role_to_execute(self) -> Optional[pulumi.Input['StreamConnectionDbRoleToExecuteArgs']]:
        return pulumi.get(self, "db_role_to_execute")

    @db_role_to_execute.setter
    def db_role_to_execute(self, value: Optional[pulumi.Input['StreamConnectionDbRoleToExecuteArgs']]):
        pulumi.set(self, "db_role_to_execute", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable label that identifies the stream instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter
    def networking(self) -> Optional[pulumi.Input['StreamConnectionNetworkingArgs']]:
        return pulumi.get(self, "networking")

    @networking.setter
    def networking(self, value: Optional[pulumi.Input['StreamConnectionNetworkingArgs']]):
        pulumi.set(self, "networking", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique 24-hexadecimal digit string that identifies your project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def security(self) -> Optional[pulumi.Input['StreamConnectionSecurityArgs']]:
        return pulumi.get(self, "security")

    @security.setter
    def security(self, value: Optional[pulumi.Input['StreamConnectionSecurityArgs']]):
        pulumi.set(self, "security", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of connection. Can be `Cluster`, `Kafka`, `Sample`, or `AWSLambda`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class StreamConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input[Union['StreamConnectionAuthenticationArgs', 'StreamConnectionAuthenticationArgsDict']]] = None,
                 aws: Optional[pulumi.Input[Union['StreamConnectionAwsArgs', 'StreamConnectionAwsArgsDict']]] = None,
                 bootstrap_servers: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 db_role_to_execute: Optional[pulumi.Input[Union['StreamConnectionDbRoleToExecuteArgs', 'StreamConnectionDbRoleToExecuteArgsDict']]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 networking: Optional[pulumi.Input[Union['StreamConnectionNetworkingArgs', 'StreamConnectionNetworkingArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 security: Optional[pulumi.Input[Union['StreamConnectionSecurityArgs', 'StreamConnectionSecurityArgsDict']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # Resource: StreamConnection

        `StreamConnection` provides a Stream Connection resource. The resource lets you create, edit, and delete stream instance connections.

        > **IMPORTANT:** All arguments including the Kafka authentication password will be stored in the raw state as plaintext. Read more about sensitive data in state.

        ## Example Usage

        ### Example Cluster Connection

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.StreamConnection("test",
            project_id=project_id,
            instance_name="InstanceName",
            connection_name="ConnectionName",
            type="Cluster",
            cluster_name="Cluster0")
        ```

        ### Example Kafka Plaintext Connection

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.StreamConnection("test",
            project_id=project_id,
            instance_name="NewInstance",
            connection_name="KafkaConnection",
            type="Kafka",
            authentication={
                "mechanism": "SCRAM-256",
                "username": "user",
                "password": "somepassword",
            },
            security={
                "protocol": "PLAINTEXT",
            },
            config={
                "auto.offset.reset": "latest",
            },
            bootstrap_servers="localhost:9091,localhost:9092")
        ```

        ## Import

        You can import a stream connection resource using the instance name, project ID, and connection name. The format must be `INSTANCE_NAME-PROJECT_ID-CONNECTION_NAME`. For example:

        ```sh
        $ pulumi import mongodbatlas:index/streamConnection:StreamConnection test "DefaultInstance-12251446ae5f3f6ec7968b13-NewConnection"
        ```
        To learn more, see: [MongoDB Atlas API - Stream Connection](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/#tag/Streams/operation/createStreamConnection) Documentation.
        The Terraform Provider Examples Section also contains details on the overall support for Atlas Streams Processing in Terraform.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connection_name: Human-readable label that identifies the stream connection. In the case of the Sample type, this is the name of the sample source.
        :param pulumi.Input[str] instance_name: Human-readable label that identifies the stream instance.
        :param pulumi.Input[str] project_id: Unique 24-hexadecimal digit string that identifies your project.
        :param pulumi.Input[str] type: Type of connection. Can be `Cluster`, `Kafka`, `Sample`, or `AWSLambda`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: StreamConnection

        `StreamConnection` provides a Stream Connection resource. The resource lets you create, edit, and delete stream instance connections.

        > **IMPORTANT:** All arguments including the Kafka authentication password will be stored in the raw state as plaintext. Read more about sensitive data in state.

        ## Example Usage

        ### Example Cluster Connection

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.StreamConnection("test",
            project_id=project_id,
            instance_name="InstanceName",
            connection_name="ConnectionName",
            type="Cluster",
            cluster_name="Cluster0")
        ```

        ### Example Kafka Plaintext Connection

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.StreamConnection("test",
            project_id=project_id,
            instance_name="NewInstance",
            connection_name="KafkaConnection",
            type="Kafka",
            authentication={
                "mechanism": "SCRAM-256",
                "username": "user",
                "password": "somepassword",
            },
            security={
                "protocol": "PLAINTEXT",
            },
            config={
                "auto.offset.reset": "latest",
            },
            bootstrap_servers="localhost:9091,localhost:9092")
        ```

        ## Import

        You can import a stream connection resource using the instance name, project ID, and connection name. The format must be `INSTANCE_NAME-PROJECT_ID-CONNECTION_NAME`. For example:

        ```sh
        $ pulumi import mongodbatlas:index/streamConnection:StreamConnection test "DefaultInstance-12251446ae5f3f6ec7968b13-NewConnection"
        ```
        To learn more, see: [MongoDB Atlas API - Stream Connection](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/#tag/Streams/operation/createStreamConnection) Documentation.
        The Terraform Provider Examples Section also contains details on the overall support for Atlas Streams Processing in Terraform.

        :param str resource_name: The name of the resource.
        :param StreamConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input[Union['StreamConnectionAuthenticationArgs', 'StreamConnectionAuthenticationArgsDict']]] = None,
                 aws: Optional[pulumi.Input[Union['StreamConnectionAwsArgs', 'StreamConnectionAwsArgsDict']]] = None,
                 bootstrap_servers: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 db_role_to_execute: Optional[pulumi.Input[Union['StreamConnectionDbRoleToExecuteArgs', 'StreamConnectionDbRoleToExecuteArgsDict']]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 networking: Optional[pulumi.Input[Union['StreamConnectionNetworkingArgs', 'StreamConnectionNetworkingArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 security: Optional[pulumi.Input[Union['StreamConnectionSecurityArgs', 'StreamConnectionSecurityArgsDict']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamConnectionArgs.__new__(StreamConnectionArgs)

            __props__.__dict__["authentication"] = authentication
            __props__.__dict__["aws"] = aws
            __props__.__dict__["bootstrap_servers"] = bootstrap_servers
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["config"] = config
            if connection_name is None and not opts.urn:
                raise TypeError("Missing required property 'connection_name'")
            __props__.__dict__["connection_name"] = connection_name
            __props__.__dict__["db_role_to_execute"] = db_role_to_execute
            if instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'instance_name'")
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["networking"] = networking
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["security"] = security
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(StreamConnection, __self__).__init__(
            'mongodbatlas:index/streamConnection:StreamConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication: Optional[pulumi.Input[Union['StreamConnectionAuthenticationArgs', 'StreamConnectionAuthenticationArgsDict']]] = None,
            aws: Optional[pulumi.Input[Union['StreamConnectionAwsArgs', 'StreamConnectionAwsArgsDict']]] = None,
            bootstrap_servers: Optional[pulumi.Input[str]] = None,
            cluster_name: Optional[pulumi.Input[str]] = None,
            config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            connection_name: Optional[pulumi.Input[str]] = None,
            db_role_to_execute: Optional[pulumi.Input[Union['StreamConnectionDbRoleToExecuteArgs', 'StreamConnectionDbRoleToExecuteArgsDict']]] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            networking: Optional[pulumi.Input[Union['StreamConnectionNetworkingArgs', 'StreamConnectionNetworkingArgsDict']]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            security: Optional[pulumi.Input[Union['StreamConnectionSecurityArgs', 'StreamConnectionSecurityArgsDict']]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'StreamConnection':
        """
        Get an existing StreamConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connection_name: Human-readable label that identifies the stream connection. In the case of the Sample type, this is the name of the sample source.
        :param pulumi.Input[str] instance_name: Human-readable label that identifies the stream instance.
        :param pulumi.Input[str] project_id: Unique 24-hexadecimal digit string that identifies your project.
        :param pulumi.Input[str] type: Type of connection. Can be `Cluster`, `Kafka`, `Sample`, or `AWSLambda`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StreamConnectionState.__new__(_StreamConnectionState)

        __props__.__dict__["authentication"] = authentication
        __props__.__dict__["aws"] = aws
        __props__.__dict__["bootstrap_servers"] = bootstrap_servers
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["config"] = config
        __props__.__dict__["connection_name"] = connection_name
        __props__.__dict__["db_role_to_execute"] = db_role_to_execute
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["networking"] = networking
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["security"] = security
        __props__.__dict__["type"] = type
        return StreamConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def authentication(self) -> pulumi.Output[Optional['outputs.StreamConnectionAuthentication']]:
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter
    def aws(self) -> pulumi.Output[Optional['outputs.StreamConnectionAws']]:
        return pulumi.get(self, "aws")

    @property
    @pulumi.getter(name="bootstrapServers")
    def bootstrap_servers(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "bootstrap_servers")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Output[str]:
        """
        Human-readable label that identifies the stream connection. In the case of the Sample type, this is the name of the sample source.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter(name="dbRoleToExecute")
    def db_role_to_execute(self) -> pulumi.Output[Optional['outputs.StreamConnectionDbRoleToExecute']]:
        return pulumi.get(self, "db_role_to_execute")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[str]:
        """
        Human-readable label that identifies the stream instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter
    def networking(self) -> pulumi.Output['outputs.StreamConnectionNetworking']:
        return pulumi.get(self, "networking")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        Unique 24-hexadecimal digit string that identifies your project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def security(self) -> pulumi.Output[Optional['outputs.StreamConnectionSecurity']]:
        return pulumi.get(self, "security")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Type of connection. Can be `Cluster`, `Kafka`, `Sample`, or `AWSLambda`.
        """
        return pulumi.get(self, "type")

