# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['StreamPrivatelinkEndpointArgs', 'StreamPrivatelinkEndpoint']

@pulumi.input_type
class StreamPrivatelinkEndpointArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[str],
                 provider_name: pulumi.Input[str],
                 vendor: pulumi.Input[str],
                 dns_domain: Optional[pulumi.Input[str]] = None,
                 dns_sub_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_endpoint_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a StreamPrivatelinkEndpoint resource.
        :param pulumi.Input[str] project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        :param pulumi.Input[str] provider_name: Provider where the Kafka cluster is deployed.
        :param pulumi.Input[str] vendor: Vendor who manages the Kafka cluster.
        :param pulumi.Input[str] dns_domain: Domain name of Privatelink connected cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_sub_domains: Sub-Domain name of Confluent cluster. These are typically your availability zones.
        :param pulumi.Input[str] region: Domain name of Confluent cluster.
        :param pulumi.Input[str] service_endpoint_id: Service Endpoint ID.
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "provider_name", provider_name)
        pulumi.set(__self__, "vendor", vendor)
        if dns_domain is not None:
            pulumi.set(__self__, "dns_domain", dns_domain)
        if dns_sub_domains is not None:
            pulumi.set(__self__, "dns_sub_domains", dns_sub_domains)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_endpoint_id is not None:
            pulumi.set(__self__, "service_endpoint_id", service_endpoint_id)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> pulumi.Input[str]:
        """
        Provider where the Kafka cluster is deployed.
        """
        return pulumi.get(self, "provider_name")

    @provider_name.setter
    def provider_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "provider_name", value)

    @property
    @pulumi.getter
    def vendor(self) -> pulumi.Input[str]:
        """
        Vendor who manages the Kafka cluster.
        """
        return pulumi.get(self, "vendor")

    @vendor.setter
    def vendor(self, value: pulumi.Input[str]):
        pulumi.set(self, "vendor", value)

    @property
    @pulumi.getter(name="dnsDomain")
    def dns_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Domain name of Privatelink connected cluster.
        """
        return pulumi.get(self, "dns_domain")

    @dns_domain.setter
    def dns_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_domain", value)

    @property
    @pulumi.getter(name="dnsSubDomains")
    def dns_sub_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Sub-Domain name of Confluent cluster. These are typically your availability zones.
        """
        return pulumi.get(self, "dns_sub_domains")

    @dns_sub_domains.setter
    def dns_sub_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_sub_domains", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Domain name of Confluent cluster.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serviceEndpointId")
    def service_endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        Service Endpoint ID.
        """
        return pulumi.get(self, "service_endpoint_id")

    @service_endpoint_id.setter
    def service_endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_endpoint_id", value)


@pulumi.input_type
class _StreamPrivatelinkEndpointState:
    def __init__(__self__, *,
                 dns_domain: Optional[pulumi.Input[str]] = None,
                 dns_sub_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 interface_endpoint_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 provider_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_endpoint_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 vendor: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering StreamPrivatelinkEndpoint resources.
        :param pulumi.Input[str] dns_domain: Domain name of Privatelink connected cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_sub_domains: Sub-Domain name of Confluent cluster. These are typically your availability zones.
        :param pulumi.Input[str] interface_endpoint_id: Interface endpoint ID that is created from the specified service endpoint ID.
        :param pulumi.Input[str] project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        :param pulumi.Input[str] provider_name: Provider where the Kafka cluster is deployed.
        :param pulumi.Input[str] region: Domain name of Confluent cluster.
        :param pulumi.Input[str] service_endpoint_id: Service Endpoint ID.
        :param pulumi.Input[str] state: Status of the connection.
        :param pulumi.Input[str] vendor: Vendor who manages the Kafka cluster.
        """
        if dns_domain is not None:
            pulumi.set(__self__, "dns_domain", dns_domain)
        if dns_sub_domains is not None:
            pulumi.set(__self__, "dns_sub_domains", dns_sub_domains)
        if interface_endpoint_id is not None:
            pulumi.set(__self__, "interface_endpoint_id", interface_endpoint_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if provider_name is not None:
            pulumi.set(__self__, "provider_name", provider_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_endpoint_id is not None:
            pulumi.set(__self__, "service_endpoint_id", service_endpoint_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if vendor is not None:
            pulumi.set(__self__, "vendor", vendor)

    @property
    @pulumi.getter(name="dnsDomain")
    def dns_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Domain name of Privatelink connected cluster.
        """
        return pulumi.get(self, "dns_domain")

    @dns_domain.setter
    def dns_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_domain", value)

    @property
    @pulumi.getter(name="dnsSubDomains")
    def dns_sub_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Sub-Domain name of Confluent cluster. These are typically your availability zones.
        """
        return pulumi.get(self, "dns_sub_domains")

    @dns_sub_domains.setter
    def dns_sub_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_sub_domains", value)

    @property
    @pulumi.getter(name="interfaceEndpointId")
    def interface_endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        Interface endpoint ID that is created from the specified service endpoint ID.
        """
        return pulumi.get(self, "interface_endpoint_id")

    @interface_endpoint_id.setter
    def interface_endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interface_endpoint_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> Optional[pulumi.Input[str]]:
        """
        Provider where the Kafka cluster is deployed.
        """
        return pulumi.get(self, "provider_name")

    @provider_name.setter
    def provider_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Domain name of Confluent cluster.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serviceEndpointId")
    def service_endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        Service Endpoint ID.
        """
        return pulumi.get(self, "service_endpoint_id")

    @service_endpoint_id.setter
    def service_endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_endpoint_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the connection.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def vendor(self) -> Optional[pulumi.Input[str]]:
        """
        Vendor who manages the Kafka cluster.
        """
        return pulumi.get(self, "vendor")

    @vendor.setter
    def vendor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vendor", value)


class StreamPrivatelinkEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dns_domain: Optional[pulumi.Input[str]] = None,
                 dns_sub_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 provider_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_endpoint_id: Optional[pulumi.Input[str]] = None,
                 vendor: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # Resource: StreamPrivatelinkEndpoint

        `StreamPrivatelinkEndpoint` describes a Privatelink Endpoint for Streams.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dns_domain: Domain name of Privatelink connected cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_sub_domains: Sub-Domain name of Confluent cluster. These are typically your availability zones.
        :param pulumi.Input[str] project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        :param pulumi.Input[str] provider_name: Provider where the Kafka cluster is deployed.
        :param pulumi.Input[str] region: Domain name of Confluent cluster.
        :param pulumi.Input[str] service_endpoint_id: Service Endpoint ID.
        :param pulumi.Input[str] vendor: Vendor who manages the Kafka cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamPrivatelinkEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: StreamPrivatelinkEndpoint

        `StreamPrivatelinkEndpoint` describes a Privatelink Endpoint for Streams.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param StreamPrivatelinkEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamPrivatelinkEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dns_domain: Optional[pulumi.Input[str]] = None,
                 dns_sub_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 provider_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_endpoint_id: Optional[pulumi.Input[str]] = None,
                 vendor: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamPrivatelinkEndpointArgs.__new__(StreamPrivatelinkEndpointArgs)

            __props__.__dict__["dns_domain"] = dns_domain
            __props__.__dict__["dns_sub_domains"] = dns_sub_domains
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if provider_name is None and not opts.urn:
                raise TypeError("Missing required property 'provider_name'")
            __props__.__dict__["provider_name"] = provider_name
            __props__.__dict__["region"] = region
            __props__.__dict__["service_endpoint_id"] = service_endpoint_id
            if vendor is None and not opts.urn:
                raise TypeError("Missing required property 'vendor'")
            __props__.__dict__["vendor"] = vendor
            __props__.__dict__["interface_endpoint_id"] = None
            __props__.__dict__["state"] = None
        super(StreamPrivatelinkEndpoint, __self__).__init__(
            'mongodbatlas:index/streamPrivatelinkEndpoint:StreamPrivatelinkEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dns_domain: Optional[pulumi.Input[str]] = None,
            dns_sub_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            interface_endpoint_id: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            provider_name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            service_endpoint_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            vendor: Optional[pulumi.Input[str]] = None) -> 'StreamPrivatelinkEndpoint':
        """
        Get an existing StreamPrivatelinkEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dns_domain: Domain name of Privatelink connected cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_sub_domains: Sub-Domain name of Confluent cluster. These are typically your availability zones.
        :param pulumi.Input[str] interface_endpoint_id: Interface endpoint ID that is created from the specified service endpoint ID.
        :param pulumi.Input[str] project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        :param pulumi.Input[str] provider_name: Provider where the Kafka cluster is deployed.
        :param pulumi.Input[str] region: Domain name of Confluent cluster.
        :param pulumi.Input[str] service_endpoint_id: Service Endpoint ID.
        :param pulumi.Input[str] state: Status of the connection.
        :param pulumi.Input[str] vendor: Vendor who manages the Kafka cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StreamPrivatelinkEndpointState.__new__(_StreamPrivatelinkEndpointState)

        __props__.__dict__["dns_domain"] = dns_domain
        __props__.__dict__["dns_sub_domains"] = dns_sub_domains
        __props__.__dict__["interface_endpoint_id"] = interface_endpoint_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["provider_name"] = provider_name
        __props__.__dict__["region"] = region
        __props__.__dict__["service_endpoint_id"] = service_endpoint_id
        __props__.__dict__["state"] = state
        __props__.__dict__["vendor"] = vendor
        return StreamPrivatelinkEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dnsDomain")
    def dns_domain(self) -> pulumi.Output[Optional[str]]:
        """
        Domain name of Privatelink connected cluster.
        """
        return pulumi.get(self, "dns_domain")

    @property
    @pulumi.getter(name="dnsSubDomains")
    def dns_sub_domains(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Sub-Domain name of Confluent cluster. These are typically your availability zones.
        """
        return pulumi.get(self, "dns_sub_domains")

    @property
    @pulumi.getter(name="interfaceEndpointId")
    def interface_endpoint_id(self) -> pulumi.Output[str]:
        """
        Interface endpoint ID that is created from the specified service endpoint ID.
        """
        return pulumi.get(self, "interface_endpoint_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> pulumi.Output[str]:
        """
        Provider where the Kafka cluster is deployed.
        """
        return pulumi.get(self, "provider_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        Domain name of Confluent cluster.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="serviceEndpointId")
    def service_endpoint_id(self) -> pulumi.Output[Optional[str]]:
        """
        Service Endpoint ID.
        """
        return pulumi.get(self, "service_endpoint_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Status of the connection.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def vendor(self) -> pulumi.Output[str]:
        """
        Vendor who manages the Kafka cluster.
        """
        return pulumi.get(self, "vendor")

