# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StreamProcessorArgs', 'StreamProcessor']

@pulumi.input_type
class StreamProcessorArgs:
    def __init__(__self__, *,
                 instance_name: pulumi.Input[str],
                 pipeline: pulumi.Input[str],
                 processor_name: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 options: Optional[pulumi.Input['StreamProcessorOptionsArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a StreamProcessor resource.
        :param pulumi.Input[str] instance_name: Human-readable label that identifies the stream instance.
        :param pulumi.Input[str] pipeline: Stream aggregation pipeline you want to apply to your streaming data. [MongoDB Atlas Docs](https://www.mongodb.com/docs/atlas/atlas-stream-processing/stream-aggregation/#std-label-stream-aggregation) contain more information. Using jsonencode is recommended when setting this attribute. For more details see the [Aggregation Pipelines Documentation](https://www.mongodb.com/docs/atlas/atlas-stream-processing/stream-aggregation/)
        :param pulumi.Input[str] processor_name: Human-readable label that identifies the stream processor.
        :param pulumi.Input[str] project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        :param pulumi.Input['StreamProcessorOptionsArgs'] options: Optional configuration for the stream processor.
        :param pulumi.Input[str] state: The state of the stream processor. Commonly occurring states are 'CREATED', 'STARTED', 'STOPPED' and 'FAILED'. Used to
               start or stop the Stream Processor. Valid values are `CREATED`, `STARTED` or `STOPPED`. When a Stream Processor is
               created without specifying the state, it will default to `CREATED` state. **NOTE** When creating a stream processor,
               setting the state to STARTED can automatically start the stream processor.
        """
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "pipeline", pipeline)
        pulumi.set(__self__, "processor_name", processor_name)
        pulumi.set(__self__, "project_id", project_id)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Input[str]:
        """
        Human-readable label that identifies the stream instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter
    def pipeline(self) -> pulumi.Input[str]:
        """
        Stream aggregation pipeline you want to apply to your streaming data. [MongoDB Atlas Docs](https://www.mongodb.com/docs/atlas/atlas-stream-processing/stream-aggregation/#std-label-stream-aggregation) contain more information. Using jsonencode is recommended when setting this attribute. For more details see the [Aggregation Pipelines Documentation](https://www.mongodb.com/docs/atlas/atlas-stream-processing/stream-aggregation/)
        """
        return pulumi.get(self, "pipeline")

    @pipeline.setter
    def pipeline(self, value: pulumi.Input[str]):
        pulumi.set(self, "pipeline", value)

    @property
    @pulumi.getter(name="processorName")
    def processor_name(self) -> pulumi.Input[str]:
        """
        Human-readable label that identifies the stream processor.
        """
        return pulumi.get(self, "processor_name")

    @processor_name.setter
    def processor_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "processor_name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['StreamProcessorOptionsArgs']]:
        """
        Optional configuration for the stream processor.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['StreamProcessorOptionsArgs']]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the stream processor. Commonly occurring states are 'CREATED', 'STARTED', 'STOPPED' and 'FAILED'. Used to
        start or stop the Stream Processor. Valid values are `CREATED`, `STARTED` or `STOPPED`. When a Stream Processor is
        created without specifying the state, it will default to `CREATED` state. **NOTE** When creating a stream processor,
        setting the state to STARTED can automatically start the stream processor.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _StreamProcessorState:
    def __init__(__self__, *,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input['StreamProcessorOptionsArgs']] = None,
                 pipeline: Optional[pulumi.Input[str]] = None,
                 processor_name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 stats: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering StreamProcessor resources.
        :param pulumi.Input[str] instance_name: Human-readable label that identifies the stream instance.
        :param pulumi.Input['StreamProcessorOptionsArgs'] options: Optional configuration for the stream processor.
        :param pulumi.Input[str] pipeline: Stream aggregation pipeline you want to apply to your streaming data. [MongoDB Atlas Docs](https://www.mongodb.com/docs/atlas/atlas-stream-processing/stream-aggregation/#std-label-stream-aggregation) contain more information. Using jsonencode is recommended when setting this attribute. For more details see the [Aggregation Pipelines Documentation](https://www.mongodb.com/docs/atlas/atlas-stream-processing/stream-aggregation/)
        :param pulumi.Input[str] processor_name: Human-readable label that identifies the stream processor.
        :param pulumi.Input[str] project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        :param pulumi.Input[str] state: The state of the stream processor. Commonly occurring states are 'CREATED', 'STARTED', 'STOPPED' and 'FAILED'. Used to
               start or stop the Stream Processor. Valid values are `CREATED`, `STARTED` or `STOPPED`. When a Stream Processor is
               created without specifying the state, it will default to `CREATED` state. **NOTE** When creating a stream processor,
               setting the state to STARTED can automatically start the stream processor.
        :param pulumi.Input[str] stats: The stats associated with the stream processor. Refer to the [MongoDB Atlas
               Docs](https://www.mongodb.com/docs/atlas/atlas-stream-processing/manage-stream-processor/#view-statistics-of-a-stream-processor)
               for more information.
        """
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if pipeline is not None:
            pulumi.set(__self__, "pipeline", pipeline)
        if processor_name is not None:
            pulumi.set(__self__, "processor_name", processor_name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if stats is not None:
            pulumi.set(__self__, "stats", stats)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable label that identifies the stream instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['StreamProcessorOptionsArgs']]:
        """
        Optional configuration for the stream processor.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['StreamProcessorOptionsArgs']]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def pipeline(self) -> Optional[pulumi.Input[str]]:
        """
        Stream aggregation pipeline you want to apply to your streaming data. [MongoDB Atlas Docs](https://www.mongodb.com/docs/atlas/atlas-stream-processing/stream-aggregation/#std-label-stream-aggregation) contain more information. Using jsonencode is recommended when setting this attribute. For more details see the [Aggregation Pipelines Documentation](https://www.mongodb.com/docs/atlas/atlas-stream-processing/stream-aggregation/)
        """
        return pulumi.get(self, "pipeline")

    @pipeline.setter
    def pipeline(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pipeline", value)

    @property
    @pulumi.getter(name="processorName")
    def processor_name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable label that identifies the stream processor.
        """
        return pulumi.get(self, "processor_name")

    @processor_name.setter
    def processor_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "processor_name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the stream processor. Commonly occurring states are 'CREATED', 'STARTED', 'STOPPED' and 'FAILED'. Used to
        start or stop the Stream Processor. Valid values are `CREATED`, `STARTED` or `STOPPED`. When a Stream Processor is
        created without specifying the state, it will default to `CREATED` state. **NOTE** When creating a stream processor,
        setting the state to STARTED can automatically start the stream processor.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def stats(self) -> Optional[pulumi.Input[str]]:
        """
        The stats associated with the stream processor. Refer to the [MongoDB Atlas
        Docs](https://www.mongodb.com/docs/atlas/atlas-stream-processing/manage-stream-processor/#view-statistics-of-a-stream-processor)
        for more information.
        """
        return pulumi.get(self, "stats")

    @stats.setter
    def stats(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stats", value)


class StreamProcessor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Union['StreamProcessorOptionsArgs', 'StreamProcessorOptionsArgsDict']]] = None,
                 pipeline: Optional[pulumi.Input[str]] = None,
                 processor_name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        Stream Processor resource can be imported using the Project ID, Stream Instance name and Stream Processor name, in the format `INSTANCE_NAME-PROJECT_ID-PROCESSOR_NAME`, e.g.

        For more information see: [MongoDB Atlas API - Stream Processor](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/v2/#tag/Streams/operation/createStreamProcessor) Documentation.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] instance_name: Human-readable label that identifies the stream instance.
        :param pulumi.Input[Union['StreamProcessorOptionsArgs', 'StreamProcessorOptionsArgsDict']] options: Optional configuration for the stream processor.
        :param pulumi.Input[str] pipeline: Stream aggregation pipeline you want to apply to your streaming data. [MongoDB Atlas Docs](https://www.mongodb.com/docs/atlas/atlas-stream-processing/stream-aggregation/#std-label-stream-aggregation) contain more information. Using jsonencode is recommended when setting this attribute. For more details see the [Aggregation Pipelines Documentation](https://www.mongodb.com/docs/atlas/atlas-stream-processing/stream-aggregation/)
        :param pulumi.Input[str] processor_name: Human-readable label that identifies the stream processor.
        :param pulumi.Input[str] project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        :param pulumi.Input[str] state: The state of the stream processor. Commonly occurring states are 'CREATED', 'STARTED', 'STOPPED' and 'FAILED'. Used to
               start or stop the Stream Processor. Valid values are `CREATED`, `STARTED` or `STOPPED`. When a Stream Processor is
               created without specifying the state, it will default to `CREATED` state. **NOTE** When creating a stream processor,
               setting the state to STARTED can automatically start the stream processor.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamProcessorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        Stream Processor resource can be imported using the Project ID, Stream Instance name and Stream Processor name, in the format `INSTANCE_NAME-PROJECT_ID-PROCESSOR_NAME`, e.g.

        For more information see: [MongoDB Atlas API - Stream Processor](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/v2/#tag/Streams/operation/createStreamProcessor) Documentation.

        :param str resource_name: The name of the resource.
        :param StreamProcessorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamProcessorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Union['StreamProcessorOptionsArgs', 'StreamProcessorOptionsArgsDict']]] = None,
                 pipeline: Optional[pulumi.Input[str]] = None,
                 processor_name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamProcessorArgs.__new__(StreamProcessorArgs)

            if instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'instance_name'")
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["options"] = options
            if pipeline is None and not opts.urn:
                raise TypeError("Missing required property 'pipeline'")
            __props__.__dict__["pipeline"] = pipeline
            if processor_name is None and not opts.urn:
                raise TypeError("Missing required property 'processor_name'")
            __props__.__dict__["processor_name"] = processor_name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["state"] = state
            __props__.__dict__["stats"] = None
        super(StreamProcessor, __self__).__init__(
            'mongodbatlas:index/streamProcessor:StreamProcessor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            options: Optional[pulumi.Input[Union['StreamProcessorOptionsArgs', 'StreamProcessorOptionsArgsDict']]] = None,
            pipeline: Optional[pulumi.Input[str]] = None,
            processor_name: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            stats: Optional[pulumi.Input[str]] = None) -> 'StreamProcessor':
        """
        Get an existing StreamProcessor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] instance_name: Human-readable label that identifies the stream instance.
        :param pulumi.Input[Union['StreamProcessorOptionsArgs', 'StreamProcessorOptionsArgsDict']] options: Optional configuration for the stream processor.
        :param pulumi.Input[str] pipeline: Stream aggregation pipeline you want to apply to your streaming data. [MongoDB Atlas Docs](https://www.mongodb.com/docs/atlas/atlas-stream-processing/stream-aggregation/#std-label-stream-aggregation) contain more information. Using jsonencode is recommended when setting this attribute. For more details see the [Aggregation Pipelines Documentation](https://www.mongodb.com/docs/atlas/atlas-stream-processing/stream-aggregation/)
        :param pulumi.Input[str] processor_name: Human-readable label that identifies the stream processor.
        :param pulumi.Input[str] project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        :param pulumi.Input[str] state: The state of the stream processor. Commonly occurring states are 'CREATED', 'STARTED', 'STOPPED' and 'FAILED'. Used to
               start or stop the Stream Processor. Valid values are `CREATED`, `STARTED` or `STOPPED`. When a Stream Processor is
               created without specifying the state, it will default to `CREATED` state. **NOTE** When creating a stream processor,
               setting the state to STARTED can automatically start the stream processor.
        :param pulumi.Input[str] stats: The stats associated with the stream processor. Refer to the [MongoDB Atlas
               Docs](https://www.mongodb.com/docs/atlas/atlas-stream-processing/manage-stream-processor/#view-statistics-of-a-stream-processor)
               for more information.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StreamProcessorState.__new__(_StreamProcessorState)

        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["options"] = options
        __props__.__dict__["pipeline"] = pipeline
        __props__.__dict__["processor_name"] = processor_name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["state"] = state
        __props__.__dict__["stats"] = stats
        return StreamProcessor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[str]:
        """
        Human-readable label that identifies the stream instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional['outputs.StreamProcessorOptions']]:
        """
        Optional configuration for the stream processor.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def pipeline(self) -> pulumi.Output[str]:
        """
        Stream aggregation pipeline you want to apply to your streaming data. [MongoDB Atlas Docs](https://www.mongodb.com/docs/atlas/atlas-stream-processing/stream-aggregation/#std-label-stream-aggregation) contain more information. Using jsonencode is recommended when setting this attribute. For more details see the [Aggregation Pipelines Documentation](https://www.mongodb.com/docs/atlas/atlas-stream-processing/stream-aggregation/)
        """
        return pulumi.get(self, "pipeline")

    @property
    @pulumi.getter(name="processorName")
    def processor_name(self) -> pulumi.Output[str]:
        """
        Human-readable label that identifies the stream processor.
        """
        return pulumi.get(self, "processor_name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the stream processor. Commonly occurring states are 'CREATED', 'STARTED', 'STOPPED' and 'FAILED'. Used to
        start or stop the Stream Processor. Valid values are `CREATED`, `STARTED` or `STOPPED`. When a Stream Processor is
        created without specifying the state, it will default to `CREATED` state. **NOTE** When creating a stream processor,
        setting the state to STARTED can automatically start the stream processor.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def stats(self) -> pulumi.Output[str]:
        """
        The stats associated with the stream processor. Refer to the [MongoDB Atlas
        Docs](https://www.mongodb.com/docs/atlas/atlas-stream-processing/manage-stream-processor/#view-statistics-of-a-stream-processor)
        for more information.
        """
        return pulumi.get(self, "stats")

