<img src="https://raw.githubusercontent.com/QTC-UMD/rydiqule/main/docs/source/img/Rydiqule_Logo_Transparent_300.png" alt="rydiqule" style="max-width: 100%;">

The Rydberg Interactive Quantum module is a modeling library designed to simulate
the response of Rydberg atoms to arbitrary input RF waveforms.
It also functions as a general master equation solver based on the semi-classical density matrix method.

[![PyPI](https://img.shields.io/pypi/v/rydiqule.svg)](https://pypi.org/project/rydiqule)
[![Conda Version](https://img.shields.io/conda/v/rydiqule/rydiqule)](https://anaconda.org/rydiqule/rydiqule)
[![Python Version](https://img.shields.io/pypi/pyversions/rydiqule.svg)](https://python.org)
[![License](https://img.shields.io/pypi/l/rydiqule.svg)](https://github.com/QTC-UMD/rydiqule/raw/main/LICENSE)
[![Docs](https://readthedocs.org/projects/rydiqule/badge/?version=latest)](https://rydiqule.readthedocs.io/)
[![DOI](https://img.shields.io/badge/Comp%20Phys%20Comms-10.1016%2Fj.cpc.2023.108952-goldenrod.svg)](https://doi.org/10.1016/j.cpc.2023.108952)
[![status](https://joss.theoj.org/papers/95777dc6ef319c09d9ace33178787137/status.svg)](https://joss.theoj.org/papers/95777dc6ef319c09d9ace33178787137)

### Please cite as

B. N Miller, D. H. Meyer, T. Virtanen, C. M O'Brien, and K. C. Cox,
RydIQule: A Graph-based paradigm for modeling Rydberg and atomic sensors,
*Computer Physics Communications*, **294**, 108952 (2024)
[https://doi.org/10.1016/j.cpc.2023.108952](https://doi.org/10.1016/j.cpc.2023.108952)

## Installation

Installation can be done via pip or conda.
See the [documentation](https://rydiqule.readthedocs.io/page/installation.html) for details.

## Documentation

Documentation is available online at [readthedocs](https://rydiqule.readthedocs.io/).
PDF or EPUB formats of the documentation can be downloaded from the online documentation.

### Examples

Example jupyter notebooks that demonstrate RydIQule can be found in the documentation,
with back-links to download them directly from the github repository.

## Support

Creation of this software was supported in part by the Defense Advanced Research Projects Agency (DARPA) Quantum Apertures program, DEVCOM Army Research Laboratory, and the Quantum Technology Center at the University of Maryland.

## Disclaimer

The views, opinions and/or findings expressed are those of the authors and should not be interpreted as representing the official views or policies of the Department of Defense or the U.S. Government.

## Contact

This github repository is primarily for code distribution.
While we monitor it, 
responses to issues or pull requests posted to it may be limited.
If you would like a more detailed response from the developers,
please e-mail david.h.meyer3.civ@army.mil or kevin.c.cox29.civ@army.mil

### Contributing

We actively encourage contributions and collaboration in the development of rydiqule.
Unforunately, rydiqule's development is done privately, _for reasons_.
If you would like to submit a PR for all but the most trivial of changes,
please e-mail us directly so we can discuss the collaboration.

