
from abacustest.lib_collectdata.comm import EV2RY


MASS_DICT = {
    "H": 1.0079,
    "He": 4.0026,
    "Li": 6.941,
    "Be": 9.0122,
    "B": 10.811,
    "C": 12.0107,
    "N": 14.0067,
    "O": 15.9994,
    "F": 18.9984,
    "Ne": 20.1797,
    "Na": 22.9897,
    "Mg": 24.305,
    "Al": 26.9815,
    "Si": 28.0855,
    "P": 30.9738,
    "S": 32.065,
    "Cl": 35.453,
    "K": 39.0983,
    "Ar": 39.948,
    "Ca": 40.078,
    "Sc": 44.9559,
    "Ti": 47.867,
    "V": 50.9415,
    "Cr": 51.9961,
    "Mn": 54.938,
    "Fe": 55.845,
    "Ni": 58.6934,
    "Co": 58.9332,
    "Cu": 63.546,
    "Zn": 65.39,
    "Ga": 69.723,
    "Ge": 72.64,
    "As": 74.9216,
    "Se": 78.96,
    "Br": 79.904,
    "Kr": 83.8,
    "Rb": 85.4678,
    "Sr": 87.62,
    "Y": 88.9059,
    "Zr": 91.224,
    "Nb": 92.9064,
    "Mo": 95.94,
    "Tc": 98,
    "Ru": 101.07,
    "Rh": 102.9055,
    "Pd": 106.42,
    "Ag": 107.8682,
    "Cd": 112.411,
    "In": 114.818,
    "Sn": 118.71,
    "Sb": 121.76,
    "I": 126.9045,
    "Te": 127.6,
    "Xe": 131.293,
    "Cs": 132.9055,
    "Ba": 137.327,
    "La": 138.9055,
    "Ce": 140.116,
    "Pr": 140.9077,
    "Nd": 144.24,
    "Pm": 145,
    "Sm": 150.36,
    "Eu": 151.964,
    "Gd": 157.25,
    "Tb": 158.9253,
    "Dy": 162.5,
    "Ho": 164.9303,
    "Er": 167.259,
    "Tm": 168.9342,
    "Yb": 173.04,
    "Lu": 174.967,
    "Hf": 178.49,
    "Ta": 180.9479,
    "W": 183.84,
    "Re": 186.207,
    "Os": 190.23,
    "Ir": 192.217,
    "Pt": 195.078,
    "Au": 196.9665,
    "Hg": 200.59,
    "Tl": 204.3833,
    "Pb": 207.2,
    "Bi": 208.9804,
    "Po": 209,
    "At": 210,
    "Rn": 222,
    "Fr": 223,
    "Ra": 226,
    "Ac": 227,
    "Pa": 231.0359,
    "Th": 232.0381,
    "Np": 237,
    "U": 238.0289,
    "Am": 243,
    "Pu": 244,
    "Cm": 247,
    "Bk": 247,
    "Cf": 251,
    "Es": 252,
    "Fm": 257,
    "Md": 258,
    "No": 259,
    "Rf": 261,
    "Lr": 262,
    "Db": 262,
    "Bh": 264,
    "Sg": 266,
    "Mt": 268,
    "Rg": 272,
    "Hs": 277,
    "H": 1.0079,
    "He": 4.0026,
    "Li": 6.941,
    "Be": 9.0122,
    "B": 10.811,
    "C": 12.0107,
    "N": 14.0067,
    "O": 15.9994,
    "F": 18.9984,
    "Ne": 20.1797,
    "Na": 22.9897,
    "Mg": 24.305,
    "Al": 26.9815,
    "Si": 28.0855,
    "P": 30.9738,
    "S": 32.065,
    "Cl": 35.453,
    "K": 39.0983,
    "Ar": 39.948,
    "Ca": 40.078,
    "Sc": 44.9559,
    "Ti": 47.867,
    "V": 50.9415,
    "Cr": 51.9961,
    "Mn": 54.938,
    "Fe": 55.845,
    "Ni": 58.6934,
    "Co": 58.9332,
    "Cu": 63.546,
    "Zn": 65.39,
    "Ga": 69.723,
    "Ge": 72.64,
    "As": 74.9216,
    "Se": 78.96,
    "Br": 79.904,
    "Kr": 83.8,
    "Rb": 85.4678,
    "Sr": 87.62,
    "Y": 88.9059,
    "Zr": 91.224,
    "Nb": 92.9064,
    "Mo": 95.94,
    "Tc": 98,
    "Ru": 101.07,
    "Rh": 102.9055,
    "Pd": 106.42,
    "Ag": 107.8682,
    "Cd": 112.411,
    "In": 114.818,
    "Sn": 118.71,
    "Sb": 121.76,
    "I": 126.9045,
    "Te": 127.6,
    "Xe": 131.293,
    "Cs": 132.9055,
    "Ba": 137.327,
    "La": 138.9055,
    "Ce": 140.116,
    "Pr": 140.9077,
    "Nd": 144.24,
    "Pm": 145,
    "Sm": 150.36,
    "Eu": 151.964,
    "Gd": 157.25,
    "Tb": 158.9253,
    "Dy": 162.5,
    "Ho": 164.9303,
    "Er": 167.259,
    "Tm": 168.9342,
    "Yb": 173.04,
    "Lu": 174.967,
    "Hf": 178.49,
    "Ta": 180.9479,
    "W": 183.84,
    "Re": 186.207,
    "Os": 190.23,
    "Ir": 192.217,
    "Pt": 195.078,
    "Au": 196.9665,
    "Hg": 200.59,
    "Tl": 204.3833,
    "Pb": 207.2,
    "Bi": 208.9804,
    "Po": 209,
    "At": 210,
    "Rn": 222,
    "Fr": 223,
    "Ra": 226,
    "Ac": 227,
    "Pa": 231.0359,
    "Th": 232.0381,
    "Np": 237,
    "U": 238.0289,
    "Am": 243,
    "Pu": 244,
    "Cm": 247,
    "Bk": 247,
    "Cf": 251,
    "Es": 252,
    "Fm": 257,
    "Md": 258,
    "No": 259,
    "Rf": 261,
    "Lr": 262,
    "Db": 262,
    "Bh": 264,
    "Sg": 266,
    "Mt": 268,
    "Rg": 272,
    "Hs": 277,
}

ABACUS_STRU_KEY_WORD = [
    "ATOMIC_SPECIES",
    "NUMERICAL_ORBITAL",
    "LATTICE_CONSTANT",
    "LATTICE_VECTORS",
    "ATOMIC_POSITIONS",
    "NUMERICAL_DESCRIPTOR",
    "PAW_FILES"
]

BOHR2A = 0.5291875321107901
A2BOHR = 1 / BOHR2A

EV2RY = 1 / 13.605698066
RY2EV = 1 / EV2RY


PERIOD_DICT_ELEMENT = {1: 'H', 2: 'He', 3: 'Li', 4: 'Be', 5: 'B', 6: 'C', 7: 'N', 8: 'O', 9: 'F', 10: 'Ne',\
11: 'Na', 12: 'Mg', 13: 'Al', 14: 'Si', 15: 'P', 16: 'S', 17: 'Cl', 18: 'Ar', 19: 'K', 20: 'Ca', \
21: 'Sc', 22: 'Ti', 23: 'V', 24: 'Cr', 25: 'Mn', 26: 'Fe', 27: 'Co', 28: 'Ni', 29: 'Cu', 30: 'Zn', \
31: 'Ga', 32: 'Ge', 33: 'As', 34: 'Se', 35: 'Br', 36: 'Kr', 37: 'Rb', 38: 'Sr', 39: 'Y', 40: 'Zr', \
41: 'Nb', 42: 'Mo', 43: 'Tc', 44: 'Ru', 45: 'Rh', 46: 'Pd', 47: 'Ag', 48: 'Cd', 49: 'In', 50: 'Sn', \
51: 'Sb', 52: 'Te', 53: 'I', 54: 'Xe', 55: 'Cs', 56: 'Ba', 57: 'La', 58: 'Ce', 59: 'Pr', 60: 'Nd', \
61: 'Pm', 62: 'Sm', 63: 'Eu', 64: 'Gd', 65: 'Tb', 66: 'Dy', 67: 'Ho', 68: 'Er', 69: 'Tm', 70: 'Yb', \
71: 'Lu', 72: 'Hf', 73: 'Ta', 74: 'W', 75: 'Re', 76: 'Os', 77: 'Ir', 78: 'Pt', 79: 'Au', 80: 'Hg', \
81: 'Tl', 82: 'Pb', 83: 'Bi', 84: 'Po', 85: 'At', 86: 'Rn', 87: 'Fr', 88: 'Ra', 89: 'Ac', 90: 'Th', \
91: 'Pa', 92: 'U', 93: 'Np', 94: 'Pu', 95: 'Am', 96: 'Cm', 97: 'Bk', 98: 'Cf', 99: 'Es', 100: 'Fm', \
101: 'Md', 102: 'No', 103: 'Lr'}

PERIOD_DICT_NUMBER = {'H': 1, 'He': 2, 'Li': 3, 'Be': 4, 'B': 5, 'C': 6, 'N': 7, 'O': 8, 'F': 9, 'Ne': 10, \
'Na': 11, 'Mg': 12, 'Al': 13, 'Si': 14, 'P': 15, 'S': 16, 'Cl': 17, 'Ar': 18, 'K': 19, 'Ca': 20, 'Sc': 21, \
'Ti': 22, 'V': 23, 'Cr': 24, 'Mn': 25, 'Fe': 26, 'Co': 27, 'Ni': 28, 'Cu': 29, 'Zn': 30, 'Ga': 31, 'Ge': 32, \
'As': 33, 'Se': 34, 'Br': 35, 'Kr': 36, 'Rb': 37, 'Sr': 38, 'Y': 39, 'Zr': 40, 'Nb': 41, 'Mo': 42, 'Tc': 43, \
'Ru': 44, 'Rh': 45, 'Pd': 46, 'Ag': 47, 'Cd': 48, 'In': 49, 'Sn': 50, 'Sb': 51, 'Te': 52, 'I': 53, 'Xe': 54, \
'Cs': 55, 'Ba': 56, 'La': 57, 'Ce': 58, 'Pr': 59, 'Nd': 60, 'Pm': 61, 'Sm': 62, 'Eu': 63, 'Gd': 64, 'Tb': 65, \
'Dy': 66, 'Ho': 67, 'Er': 68, 'Tm': 69, 'Yb': 70, 'Lu': 71, 'Hf': 72, 'Ta': 73, 'W': 74, 'Re': 75, 'Os': 76, \
'Ir': 77, 'Pt': 78, 'Au': 79, 'Hg': 80, 'Tl': 81, 'Pb': 82, 'Bi': 83, 'Po': 84, 'At': 85, 'Rn': 86, 'Fr': 87, \
'Ra': 88, 'Ac': 89, 'Th': 90, 'Pa': 91, 'U': 92, 'Np': 93, 'Pu': 94, 'Am': 95, 'Cm': 96, 'Bk': 97, 'Cf': 98, \
'Es': 99, 'Fm': 100, 'Md': 101, 'No': 102, 'Lr': 103}

RECOMMAND_IMAGE = "registry.dp.tech/dptech/abacus-stable:LTSv3.10"
RECOMMAND_COMMAND = "OMP_NUM_THREADS=1 mpirun -np 16 abacus | tee out.log"
RECOMMAND_MACHINE = "c32_m64_cpu"

# From Introduction to Solid State Physics, 8th edition, by Charles Kittel
ELEMENT_CRYSTAL_STRUCTURES = {
    "Li": {"crystal": "bcc", "a": 3.51},
    "Be": {"crystal": "hcp", "a": 2.27, "c": 3.59},
    "Na": {"crystal": "bcc", "a": 4.23},
    "Mg": {"crystal": "hcp", "a": 3.21, "c": 5.21},
    "Al": {"crystal": "fcc", "a": 4.05},
    "Si": {"crystal": "diamond", "a": 5.43},
    "K": {"crystal": "bcc", "a": 5.23},
    "Ca": {"crystal": "fcc", "a": 5.58},
    "Sc": {"crystal": "hcp", "a": 3.31, "c": 5.27},
    "Ti": {"crystal": "hcp", "a": 2.95, "c": 4.68},
    "V": {"crystal": "bcc", "a": 3.03},
    "Cr": {"crystal": "bcc", "a": 2.88},
    "Mn": {"crystal": "bcc", "a": 2.91}, # To be checked
    "Fe": {"crystal": "bcc", "a": 2.87},
    "Co": {"crystal": "hcp", "a": 2.51, "c": 4.07},
    "Ni": {"crystal": "fcc", "a": 3.52},
    "Cu": {"crystal": "fcc", "a": 3.61},
    "Zn": {"crystal": "hcp", "a": 2.66, "c": 4.95},
    "Ga": {"crystal": "fcc", "a": 4.50}, # To be checked
    "Ge": {"crystal": "diamond", "a": 5.69},
    "Rb": {"crystal": "bcc", "a": 5.58},
    "Sr": {"crystal": "fcc", "a": 6.08},
    "Y": {"crystal": "hcp", "a": 3.65, "c": 5.73},
    "Zr": {"crystal": "hcp", "a": 3.23, "c": 5.15},
    "Nb": {"crystal": "bcc", "a": 3.30},
    "Mo": {"crystal": "bcc", "a": 3.15},
    "Tc": {"crystal": "hcp", "a": 2.74, "c": 4.44},
    "Ru": {"crystal": "hcp", "a": 2.71, "c": 4.28},
    "Rh": {"crystal": "fcc", "a": 3.80},
    "Pd": {"crystal": "fcc", "a": 3.89},
    "Ag": {"crystal": "fcc", "a": 4.09},
    "Cd": {"crystal": "hcp", "a": 2.98, "c": 5.62},
    "In": {"crystal": "bcc", "a": 3.25}, # To be checked
    "Sn": {"crystal": "diamond", "a": 6.49},
    "Cs": {"crystal": "bcc", "a": 6.05},
    "Ba": {"crystal": "bcc", "a": 5.02},
    "La": {"crystal": "hcp", "a": 3.75, "c": 5.75}, # To be checked
    "Ce": {"crystal": "fcc", "a": 5.16}, 
    "Pr": {"crystal": "hcp", "a": 3.65, "c": 5.75}, # To be checked
    "Nd": {"crystal": "hcp", "a": 3.65, "c": 5.73}, # To be checked
    "Pm": {"crystal": "hcp", "a": 3.65, "c": 5.73}, # To be checked
    "Sm": {"crystal": "hcp", "a": 3.65, "c": 5.73}, # To be checked 
    "Eu": {"crystal": "bcc", "a": 4.58},
    "Gd": {"crystal": "hcp", "a": 3.63, "c": 5.78},
    "Tb": {"crystal": "hcp", "a": 3.60, "c": 5.70},
    "Dy": {"crystal": "hcp", "a": 3.59, "c": 5.65},
    "Ho": {"crystal": "hcp", "a": 3.58, "c": 5.62},
    "Er": {"crystal": "hcp", "a": 3.56, "c": 5.59},
    "Tm": {"crystal": "hcp", "a": 3.54, "c": 5.56},
    "Yb": {"crystal": "fcc", "a": 5.48},
    "Lu": {"crystal": "hcp", "a": 3.50, "c": 5.55},
    "Hf": {"crystal": "hcp", "a": 3.19, "c": 5.05},
    "Ta": {"crystal": "bcc", "a": 3.30},
    "W": {"crystal": "bcc", "a": 3.16},
    "Re": {"crystal": "hcp", "a": 2.76, "c": 4.46},
    "Os": {"crystal": "hcp", "a": 2.74, "c": 4.32},
    "Ir": {"crystal": "fcc", "a": 3.84},
    "Pt": {"crystal": "fcc", "a": 3.92},
    "Au": {"crystal": "fcc", "a": 4.08},
    "Hg": {"crystal": "hcp", "a": 2.99, "c": 5.01}, # To be checked
    "Tl": {"crystal": "hcp", "a": 3.46, "c": 5.52},
    "Pb": {"crystal": "fcc", "a": 4.95},
}
