# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.consent import Consent
from ..types.health_insurance_create_request import HealthInsuranceCreateRequest
from ..types.http_validation_error import HttpValidationError
from ..types.patient_address_with_validation import PatientAddressWithValidation
from ..types.patient_details_with_validation import PatientDetailsWithValidation
from ..types.physician_create_request_base import PhysicianCreateRequestBase
from ..types.post_order_response import PostOrderResponse
from ..types.shipping_address_with_validation import ShippingAddressWithValidation

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawTestkitClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def register(
        self,
        *,
        sample_id: str,
        patient_details: PatientDetailsWithValidation,
        patient_address: PatientAddressWithValidation,
        user_id: typing.Optional[str] = OMIT,
        physician: typing.Optional[PhysicianCreateRequestBase] = OMIT,
        health_insurance: typing.Optional[HealthInsuranceCreateRequest] = OMIT,
        consents: typing.Optional[typing.Sequence[Consent]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PostOrderResponse]:
        """
        Parameters
        ----------
        sample_id : str

        patient_details : PatientDetailsWithValidation

        patient_address : PatientAddressWithValidation

        user_id : typing.Optional[str]
            The user ID of the patient.

        physician : typing.Optional[PhysicianCreateRequestBase]

        health_insurance : typing.Optional[HealthInsuranceCreateRequest]

        consents : typing.Optional[typing.Sequence[Consent]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PostOrderResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v3/order/testkit/register",
            method="POST",
            json={
                "user_id": user_id,
                "sample_id": sample_id,
                "patient_details": patient_details,
                "patient_address": patient_address,
                "physician": physician,
                "health_insurance": health_insurance,
                "consents": consents,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostOrderResponse,
                    parse_obj_as(
                        type_=PostOrderResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_order(
        self,
        *,
        user_id: str,
        lab_test_id: str,
        shipping_details: ShippingAddressWithValidation,
        passthrough: typing.Optional[str] = OMIT,
        lab_account_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PostOrderResponse]:
        """
        Creates an order for an unregistered testkit

        Parameters
        ----------
        user_id : str

        lab_test_id : str

        shipping_details : ShippingAddressWithValidation

        passthrough : typing.Optional[str]

        lab_account_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PostOrderResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v3/order/testkit",
            method="POST",
            json={
                "user_id": user_id,
                "lab_test_id": lab_test_id,
                "shipping_details": shipping_details,
                "passthrough": passthrough,
                "lab_account_id": lab_account_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostOrderResponse,
                    parse_obj_as(
                        type_=PostOrderResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawTestkitClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def register(
        self,
        *,
        sample_id: str,
        patient_details: PatientDetailsWithValidation,
        patient_address: PatientAddressWithValidation,
        user_id: typing.Optional[str] = OMIT,
        physician: typing.Optional[PhysicianCreateRequestBase] = OMIT,
        health_insurance: typing.Optional[HealthInsuranceCreateRequest] = OMIT,
        consents: typing.Optional[typing.Sequence[Consent]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PostOrderResponse]:
        """
        Parameters
        ----------
        sample_id : str

        patient_details : PatientDetailsWithValidation

        patient_address : PatientAddressWithValidation

        user_id : typing.Optional[str]
            The user ID of the patient.

        physician : typing.Optional[PhysicianCreateRequestBase]

        health_insurance : typing.Optional[HealthInsuranceCreateRequest]

        consents : typing.Optional[typing.Sequence[Consent]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PostOrderResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v3/order/testkit/register",
            method="POST",
            json={
                "user_id": user_id,
                "sample_id": sample_id,
                "patient_details": patient_details,
                "patient_address": patient_address,
                "physician": physician,
                "health_insurance": health_insurance,
                "consents": consents,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostOrderResponse,
                    parse_obj_as(
                        type_=PostOrderResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_order(
        self,
        *,
        user_id: str,
        lab_test_id: str,
        shipping_details: ShippingAddressWithValidation,
        passthrough: typing.Optional[str] = OMIT,
        lab_account_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PostOrderResponse]:
        """
        Creates an order for an unregistered testkit

        Parameters
        ----------
        user_id : str

        lab_test_id : str

        shipping_details : ShippingAddressWithValidation

        passthrough : typing.Optional[str]

        lab_account_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PostOrderResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v3/order/testkit",
            method="POST",
            json={
                "user_id": user_id,
                "lab_test_id": lab_test_id,
                "shipping_details": shipping_details,
                "passthrough": passthrough,
                "lab_account_id": lab_account_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostOrderResponse,
                    parse_obj_as(
                        type_=PostOrderResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
