# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .password_providers import PasswordProviders
from .provider_link_response_error_type import ProviderLinkResponseErrorType
from .provider_link_response_state import ProviderLinkResponseState
from .provider_mfa_request import ProviderMfaRequest


class ProviderLinkResponse(UniversalBaseModel):
    state: ProviderLinkResponseState = pydantic.Field()
    """
    ℹ️ This enum is non-exhaustive.
    """

    redirect_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The redirect URL you supplied when creating the Link Token (via `POST /v2/link/token`).
    """

    error_type: typing.Optional[ProviderLinkResponseErrorType] = pydantic.Field(default=None)
    """
    The Link Error Type. This field is populated only when state is `error`. ℹ️ This enum is non-exhaustive.
    """

    error: typing.Optional[str] = pydantic.Field(default=None)
    """
    A developer-readable debug description of the Link Error. This field is populated only when state is `error`.
    """

    provider_mfa: typing.Optional[ProviderMfaRequest] = pydantic.Field(default=None)
    """
    The provider MFA request. This field is populated only when state is `pending_provider_mfa`.
    """

    provider: PasswordProviders
    connected: bool
    provider_id: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
