# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DomainAdminArgs',
    'DomainAdminArgsDict',
    'DomainBillingArgs',
    'DomainBillingArgsDict',
    'DomainOwnerArgs',
    'DomainOwnerArgsDict',
    'DomainTechArgs',
    'DomainTechArgsDict',
]

MYPY = False

if not MYPY:
    class DomainAdminArgsDict(TypedDict):
        city: pulumi.Input[_builtins.str]
        """
        City for the contact
        """
        country: pulumi.Input[_builtins.str]
        """
        The two letter country code for the contact
        """
        email: pulumi.Input[_builtins.str]
        """
        Contact email address
        """
        family_name: pulumi.Input[_builtins.str]
        """
        Family name of the contact
        """
        given_name: pulumi.Input[_builtins.str]
        """
        Given name of the contact
        """
        phone: pulumi.Input[_builtins.str]
        """
        Phone number for the contact
        """
        street_addr: pulumi.Input[_builtins.str]
        """
        Street Address of the contact
        """
        type: pulumi.Input[_builtins.str]
        """
        One of 'person', 'company', 'association', 'public body', or 'reseller'
        """
        zip: pulumi.Input[_builtins.str]
        """
        Postal Code/Zipcode of the contact
        """
        data_obfuscated: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether or not to obfuscate contact data in WHOIS
        """
        extra_parameters: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Extra parameters, needed for some jurisdictions
        """
        mail_obfuscated: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether or not to obfuscate contact email in WHOIS
        """
        organisation: NotRequired[pulumi.Input[_builtins.str]]
        """
        The legal name of the organisation. Required for types other than person
        """
        state: NotRequired[pulumi.Input[_builtins.str]]
        """
        The state code for the contact
        """
elif False:
    DomainAdminArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainAdminArgs:
    def __init__(__self__, *,
                 city: pulumi.Input[_builtins.str],
                 country: pulumi.Input[_builtins.str],
                 email: pulumi.Input[_builtins.str],
                 family_name: pulumi.Input[_builtins.str],
                 given_name: pulumi.Input[_builtins.str],
                 phone: pulumi.Input[_builtins.str],
                 street_addr: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 zip: pulumi.Input[_builtins.str],
                 data_obfuscated: Optional[pulumi.Input[_builtins.bool]] = None,
                 extra_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mail_obfuscated: Optional[pulumi.Input[_builtins.bool]] = None,
                 organisation: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] city: City for the contact
        :param pulumi.Input[_builtins.str] country: The two letter country code for the contact
        :param pulumi.Input[_builtins.str] email: Contact email address
        :param pulumi.Input[_builtins.str] family_name: Family name of the contact
        :param pulumi.Input[_builtins.str] given_name: Given name of the contact
        :param pulumi.Input[_builtins.str] phone: Phone number for the contact
        :param pulumi.Input[_builtins.str] street_addr: Street Address of the contact
        :param pulumi.Input[_builtins.str] type: One of 'person', 'company', 'association', 'public body', or 'reseller'
        :param pulumi.Input[_builtins.str] zip: Postal Code/Zipcode of the contact
        :param pulumi.Input[_builtins.bool] data_obfuscated: Whether or not to obfuscate contact data in WHOIS
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extra_parameters: Extra parameters, needed for some jurisdictions
        :param pulumi.Input[_builtins.bool] mail_obfuscated: Whether or not to obfuscate contact email in WHOIS
        :param pulumi.Input[_builtins.str] organisation: The legal name of the organisation. Required for types other than person
        :param pulumi.Input[_builtins.str] state: The state code for the contact
        """
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "family_name", family_name)
        pulumi.set(__self__, "given_name", given_name)
        pulumi.set(__self__, "phone", phone)
        pulumi.set(__self__, "street_addr", street_addr)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "zip", zip)
        if data_obfuscated is not None:
            pulumi.set(__self__, "data_obfuscated", data_obfuscated)
        if extra_parameters is not None:
            pulumi.set(__self__, "extra_parameters", extra_parameters)
        if mail_obfuscated is not None:
            pulumi.set(__self__, "mail_obfuscated", mail_obfuscated)
        if organisation is not None:
            pulumi.set(__self__, "organisation", organisation)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def city(self) -> pulumi.Input[_builtins.str]:
        """
        City for the contact
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "city", value)

    @_builtins.property
    @pulumi.getter
    def country(self) -> pulumi.Input[_builtins.str]:
        """
        The two letter country code for the contact
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "country", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Input[_builtins.str]:
        """
        Contact email address
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="familyName")
    def family_name(self) -> pulumi.Input[_builtins.str]:
        """
        Family name of the contact
        """
        return pulumi.get(self, "family_name")

    @family_name.setter
    def family_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "family_name", value)

    @_builtins.property
    @pulumi.getter(name="givenName")
    def given_name(self) -> pulumi.Input[_builtins.str]:
        """
        Given name of the contact
        """
        return pulumi.get(self, "given_name")

    @given_name.setter
    def given_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "given_name", value)

    @_builtins.property
    @pulumi.getter
    def phone(self) -> pulumi.Input[_builtins.str]:
        """
        Phone number for the contact
        """
        return pulumi.get(self, "phone")

    @phone.setter
    def phone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "phone", value)

    @_builtins.property
    @pulumi.getter(name="streetAddr")
    def street_addr(self) -> pulumi.Input[_builtins.str]:
        """
        Street Address of the contact
        """
        return pulumi.get(self, "street_addr")

    @street_addr.setter
    def street_addr(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "street_addr", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        One of 'person', 'company', 'association', 'public body', or 'reseller'
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def zip(self) -> pulumi.Input[_builtins.str]:
        """
        Postal Code/Zipcode of the contact
        """
        return pulumi.get(self, "zip")

    @zip.setter
    def zip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zip", value)

    @_builtins.property
    @pulumi.getter(name="dataObfuscated")
    def data_obfuscated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to obfuscate contact data in WHOIS
        """
        return pulumi.get(self, "data_obfuscated")

    @data_obfuscated.setter
    def data_obfuscated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "data_obfuscated", value)

    @_builtins.property
    @pulumi.getter(name="extraParameters")
    def extra_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Extra parameters, needed for some jurisdictions
        """
        return pulumi.get(self, "extra_parameters")

    @extra_parameters.setter
    def extra_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "extra_parameters", value)

    @_builtins.property
    @pulumi.getter(name="mailObfuscated")
    def mail_obfuscated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to obfuscate contact email in WHOIS
        """
        return pulumi.get(self, "mail_obfuscated")

    @mail_obfuscated.setter
    def mail_obfuscated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mail_obfuscated", value)

    @_builtins.property
    @pulumi.getter
    def organisation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The legal name of the organisation. Required for types other than person
        """
        return pulumi.get(self, "organisation")

    @organisation.setter
    def organisation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organisation", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state code for the contact
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


if not MYPY:
    class DomainBillingArgsDict(TypedDict):
        city: pulumi.Input[_builtins.str]
        """
        City for the contact
        """
        country: pulumi.Input[_builtins.str]
        """
        The two letter country code for the contact
        """
        email: pulumi.Input[_builtins.str]
        """
        Contact email address
        """
        family_name: pulumi.Input[_builtins.str]
        """
        Family name of the contact
        """
        given_name: pulumi.Input[_builtins.str]
        """
        Given name of the contact
        """
        phone: pulumi.Input[_builtins.str]
        """
        Phone number for the contact
        """
        street_addr: pulumi.Input[_builtins.str]
        """
        Street Address of the contact
        """
        type: pulumi.Input[_builtins.str]
        """
        One of 'person', 'company', 'association', 'public body', or 'reseller'
        """
        zip: pulumi.Input[_builtins.str]
        """
        Postal Code/Zipcode of the contact
        """
        data_obfuscated: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether or not to obfuscate contact data in WHOIS
        """
        extra_parameters: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Extra parameters, needed for some jurisdictions
        """
        mail_obfuscated: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether or not to obfuscate contact email in WHOIS
        """
        organisation: NotRequired[pulumi.Input[_builtins.str]]
        """
        The legal name of the organisation. Required for types other than person
        """
        state: NotRequired[pulumi.Input[_builtins.str]]
        """
        The state code for the contact
        """
elif False:
    DomainBillingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainBillingArgs:
    def __init__(__self__, *,
                 city: pulumi.Input[_builtins.str],
                 country: pulumi.Input[_builtins.str],
                 email: pulumi.Input[_builtins.str],
                 family_name: pulumi.Input[_builtins.str],
                 given_name: pulumi.Input[_builtins.str],
                 phone: pulumi.Input[_builtins.str],
                 street_addr: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 zip: pulumi.Input[_builtins.str],
                 data_obfuscated: Optional[pulumi.Input[_builtins.bool]] = None,
                 extra_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mail_obfuscated: Optional[pulumi.Input[_builtins.bool]] = None,
                 organisation: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] city: City for the contact
        :param pulumi.Input[_builtins.str] country: The two letter country code for the contact
        :param pulumi.Input[_builtins.str] email: Contact email address
        :param pulumi.Input[_builtins.str] family_name: Family name of the contact
        :param pulumi.Input[_builtins.str] given_name: Given name of the contact
        :param pulumi.Input[_builtins.str] phone: Phone number for the contact
        :param pulumi.Input[_builtins.str] street_addr: Street Address of the contact
        :param pulumi.Input[_builtins.str] type: One of 'person', 'company', 'association', 'public body', or 'reseller'
        :param pulumi.Input[_builtins.str] zip: Postal Code/Zipcode of the contact
        :param pulumi.Input[_builtins.bool] data_obfuscated: Whether or not to obfuscate contact data in WHOIS
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extra_parameters: Extra parameters, needed for some jurisdictions
        :param pulumi.Input[_builtins.bool] mail_obfuscated: Whether or not to obfuscate contact email in WHOIS
        :param pulumi.Input[_builtins.str] organisation: The legal name of the organisation. Required for types other than person
        :param pulumi.Input[_builtins.str] state: The state code for the contact
        """
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "family_name", family_name)
        pulumi.set(__self__, "given_name", given_name)
        pulumi.set(__self__, "phone", phone)
        pulumi.set(__self__, "street_addr", street_addr)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "zip", zip)
        if data_obfuscated is not None:
            pulumi.set(__self__, "data_obfuscated", data_obfuscated)
        if extra_parameters is not None:
            pulumi.set(__self__, "extra_parameters", extra_parameters)
        if mail_obfuscated is not None:
            pulumi.set(__self__, "mail_obfuscated", mail_obfuscated)
        if organisation is not None:
            pulumi.set(__self__, "organisation", organisation)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def city(self) -> pulumi.Input[_builtins.str]:
        """
        City for the contact
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "city", value)

    @_builtins.property
    @pulumi.getter
    def country(self) -> pulumi.Input[_builtins.str]:
        """
        The two letter country code for the contact
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "country", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Input[_builtins.str]:
        """
        Contact email address
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="familyName")
    def family_name(self) -> pulumi.Input[_builtins.str]:
        """
        Family name of the contact
        """
        return pulumi.get(self, "family_name")

    @family_name.setter
    def family_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "family_name", value)

    @_builtins.property
    @pulumi.getter(name="givenName")
    def given_name(self) -> pulumi.Input[_builtins.str]:
        """
        Given name of the contact
        """
        return pulumi.get(self, "given_name")

    @given_name.setter
    def given_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "given_name", value)

    @_builtins.property
    @pulumi.getter
    def phone(self) -> pulumi.Input[_builtins.str]:
        """
        Phone number for the contact
        """
        return pulumi.get(self, "phone")

    @phone.setter
    def phone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "phone", value)

    @_builtins.property
    @pulumi.getter(name="streetAddr")
    def street_addr(self) -> pulumi.Input[_builtins.str]:
        """
        Street Address of the contact
        """
        return pulumi.get(self, "street_addr")

    @street_addr.setter
    def street_addr(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "street_addr", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        One of 'person', 'company', 'association', 'public body', or 'reseller'
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def zip(self) -> pulumi.Input[_builtins.str]:
        """
        Postal Code/Zipcode of the contact
        """
        return pulumi.get(self, "zip")

    @zip.setter
    def zip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zip", value)

    @_builtins.property
    @pulumi.getter(name="dataObfuscated")
    def data_obfuscated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to obfuscate contact data in WHOIS
        """
        return pulumi.get(self, "data_obfuscated")

    @data_obfuscated.setter
    def data_obfuscated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "data_obfuscated", value)

    @_builtins.property
    @pulumi.getter(name="extraParameters")
    def extra_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Extra parameters, needed for some jurisdictions
        """
        return pulumi.get(self, "extra_parameters")

    @extra_parameters.setter
    def extra_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "extra_parameters", value)

    @_builtins.property
    @pulumi.getter(name="mailObfuscated")
    def mail_obfuscated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to obfuscate contact email in WHOIS
        """
        return pulumi.get(self, "mail_obfuscated")

    @mail_obfuscated.setter
    def mail_obfuscated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mail_obfuscated", value)

    @_builtins.property
    @pulumi.getter
    def organisation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The legal name of the organisation. Required for types other than person
        """
        return pulumi.get(self, "organisation")

    @organisation.setter
    def organisation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organisation", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state code for the contact
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


if not MYPY:
    class DomainOwnerArgsDict(TypedDict):
        city: pulumi.Input[_builtins.str]
        """
        City for the contact
        """
        country: pulumi.Input[_builtins.str]
        """
        The two letter country code for the contact
        """
        email: pulumi.Input[_builtins.str]
        """
        Contact email address
        """
        family_name: pulumi.Input[_builtins.str]
        """
        Family name of the contact
        """
        given_name: pulumi.Input[_builtins.str]
        """
        Given name of the contact
        """
        phone: pulumi.Input[_builtins.str]
        """
        Phone number for the contact
        """
        street_addr: pulumi.Input[_builtins.str]
        """
        Street Address of the contact
        """
        type: pulumi.Input[_builtins.str]
        """
        One of 'person', 'company', 'association', 'public body', or 'reseller'
        """
        zip: pulumi.Input[_builtins.str]
        """
        Postal Code/Zipcode of the contact
        """
        data_obfuscated: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether or not to obfuscate contact data in WHOIS
        """
        extra_parameters: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Extra parameters, needed for some jurisdictions
        """
        mail_obfuscated: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether or not to obfuscate contact email in WHOIS
        """
        organisation: NotRequired[pulumi.Input[_builtins.str]]
        """
        The legal name of the organisation. Required for types other than person
        """
        state: NotRequired[pulumi.Input[_builtins.str]]
        """
        The state code for the contact
        """
elif False:
    DomainOwnerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainOwnerArgs:
    def __init__(__self__, *,
                 city: pulumi.Input[_builtins.str],
                 country: pulumi.Input[_builtins.str],
                 email: pulumi.Input[_builtins.str],
                 family_name: pulumi.Input[_builtins.str],
                 given_name: pulumi.Input[_builtins.str],
                 phone: pulumi.Input[_builtins.str],
                 street_addr: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 zip: pulumi.Input[_builtins.str],
                 data_obfuscated: Optional[pulumi.Input[_builtins.bool]] = None,
                 extra_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mail_obfuscated: Optional[pulumi.Input[_builtins.bool]] = None,
                 organisation: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] city: City for the contact
        :param pulumi.Input[_builtins.str] country: The two letter country code for the contact
        :param pulumi.Input[_builtins.str] email: Contact email address
        :param pulumi.Input[_builtins.str] family_name: Family name of the contact
        :param pulumi.Input[_builtins.str] given_name: Given name of the contact
        :param pulumi.Input[_builtins.str] phone: Phone number for the contact
        :param pulumi.Input[_builtins.str] street_addr: Street Address of the contact
        :param pulumi.Input[_builtins.str] type: One of 'person', 'company', 'association', 'public body', or 'reseller'
        :param pulumi.Input[_builtins.str] zip: Postal Code/Zipcode of the contact
        :param pulumi.Input[_builtins.bool] data_obfuscated: Whether or not to obfuscate contact data in WHOIS
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extra_parameters: Extra parameters, needed for some jurisdictions
        :param pulumi.Input[_builtins.bool] mail_obfuscated: Whether or not to obfuscate contact email in WHOIS
        :param pulumi.Input[_builtins.str] organisation: The legal name of the organisation. Required for types other than person
        :param pulumi.Input[_builtins.str] state: The state code for the contact
        """
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "family_name", family_name)
        pulumi.set(__self__, "given_name", given_name)
        pulumi.set(__self__, "phone", phone)
        pulumi.set(__self__, "street_addr", street_addr)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "zip", zip)
        if data_obfuscated is not None:
            pulumi.set(__self__, "data_obfuscated", data_obfuscated)
        if extra_parameters is not None:
            pulumi.set(__self__, "extra_parameters", extra_parameters)
        if mail_obfuscated is not None:
            pulumi.set(__self__, "mail_obfuscated", mail_obfuscated)
        if organisation is not None:
            pulumi.set(__self__, "organisation", organisation)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def city(self) -> pulumi.Input[_builtins.str]:
        """
        City for the contact
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "city", value)

    @_builtins.property
    @pulumi.getter
    def country(self) -> pulumi.Input[_builtins.str]:
        """
        The two letter country code for the contact
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "country", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Input[_builtins.str]:
        """
        Contact email address
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="familyName")
    def family_name(self) -> pulumi.Input[_builtins.str]:
        """
        Family name of the contact
        """
        return pulumi.get(self, "family_name")

    @family_name.setter
    def family_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "family_name", value)

    @_builtins.property
    @pulumi.getter(name="givenName")
    def given_name(self) -> pulumi.Input[_builtins.str]:
        """
        Given name of the contact
        """
        return pulumi.get(self, "given_name")

    @given_name.setter
    def given_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "given_name", value)

    @_builtins.property
    @pulumi.getter
    def phone(self) -> pulumi.Input[_builtins.str]:
        """
        Phone number for the contact
        """
        return pulumi.get(self, "phone")

    @phone.setter
    def phone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "phone", value)

    @_builtins.property
    @pulumi.getter(name="streetAddr")
    def street_addr(self) -> pulumi.Input[_builtins.str]:
        """
        Street Address of the contact
        """
        return pulumi.get(self, "street_addr")

    @street_addr.setter
    def street_addr(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "street_addr", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        One of 'person', 'company', 'association', 'public body', or 'reseller'
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def zip(self) -> pulumi.Input[_builtins.str]:
        """
        Postal Code/Zipcode of the contact
        """
        return pulumi.get(self, "zip")

    @zip.setter
    def zip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zip", value)

    @_builtins.property
    @pulumi.getter(name="dataObfuscated")
    def data_obfuscated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to obfuscate contact data in WHOIS
        """
        return pulumi.get(self, "data_obfuscated")

    @data_obfuscated.setter
    def data_obfuscated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "data_obfuscated", value)

    @_builtins.property
    @pulumi.getter(name="extraParameters")
    def extra_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Extra parameters, needed for some jurisdictions
        """
        return pulumi.get(self, "extra_parameters")

    @extra_parameters.setter
    def extra_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "extra_parameters", value)

    @_builtins.property
    @pulumi.getter(name="mailObfuscated")
    def mail_obfuscated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to obfuscate contact email in WHOIS
        """
        return pulumi.get(self, "mail_obfuscated")

    @mail_obfuscated.setter
    def mail_obfuscated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mail_obfuscated", value)

    @_builtins.property
    @pulumi.getter
    def organisation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The legal name of the organisation. Required for types other than person
        """
        return pulumi.get(self, "organisation")

    @organisation.setter
    def organisation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organisation", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state code for the contact
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


if not MYPY:
    class DomainTechArgsDict(TypedDict):
        city: pulumi.Input[_builtins.str]
        """
        City for the contact
        """
        country: pulumi.Input[_builtins.str]
        """
        The two letter country code for the contact
        """
        email: pulumi.Input[_builtins.str]
        """
        Contact email address
        """
        family_name: pulumi.Input[_builtins.str]
        """
        Family name of the contact
        """
        given_name: pulumi.Input[_builtins.str]
        """
        Given name of the contact
        """
        phone: pulumi.Input[_builtins.str]
        """
        Phone number for the contact
        """
        street_addr: pulumi.Input[_builtins.str]
        """
        Street Address of the contact
        """
        type: pulumi.Input[_builtins.str]
        """
        One of 'person', 'company', 'association', 'public body', or 'reseller'
        """
        zip: pulumi.Input[_builtins.str]
        """
        Postal Code/Zipcode of the contact
        """
        data_obfuscated: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether or not to obfuscate contact data in WHOIS
        """
        extra_parameters: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Extra parameters, needed for some jurisdictions
        """
        mail_obfuscated: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether or not to obfuscate contact email in WHOIS
        """
        organisation: NotRequired[pulumi.Input[_builtins.str]]
        """
        The legal name of the organisation. Required for types other than person
        """
        state: NotRequired[pulumi.Input[_builtins.str]]
        """
        The state code for the contact
        """
elif False:
    DomainTechArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainTechArgs:
    def __init__(__self__, *,
                 city: pulumi.Input[_builtins.str],
                 country: pulumi.Input[_builtins.str],
                 email: pulumi.Input[_builtins.str],
                 family_name: pulumi.Input[_builtins.str],
                 given_name: pulumi.Input[_builtins.str],
                 phone: pulumi.Input[_builtins.str],
                 street_addr: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 zip: pulumi.Input[_builtins.str],
                 data_obfuscated: Optional[pulumi.Input[_builtins.bool]] = None,
                 extra_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mail_obfuscated: Optional[pulumi.Input[_builtins.bool]] = None,
                 organisation: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] city: City for the contact
        :param pulumi.Input[_builtins.str] country: The two letter country code for the contact
        :param pulumi.Input[_builtins.str] email: Contact email address
        :param pulumi.Input[_builtins.str] family_name: Family name of the contact
        :param pulumi.Input[_builtins.str] given_name: Given name of the contact
        :param pulumi.Input[_builtins.str] phone: Phone number for the contact
        :param pulumi.Input[_builtins.str] street_addr: Street Address of the contact
        :param pulumi.Input[_builtins.str] type: One of 'person', 'company', 'association', 'public body', or 'reseller'
        :param pulumi.Input[_builtins.str] zip: Postal Code/Zipcode of the contact
        :param pulumi.Input[_builtins.bool] data_obfuscated: Whether or not to obfuscate contact data in WHOIS
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extra_parameters: Extra parameters, needed for some jurisdictions
        :param pulumi.Input[_builtins.bool] mail_obfuscated: Whether or not to obfuscate contact email in WHOIS
        :param pulumi.Input[_builtins.str] organisation: The legal name of the organisation. Required for types other than person
        :param pulumi.Input[_builtins.str] state: The state code for the contact
        """
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "family_name", family_name)
        pulumi.set(__self__, "given_name", given_name)
        pulumi.set(__self__, "phone", phone)
        pulumi.set(__self__, "street_addr", street_addr)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "zip", zip)
        if data_obfuscated is not None:
            pulumi.set(__self__, "data_obfuscated", data_obfuscated)
        if extra_parameters is not None:
            pulumi.set(__self__, "extra_parameters", extra_parameters)
        if mail_obfuscated is not None:
            pulumi.set(__self__, "mail_obfuscated", mail_obfuscated)
        if organisation is not None:
            pulumi.set(__self__, "organisation", organisation)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def city(self) -> pulumi.Input[_builtins.str]:
        """
        City for the contact
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "city", value)

    @_builtins.property
    @pulumi.getter
    def country(self) -> pulumi.Input[_builtins.str]:
        """
        The two letter country code for the contact
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "country", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Input[_builtins.str]:
        """
        Contact email address
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="familyName")
    def family_name(self) -> pulumi.Input[_builtins.str]:
        """
        Family name of the contact
        """
        return pulumi.get(self, "family_name")

    @family_name.setter
    def family_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "family_name", value)

    @_builtins.property
    @pulumi.getter(name="givenName")
    def given_name(self) -> pulumi.Input[_builtins.str]:
        """
        Given name of the contact
        """
        return pulumi.get(self, "given_name")

    @given_name.setter
    def given_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "given_name", value)

    @_builtins.property
    @pulumi.getter
    def phone(self) -> pulumi.Input[_builtins.str]:
        """
        Phone number for the contact
        """
        return pulumi.get(self, "phone")

    @phone.setter
    def phone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "phone", value)

    @_builtins.property
    @pulumi.getter(name="streetAddr")
    def street_addr(self) -> pulumi.Input[_builtins.str]:
        """
        Street Address of the contact
        """
        return pulumi.get(self, "street_addr")

    @street_addr.setter
    def street_addr(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "street_addr", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        One of 'person', 'company', 'association', 'public body', or 'reseller'
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def zip(self) -> pulumi.Input[_builtins.str]:
        """
        Postal Code/Zipcode of the contact
        """
        return pulumi.get(self, "zip")

    @zip.setter
    def zip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zip", value)

    @_builtins.property
    @pulumi.getter(name="dataObfuscated")
    def data_obfuscated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to obfuscate contact data in WHOIS
        """
        return pulumi.get(self, "data_obfuscated")

    @data_obfuscated.setter
    def data_obfuscated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "data_obfuscated", value)

    @_builtins.property
    @pulumi.getter(name="extraParameters")
    def extra_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Extra parameters, needed for some jurisdictions
        """
        return pulumi.get(self, "extra_parameters")

    @extra_parameters.setter
    def extra_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "extra_parameters", value)

    @_builtins.property
    @pulumi.getter(name="mailObfuscated")
    def mail_obfuscated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to obfuscate contact email in WHOIS
        """
        return pulumi.get(self, "mail_obfuscated")

    @mail_obfuscated.setter
    def mail_obfuscated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mail_obfuscated", value)

    @_builtins.property
    @pulumi.getter
    def organisation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The legal name of the organisation. Required for types other than person
        """
        return pulumi.get(self, "organisation")

    @organisation.setter
    def organisation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organisation", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state code for the contact
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


