# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DNSSecKeyArgs', 'DNSSecKey']

@pulumi.input_type
class DNSSecKeyArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input[_builtins.int],
                 domain: pulumi.Input[_builtins.str],
                 public_key: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a DNSSecKey resource.
        :param pulumi.Input[_builtins.int] algorithm: DNSSEC algorithm type
        :param pulumi.Input[_builtins.str] domain: Domain name
        :param pulumi.Input[_builtins.str] public_key: DNSSEC public key
        :param pulumi.Input[_builtins.str] type: DNSSEC key type
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "public_key", public_key)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input[_builtins.int]:
        """
        DNSSEC algorithm type
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Input[_builtins.str]:
        """
        Domain name
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Input[_builtins.str]:
        """
        DNSSEC public key
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "public_key", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        DNSSEC key type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _DNSSecKeyState:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input[_builtins.int]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DNSSecKey resources.
        :param pulumi.Input[_builtins.int] algorithm: DNSSEC algorithm type
        :param pulumi.Input[_builtins.str] domain: Domain name
        :param pulumi.Input[_builtins.str] public_key: DNSSEC public key
        :param pulumi.Input[_builtins.str] type: DNSSEC key type
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        DNSSEC algorithm type
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Domain name
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DNSSEC public key
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_key", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DNSSEC key type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("gandi:domains/dNSSecKey:DNSSecKey")
class DNSSecKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[_builtins.int]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a DNSSecKey resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] algorithm: DNSSEC algorithm type
        :param pulumi.Input[_builtins.str] domain: Domain name
        :param pulumi.Input[_builtins.str] public_key: DNSSEC public key
        :param pulumi.Input[_builtins.str] type: DNSSEC key type
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DNSSecKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a DNSSecKey resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param DNSSecKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DNSSecKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[_builtins.int]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DNSSecKeyArgs.__new__(DNSSecKeyArgs)

            if algorithm is None and not opts.urn:
                raise TypeError("Missing required property 'algorithm'")
            __props__.__dict__["algorithm"] = algorithm
            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            if public_key is None and not opts.urn:
                raise TypeError("Missing required property 'public_key'")
            __props__.__dict__["public_key"] = public_key
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(DNSSecKey, __self__).__init__(
            'gandi:domains/dNSSecKey:DNSSecKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            algorithm: Optional[pulumi.Input[_builtins.int]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            public_key: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'DNSSecKey':
        """
        Get an existing DNSSecKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] algorithm: DNSSEC algorithm type
        :param pulumi.Input[_builtins.str] domain: Domain name
        :param pulumi.Input[_builtins.str] public_key: DNSSEC public key
        :param pulumi.Input[_builtins.str] type: DNSSEC key type
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DNSSecKeyState.__new__(_DNSSecKeyState)

        __props__.__dict__["algorithm"] = algorithm
        __props__.__dict__["domain"] = domain
        __props__.__dict__["public_key"] = public_key
        __props__.__dict__["type"] = type
        return DNSSecKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Output[_builtins.int]:
        """
        DNSSEC algorithm type
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        Domain name
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Output[_builtins.str]:
        """
        DNSSEC public key
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        DNSSEC key type
        """
        return pulumi.get(self, "type")

