# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainArgs', 'Domain']

@pulumi.input_type
class DomainArgs:
    def __init__(__self__, *,
                 owner: pulumi.Input['DomainOwnerArgs'],
                 admin: Optional[pulumi.Input['DomainAdminArgs']] = None,
                 autorenew: Optional[pulumi.Input[_builtins.bool]] = None,
                 billing: Optional[pulumi.Input['DomainBillingArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tech: Optional[pulumi.Input['DomainTechArgs']] = None):
        """
        The set of arguments for constructing a Domain resource.
        :param pulumi.Input[_builtins.bool] autorenew: Should the domain autorenew
        :param pulumi.Input[_builtins.str] name: The FQDN of the domain
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nameservers: A list of nameservers for the domain
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags attached to the domain
        """
        pulumi.set(__self__, "owner", owner)
        if admin is not None:
            pulumi.set(__self__, "admin", admin)
        if autorenew is not None:
            pulumi.set(__self__, "autorenew", autorenew)
        if billing is not None:
            pulumi.set(__self__, "billing", billing)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nameservers is not None:
            warnings.warn("""This nameservers attribute will be removed on next major release: the nameservers resource has to be used instead.
See https://github.com/go-gandi/terraform-provider-gandi/issues/88 for details.""", DeprecationWarning)
            pulumi.log.warn("""nameservers is deprecated: This nameservers attribute will be removed on next major release: the nameservers resource has to be used instead.
See https://github.com/go-gandi/terraform-provider-gandi/issues/88 for details.""")
        if nameservers is not None:
            pulumi.set(__self__, "nameservers", nameservers)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tech is not None:
            pulumi.set(__self__, "tech", tech)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Input['DomainOwnerArgs']:
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: pulumi.Input['DomainOwnerArgs']):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def admin(self) -> Optional[pulumi.Input['DomainAdminArgs']]:
        return pulumi.get(self, "admin")

    @admin.setter
    def admin(self, value: Optional[pulumi.Input['DomainAdminArgs']]):
        pulumi.set(self, "admin", value)

    @_builtins.property
    @pulumi.getter
    def autorenew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the domain autorenew
        """
        return pulumi.get(self, "autorenew")

    @autorenew.setter
    def autorenew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "autorenew", value)

    @_builtins.property
    @pulumi.getter
    def billing(self) -> Optional[pulumi.Input['DomainBillingArgs']]:
        return pulumi.get(self, "billing")

    @billing.setter
    def billing(self, value: Optional[pulumi.Input['DomainBillingArgs']]):
        pulumi.set(self, "billing", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The FQDN of the domain
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This nameservers attribute will be removed on next major release: the nameservers resource has to be used instead.
See https://github.com/go-gandi/terraform-provider-gandi/issues/88 for details.""")
    def nameservers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of nameservers for the domain
        """
        return pulumi.get(self, "nameservers")

    @nameservers.setter
    def nameservers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "nameservers", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tags attached to the domain
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def tech(self) -> Optional[pulumi.Input['DomainTechArgs']]:
        return pulumi.get(self, "tech")

    @tech.setter
    def tech(self, value: Optional[pulumi.Input['DomainTechArgs']]):
        pulumi.set(self, "tech", value)


@pulumi.input_type
class _DomainState:
    def __init__(__self__, *,
                 admin: Optional[pulumi.Input['DomainAdminArgs']] = None,
                 autorenew: Optional[pulumi.Input[_builtins.bool]] = None,
                 billing: Optional[pulumi.Input['DomainBillingArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 owner: Optional[pulumi.Input['DomainOwnerArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tech: Optional[pulumi.Input['DomainTechArgs']] = None):
        """
        Input properties used for looking up and filtering Domain resources.
        :param pulumi.Input[_builtins.bool] autorenew: Should the domain autorenew
        :param pulumi.Input[_builtins.str] name: The FQDN of the domain
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nameservers: A list of nameservers for the domain
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags attached to the domain
        """
        if admin is not None:
            pulumi.set(__self__, "admin", admin)
        if autorenew is not None:
            pulumi.set(__self__, "autorenew", autorenew)
        if billing is not None:
            pulumi.set(__self__, "billing", billing)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nameservers is not None:
            warnings.warn("""This nameservers attribute will be removed on next major release: the nameservers resource has to be used instead.
See https://github.com/go-gandi/terraform-provider-gandi/issues/88 for details.""", DeprecationWarning)
            pulumi.log.warn("""nameservers is deprecated: This nameservers attribute will be removed on next major release: the nameservers resource has to be used instead.
See https://github.com/go-gandi/terraform-provider-gandi/issues/88 for details.""")
        if nameservers is not None:
            pulumi.set(__self__, "nameservers", nameservers)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tech is not None:
            pulumi.set(__self__, "tech", tech)

    @_builtins.property
    @pulumi.getter
    def admin(self) -> Optional[pulumi.Input['DomainAdminArgs']]:
        return pulumi.get(self, "admin")

    @admin.setter
    def admin(self, value: Optional[pulumi.Input['DomainAdminArgs']]):
        pulumi.set(self, "admin", value)

    @_builtins.property
    @pulumi.getter
    def autorenew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the domain autorenew
        """
        return pulumi.get(self, "autorenew")

    @autorenew.setter
    def autorenew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "autorenew", value)

    @_builtins.property
    @pulumi.getter
    def billing(self) -> Optional[pulumi.Input['DomainBillingArgs']]:
        return pulumi.get(self, "billing")

    @billing.setter
    def billing(self, value: Optional[pulumi.Input['DomainBillingArgs']]):
        pulumi.set(self, "billing", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The FQDN of the domain
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This nameservers attribute will be removed on next major release: the nameservers resource has to be used instead.
See https://github.com/go-gandi/terraform-provider-gandi/issues/88 for details.""")
    def nameservers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of nameservers for the domain
        """
        return pulumi.get(self, "nameservers")

    @nameservers.setter
    def nameservers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "nameservers", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input['DomainOwnerArgs']]:
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input['DomainOwnerArgs']]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tags attached to the domain
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def tech(self) -> Optional[pulumi.Input['DomainTechArgs']]:
        return pulumi.get(self, "tech")

    @tech.setter
    def tech(self, value: Optional[pulumi.Input['DomainTechArgs']]):
        pulumi.set(self, "tech", value)


@pulumi.type_token("gandi:domains/domain:Domain")
class Domain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin: Optional[pulumi.Input[Union['DomainAdminArgs', 'DomainAdminArgsDict']]] = None,
                 autorenew: Optional[pulumi.Input[_builtins.bool]] = None,
                 billing: Optional[pulumi.Input[Union['DomainBillingArgs', 'DomainBillingArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 owner: Optional[pulumi.Input[Union['DomainOwnerArgs', 'DomainOwnerArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tech: Optional[pulumi.Input[Union['DomainTechArgs', 'DomainTechArgsDict']]] = None,
                 __props__=None):
        """
        Create a Domain resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] autorenew: Should the domain autorenew
        :param pulumi.Input[_builtins.str] name: The FQDN of the domain
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nameservers: A list of nameservers for the domain
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags attached to the domain
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Domain resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param DomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin: Optional[pulumi.Input[Union['DomainAdminArgs', 'DomainAdminArgsDict']]] = None,
                 autorenew: Optional[pulumi.Input[_builtins.bool]] = None,
                 billing: Optional[pulumi.Input[Union['DomainBillingArgs', 'DomainBillingArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 owner: Optional[pulumi.Input[Union['DomainOwnerArgs', 'DomainOwnerArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tech: Optional[pulumi.Input[Union['DomainTechArgs', 'DomainTechArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainArgs.__new__(DomainArgs)

            __props__.__dict__["admin"] = admin
            __props__.__dict__["autorenew"] = autorenew
            __props__.__dict__["billing"] = billing
            __props__.__dict__["name"] = name
            __props__.__dict__["nameservers"] = nameservers
            if owner is None and not opts.urn:
                raise TypeError("Missing required property 'owner'")
            __props__.__dict__["owner"] = owner
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tech"] = tech
        super(Domain, __self__).__init__(
            'gandi:domains/domain:Domain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin: Optional[pulumi.Input[Union['DomainAdminArgs', 'DomainAdminArgsDict']]] = None,
            autorenew: Optional[pulumi.Input[_builtins.bool]] = None,
            billing: Optional[pulumi.Input[Union['DomainBillingArgs', 'DomainBillingArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            owner: Optional[pulumi.Input[Union['DomainOwnerArgs', 'DomainOwnerArgsDict']]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tech: Optional[pulumi.Input[Union['DomainTechArgs', 'DomainTechArgsDict']]] = None) -> 'Domain':
        """
        Get an existing Domain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] autorenew: Should the domain autorenew
        :param pulumi.Input[_builtins.str] name: The FQDN of the domain
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nameservers: A list of nameservers for the domain
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags attached to the domain
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainState.__new__(_DomainState)

        __props__.__dict__["admin"] = admin
        __props__.__dict__["autorenew"] = autorenew
        __props__.__dict__["billing"] = billing
        __props__.__dict__["name"] = name
        __props__.__dict__["nameservers"] = nameservers
        __props__.__dict__["owner"] = owner
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tech"] = tech
        return Domain(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def admin(self) -> pulumi.Output['outputs.DomainAdmin']:
        return pulumi.get(self, "admin")

    @_builtins.property
    @pulumi.getter
    def autorenew(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the domain autorenew
        """
        return pulumi.get(self, "autorenew")

    @_builtins.property
    @pulumi.getter
    def billing(self) -> pulumi.Output['outputs.DomainBilling']:
        return pulumi.get(self, "billing")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The FQDN of the domain
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This nameservers attribute will be removed on next major release: the nameservers resource has to be used instead.
See https://github.com/go-gandi/terraform-provider-gandi/issues/88 for details.""")
    def nameservers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of nameservers for the domain
        """
        return pulumi.get(self, "nameservers")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output['outputs.DomainOwner']:
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of tags attached to the domain
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def tech(self) -> pulumi.Output['outputs.DomainTech']:
        return pulumi.get(self, "tech")

