# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GlueRecordArgs', 'GlueRecord']

@pulumi.input_type
class GlueRecordArgs:
    def __init__(__self__, *,
                 ips: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 zone: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GlueRecord resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ips: List of IP addresses
        :param pulumi.Input[_builtins.str] zone: Domain name
        :param pulumi.Input[_builtins.str] name: Host name of the glue record
        """
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "zone", zone)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def ips(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of IP addresses
        """
        return pulumi.get(self, "ips")

    @ips.setter
    def ips(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "ips", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Input[_builtins.str]:
        """
        Domain name
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Host name of the glue record
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _GlueRecordState:
    def __init__(__self__, *,
                 fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 fqdn_unicode: Optional[pulumi.Input[_builtins.str]] = None,
                 href: Optional[pulumi.Input[_builtins.str]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GlueRecord resources.
        :param pulumi.Input[_builtins.str] fqdn: The fqdn of the record
        :param pulumi.Input[_builtins.str] fqdn_unicode: The fqdn unicode of the record
        :param pulumi.Input[_builtins.str] href: The href of the record
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ips: List of IP addresses
        :param pulumi.Input[_builtins.str] name: Host name of the glue record
        :param pulumi.Input[_builtins.str] zone: Domain name
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if fqdn_unicode is not None:
            pulumi.set(__self__, "fqdn_unicode", fqdn_unicode)
        if href is not None:
            pulumi.set(__self__, "href", href)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fqdn of the record
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @_builtins.property
    @pulumi.getter(name="fqdnUnicode")
    def fqdn_unicode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fqdn unicode of the record
        """
        return pulumi.get(self, "fqdn_unicode")

    @fqdn_unicode.setter
    def fqdn_unicode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fqdn_unicode", value)

    @_builtins.property
    @pulumi.getter
    def href(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The href of the record
        """
        return pulumi.get(self, "href")

    @href.setter
    def href(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "href", value)

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IP addresses
        """
        return pulumi.get(self, "ips")

    @ips.setter
    def ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ips", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Host name of the glue record
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Domain name
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("gandi:domains/glueRecord:GlueRecord")
class GlueRecord(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a GlueRecord resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ips: List of IP addresses
        :param pulumi.Input[_builtins.str] name: Host name of the glue record
        :param pulumi.Input[_builtins.str] zone: Domain name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GlueRecordArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a GlueRecord resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param GlueRecordArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GlueRecordArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GlueRecordArgs.__new__(GlueRecordArgs)

            if ips is None and not opts.urn:
                raise TypeError("Missing required property 'ips'")
            __props__.__dict__["ips"] = ips
            __props__.__dict__["name"] = name
            if zone is None and not opts.urn:
                raise TypeError("Missing required property 'zone'")
            __props__.__dict__["zone"] = zone
            __props__.__dict__["fqdn"] = None
            __props__.__dict__["fqdn_unicode"] = None
            __props__.__dict__["href"] = None
        super(GlueRecord, __self__).__init__(
            'gandi:domains/glueRecord:GlueRecord',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            fqdn: Optional[pulumi.Input[_builtins.str]] = None,
            fqdn_unicode: Optional[pulumi.Input[_builtins.str]] = None,
            href: Optional[pulumi.Input[_builtins.str]] = None,
            ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'GlueRecord':
        """
        Get an existing GlueRecord resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] fqdn: The fqdn of the record
        :param pulumi.Input[_builtins.str] fqdn_unicode: The fqdn unicode of the record
        :param pulumi.Input[_builtins.str] href: The href of the record
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ips: List of IP addresses
        :param pulumi.Input[_builtins.str] name: Host name of the glue record
        :param pulumi.Input[_builtins.str] zone: Domain name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GlueRecordState.__new__(_GlueRecordState)

        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["fqdn_unicode"] = fqdn_unicode
        __props__.__dict__["href"] = href
        __props__.__dict__["ips"] = ips
        __props__.__dict__["name"] = name
        __props__.__dict__["zone"] = zone
        return GlueRecord(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[_builtins.str]:
        """
        The fqdn of the record
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter(name="fqdnUnicode")
    def fqdn_unicode(self) -> pulumi.Output[_builtins.str]:
        """
        The fqdn unicode of the record
        """
        return pulumi.get(self, "fqdn_unicode")

    @_builtins.property
    @pulumi.getter
    def href(self) -> pulumi.Output[_builtins.str]:
        """
        The href of the record
        """
        return pulumi.get(self, "href")

    @_builtins.property
    @pulumi.getter
    def ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of IP addresses
        """
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Host name of the glue record
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[_builtins.str]:
        """
        Domain name
        """
        return pulumi.get(self, "zone")

