# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MailboxArgs', 'Mailbox']

@pulumi.input_type
class MailboxArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[_builtins.str],
                 login: pulumi.Input[_builtins.str],
                 password: pulumi.Input[_builtins.str],
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mailbox_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Mailbox resource.
        :param pulumi.Input[_builtins.str] domain: Domain name
        :param pulumi.Input[_builtins.str] login: Login
        :param pulumi.Input[_builtins.str] password: Password
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] aliases: Aliases for email
        :param pulumi.Input[_builtins.str] mailbox_type: Mailbox type
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "login", login)
        pulumi.set(__self__, "password", password)
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if mailbox_type is not None:
            pulumi.set(__self__, "mailbox_type", mailbox_type)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Input[_builtins.str]:
        """
        Domain name
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def login(self) -> pulumi.Input[_builtins.str]:
        """
        Login
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "login", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Input[_builtins.str]:
        """
        Password
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Aliases for email
        """
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "aliases", value)

    @_builtins.property
    @pulumi.getter(name="mailboxType")
    def mailbox_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mailbox type
        """
        return pulumi.get(self, "mailbox_type")

    @mailbox_type.setter
    def mailbox_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mailbox_type", value)


@pulumi.input_type
class _MailboxState:
    def __init__(__self__, *,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 login: Optional[pulumi.Input[_builtins.str]] = None,
                 mailbox_type: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Mailbox resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] aliases: Aliases for email
        :param pulumi.Input[_builtins.str] domain: Domain name
        :param pulumi.Input[_builtins.str] login: Login
        :param pulumi.Input[_builtins.str] mailbox_type: Mailbox type
        :param pulumi.Input[_builtins.str] password: Password
        """
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if mailbox_type is not None:
            pulumi.set(__self__, "mailbox_type", mailbox_type)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @_builtins.property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Aliases for email
        """
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "aliases", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Domain name
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Login
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "login", value)

    @_builtins.property
    @pulumi.getter(name="mailboxType")
    def mailbox_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mailbox type
        """
        return pulumi.get(self, "mailbox_type")

    @mailbox_type.setter
    def mailbox_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mailbox_type", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)


@pulumi.type_token("gandi:email/mailbox:Mailbox")
class Mailbox(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 login: Optional[pulumi.Input[_builtins.str]] = None,
                 mailbox_type: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a Mailbox resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] aliases: Aliases for email
        :param pulumi.Input[_builtins.str] domain: Domain name
        :param pulumi.Input[_builtins.str] login: Login
        :param pulumi.Input[_builtins.str] mailbox_type: Mailbox type
        :param pulumi.Input[_builtins.str] password: Password
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MailboxArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Mailbox resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param MailboxArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MailboxArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 login: Optional[pulumi.Input[_builtins.str]] = None,
                 mailbox_type: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MailboxArgs.__new__(MailboxArgs)

            __props__.__dict__["aliases"] = aliases
            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            if login is None and not opts.urn:
                raise TypeError("Missing required property 'login'")
            __props__.__dict__["login"] = login
            __props__.__dict__["mailbox_type"] = mailbox_type
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Mailbox, __self__).__init__(
            'gandi:email/mailbox:Mailbox',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aliases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            login: Optional[pulumi.Input[_builtins.str]] = None,
            mailbox_type: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None) -> 'Mailbox':
        """
        Get an existing Mailbox resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] aliases: Aliases for email
        :param pulumi.Input[_builtins.str] domain: Domain name
        :param pulumi.Input[_builtins.str] login: Login
        :param pulumi.Input[_builtins.str] mailbox_type: Mailbox type
        :param pulumi.Input[_builtins.str] password: Password
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MailboxState.__new__(_MailboxState)

        __props__.__dict__["aliases"] = aliases
        __props__.__dict__["domain"] = domain
        __props__.__dict__["login"] = login
        __props__.__dict__["mailbox_type"] = mailbox_type
        __props__.__dict__["password"] = password
        return Mailbox(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def aliases(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Aliases for email
        """
        return pulumi.get(self, "aliases")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        Domain name
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def login(self) -> pulumi.Output[_builtins.str]:
        """
        Login
        """
        return pulumi.get(self, "login")

    @_builtins.property
    @pulumi.getter(name="mailboxType")
    def mailbox_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Mailbox type
        """
        return pulumi.get(self, "mailbox_type")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        Password
        """
        return pulumi.get(self, "password")

