# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DomainArgs', 'Domain']

@pulumi.input_type
class DomainArgs:
    def __init__(__self__, *,
                 automatic_snapshots: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Domain resource.
        :param pulumi.Input[_builtins.bool] automatic_snapshots: Enable or disable the automatic creation of snapshots when records are changed
        :param pulumi.Input[_builtins.str] name: The FQDN of the domain
        :param pulumi.Input[_builtins.int] ttl: The SOA TTL for the domain
        """
        if automatic_snapshots is not None:
            pulumi.set(__self__, "automatic_snapshots", automatic_snapshots)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ttl is not None:
            warnings.warn("""This ttl attribute will be removed on next major release: this attribute should not be exposed to the user.
See https://github.com/go-gandi/terraform-provider-gandi/pull/90 for details.""", DeprecationWarning)
            pulumi.log.warn("""ttl is deprecated: This ttl attribute will be removed on next major release: this attribute should not be exposed to the user.
See https://github.com/go-gandi/terraform-provider-gandi/pull/90 for details.""")
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter(name="automaticSnapshots")
    def automatic_snapshots(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable or disable the automatic creation of snapshots when records are changed
        """
        return pulumi.get(self, "automatic_snapshots")

    @automatic_snapshots.setter
    def automatic_snapshots(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "automatic_snapshots", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The FQDN of the domain
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This ttl attribute will be removed on next major release: this attribute should not be exposed to the user.
See https://github.com/go-gandi/terraform-provider-gandi/pull/90 for details.""")
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The SOA TTL for the domain
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _DomainState:
    def __init__(__self__, *,
                 automatic_snapshots: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Domain resources.
        :param pulumi.Input[_builtins.bool] automatic_snapshots: Enable or disable the automatic creation of snapshots when records are changed
        :param pulumi.Input[_builtins.str] name: The FQDN of the domain
        :param pulumi.Input[_builtins.int] ttl: The SOA TTL for the domain
        """
        if automatic_snapshots is not None:
            pulumi.set(__self__, "automatic_snapshots", automatic_snapshots)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ttl is not None:
            warnings.warn("""This ttl attribute will be removed on next major release: this attribute should not be exposed to the user.
See https://github.com/go-gandi/terraform-provider-gandi/pull/90 for details.""", DeprecationWarning)
            pulumi.log.warn("""ttl is deprecated: This ttl attribute will be removed on next major release: this attribute should not be exposed to the user.
See https://github.com/go-gandi/terraform-provider-gandi/pull/90 for details.""")
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter(name="automaticSnapshots")
    def automatic_snapshots(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable or disable the automatic creation of snapshots when records are changed
        """
        return pulumi.get(self, "automatic_snapshots")

    @automatic_snapshots.setter
    def automatic_snapshots(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "automatic_snapshots", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The FQDN of the domain
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This ttl attribute will be removed on next major release: this attribute should not be exposed to the user.
See https://github.com/go-gandi/terraform-provider-gandi/pull/90 for details.""")
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The SOA TTL for the domain
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)


@pulumi.type_token("gandi:livedns/domain:Domain")
class Domain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automatic_snapshots: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Create a Domain resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] automatic_snapshots: Enable or disable the automatic creation of snapshots when records are changed
        :param pulumi.Input[_builtins.str] name: The FQDN of the domain
        :param pulumi.Input[_builtins.int] ttl: The SOA TTL for the domain
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DomainArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Domain resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param DomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automatic_snapshots: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainArgs.__new__(DomainArgs)

            __props__.__dict__["automatic_snapshots"] = automatic_snapshots
            __props__.__dict__["name"] = name
            __props__.__dict__["ttl"] = ttl
        super(Domain, __self__).__init__(
            'gandi:livedns/domain:Domain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            automatic_snapshots: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ttl: Optional[pulumi.Input[_builtins.int]] = None) -> 'Domain':
        """
        Get an existing Domain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] automatic_snapshots: Enable or disable the automatic creation of snapshots when records are changed
        :param pulumi.Input[_builtins.str] name: The FQDN of the domain
        :param pulumi.Input[_builtins.int] ttl: The SOA TTL for the domain
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainState.__new__(_DomainState)

        __props__.__dict__["automatic_snapshots"] = automatic_snapshots
        __props__.__dict__["name"] = name
        __props__.__dict__["ttl"] = ttl
        return Domain(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="automaticSnapshots")
    def automatic_snapshots(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable or disable the automatic creation of snapshots when records are changed
        """
        return pulumi.get(self, "automatic_snapshots")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The FQDN of the domain
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This ttl attribute will be removed on next major release: this attribute should not be exposed to the user.
See https://github.com/go-gandi/terraform-provider-gandi/pull/90 for details.""")
    def ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The SOA TTL for the domain
        """
        return pulumi.get(self, "ttl")

