# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RecordArgs', 'Record']

@pulumi.input_type
class RecordArgs:
    def __init__(__self__, *,
                 ttl: pulumi.Input[_builtins.int],
                 type: pulumi.Input[_builtins.str],
                 values: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 zone: pulumi.Input[_builtins.str],
                 mutable: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Record resource.
        :param pulumi.Input[_builtins.int] ttl: The TTL of the record
        :param pulumi.Input[_builtins.str] type: The type of the record
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] values: A list of values of the record
        :param pulumi.Input[_builtins.str] zone: The FQDN of the domain
        :param pulumi.Input[_builtins.str] name: The name of the record
        """
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "values", values)
        pulumi.set(__self__, "zone", zone)
        if mutable is not None:
            pulumi.set(__self__, "mutable", mutable)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Input[_builtins.int]:
        """
        The TTL of the record
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the record
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of values of the record
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Input[_builtins.str]:
        """
        The FQDN of the domain
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone", value)

    @_builtins.property
    @pulumi.getter
    def mutable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "mutable")

    @mutable.setter
    def mutable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mutable", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the record
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _RecordState:
    def __init__(__self__, *,
                 href: Optional[pulumi.Input[_builtins.str]] = None,
                 mutable: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Record resources.
        :param pulumi.Input[_builtins.str] href: The href of the record
        :param pulumi.Input[_builtins.str] name: The name of the record
        :param pulumi.Input[_builtins.int] ttl: The TTL of the record
        :param pulumi.Input[_builtins.str] type: The type of the record
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] values: A list of values of the record
        :param pulumi.Input[_builtins.str] zone: The FQDN of the domain
        """
        if href is not None:
            pulumi.set(__self__, "href", href)
        if mutable is not None:
            pulumi.set(__self__, "mutable", mutable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if values is not None:
            pulumi.set(__self__, "values", values)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def href(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The href of the record
        """
        return pulumi.get(self, "href")

    @href.setter
    def href(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "href", value)

    @_builtins.property
    @pulumi.getter
    def mutable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "mutable")

    @mutable.setter
    def mutable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mutable", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the record
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The TTL of the record
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the record
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of values of the record
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The FQDN of the domain
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("gandi:livedns/record:Record")
class Record(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 mutable: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a Record resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the record
        :param pulumi.Input[_builtins.int] ttl: The TTL of the record
        :param pulumi.Input[_builtins.str] type: The type of the record
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] values: A list of values of the record
        :param pulumi.Input[_builtins.str] zone: The FQDN of the domain
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RecordArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Record resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param RecordArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RecordArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 mutable: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RecordArgs.__new__(RecordArgs)

            __props__.__dict__["mutable"] = mutable
            __props__.__dict__["name"] = name
            if ttl is None and not opts.urn:
                raise TypeError("Missing required property 'ttl'")
            __props__.__dict__["ttl"] = ttl
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if values is None and not opts.urn:
                raise TypeError("Missing required property 'values'")
            __props__.__dict__["values"] = values
            if zone is None and not opts.urn:
                raise TypeError("Missing required property 'zone'")
            __props__.__dict__["zone"] = zone
            __props__.__dict__["href"] = None
        super(Record, __self__).__init__(
            'gandi:livedns/record:Record',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            href: Optional[pulumi.Input[_builtins.str]] = None,
            mutable: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ttl: Optional[pulumi.Input[_builtins.int]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'Record':
        """
        Get an existing Record resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] href: The href of the record
        :param pulumi.Input[_builtins.str] name: The name of the record
        :param pulumi.Input[_builtins.int] ttl: The TTL of the record
        :param pulumi.Input[_builtins.str] type: The type of the record
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] values: A list of values of the record
        :param pulumi.Input[_builtins.str] zone: The FQDN of the domain
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RecordState.__new__(_RecordState)

        __props__.__dict__["href"] = href
        __props__.__dict__["mutable"] = mutable
        __props__.__dict__["name"] = name
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["type"] = type
        __props__.__dict__["values"] = values
        __props__.__dict__["zone"] = zone
        return Record(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def href(self) -> pulumi.Output[_builtins.str]:
        """
        The href of the record
        """
        return pulumi.get(self, "href")

    @_builtins.property
    @pulumi.getter
    def mutable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "mutable")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the record
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[_builtins.int]:
        """
        The TTL of the record
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the record
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def values(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of values of the record
        """
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[_builtins.str]:
        """
        The FQDN of the domain
        """
        return pulumi.get(self, "zone")

