# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 sharing_id: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[_builtins.bool] dry_run: Prevent the Domain provider from taking certain actions
        :param pulumi.Input[_builtins.str] key: A Gandi API key
        :param pulumi.Input[_builtins.str] sharing_id: A Gandi Sharing ID
        :param pulumi.Input[_builtins.str] url: The Gandi API URL
        """
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if key is None:
            key = _utilities.get_env('GANDI_KEY')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if sharing_id is not None:
            pulumi.set(__self__, "sharing_id", sharing_id)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Prevent the Domain provider from taking certain actions
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A Gandi API key
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="sharingId")
    def sharing_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A Gandi Sharing ID
        """
        return pulumi.get(self, "sharing_id")

    @sharing_id.setter
    def sharing_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sharing_id", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Gandi API URL
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("pulumi:providers:gandi")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 sharing_id: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The provider type for the gandi package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] dry_run: Prevent the Domain provider from taking certain actions
        :param pulumi.Input[_builtins.str] key: A Gandi API key
        :param pulumi.Input[_builtins.str] sharing_id: A Gandi Sharing ID
        :param pulumi.Input[_builtins.str] url: The Gandi API URL
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the gandi package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 sharing_id: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["dry_run"] = pulumi.Output.from_input(dry_run).apply(pulumi.runtime.to_json) if dry_run is not None else None
            if key is None:
                key = _utilities.get_env('GANDI_KEY')
            __props__.__dict__["key"] = None if key is None else pulumi.Output.secret(key)
            __props__.__dict__["sharing_id"] = sharing_id
            __props__.__dict__["url"] = url
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["key"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'gandi',
            resource_name,
            __props__,
            opts)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A Gandi API key
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="sharingId")
    def sharing_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A Gandi Sharing ID
        """
        return pulumi.get(self, "sharing_id")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Gandi API URL
        """
        return pulumi.get(self, "url")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @_builtins.property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:gandi/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

