# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[_builtins.str],
                 language_name: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 size: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] database_name: The name of the database type ('mysql' or 'pgsql')
        :param pulumi.Input[_builtins.str] language_name: The name of the language ('php', 'python', 'nodejs' or 'ruby')
        :param pulumi.Input[_builtins.str] location: The datacenter location of the instance ('FR' or 'LU')
        :param pulumi.Input[_builtins.str] size: The size of the SimpleHosting instance ('s+', 'm', 'l' or 'xxl')
        :param pulumi.Input[_builtins.str] name: The name of the SimpleHosting instance
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "language_name", language_name)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "size", size)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the database type ('mysql' or 'pgsql')
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="languageName")
    def language_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the language ('php', 'python', 'nodejs' or 'ruby')
        """
        return pulumi.get(self, "language_name")

    @language_name.setter
    def language_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "language_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The datacenter location of the instance ('FR' or 'LU')
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Input[_builtins.str]:
        """
        The size of the SimpleHosting instance ('s+', 'm', 'l' or 'xxl')
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the SimpleHosting instance
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 language_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.str] database_name: The name of the database type ('mysql' or 'pgsql')
        :param pulumi.Input[_builtins.str] language_name: The name of the language ('php', 'python', 'nodejs' or 'ruby')
        :param pulumi.Input[_builtins.str] location: The datacenter location of the instance ('FR' or 'LU')
        :param pulumi.Input[_builtins.str] name: The name of the SimpleHosting instance
        :param pulumi.Input[_builtins.str] size: The size of the SimpleHosting instance ('s+', 'm', 'l' or 'xxl')
        """
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if language_name is not None:
            pulumi.set(__self__, "language_name", language_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the database type ('mysql' or 'pgsql')
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="languageName")
    def language_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the language ('php', 'python', 'nodejs' or 'ruby')
        """
        return pulumi.get(self, "language_name")

    @language_name.setter
    def language_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "language_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The datacenter location of the instance ('FR' or 'LU')
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the SimpleHosting instance
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The size of the SimpleHosting instance ('s+', 'm', 'l' or 'xxl')
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "size", value)


@pulumi.type_token("gandi:simplehosting/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 language_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a Instance resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] database_name: The name of the database type ('mysql' or 'pgsql')
        :param pulumi.Input[_builtins.str] language_name: The name of the language ('php', 'python', 'nodejs' or 'ruby')
        :param pulumi.Input[_builtins.str] location: The datacenter location of the instance ('FR' or 'LU')
        :param pulumi.Input[_builtins.str] name: The name of the SimpleHosting instance
        :param pulumi.Input[_builtins.str] size: The size of the SimpleHosting instance ('s+', 'm', 'l' or 'xxl')
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Instance resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 language_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            if language_name is None and not opts.urn:
                raise TypeError("Missing required property 'language_name'")
            __props__.__dict__["language_name"] = language_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
        super(Instance, __self__).__init__(
            'gandi:simplehosting/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            language_name: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] database_name: The name of the database type ('mysql' or 'pgsql')
        :param pulumi.Input[_builtins.str] language_name: The name of the language ('php', 'python', 'nodejs' or 'ruby')
        :param pulumi.Input[_builtins.str] location: The datacenter location of the instance ('FR' or 'LU')
        :param pulumi.Input[_builtins.str] name: The name of the SimpleHosting instance
        :param pulumi.Input[_builtins.str] size: The size of the SimpleHosting instance ('s+', 'm', 'l' or 'xxl')
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["language_name"] = language_name
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["size"] = size
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the database type ('mysql' or 'pgsql')
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter(name="languageName")
    def language_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the language ('php', 'python', 'nodejs' or 'ruby')
        """
        return pulumi.get(self, "language_name")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The datacenter location of the instance ('FR' or 'LU')
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the SimpleHosting instance
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.str]:
        """
        The size of the SimpleHosting instance ('s+', 'm', 'l' or 'xxl')
        """
        return pulumi.get(self, "size")

