# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VHostArgs', 'VHost']

@pulumi.input_type
class VHostArgs:
    def __init__(__self__, *,
                 fqdn: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 application: Optional[pulumi.Input[_builtins.str]] = None,
                 linked_dns_zone_alteration: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a VHost resource.
        :param pulumi.Input[_builtins.str] fqdn: The FQDN of the Vhost
        :param pulumi.Input[_builtins.str] instance_id: The ID of the SimpleHosting instance
        :param pulumi.Input[_builtins.str] application: The name of an application to install ('grav', 'matomo', 'nextcloud', 'prestashop', 'wordpress')
        :param pulumi.Input[_builtins.bool] linked_dns_zone_alteration: Whether to alter the linked DNS Zone
        """
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "instance_id", instance_id)
        if application is not None:
            pulumi.set(__self__, "application", application)
        if linked_dns_zone_alteration is not None:
            pulumi.set(__self__, "linked_dns_zone_alteration", linked_dns_zone_alteration)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> pulumi.Input[_builtins.str]:
        """
        The FQDN of the Vhost
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "fqdn", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the SimpleHosting instance
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def application(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of an application to install ('grav', 'matomo', 'nextcloud', 'prestashop', 'wordpress')
        """
        return pulumi.get(self, "application")

    @application.setter
    def application(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application", value)

    @_builtins.property
    @pulumi.getter(name="linkedDnsZoneAlteration")
    def linked_dns_zone_alteration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to alter the linked DNS Zone
        """
        return pulumi.get(self, "linked_dns_zone_alteration")

    @linked_dns_zone_alteration.setter
    def linked_dns_zone_alteration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "linked_dns_zone_alteration", value)


@pulumi.input_type
class _VHostState:
    def __init__(__self__, *,
                 application: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 linked_dns_zone_alteration: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering VHost resources.
        :param pulumi.Input[_builtins.str] application: The name of an application to install ('grav', 'matomo', 'nextcloud', 'prestashop', 'wordpress')
        :param pulumi.Input[_builtins.str] certificate_id: The ID of the created free certificate
        :param pulumi.Input[_builtins.str] fqdn: The FQDN of the Vhost
        :param pulumi.Input[_builtins.str] instance_id: The ID of the SimpleHosting instance
        :param pulumi.Input[_builtins.bool] linked_dns_zone_alteration: Whether to alter the linked DNS Zone
        """
        if application is not None:
            pulumi.set(__self__, "application", application)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if linked_dns_zone_alteration is not None:
            pulumi.set(__self__, "linked_dns_zone_alteration", linked_dns_zone_alteration)

    @_builtins.property
    @pulumi.getter
    def application(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of an application to install ('grav', 'matomo', 'nextcloud', 'prestashop', 'wordpress')
        """
        return pulumi.get(self, "application")

    @application.setter
    def application(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application", value)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the created free certificate
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_id", value)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The FQDN of the Vhost
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the SimpleHosting instance
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="linkedDnsZoneAlteration")
    def linked_dns_zone_alteration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to alter the linked DNS Zone
        """
        return pulumi.get(self, "linked_dns_zone_alteration")

    @linked_dns_zone_alteration.setter
    def linked_dns_zone_alteration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "linked_dns_zone_alteration", value)


@pulumi.type_token("gandi:simplehosting/vHost:VHost")
class VHost(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application: Optional[pulumi.Input[_builtins.str]] = None,
                 fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 linked_dns_zone_alteration: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Create a VHost resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application: The name of an application to install ('grav', 'matomo', 'nextcloud', 'prestashop', 'wordpress')
        :param pulumi.Input[_builtins.str] fqdn: The FQDN of the Vhost
        :param pulumi.Input[_builtins.str] instance_id: The ID of the SimpleHosting instance
        :param pulumi.Input[_builtins.bool] linked_dns_zone_alteration: Whether to alter the linked DNS Zone
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VHostArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a VHost resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param VHostArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VHostArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application: Optional[pulumi.Input[_builtins.str]] = None,
                 fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 linked_dns_zone_alteration: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VHostArgs.__new__(VHostArgs)

            __props__.__dict__["application"] = application
            if fqdn is None and not opts.urn:
                raise TypeError("Missing required property 'fqdn'")
            __props__.__dict__["fqdn"] = fqdn
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["linked_dns_zone_alteration"] = linked_dns_zone_alteration
            __props__.__dict__["certificate_id"] = None
        super(VHost, __self__).__init__(
            'gandi:simplehosting/vHost:VHost',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
            fqdn: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            linked_dns_zone_alteration: Optional[pulumi.Input[_builtins.bool]] = None) -> 'VHost':
        """
        Get an existing VHost resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application: The name of an application to install ('grav', 'matomo', 'nextcloud', 'prestashop', 'wordpress')
        :param pulumi.Input[_builtins.str] certificate_id: The ID of the created free certificate
        :param pulumi.Input[_builtins.str] fqdn: The FQDN of the Vhost
        :param pulumi.Input[_builtins.str] instance_id: The ID of the SimpleHosting instance
        :param pulumi.Input[_builtins.bool] linked_dns_zone_alteration: Whether to alter the linked DNS Zone
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VHostState.__new__(_VHostState)

        __props__.__dict__["application"] = application
        __props__.__dict__["certificate_id"] = certificate_id
        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["linked_dns_zone_alteration"] = linked_dns_zone_alteration
        return VHost(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def application(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of an application to install ('grav', 'matomo', 'nextcloud', 'prestashop', 'wordpress')
        """
        return pulumi.get(self, "application")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the created free certificate
        """
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[_builtins.str]:
        """
        The FQDN of the Vhost
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the SimpleHosting instance
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="linkedDnsZoneAlteration")
    def linked_dns_zone_alteration(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to alter the linked DNS Zone
        """
        return pulumi.get(self, "linked_dns_zone_alteration")

