import pandas as pd

from ...client.kawa_client import KawaClient as K
from datetime import datetime, date, timedelta
import numpy as np
from faker import Faker


def kawa():
    k = K(kawa_api_url='http://localhost:8080')
    k.set_api_key(api_key_file='/Users/emmanuel/doc/local-pristine/.key')
    k.set_active_workspace_id(workspace_id='107')
    return k


research = kawa().research('Some research')
orders_model = research.register_model('3597')
events_model = research.register_model('3598')

events_relationship = orders_model.create_relationship(
    name='Event per State',
    description="""
      We are joining the events to the orders to get the cost per state on the State.
      """,
    target_model=events_model,
    link={'State': 'event state'},
)

events_relationship.add_column(
    name='event cost',
    aggregation='SUM',
    new_column_name='Cost per State',
)

orders_relationship = orders_model.create_relationship(
    name='Cost per State',
    description="""
      We are joining the orders to the event to get the profit per state on the State
      """,
    target_model=orders_model,
    link={'State': 'State'},
)

orders_relationship.add_column(
    name='Profit',
    aggregation='SUM',
    new_column_name='Profit per State',
)

orders_model.create_metric(
    name='Unit Profit',
    formula='"Profit" / "Quantity"'
)

research.publish_models()

## PHASE 2: Model querying and analysis
df = (orders_model
      .select(
        K.col('State'),
        K.col('Unit Profit III').avg().alias('Average profit'),
        K.col('Cost per State').sum().alias('Total per state'),
        K.col('Profit per State').median().alias('Median profit per state'),
      )
      .group_by('State')
      .query_description('This is the description')
      .collect())

research.register_result(
    description='Dataframe containing data about cost and profit',
    df=df
)
print(research.publish_results())
