# yyp

多分支 worktree 管理工具（支持 `krepo-ng` 与 `git`）。

## 安装

```bash
pip install yyp
```

## 使用

- 创建 worktree：

```bash
yyp add <path> <branch>
```

这会在 `~/<path>/wpsmain` 和 `~/<path>/wpsweb` 下分别创建或切换到 `<branch>`。

- 列出 worktree：

```bash
yyp list
```

- 移除 worktree：

```bash
yyp remove <path>
```

这会移除 `~/<path>/wpsmain` 和 `~/<path>/wpsweb` 的 worktree，并删除整个 `<path>` 目录。

- 配置管理：

```bash
yyp set work_dir=~/workspace  # 设置工作目录
yyp config                    # 显示当前配置
```

- 修改配置和生成构建脚本（仅限 Linux）：

```bash
yyp modify                    # 修改 wpsweb/server/Makefile 和生成 build_server.sh
yyp modify --force            # 强制在非 Linux 系统上运行（不推荐）
```

这会自动查找 wpsweb 目录，并执行以下操作：
1. **修改 `server/Makefile`**：
   - 去掉 `-Wl,-s` 参数
   - 将 `-O2` 修改为 `-g`
2. **生成 `build_server.sh`**：
   - 清空文件内容并写入构建脚本
   - 动态替换路径变量（基于当前执行路径）
   - 自动设置执行权限

> **注意**: `modify` 命令仅在 Linux 系统上支持，因为它需要修改 Makefile 和生成 shell 脚本。

- 自动编译 wpsmain：

```bash
yyp build                     # 自动编译 wpsmain
```

这会自动查找 wpsmain 目录，并在 Docker 中执行以下操作：
1. **配置 weboffice**：执行 `krepo-ng config --new -x weboffice`
2. **检查目录**：验证 `debug_weboffice` 目录是否创建成功
3. **编译项目**：在 `debug_weboffice` 目录中执行 `krepo-ng build`
4. **执行构建脚本**：查找并执行 `wpsweb/build_server.sh` 脚本

> **注意**: `build` 命令需要在 Docker 环境中执行，使用 `kdocker -r qt5` 命令。

## 依赖

- 需要本机已安装并在 PATH 中可用：`krepo-ng`、`git`。
- 配置文件位置：`~/.yyp.json`

## 许可

MIT