# Copyright 2023 The Langfun Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Modalities for LLM."""

# pylint: disable=g-importing-member
# pylint: disable=g-bad-import-order
# pylint: disable=g-import-not-at-top

from langfun.core.modalities.audio import Audio
from langfun.core.modalities.mime import Mime
from langfun.core.modalities.mime import Custom
from langfun.core.modalities.image import Image
from langfun.core.modalities.pdf import PDF
from langfun.core.modalities.video import Video

from langfun.core import message as _message_lib

# Override the `images`, `videos` and `audios` properties of `Message` to
# return the modalities of the corresponding types.
_message_lib.Message.images = property(lambda self: self.modalities(Image))
_message_lib.Message.videos = property(lambda self: self.modalities(Video))
_message_lib.Message.audios = property(lambda self: self.modalities(Audio))

# pylint: enable=g-import-not-at-top
# pylint: enable=g-bad-import-order
# pylint: enable=g-importing-member
