import asyncio
import time

from x_model import init_db
from xync_schema import models
from xync_client.loader import TORM
from camoufox.async_api import AsyncCamoufox


async def _input(page):
    for i in input("email: "):
        await page.keyboard.press(i)
    await page.wait_for_timeout(1000)


async def payment(page, agent, account, amount, cur):
    await page.goto("https://payeer.com/en/account/send/")
    fiat_accounts = await page.locator(
        ".balance-item.balance-item--green.balance-item--rub.balance-curr--rub "
    ).all_text_contents()
    if float(amount) <= float(fiat_accounts[0].replace(",", "").strip()):
        await page.locator('input[name="param_ACCOUNT_NUMBER"]').fill(account)
        time.sleep(1)
        await page.locator('.jq-selectbox__select-text:has-text("USD")').first.click()
        time.sleep(1)
        await page.locator(f'li:has-text("{cur}")').first.click()
        time.sleep(1)
        await page.locator('input[name="sum_receive"]').fill(amount)
        time.sleep(1)
        await page.click(".btn.n-form--btn.n-form--btn-mod")
        time.sleep(1)
        await page.click(".btn.n-form--btn.n-form--btn-mod")
        time.sleep(1)
        if await page.locator(".input4").count():
            await page.locator(".input4").fill(agent.auth.get("master_key"))
            time.sleep(1)
            await page.click(".ok.button_green2")
        time.sleep(1)
        await page.goto("https://payeer.com/ru/account/history/")
        await page.click('[class^="history-id-"] a.link')
        time.sleep(1)
        payment = await page.query_selector(".ui-dialog.ui-corner-all")
        await payment.screenshot(path="scrin.png")
    else:
        return fiat_accounts[0].strip()


async def main():
    _ = await init_db(TORM, True)
    agent = await models.PmAgent.filter(pm__norm="payeer", auth__isnull=False).first()
    async with AsyncCamoufox(os=["macos"]) as playwright:
        context = await playwright.new_context(storage_state=agent.state, record_video_dir="videos")
        page = await context.new_page()
        # await page.wait_for_timeout(15000)
        await page.goto("https://payeer.com/en/", wait_until="domcontentloaded", timeout=60000)

        try:
            if not agent.state:
                await asyncio.sleep(1)
                await page.click(".btn.btn--login.white-login")
                time.sleep(2)
                await page.locator('input[name="email"]').fill(agent.auth.get("email"))
                time.sleep(1)
                await page.locator('input[name="password"]').fill(agent.auth.get("passwd"))
                time.sleep(1)
                await page.locator(".login-form__login-btn.step1").click()
                time.sleep(5)
                await page.locator(".login-form__login-btn.step1").click()
                time.sleep(1)
                if await page.locator(".form-input-top").is_visible():
                    await _input(page)
                    await page.click(".login-form__login-btn.step2")
                agent.state = await page.context.storage_state()
                await agent.save()
                time.sleep(5)
            await payment(page, agent, "P1132935842", "500", "RUB")
            time.sleep(500)
        finally:
            await playwright.close()


if __name__ == "__main__":
    asyncio.run(main())
