# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-04-11 18:27


import collections
import uuid

import django_countries.fields
import fernet_fields.fields
import jsonfield.fields
import multi_email_field.fields
import simple_history.models

import django.utils.timezone
from django.conf import settings
from django.db import migrations, models

import model_utils.fields

import enterprise.constants
import enterprise.models
import enterprise.validators
from enterprise.constants import (
    ENTERPRISE_ADMIN_ROLE,
    ENTERPRISE_CATALOG_ADMIN_ROLE,
    ENTERPRISE_DASHBOARD_ADMIN_ROLE,
    ENTERPRISE_ENROLLMENT_API_ADMIN_ROLE,
    ENTERPRISE_LEARNER_ROLE,
    ENTERPRISE_OPERATOR_ROLE,
    ENTERPRISE_REPORTING_CONFIG_ADMIN_ROLE,
)

ENTERPRISE_ENROLLMENT_SOURCES = {
    # Created in squashed 0079_AddEnterpriseEnrollmentSource
    'Manual Enterprise Enrollment': 'manual',
    'Enterprise API Enrollment': 'enterprise_api',
    'Enterprise Enrollment URL': 'enrollment_url',
    'Enterprise Offer Redemption': 'offer_redemption',
    # Updated in squashed 0081_UpdateEnterpriseEnrollmentSource
    'Enterprise User Enrollment Background Task': 'enrollment_task',
    # Added in squashed 0082_AddManagementEnterpriseEnrollmentSource
    'Enterprise management command enrollment': 'management_command',
}


# From squashed 0079_AddEnterpriseEnrollmentSource
def add_enterprise_enrollment_sources(apps, schema_editor):
    enrollment_sources = apps.get_model('enterprise', 'EnterpriseEnrollmentSource')
    for name, slug in ENTERPRISE_ENROLLMENT_SOURCES.items():
        enrollment_sources.objects.update_or_create(name=name, slug=slug)


# From squashed 0079_AddEnterpriseEnrollmentSource
def drop_enterprise_enrollment_sources(apps, schema_editor):
    enrollment_sources = apps.get_model('enterprise', 'EnterpriseEnrollmentSource')
    enrollment_sources.objects.filter(name__in=ENTERPRISE_ENROLLMENT_SOURCES).delete()


def create_enterprise_roles(apps, schema_editor):
    """Create the enterprise roles if they do not already exist."""
    SystemWideEnterpriseRole = apps.get_model('enterprise', 'SystemWideEnterpriseRole')
    # From squashed 0062_add_system_wide_enterprise_roles
    SystemWideEnterpriseRole.objects.update_or_create(name=ENTERPRISE_ADMIN_ROLE)
    SystemWideEnterpriseRole.objects.update_or_create(name=ENTERPRISE_LEARNER_ROLE)
    # From squashed 0066_add_system_wide_enterprise_operator_role
    SystemWideEnterpriseRole.objects.update_or_create(name=ENTERPRISE_OPERATOR_ROLE)

    EnterpriseFeatureRole = apps.get_model('enterprise', 'EnterpriseFeatureRole')
    # From squashed 0065_add_enterprise_feature_roles
    EnterpriseFeatureRole.objects.update_or_create(name=ENTERPRISE_CATALOG_ADMIN_ROLE)
    EnterpriseFeatureRole.objects.update_or_create(name=ENTERPRISE_DASHBOARD_ADMIN_ROLE)
    EnterpriseFeatureRole.objects.update_or_create(name=ENTERPRISE_ENROLLMENT_API_ADMIN_ROLE)
    # From squashed 0072_add_enterprise_report_config_feature_role
    EnterpriseFeatureRole.objects.update_or_create(name=ENTERPRISE_REPORTING_CONFIG_ADMIN_ROLE)


def delete_enterprise_roles(apps, schema_editor):
    """Delete the enterprise roles."""
    SystemWideEnterpriseRole = apps.get_model('enterprise', 'SystemWideEnterpriseRole')
    # From squashed 0062_add_system_wide_enterprise_roles
    SystemWideEnterpriseRole.objects.filter(
        name__in=[ENTERPRISE_ADMIN_ROLE, ENTERPRISE_LEARNER_ROLE]
    ).delete()
    # From squashed 0066_add_system_wide_enterprise_operator_role
    SystemWideEnterpriseRole.objects.filter(
        name__in=[ENTERPRISE_OPERATOR_ROLE]
    ).delete()

    EnterpriseFeatureRole = apps.get_model('enterprise', 'EnterpriseFeatureRole')
    # From squashed 0065_add_enterprise_feature_roles
    EnterpriseFeatureRole.objects.filter(
        name__in=[ENTERPRISE_CATALOG_ADMIN_ROLE, ENTERPRISE_DASHBOARD_ADMIN_ROLE, ENTERPRISE_ENROLLMENT_API_ADMIN_ROLE]
    ).delete()
    # From squashed 0072_add_enterprise_report_config_feature_role
    EnterpriseFeatureRole.objects.filter(
        name__in=[ENTERPRISE_REPORTING_CONFIG_ADMIN_ROLE]
    ).delete()


class Migration(migrations.Migration):

    replaces = [('enterprise', '0001_initial'), ('enterprise', '0002_enterprisecustomerbrandingconfiguration'), ('enterprise', '0003_auto_20161104_0937'), ('enterprise', '0004_auto_20161114_0434'), ('enterprise', '0005_pendingenterprisecustomeruser'), ('enterprise', '0006_auto_20161121_0241'), ('enterprise', '0007_auto_20161109_1511'), ('enterprise', '0008_auto_20161124_2355'), ('enterprise', '0009_auto_20161130_1651'), ('enterprise', '0010_auto_20161222_1212'), ('enterprise', '0011_enterprisecustomerentitlement_historicalenterprisecustomerentitlement'), ('enterprise', '0012_auto_20170125_1033'), ('enterprise', '0013_auto_20170125_1157'), ('enterprise', '0014_enrollmentnotificationemailtemplate_historicalenrollmentnotificationemailtemplate'), ('enterprise', '0015_auto_20170130_0003'), ('enterprise', '0016_auto_20170405_0647'), ('enterprise', '0017_auto_20170508_1341'), ('enterprise', '0018_auto_20170511_1357'), ('enterprise', '0019_auto_20170606_1853'), ('enterprise', '0020_auto_20170624_2316'), ('enterprise', '0021_auto_20170711_0712'), ('enterprise', '0022_auto_20170720_1543'), ('enterprise', '0023_audit_data_reporting_flag'), ('enterprise', '0024_enterprisecustomercatalog_historicalenterprisecustomercatalog'), ('enterprise', '0025_auto_20170828_1412'), ('enterprise', '0026_make_require_account_level_consent_nullable'), ('enterprise', '0027_remove_account_level_consent'), ('enterprise', '0028_link_enterprise_to_enrollment_template'), ('enterprise', '0029_auto_20170925_1909'), ('enterprise', '0030_auto_20171005_1600'), ('enterprise', '0031_auto_20171012_1249'), ('enterprise', '0032_reporting_model'), ('enterprise', '0033_add_history_change_reason_field'), ('enterprise', '0034_auto_20171023_0727'), ('enterprise', '0035_auto_20171212_1129'), ('enterprise', '0036_sftp_reporting_support'), ('enterprise', '0037_auto_20180110_0450'), ('enterprise', '0038_auto_20180122_1427'), ('enterprise', '0039_auto_20180129_1034'), ('enterprise', '0040_auto_20180129_1428'), ('enterprise', '0041_auto_20180212_1507'), ('enterprise', '0042_replace_sensitive_sso_username'), ('enterprise', '0043_auto_20180507_0138'), ('enterprise', '0044_reporting_config_multiple_types'), ('enterprise', '0045_report_type_json'), ('enterprise', '0046_remove_unique_constraints'), ('enterprise', '0047_auto_20180517_0457'), ('enterprise', '0048_enterprisecustomeruser_active'), ('enterprise', '0049_auto_20180531_0321'), ('enterprise', '0050_progress_v2'), ('enterprise', '0051_add_enterprise_slug'), ('enterprise', '0052_create_unique_slugs'), ('enterprise', '0053_pendingenrollment_cohort_name'), ('enterprise', '0053_auto_20180911_0811'), ('enterprise', '0054_merge_20180914_1511'), ('enterprise', '0055_auto_20181015_1112'), ('enterprise', '0056_enterprisecustomerreportingconfiguration_pgp_encryption_key'), ('enterprise', '0057_enterprisecustomerreportingconfiguration_enterprise_customer_catalogs'), ('enterprise', '0058_auto_20181212_0145'), ('enterprise', '0059_add_code_management_portal_config'), ('enterprise', '0060_upgrade_django_simple_history'), ('enterprise', '0061_systemwideenterpriserole_systemwideenterpriseuserroleassignment'), ('enterprise', '0062_add_system_wide_enterprise_roles'), ('enterprise', '0063_systemwideenterpriserole_description'), ('enterprise', '0064_enterprisefeaturerole_enterprisefeatureuserroleassignment'), ('enterprise', '0065_add_enterprise_feature_roles'), ('enterprise', '0066_add_system_wide_enterprise_operator_role'), ('enterprise', '0067_add_role_based_access_control_switch'), ('enterprise', '0068_remove_role_based_access_control_switch'), ('enterprise', '0069_auto_20190613_0607'), ('enterprise', '0070_enterprise_catalog_query'), ('enterprise', '0071_historicalpendingenrollment_historicalpendingenterprisecustomeruser'), ('enterprise', '0072_add_enterprise_report_config_feature_role'), ('enterprise', '0073_enterprisecustomerreportingconfiguration_uuid'), ('enterprise', '0074_auto_20190904_1143'), ('enterprise', '0075_auto_20190916_1030'), ('enterprise', '0076_auto_20190918_2037'), ('enterprise', '0077_auto_20191002_1529'), ('enterprise', '0078_auto_20191107_1536'), ('enterprise', '0079_AddEnterpriseEnrollmentSource'), ('enterprise', '0080_auto_20191113_1708'), ('enterprise', '0081_UpdateEnterpriseEnrollmentSource'), ('enterprise', '0082_AddManagementEnterpriseEnrollmentSource'), ('enterprise', '0083_enterprisecustomerreportingconfiguration_include_date'), ('enterprise', '0084_auto_20200120_1137'), ('enterprise', '0085_enterprisecustomeruser_linked'), ('enterprise', '0086_auto_20200128_1726'), ('enterprise', '0087_auto_20200206_1151'), ('enterprise', '0088_auto_20200224_1341'), ('enterprise', '0089_auto_20200305_0652'), ('enterprise', '0090_update_content_filter'), ('enterprise', '0091_add_sales_force_id_in_pendingenrollment'), ('enterprise', '0092_auto_20200312_1650')]

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('sites', '0002_alter_domain_unique'),
    ]

    operations = [
        migrations.CreateModel(
            name='EnrollmentNotificationEmailTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('plaintext_template', models.TextField(blank=True, help_text='Fill in a standard Django template that, when rendered, produces the email you want sent to newly-enrolled Enterprise Customer learners. The following variables may be available:\n<ul><li>user_name: A human-readable name for the person being emailed. Be sure to handle the case where this is not defined, as it may be missing in some cases. It may also be a username, if the learner hasn\'t configured their "real" name in the system.</li>    <li>organization_name: The name of the organization sponsoring the enrollment.</li>    <li>enrolled_in: Details of the course or program that was enrolled in. It may contain:    <ul><li>name: The name of the enrollable item (e.g., "Demo Course").</li>        <li>url: A link to the homepage of the enrolled-in item.</li>        <li>branding: A custom branding name for the enrolled-in item. For example, the branding of a MicroMasters program would be "MicroMasters".</li>     <li>start: The date the enrolled-in item becomes available. Render this to text using the Django `date` template filter (see <a href="https://docs.djangoproject.com/en/1.8/ref/templates/builtins/#date">the Django documentation</a>).</li><li>type: Whether the enrolled-in item is a course, a program, or something else.</li></ul></ul>')),
                ('html_template', models.TextField(blank=True, help_text='Fill in a standard Django template that, when rendered, produces the email you want sent to newly-enrolled Enterprise Customer learners. The following variables may be available:\n<ul><li>user_name: A human-readable name for the person being emailed. Be sure to handle the case where this is not defined, as it may be missing in some cases. It may also be a username, if the learner hasn\'t configured their "real" name in the system.</li>    <li>organization_name: The name of the organization sponsoring the enrollment.</li>    <li>enrolled_in: Details of the course or program that was enrolled in. It may contain:    <ul><li>name: The name of the enrollable item (e.g., "Demo Course").</li>        <li>url: A link to the homepage of the enrolled-in item.</li>        <li>branding: A custom branding name for the enrolled-in item. For example, the branding of a MicroMasters program would be "MicroMasters".</li>     <li>start: The date the enrolled-in item becomes available. Render this to text using the Django `date` template filter (see <a href="https://docs.djangoproject.com/en/1.8/ref/templates/builtins/#date">the Django documentation</a>).</li><li>type: Whether the enrolled-in item is a course, a program, or something else.</li></ul></ul>')),
                ('subject_line', models.CharField(blank=True, help_text='Enter a string that can be used to generate a dynamic subject line for notification emails. The placeholder {course_name} will be replaced with the name of the course or program that was enrolled in.', max_length=100)),
            ],
            options={
                'ordering': ['created'],
            },
        ),
        migrations.CreateModel(
            name='EnterpriseCatalogQuery',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('title', models.CharField(default='All Content', max_length=255)),
                ('content_filter', jsonfield.fields.JSONField(blank=True, default={}, dump_kwargs={'cls': jsonfield.encoder.JSONEncoder, 'indent': 4, 'separators': (',', ':')}, help_text="Query parameters which will be used to filter the discovery service's search/all endpoint results, specified as a JSON object. An empty JSON object means that all available content items will be included in the catalog.", load_kwargs={'object_pairs_hook': collections.OrderedDict}, null=True)),
            ],
            options={
                'verbose_name': 'Enterprise Catalog Query',
                'verbose_name_plural': 'Enterprise Catalog Queries',
                'ordering': ['created'],
            },
        ),
        migrations.CreateModel(
            name='EnterpriseCourseEnrollment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('course_id', models.CharField(help_text='The ID of the course in which the learner was enrolled.', max_length=255)),
                ('marked_done', models.BooleanField(default=False, help_text='Specifies whether a user marked this course as completed in the learner portal.')),
            ],
            options={
                'ordering': ['created'],
            },
        ),
        migrations.CreateModel(
            name='EnterpriseCustomer',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(help_text='Enterprise Customer name.', max_length=255)),
                ('slug', models.SlugField(default='default', help_text='A short string uniquely identifying this enterprise. Cannot contain spaces and should be a usable as a CSS class. Examples: "ubc", "mit-staging"', max_length=30, unique=True)),
                ('active', models.BooleanField(default=True)),
                ('country', django_countries.fields.CountryField(max_length=2, null=True)),
                ('hide_course_original_price', models.BooleanField(default=False, help_text='Specify whether display the course original price on enterprise course landing page or not.')),
                ('enable_data_sharing_consent', models.BooleanField(default=False, help_text='Specifies whether data sharing consent is enabled or disabled for learners signing in through this enterprise customer. If disabled, consent will not be requested, and eligible data will not be shared.')),
                ('enforce_data_sharing_consent', models.CharField(choices=[('at_enrollment', 'At Enrollment'), ('externally_managed', 'Managed externally')], default='at_enrollment', help_text='Specifies whether data sharing consent is optional, is required at login, or is required at enrollment.', max_length=25)),
                ('enable_audit_enrollment', models.BooleanField(default=False, help_text='Specifies whether the audit track enrollment option will be displayed in the course enrollment view.')),
                ('enable_audit_data_reporting', models.BooleanField(default=False, help_text='Specifies whether to pass-back audit track enrollment data through an integrated channel.')),
                ('replace_sensitive_sso_username', models.BooleanField(default=False, help_text='Specifies whether to replace the display of potentially sensitive SSO usernames with a more generic name, e.g. EnterpriseLearner.')),
                ('enable_autocohorting', models.BooleanField(default=False, help_text='Specifies whether the customer is able to assign learners to cohorts upon enrollment.')),
                ('enable_portal_code_management_screen', models.BooleanField(default=False, help_text='Specifies whether to allow access to the code management screen in the admin portal.')),
                ('enable_portal_reporting_config_screen', models.BooleanField(default=False, help_text='Specifies whether to allow access to the reporting configurations screen in the admin portal.')),
                ('enable_portal_subscription_management_screen', models.BooleanField(default=False, help_text='Specifies whether to allow access to the subscription management screen in the admin portal.')),
                ('enable_learner_portal', models.BooleanField(default=False, help_text='Specifies whether the enterprise learner portal site should be made known to the learner.')),
                ('contact_email', models.EmailField(blank=True, help_text='Email to be displayed as public point of contact for enterprise.', max_length=254, null=True)),
            ],
            options={
                'verbose_name': 'Enterprise Customer',
                'verbose_name_plural': 'Enterprise Customers',
                'ordering': ['created'],
            },
        ),
        migrations.CreateModel(
            name='EnterpriseCustomerBrandingConfiguration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('logo', models.ImageField(blank=True, help_text='Logo images must be in .png format.', max_length=255, null=True, upload_to=enterprise.models.logo_path, validators=[enterprise.validators.validate_image_extension, enterprise.validators.validate_image_size])),
                ('banner_border_color', models.CharField(blank=True, max_length=7, null=True, validators=[enterprise.validators.validate_hex_color])),
                ('banner_background_color', models.CharField(blank=True, max_length=7, null=True, validators=[enterprise.validators.validate_hex_color])),
                ('enterprise_customer', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='branding_configuration', to='enterprise.EnterpriseCustomer')),
            ],
            options={
                'verbose_name': 'Branding Configuration',
                'verbose_name_plural': 'Branding Configurations',
                'ordering': ['created'],
            },
        ),
        migrations.CreateModel(
            name='EnterpriseCustomerCatalog',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('title', models.CharField(default='All Content', max_length=255)),
                ('content_filter', jsonfield.fields.JSONField(blank=True, default={}, dump_kwargs={'cls': jsonfield.encoder.JSONEncoder, 'indent': 4, 'separators': (',', ':')}, help_text="Query parameters which will be used to filter the discovery service's search/all endpoint results, specified as a Json object. An empty Json object means that all available content items will be included in the catalog.", load_kwargs={'object_pairs_hook': collections.OrderedDict}, null=True)),
                ('enabled_course_modes', jsonfield.fields.JSONField(default=enterprise.constants.json_serialized_course_modes, dump_kwargs={'cls': jsonfield.encoder.JSONEncoder, 'separators': (',', ':')}, help_text='Ordered list of enrollment modes which can be displayed to learners for course runs in this catalog.', load_kwargs={})),
                ('publish_audit_enrollment_urls', models.BooleanField(default=False, help_text='Specifies whether courses should be published with direct-to-audit enrollment URLs.')),
                ('enterprise_catalog_query', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='enterprise_customer_catalogs', to='enterprise.EnterpriseCatalogQuery')),
                ('enterprise_customer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='enterprise_customer_catalogs', to='enterprise.EnterpriseCustomer')),
            ],
            options={
                'verbose_name': 'Enterprise Customer Catalog',
                'verbose_name_plural': 'Enterprise Customer Catalogs',
                'ordering': ['created'],
            },
        ),
        migrations.CreateModel(
            name='EnterpriseCustomerIdentityProvider',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('provider_id', models.SlugField(help_text='Slug field containing a unique identifier for the identity provider.', unique=True)),
                ('enterprise_customer', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='enterprise_customer_identity_provider', to='enterprise.EnterpriseCustomer')),
            ],
            options={
                'ordering': ['created'],
            },
        ),
        migrations.CreateModel(
            name='EnterpriseCustomerReportingConfiguration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True)),
                ('active', models.BooleanField(verbose_name='Active')),
                ('include_date', models.BooleanField(default=True, help_text='Include date in the report file name', verbose_name='Include Date')),
                ('delivery_method', models.CharField(choices=[('email', 'email'), ('sftp', 'sftp')], default='email', help_text='The method in which the data should be sent.', max_length=20, verbose_name='Delivery Method')),
                ('pgp_encryption_key', models.TextField(blank=True, help_text='The key for encryption, if PGP encrypted file is required.', null=True, verbose_name='PGP Encryption Key')),
                ('data_type', models.CharField(choices=[('progress', 'progress'), ('progress_v2', 'progress_v2'), ('catalog', 'catalog'), ('engagement', 'engagement')], default='progress', help_text='The type of data this report should contain.', max_length=20, verbose_name='Data Type')),
                ('report_type', models.CharField(choices=[('csv', 'csv'), ('json', 'json')], default='csv', help_text='The type this report should be sent as, e.g. CSV.', max_length=20, verbose_name='Report Type')),
                ('email', multi_email_field.fields.MultiEmailField(blank=True, help_text='The email(s), one per line, where the report should be sent.', verbose_name='Email')),
                ('frequency', models.CharField(choices=[('daily', 'daily'), ('monthly', 'monthly'), ('weekly', 'weekly')], default='monthly', help_text='The frequency interval (daily, weekly, or monthly) that the report should be sent.', max_length=20, verbose_name='Frequency')),
                ('day_of_month', models.SmallIntegerField(blank=True, help_text='The day of the month to send the report. This field is required and only valid when the frequency is monthly.', null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(31)], verbose_name='Day of Month')),
                ('day_of_week', models.SmallIntegerField(blank=True, choices=[(0, 'Monday'), (1, 'Tuesday'), (2, 'Wednesday'), (3, 'Thursday'), (4, 'Friday'), (5, 'Saturday'), (6, 'Sunday')], help_text='The day of the week to send the report. This field is required and only valid when the frequency is weekly.', null=True, verbose_name='Day of Week')),
                ('hour_of_day', models.SmallIntegerField(help_text='The hour of the day to send the report, in Eastern Standard Time (EST). This is required for all frequency settings.', validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(23)], verbose_name='Hour of Day')),
                ('decrypted_password', fernet_fields.fields.EncryptedCharField(blank=True, help_text='This password will be used to secure the zip file. It will be encrypted when stored in the database.', max_length=256, null=True)),
                ('sftp_hostname', models.CharField(blank=True, help_text='If the delivery method is sftp, the host to deliver the report to.', max_length=256, null=True, verbose_name='SFTP Host name')),
                ('sftp_port', models.PositiveIntegerField(blank=True, default=22, help_text='If the delivery method is sftp, the port on the host to connect to.', null=True, verbose_name='SFTP Port')),
                ('sftp_username', models.CharField(blank=True, help_text='If the delivery method is sftp, the username to use to securely access the host.', max_length=256, null=True, verbose_name='SFTP username')),
                ('decrypted_sftp_password', fernet_fields.fields.EncryptedCharField(blank=True, help_text='If the delivery method is sftp, the password to use to securely access the host. The password will be encrypted when stored in the database.', max_length=256, null=True)),
                ('sftp_file_path', models.CharField(blank=True, help_text='If the delivery method is sftp, the path on the host to deliver the report to.', max_length=256, null=True, verbose_name='SFTP file path')),
                ('enterprise_customer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='reporting_configurations', to='enterprise.EnterpriseCustomer', verbose_name='Enterprise Customer')),
                ('enterprise_customer_catalogs', models.ManyToManyField(to='enterprise.EnterpriseCustomerCatalog', verbose_name='Enterprise Customer Catalogs')),
            ],
            options={
                'ordering': ['created'],
            },
        ),
        migrations.CreateModel(
            name='EnterpriseCustomerType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(help_text='Specifies enterprise customer type.', max_length=25)),
            ],
            options={
                'verbose_name': 'Enterprise Customer Type',
                'verbose_name_plural': 'Enterprise Customer Types',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='EnterpriseCustomerUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('user_id', models.PositiveIntegerField(db_index=True)),
                ('active', models.BooleanField(default=True)),
                ('linked', models.BooleanField(default=True)),
                ('enterprise_customer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='enterprise_customer_users', to='enterprise.EnterpriseCustomer')),
            ],
            options={
                'verbose_name': 'Enterprise Customer Learner',
                'verbose_name_plural': 'Enterprise Customer Learners',
                'ordering': ['-active', '-modified'],
            },
        ),
        migrations.CreateModel(
            name='EnterpriseEnrollmentSource',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=64)),
                ('slug', models.SlugField(max_length=30, unique=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EnterpriseFeatureRole',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(db_index=True, max_length=255, unique=True)),
                ('description', models.TextField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EnterpriseFeatureUserRoleAssignment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('role', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='enterprise.EnterpriseFeatureRole')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
            bases=(enterprise.models.EnterpriseRoleAssignmentContextMixin, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalEnrollmentNotificationEmailTemplate',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('plaintext_template', models.TextField(blank=True, help_text='Fill in a standard Django template that, when rendered, produces the email you want sent to newly-enrolled Enterprise Customer learners. The following variables may be available:\n<ul><li>user_name: A human-readable name for the person being emailed. Be sure to handle the case where this is not defined, as it may be missing in some cases. It may also be a username, if the learner hasn\'t configured their "real" name in the system.</li>    <li>organization_name: The name of the organization sponsoring the enrollment.</li>    <li>enrolled_in: Details of the course or program that was enrolled in. It may contain:    <ul><li>name: The name of the enrollable item (e.g., "Demo Course").</li>        <li>url: A link to the homepage of the enrolled-in item.</li>        <li>branding: A custom branding name for the enrolled-in item. For example, the branding of a MicroMasters program would be "MicroMasters".</li>     <li>start: The date the enrolled-in item becomes available. Render this to text using the Django `date` template filter (see <a href="https://docs.djangoproject.com/en/1.8/ref/templates/builtins/#date">the Django documentation</a>).</li><li>type: Whether the enrolled-in item is a course, a program, or something else.</li></ul></ul>')),
                ('html_template', models.TextField(blank=True, help_text='Fill in a standard Django template that, when rendered, produces the email you want sent to newly-enrolled Enterprise Customer learners. The following variables may be available:\n<ul><li>user_name: A human-readable name for the person being emailed. Be sure to handle the case where this is not defined, as it may be missing in some cases. It may also be a username, if the learner hasn\'t configured their "real" name in the system.</li>    <li>organization_name: The name of the organization sponsoring the enrollment.</li>    <li>enrolled_in: Details of the course or program that was enrolled in. It may contain:    <ul><li>name: The name of the enrollable item (e.g., "Demo Course").</li>        <li>url: A link to the homepage of the enrolled-in item.</li>        <li>branding: A custom branding name for the enrolled-in item. For example, the branding of a MicroMasters program would be "MicroMasters".</li>     <li>start: The date the enrolled-in item becomes available. Render this to text using the Django `date` template filter (see <a href="https://docs.djangoproject.com/en/1.8/ref/templates/builtins/#date">the Django documentation</a>).</li><li>type: Whether the enrolled-in item is a course, a program, or something else.</li></ul></ul>')),
                ('subject_line', models.CharField(blank=True, help_text='Enter a string that can be used to generate a dynamic subject line for notification emails. The placeholder {course_name} will be replaced with the name of the course or program that was enrolled in.', max_length=100)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('enterprise_customer', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='enterprise.EnterpriseCustomer')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical enrollment notification email template',
                'get_latest_by': 'history_date',
                'ordering': ('-history_date', '-history_id'),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalEnterpriseCourseEnrollment',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('course_id', models.CharField(help_text='The ID of the course in which the learner was enrolled.', max_length=255)),
                ('marked_done', models.BooleanField(default=False, help_text='Specifies whether a user marked this course as completed in the learner portal.')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('enterprise_customer_user', models.ForeignKey(blank=True, db_constraint=False, help_text='The enterprise learner to which this enrollment is attached.', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='enterprise.EnterpriseCustomerUser')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('source', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='enterprise.EnterpriseEnrollmentSource')),
            ],
            options={
                'verbose_name': 'historical enterprise course enrollment',
                'get_latest_by': 'history_date',
                'ordering': ('-history_date', '-history_id'),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalEnterpriseCustomer',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('uuid', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False)),
                ('name', models.CharField(help_text='Enterprise Customer name.', max_length=255)),
                ('slug', models.SlugField(default='default', help_text='A short string uniquely identifying this enterprise. Cannot contain spaces and should be a usable as a CSS class. Examples: "ubc", "mit-staging"', max_length=30)),
                ('active', models.BooleanField(default=True)),
                ('country', django_countries.fields.CountryField(max_length=2, null=True)),
                ('hide_course_original_price', models.BooleanField(default=False, help_text='Specify whether display the course original price on enterprise course landing page or not.')),
                ('enable_data_sharing_consent', models.BooleanField(default=False, help_text='Specifies whether data sharing consent is enabled or disabled for learners signing in through this enterprise customer. If disabled, consent will not be requested, and eligible data will not be shared.')),
                ('enforce_data_sharing_consent', models.CharField(choices=[('at_enrollment', 'At Enrollment'), ('externally_managed', 'Managed externally')], default='at_enrollment', help_text='Specifies whether data sharing consent is optional, is required at login, or is required at enrollment.', max_length=25)),
                ('enable_audit_enrollment', models.BooleanField(default=False, help_text='Specifies whether the audit track enrollment option will be displayed in the course enrollment view.')),
                ('enable_audit_data_reporting', models.BooleanField(default=False, help_text='Specifies whether to pass-back audit track enrollment data through an integrated channel.')),
                ('replace_sensitive_sso_username', models.BooleanField(default=False, help_text='Specifies whether to replace the display of potentially sensitive SSO usernames with a more generic name, e.g. EnterpriseLearner.')),
                ('enable_autocohorting', models.BooleanField(default=False, help_text='Specifies whether the customer is able to assign learners to cohorts upon enrollment.')),
                ('enable_portal_code_management_screen', models.BooleanField(default=False, help_text='Specifies whether to allow access to the code management screen in the admin portal.')),
                ('enable_portal_reporting_config_screen', models.BooleanField(default=False, help_text='Specifies whether to allow access to the reporting configurations screen in the admin portal.')),
                ('enable_portal_subscription_management_screen', models.BooleanField(default=False, help_text='Specifies whether to allow access to the subscription management screen in the admin portal.')),
                ('enable_learner_portal', models.BooleanField(default=False, help_text='Specifies whether the enterprise learner portal site should be made known to the learner.')),
                ('contact_email', models.EmailField(blank=True, help_text='Email to be displayed as public point of contact for enterprise.', max_length=254, null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('customer_type', models.ForeignKey(blank=True, db_constraint=False, default=enterprise.models.get_default_customer_type, help_text='Specifies enterprise customer type.', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='enterprise.EnterpriseCustomerType', verbose_name='Customer Type')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('site', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='sites.Site')),
            ],
            options={
                'verbose_name': 'historical Enterprise Customer',
                'get_latest_by': 'history_date',
                'ordering': ('-history_date', '-history_id'),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalEnterpriseCustomerCatalog',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('uuid', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False)),
                ('title', models.CharField(default='All Content', max_length=255)),
                ('content_filter', jsonfield.fields.JSONField(blank=True, default={}, dump_kwargs={'cls': jsonfield.encoder.JSONEncoder, 'indent': 4, 'separators': (',', ':')}, help_text="Query parameters which will be used to filter the discovery service's search/all endpoint results, specified as a Json object. An empty Json object means that all available content items will be included in the catalog.", load_kwargs={'object_pairs_hook': collections.OrderedDict}, null=True)),
                ('enabled_course_modes', jsonfield.fields.JSONField(default=enterprise.constants.json_serialized_course_modes, dump_kwargs={'cls': jsonfield.encoder.JSONEncoder, 'separators': (',', ':')}, help_text='Ordered list of enrollment modes which can be displayed to learners for course runs in this catalog.', load_kwargs={})),
                ('publish_audit_enrollment_urls', models.BooleanField(default=False, help_text='Specifies whether courses should be published with direct-to-audit enrollment URLs.')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('enterprise_catalog_query', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='enterprise.EnterpriseCatalogQuery')),
                ('enterprise_customer', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='enterprise.EnterpriseCustomer')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical Enterprise Customer Catalog',
                'get_latest_by': 'history_date',
                'ordering': ('-history_date', '-history_id'),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalPendingEnrollment',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('course_id', models.CharField(max_length=255)),
                ('course_mode', models.CharField(max_length=25)),
                ('cohort_name', models.CharField(blank=True, max_length=255, null=True)),
                ('discount_percentage', models.DecimalField(decimal_places=5, default=0.0, max_digits=8)),
                ('sales_force_id', models.CharField(blank=True, max_length=255, null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('source', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='enterprise.EnterpriseEnrollmentSource')),
            ],
            options={
                'verbose_name': 'historical pending enrollment',
                'get_latest_by': 'history_date',
                'ordering': ('-history_date', '-history_id'),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalPendingEnterpriseCustomerUser',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('user_email', models.EmailField(db_index=True, max_length=254)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('enterprise_customer', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='enterprise.EnterpriseCustomer')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical pending enterprise customer user',
                'get_latest_by': 'history_date',
                'ordering': ('-history_date', '-history_id'),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='PendingEnrollment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('course_id', models.CharField(max_length=255)),
                ('course_mode', models.CharField(max_length=25)),
                ('cohort_name', models.CharField(blank=True, max_length=255, null=True)),
                ('discount_percentage', models.DecimalField(decimal_places=5, default=0.0, max_digits=8)),
                ('sales_force_id', models.CharField(blank=True, max_length=255, null=True)),
                ('source', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='enterprise.EnterpriseEnrollmentSource')),
            ],
            options={
                'ordering': ['created'],
            },
        ),
        migrations.CreateModel(
            name='PendingEnterpriseCustomerUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('user_email', models.EmailField(max_length=254, unique=True)),
                ('enterprise_customer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='enterprise.EnterpriseCustomer')),
            ],
            options={
                'ordering': ['created'],
            },
        ),
        migrations.CreateModel(
            name='SystemWideEnterpriseRole',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(db_index=True, max_length=255, unique=True)),
                ('description', models.TextField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SystemWideEnterpriseUserRoleAssignment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('role', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='enterprise.SystemWideEnterpriseRole')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
            bases=(enterprise.models.EnterpriseRoleAssignmentContextMixin, models.Model),
        ),
        migrations.AddField(
            model_name='pendingenrollment',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='enterprise.PendingEnterpriseCustomerUser'),
        ),
        migrations.AddField(
            model_name='historicalpendingenrollment',
            name='user',
            field=models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='enterprise.PendingEnterpriseCustomerUser'),
        ),
        migrations.AddField(
            model_name='enterprisecustomer',
            name='customer_type',
            field=models.ForeignKey(default=enterprise.models.get_default_customer_type, help_text='Specifies enterprise customer type.', on_delete=django.db.models.deletion.CASCADE, to='enterprise.EnterpriseCustomerType', verbose_name='Customer Type'),
        ),
        migrations.AddField(
            model_name='enterprisecustomer',
            name='site',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='enterprise_customers', to='sites.Site'),
        ),
        migrations.AddField(
            model_name='enterprisecourseenrollment',
            name='enterprise_customer_user',
            field=models.ForeignKey(help_text='The enterprise learner to which this enrollment is attached.', on_delete=django.db.models.deletion.CASCADE, related_name='enterprise_enrollments', to='enterprise.EnterpriseCustomerUser'),
        ),
        migrations.AddField(
            model_name='enterprisecourseenrollment',
            name='source',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='enterprise.EnterpriseEnrollmentSource'),
        ),
        migrations.AddField(
            model_name='enrollmentnotificationemailtemplate',
            name='enterprise_customer',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='enterprise_enrollment_template', to='enterprise.EnterpriseCustomer'),
        ),
        migrations.AlterUniqueTogether(
            name='pendingenrollment',
            unique_together=set([('user', 'course_id')]),
        ),
        migrations.AlterUniqueTogether(
            name='enterprisecustomeruser',
            unique_together=set([('enterprise_customer', 'user_id')]),
        ),
        migrations.AlterUniqueTogether(
            name='enterprisecourseenrollment',
            unique_together=set([('enterprise_customer_user', 'course_id')]),
        ),
        migrations.RunPython(
            code=create_enterprise_roles,
            reverse_code=delete_enterprise_roles,
        ),
        migrations.RunPython(
            code=add_enterprise_enrollment_sources,
            reverse_code=drop_enterprise_enrollment_sources,
        ),
    ]
