# -*- coding: utf-8 -*-
# Generated by Django 1.11.15 on 2018-12-12 07:45


import django.db.models.deletion
import django.utils.timezone
from django.db import migrations, models

import model_utils.fields

import enterprise.models


class Migration(migrations.Migration):

    dependencies = [
        ('enterprise', '0057_enterprisecustomerreportingconfiguration_enterprise_customer_catalogs'),
    ]

    operations = [
        migrations.CreateModel(
            name='EnterpriseCustomerType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(help_text='Specifies enterprise customer type.', max_length=25)),
            ],
            options={
                'ordering': ['name'],
                'verbose_name': 'Enterprise Customer Type',
                'verbose_name_plural': 'Enterprise Customer Types',
            },
        ),
        migrations.AddField(
            model_name='enterprisecustomer',
            name='customer_type',
            field=models.ForeignKey(default=enterprise.models.get_default_customer_type, help_text='Specifies enterprise customer type.', on_delete=django.db.models.deletion.CASCADE, to='enterprise.EnterpriseCustomerType', verbose_name='Customer Type'),
        ),
        migrations.AddField(
            model_name='historicalenterprisecustomer',
            name='customer_type',
            field=models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='enterprise.EnterpriseCustomerType'),
        ),
    ]
