# -*- coding: utf-8 -*-
# Generated by Django 1.11.28 on 2020-03-31 19:13


from django.db import migrations

from enterprise.constants import USE_ENTERPRISE_CATALOG


def create_flag(apps, schema_editor):
    """Create the `use_enterprise_catalog` flag if it does not already exist."""
    Flag = apps.get_model('waffle', 'Flag')
    Flag.objects.get_or_create(
        name=USE_ENTERPRISE_CATALOG,
        defaults={'everyone': None, 'superusers': False},
    )


def delete_flag(apps, schema_editor):
    """Delete the `use_enterprise_catalog` flag if one exists."""
    Flag = apps.get_model('waffle', 'Flag')
    Flag.objects.filter(name=USE_ENTERPRISE_CATALOG).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('enterprise', '0092_auto_20200312_1650'),
    ]

    operations = [
        migrations.RunPython(create_flag, delete_flag)
    ]
