# Generated by Django 2.2.12 on 2020-05-07 11:38

from django.db import migrations

from enterprise.constants import SYSTEM_ENTERPRISE_CATALOG_ADMIN_ROLE


def create_enterprise_catalog_admin_role(apps, schema_editor):
    """Create the `enterprise_catalog_admin` system-wide role if it does not already exist"""
    SystemWideEnterpriseRole = apps.get_model('enterprise', 'SystemWideEnterpriseRole')
    SystemWideEnterpriseRole.objects.update_or_create(
        name=SYSTEM_ENTERPRISE_CATALOG_ADMIN_ROLE,
        description='Role for access to endpoints in the enterprise catalog service',
    )


def delete_enterprise_catalog_admin_role(apps, schema_editor):
    """Delete the `enterprise_catalog_admin` system-wide role"""
    SystemWideEnterpriseRole = apps.get_model('enterprise', 'SystemWideEnterpriseRole')
    SystemWideEnterpriseRole.objects.filter(name=SYSTEM_ENTERPRISE_CATALOG_ADMIN_ROLE).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('enterprise', '0095_auto_20200507_1138'),
    ]

    operations = [
        migrations.RunPython(
            code=create_enterprise_catalog_admin_role,
            reverse_code=delete_enterprise_catalog_admin_role,
        ),
    ]
