# -*- coding: utf-8 -*-
# Generated by Django 1.11.22 on 2019-08-07 10:06


import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models

import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('xapi', '0002_auto_20180726_0142'),
    ]

    operations = [
        migrations.CreateModel(
            name='XAPILearnerDataTransmissionAudit',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('enterprise_course_enrollment_id', models.PositiveIntegerField(blank=True, db_index=True, null=True)),
                ('course_id', models.CharField(db_index=True, max_length=255)),
                ('course_completed', models.BooleanField(default=False)),
                ('completed_timestamp', models.DateTimeField(blank=True, null=True)),
                ('grade', models.CharField(blank=True, max_length=255, null=True)),
                ('status', models.CharField(max_length=100)),
                ('error_message', models.TextField(blank=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='xapi_transmission_audit', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AlterUniqueTogether(
            name='xapilearnerdatatransmissionaudit',
            unique_together=set([('user', 'course_id')]),
        ),
    ]
