# Generated by Django 5.2.6 on 2025-09-29 06:18

import uuid

import django.core.validators
import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="EndpointGroup",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Endpoint group name (e.g., 'Payment API', 'Balance API')",
                        max_length=100,
                        unique=True,
                    ),
                ),
                (
                    "code",
                    models.CharField(
                        help_text="Endpoint group code (e.g., 'payments', 'balance')",
                        max_length=50,
                        unique=True,
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="Description of what this endpoint group provides"
                    ),
                ),
                (
                    "is_enabled",
                    models.BooleanField(
                        default=True, help_text="Whether this endpoint group is available"
                    ),
                ),
                (
                    "requires_subscription",
                    models.BooleanField(
                        default=True, help_text="Whether access requires an active subscription"
                    ),
                ),
                (
                    "default_rate_limit",
                    models.PositiveIntegerField(
                        default=1000, help_text="Default requests per hour for this endpoint group"
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "verbose_name": "Endpoint Group",
                "verbose_name_plural": "Endpoint Groups",
                "db_table": "payments_endpoint_groups",
                "ordering": ["name"],
            },
        ),
        migrations.CreateModel(
            name="Currency",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True, db_index=True, help_text="When this record was created"
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True, help_text="When this record was last updated"
                    ),
                ),
                (
                    "code",
                    models.CharField(
                        help_text="Currency code (e.g., BTC, USD, ETH)",
                        max_length=10,
                        unique=True,
                        validators=[
                            django.core.validators.MinLengthValidator(3),
                            django.core.validators.MaxLengthValidator(10),
                        ],
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Full currency name (e.g., Bitcoin, US Dollar)", max_length=100
                    ),
                ),
                (
                    "currency_type",
                    models.CharField(
                        choices=[("fiat", "Fiat Currency"), ("crypto", "Cryptocurrency")],
                        help_text="Type of currency",
                        max_length=10,
                    ),
                ),
                (
                    "symbol",
                    models.CharField(
                        blank=True, help_text="Currency symbol (e.g., $, ₿, Ξ)", max_length=10
                    ),
                ),
                (
                    "decimal_places",
                    models.PositiveSmallIntegerField(
                        default=8, help_text="Number of decimal places for this currency"
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        default=True, help_text="Whether this currency is available for payments"
                    ),
                ),
                (
                    "exchange_rate_source",
                    models.CharField(
                        blank=True,
                        help_text="Source for exchange rates (auto-detected by django_currency)",
                        max_length=50,
                    ),
                ),
                (
                    "usd_rate",
                    models.FloatField(
                        default=1.0, help_text="Current USD exchange rate (1 unit = X USD)"
                    ),
                ),
                (
                    "usd_rate_updated_at",
                    models.DateTimeField(
                        blank=True, help_text="When USD rate was last updated", null=True
                    ),
                ),
            ],
            options={
                "verbose_name": "Currency",
                "verbose_name_plural": "Currencies",
                "db_table": "payments_currencies",
                "ordering": ["currency_type", "code"],
                "indexes": [
                    models.Index(
                        fields=["currency_type", "is_active"], name="payments_cu_currenc_c67daf_idx"
                    ),
                    models.Index(fields=["code"], name="payments_cu_code_2e1e62_idx"),
                ],
            },
        ),
        migrations.CreateModel(
            name="Network",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True, db_index=True, help_text="When this record was created"
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True, help_text="When this record was last updated"
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Network name (e.g., Ethereum, Bitcoin, Polygon)",
                        max_length=50,
                        unique=True,
                    ),
                ),
                (
                    "code",
                    models.CharField(
                        help_text="Network code (e.g., ETH, BTC, MATIC)", max_length=20, unique=True
                    ),
                ),
                (
                    "block_explorer_url",
                    models.URLField(
                        blank=True,
                        help_text="Block explorer URL template (use {tx} for transaction hash)",
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        default=True, help_text="Whether this network is available for payments"
                    ),
                ),
                (
                    "confirmation_blocks",
                    models.PositiveIntegerField(
                        default=1, help_text="Number of confirmations required for this network"
                    ),
                ),
                (
                    "average_block_time",
                    models.PositiveIntegerField(
                        default=600, help_text="Average block time in seconds"
                    ),
                ),
                (
                    "native_currency",
                    models.ForeignKey(
                        help_text="Native currency of this network",
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="native_networks",
                        to="payments.currency",
                    ),
                ),
            ],
            options={
                "verbose_name": "Network",
                "verbose_name_plural": "Networks",
                "db_table": "payments_networks",
                "ordering": ["name"],
            },
        ),
        migrations.CreateModel(
            name="ProviderCurrency",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True, db_index=True, help_text="When this record was created"
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True, help_text="When this record was last updated"
                    ),
                ),
                (
                    "provider",
                    models.CharField(
                        help_text="Payment provider name (e.g., nowpayments)", max_length=50
                    ),
                ),
                (
                    "provider_currency_code",
                    models.CharField(
                        help_text="Currency code as used by the provider", max_length=20
                    ),
                ),
                (
                    "is_enabled",
                    models.BooleanField(
                        default=True, help_text="Whether this currency is enabled for this provider"
                    ),
                ),
                (
                    "currency",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="provider_configs",
                        to="payments.currency",
                    ),
                ),
                (
                    "network",
                    models.ForeignKey(
                        blank=True,
                        help_text="Network for crypto currencies (null for fiat)",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="provider_configs",
                        to="payments.network",
                    ),
                ),
            ],
            options={
                "verbose_name": "Provider Currency",
                "verbose_name_plural": "Provider Currencies",
                "db_table": "payments_provider_currencies",
                "ordering": ["provider", "currency__code"],
            },
        ),
        migrations.CreateModel(
            name="Subscription",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        help_text="Unique identifier for this record",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True, db_index=True, help_text="When this record was created"
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True, help_text="When this record was last updated"
                    ),
                ),
                (
                    "tier",
                    models.CharField(
                        choices=[
                            ("free", "Free Tier"),
                            ("basic", "Basic Tier"),
                            ("pro", "Pro Tier"),
                            ("enterprise", "Enterprise Tier"),
                        ],
                        default="free",
                        help_text="Subscription tier",
                        max_length=20,
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("active", "Active"),
                            ("inactive", "Inactive"),
                            ("suspended", "Suspended"),
                            ("cancelled", "Cancelled"),
                            ("expired", "Expired"),
                        ],
                        default="active",
                        help_text="Subscription status",
                        max_length=20,
                    ),
                ),
                (
                    "requests_per_hour",
                    models.PositiveIntegerField(
                        default=100,
                        help_text="API requests allowed per hour",
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(100000),
                        ],
                    ),
                ),
                (
                    "requests_per_day",
                    models.PositiveIntegerField(
                        default=1000,
                        help_text="API requests allowed per day",
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(1000000),
                        ],
                    ),
                ),
                (
                    "starts_at",
                    models.DateTimeField(
                        default=django.utils.timezone.now, help_text="When this subscription starts"
                    ),
                ),
                ("expires_at", models.DateTimeField(help_text="When this subscription expires")),
                (
                    "monthly_cost_usd",
                    models.FloatField(
                        default=0.0,
                        help_text="Monthly cost in USD",
                        validators=[django.core.validators.MinValueValidator(0.0)],
                    ),
                ),
                (
                    "total_requests",
                    models.PositiveIntegerField(
                        default=0, help_text="Total API requests made with this subscription"
                    ),
                ),
                (
                    "last_request_at",
                    models.DateTimeField(
                        blank=True, help_text="When the last API request was made", null=True
                    ),
                ),
                (
                    "auto_renew",
                    models.BooleanField(
                        default=False, help_text="Whether to automatically renew this subscription"
                    ),
                ),
                (
                    "endpoint_groups",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Endpoint groups accessible with this subscription",
                        related_name="subscriptions",
                        to="payments.endpointgroup",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        help_text="User who owns this subscription",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="payment_subscriptions",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Subscription",
                "verbose_name_plural": "Subscriptions",
                "db_table": "payments_subscriptions",
                "ordering": ["-created_at"],
            },
        ),
        migrations.CreateModel(
            name="Tariff",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True, db_index=True, help_text="When this record was created"
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True, help_text="When this record was last updated"
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Tariff name (e.g., 'Free', 'Basic', 'Pro')",
                        max_length=100,
                        unique=True,
                    ),
                ),
                (
                    "code",
                    models.CharField(
                        help_text="Tariff code (e.g., 'free', 'basic', 'pro')",
                        max_length=50,
                        unique=True,
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="Detailed description of what this tariff includes"
                    ),
                ),
                (
                    "monthly_price_usd",
                    models.FloatField(
                        help_text="Monthly price in USD",
                        validators=[django.core.validators.MinValueValidator(0.0)],
                    ),
                ),
                (
                    "yearly_price_usd",
                    models.FloatField(
                        blank=True,
                        help_text="Yearly price in USD (optional discount)",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                    ),
                ),
                (
                    "requests_per_hour",
                    models.PositiveIntegerField(
                        default=100,
                        help_text="API requests allowed per hour",
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(100000),
                        ],
                    ),
                ),
                (
                    "requests_per_day",
                    models.PositiveIntegerField(
                        default=1000,
                        help_text="API requests allowed per day",
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(1000000),
                        ],
                    ),
                ),
                (
                    "requests_per_month",
                    models.PositiveIntegerField(
                        default=30000,
                        help_text="API requests allowed per month",
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(10000000),
                        ],
                    ),
                ),
                (
                    "max_api_keys",
                    models.PositiveIntegerField(
                        default=1,
                        help_text="Maximum number of API keys allowed",
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(100),
                        ],
                    ),
                ),
                (
                    "supports_webhooks",
                    models.BooleanField(default=True, help_text="Whether webhooks are supported"),
                ),
                (
                    "priority_support",
                    models.BooleanField(
                        default=False, help_text="Whether priority support is included"
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        default=True,
                        help_text="Whether this tariff is available for new subscriptions",
                    ),
                ),
                (
                    "is_public",
                    models.BooleanField(
                        default=True, help_text="Whether this tariff is publicly visible"
                    ),
                ),
                (
                    "sort_order",
                    models.PositiveIntegerField(
                        default=0, help_text="Sort order for display (lower numbers first)"
                    ),
                ),
            ],
            options={
                "verbose_name": "Tariff",
                "verbose_name_plural": "Tariffs",
                "db_table": "payments_tariffs",
                "ordering": ["sort_order", "monthly_price_usd"],
                "indexes": [
                    models.Index(
                        fields=["is_active", "is_public"], name="payments_ta_is_acti_716f1f_idx"
                    ),
                    models.Index(fields=["sort_order"], name="payments_ta_sort_or_e6ec28_idx"),
                ],
            },
        ),
        migrations.CreateModel(
            name="TariffEndpointGroup",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True, db_index=True, help_text="When this record was created"
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True, help_text="When this record was last updated"
                    ),
                ),
                (
                    "custom_rate_limit",
                    models.PositiveIntegerField(
                        blank=True,
                        help_text="Custom rate limit for this endpoint group (overrides tariff default)",
                        null=True,
                    ),
                ),
                (
                    "is_enabled",
                    models.BooleanField(
                        default=True,
                        help_text="Whether this endpoint group is enabled for this tariff",
                    ),
                ),
                (
                    "endpoint_group",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="tariffs",
                        to="payments.endpointgroup",
                    ),
                ),
                (
                    "tariff",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="endpoint_groups",
                        to="payments.tariff",
                    ),
                ),
            ],
            options={
                "verbose_name": "Tariff Endpoint Group",
                "verbose_name_plural": "Tariff Endpoint Groups",
                "db_table": "payments_tariff_endpoint_groups",
                "ordering": ["tariff__sort_order", "endpoint_group__name"],
            },
        ),
        migrations.CreateModel(
            name="Transaction",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        help_text="Unique identifier for this record",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True, db_index=True, help_text="When this record was created"
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True, help_text="When this record was last updated"
                    ),
                ),
                (
                    "transaction_type",
                    models.CharField(
                        choices=[
                            ("deposit", "Deposit"),
                            ("withdrawal", "Withdrawal"),
                            ("payment", "Payment"),
                            ("refund", "Refund"),
                            ("fee", "Fee"),
                            ("bonus", "Bonus"),
                            ("adjustment", "Adjustment"),
                        ],
                        help_text="Type of transaction",
                        max_length=20,
                    ),
                ),
                (
                    "amount_usd",
                    models.FloatField(
                        help_text="Transaction amount in USD (positive=credit, negative=debit)"
                    ),
                ),
                (
                    "balance_after",
                    models.FloatField(
                        help_text="User balance after this transaction",
                        validators=[django.core.validators.MinValueValidator(0.0)],
                    ),
                ),
                (
                    "payment_id",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="Related payment ID (if applicable)",
                        max_length=100,
                        null=True,
                    ),
                ),
                ("description", models.TextField(help_text="Transaction description")),
                (
                    "metadata",
                    models.JSONField(
                        blank=True, default=dict, help_text="Additional transaction metadata"
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        help_text="User who owns this transaction",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="payment_transactions",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Transaction",
                "verbose_name_plural": "Transactions",
                "db_table": "payments_transactions",
                "ordering": ["-created_at"],
            },
        ),
        migrations.CreateModel(
            name="UniversalPayment",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        help_text="Unique identifier for this record",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True, db_index=True, help_text="When this record was created"
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True, help_text="When this record was last updated"
                    ),
                ),
                (
                    "internal_payment_id",
                    models.CharField(
                        db_index=True,
                        help_text="Internal payment identifier",
                        max_length=100,
                        unique=True,
                    ),
                ),
                (
                    "amount_usd",
                    models.FloatField(
                        help_text="Payment amount in USD (float for performance)",
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(50000.0),
                        ],
                    ),
                ),
                (
                    "pay_amount",
                    models.DecimalField(
                        blank=True,
                        decimal_places=8,
                        help_text="Amount to pay in cryptocurrency (Decimal for precision)",
                        max_digits=20,
                        null=True,
                    ),
                ),
                (
                    "actual_amount_usd",
                    models.FloatField(
                        blank=True, help_text="Actual amount received in USD", null=True
                    ),
                ),
                (
                    "fee_amount_usd",
                    models.FloatField(blank=True, help_text="Fee amount in USD", null=True),
                ),
                (
                    "provider",
                    models.CharField(
                        choices=[("nowpayments", "NowPayments")],
                        default="nowpayments",
                        help_text="Payment provider",
                        max_length=50,
                    ),
                ),
                (
                    "provider_payment_id",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="Provider's payment ID",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("pending", "Pending"),
                            ("confirming", "Confirming"),
                            ("confirmed", "Confirmed"),
                            ("completed", "Completed"),
                            ("failed", "Failed"),
                            ("expired", "Expired"),
                            ("cancelled", "Cancelled"),
                            ("refunded", "Refunded"),
                        ],
                        db_index=True,
                        default="pending",
                        help_text="Current payment status",
                        max_length=20,
                    ),
                ),
                (
                    "pay_address",
                    models.CharField(
                        blank=True,
                        help_text="Cryptocurrency payment address",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "payment_url",
                    models.URLField(blank=True, help_text="Payment page URL", null=True),
                ),
                (
                    "transaction_hash",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="Blockchain transaction hash",
                        max_length=256,
                        null=True,
                    ),
                ),
                (
                    "confirmations_count",
                    models.PositiveIntegerField(
                        default=0, help_text="Number of blockchain confirmations"
                    ),
                ),
                (
                    "security_nonce",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="Security nonce for validation",
                        max_length=64,
                        null=True,
                    ),
                ),
                (
                    "expires_at",
                    models.DateTimeField(
                        blank=True, help_text="When this payment expires", null=True
                    ),
                ),
                (
                    "completed_at",
                    models.DateTimeField(
                        blank=True, help_text="When this payment was completed", null=True
                    ),
                ),
                ("description", models.TextField(blank=True, help_text="Payment description")),
                (
                    "callback_url",
                    models.URLField(blank=True, help_text="Success callback URL", null=True),
                ),
                (
                    "cancel_url",
                    models.URLField(blank=True, help_text="Cancellation URL", null=True),
                ),
                (
                    "provider_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        help_text="Provider-specific data (validated by Pydantic)",
                    ),
                ),
                (
                    "webhook_data",
                    models.JSONField(
                        blank=True, default=dict, help_text="Webhook data (validated by Pydantic)"
                    ),
                ),
                (
                    "currency",
                    models.ForeignKey(
                        help_text="Payment currency",
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="payments",
                        to="payments.currency",
                    ),
                ),
                (
                    "network",
                    models.ForeignKey(
                        blank=True,
                        help_text="Blockchain network (for crypto payments)",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="payments",
                        to="payments.network",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        help_text="User who created this payment",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="payments",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Universal Payment",
                "verbose_name_plural": "Universal Payments",
                "ordering": ["-created_at"],
            },
        ),
        migrations.CreateModel(
            name="UserBalance",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "balance_usd",
                    models.FloatField(
                        default=0.0,
                        help_text="Current balance in USD (float for performance)",
                        validators=[django.core.validators.MinValueValidator(0.0)],
                    ),
                ),
                (
                    "reserved_usd",
                    models.FloatField(
                        default=0.0,
                        help_text="Reserved amount in USD (pending transactions)",
                        validators=[django.core.validators.MinValueValidator(0.0)],
                    ),
                ),
                (
                    "total_deposited",
                    models.FloatField(
                        default=0.0,
                        help_text="Total amount deposited (lifetime)",
                        validators=[django.core.validators.MinValueValidator(0.0)],
                    ),
                ),
                (
                    "total_spent",
                    models.FloatField(
                        default=0.0,
                        help_text="Total amount spent (lifetime)",
                        validators=[django.core.validators.MinValueValidator(0.0)],
                    ),
                ),
                (
                    "last_transaction_at",
                    models.DateTimeField(
                        blank=True, help_text="When the last transaction occurred", null=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "user",
                    models.OneToOneField(
                        help_text="User who owns this balance",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="payment_balance",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "User Balance",
                "verbose_name_plural": "User Balances",
                "db_table": "payments_user_balances",
            },
        ),
        migrations.CreateModel(
            name="APIKey",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        help_text="Unique identifier for this record",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True, db_index=True, help_text="When this record was created"
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True, help_text="When this record was last updated"
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Human-readable name for this API key", max_length=100
                    ),
                ),
                (
                    "key",
                    models.CharField(
                        help_text="The actual API key (auto-generated)",
                        max_length=64,
                        unique=True,
                        validators=[django.core.validators.MinLengthValidator(32)],
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(default=True, help_text="Whether this API key is active"),
                ),
                (
                    "total_requests",
                    models.PositiveIntegerField(
                        default=0, help_text="Total number of requests made with this key"
                    ),
                ),
                (
                    "last_used_at",
                    models.DateTimeField(
                        blank=True, help_text="When this API key was last used", null=True
                    ),
                ),
                (
                    "expires_at",
                    models.DateTimeField(
                        blank=True,
                        help_text="When this API key expires (null = never expires)",
                        null=True,
                    ),
                ),
                (
                    "allowed_ips",
                    models.TextField(
                        blank=True,
                        help_text="Comma-separated list of allowed IP addresses (empty = any IP)",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        help_text="User who owns this API key",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="api_keys",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "API Key",
                "verbose_name_plural": "API Keys",
                "db_table": "payments_api_keys",
                "ordering": ["-created_at"],
                "indexes": [
                    models.Index(fields=["key"], name="payments_ap_key_9290c6_idx"),
                    models.Index(
                        fields=["user", "is_active"], name="payments_ap_user_id_784de9_idx"
                    ),
                    models.Index(fields=["expires_at"], name="payments_ap_expires_dff82d_idx"),
                ],
            },
        ),
        migrations.AddIndex(
            model_name="network",
            index=models.Index(fields=["is_active"], name="payments_ne_is_acti_915889_idx"),
        ),
        migrations.AddIndex(
            model_name="network",
            index=models.Index(fields=["code"], name="payments_ne_code_28d2a9_idx"),
        ),
        migrations.AddIndex(
            model_name="providercurrency",
            index=models.Index(
                fields=["provider", "is_enabled"], name="payments_pr_provide_585c03_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="providercurrency",
            index=models.Index(
                fields=["currency", "is_enabled"], name="payments_pr_currenc_a88055_idx"
            ),
        ),
        migrations.AlterUniqueTogether(
            name="providercurrency",
            unique_together={("provider", "currency", "network")},
        ),
        migrations.AddIndex(
            model_name="subscription",
            index=models.Index(fields=["user", "status"], name="payments_su_user_id_3279a3_idx"),
        ),
        migrations.AddIndex(
            model_name="subscription",
            index=models.Index(
                fields=["status", "expires_at"], name="payments_su_status_1a9788_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="subscription",
            index=models.Index(fields=["tier", "status"], name="payments_su_tier_2ba72c_idx"),
        ),
        migrations.AddConstraint(
            model_name="subscription",
            constraint=models.UniqueConstraint(
                condition=models.Q(("status", "active")),
                fields=("user",),
                name="one_active_subscription_per_user",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="tariffendpointgroup",
            unique_together={("tariff", "endpoint_group")},
        ),
        migrations.AddIndex(
            model_name="transaction",
            index=models.Index(
                fields=["user", "created_at"], name="payments_tr_user_id_c1c1f7_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="transaction",
            index=models.Index(
                fields=["transaction_type", "created_at"], name="payments_tr_transac_4c7d58_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="transaction",
            index=models.Index(fields=["payment_id"], name="payments_tr_payment_96b00a_idx"),
        ),
        migrations.AddIndex(
            model_name="transaction",
            index=models.Index(fields=["amount_usd"], name="payments_tr_amount__c7f348_idx"),
        ),
        migrations.AddIndex(
            model_name="universalpayment",
            index=models.Index(fields=["user", "status"], name="payments_un_user_id_7f6e79_idx"),
        ),
        migrations.AddIndex(
            model_name="universalpayment",
            index=models.Index(
                fields=["provider", "status"], name="payments_un_provide_982d48_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="universalpayment",
            index=models.Index(
                fields=["status", "created_at"], name="payments_un_status_eba1d1_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="universalpayment",
            index=models.Index(
                fields=["provider_payment_id"], name="payments_un_provide_8ed72f_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="universalpayment",
            index=models.Index(fields=["transaction_hash"], name="payments_un_transac_6095d4_idx"),
        ),
        migrations.AddIndex(
            model_name="universalpayment",
            index=models.Index(fields=["expires_at"], name="payments_un_expires_6a9f9d_idx"),
        ),
        migrations.AddConstraint(
            model_name="universalpayment",
            constraint=models.CheckConstraint(
                condition=models.Q(("amount_usd__gte", 1.0)), name="payments_min_amount_check"
            ),
        ),
        migrations.AddConstraint(
            model_name="universalpayment",
            constraint=models.CheckConstraint(
                condition=models.Q(("amount_usd__lte", 50000.0)), name="payments_max_amount_check"
            ),
        ),
        migrations.AddIndex(
            model_name="userbalance",
            index=models.Index(fields=["balance_usd"], name="payments_us_balance_32e5aa_idx"),
        ),
        migrations.AddIndex(
            model_name="userbalance",
            index=models.Index(
                fields=["last_transaction_at"], name="payments_us_last_tr_935db2_idx"
            ),
        ),
        migrations.AddConstraint(
            model_name="userbalance",
            constraint=models.CheckConstraint(
                condition=models.Q(("balance_usd__gte", 0.0)), name="balance_non_negative_check"
            ),
        ),
        migrations.AddConstraint(
            model_name="userbalance",
            constraint=models.CheckConstraint(
                condition=models.Q(("reserved_usd__gte", 0.0)), name="reserved_non_negative_check"
            ),
        ),
    ]
