# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231107

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.capacity_management.src.oci_cli_capacity_management.generated import capacity_management_service_cli


@click.command(cli_util.override('demand_signal.demand_signal_root_group.command_name', 'demand-signal'), cls=CommandGroupWithAlias, help=cli_util.override('demand_signal.demand_signal_root_group.help', """OCI Control Center (OCC) Capacity Management enables you to manage capacity requests in realms where OCI Control Center Capacity Management is available. For more information, see [OCI Control Center]."""), short_help=cli_util.override('demand_signal.demand_signal_root_group.short_help', """OCI Control Center Capacity Management API"""))
@cli_util.help_option_group
def demand_signal_root_group():
    pass


@click.command(cli_util.override('demand_signal.occm_demand_signal_item_group.command_name', 'occm-demand-signal-item'), cls=CommandGroupWithAlias, help="""An occm demand signal item is a resource that is used to communicate the forecasting need for a particular resource with OCI. It's a sub-resource and need to be grouped inside a demand signal.""")
@cli_util.help_option_group
def occm_demand_signal_item_group():
    pass


@click.command(cli_util.override('demand_signal.occm_demand_signal_group.command_name', 'occm-demand-signal'), cls=CommandGroupWithAlias, help="""An occm demand signal is a resource that communicates the forecasting needs of a customer to OCI in advance.""")
@cli_util.help_option_group
def occm_demand_signal_group():
    pass


@click.command(cli_util.override('demand_signal.occm_demand_signal_catalog_resource_group.command_name', 'occm-demand-signal-catalog-resource'), cls=CommandGroupWithAlias, help="""A model containing information about the details of a demand signal catalog resource.""")
@cli_util.help_option_group
def occm_demand_signal_catalog_resource_group():
    pass


@click.command(cli_util.override('demand_signal.occm_demand_signal_delivery_collection_group.command_name', 'occm-demand-signal-delivery-collection'), cls=CommandGroupWithAlias, help="""A list containing detailed delivery information about different resource demanded as part of the demand signal.""")
@cli_util.help_option_group
def occm_demand_signal_delivery_collection_group():
    pass


capacity_management_service_cli.capacity_management_service_group.add_command(demand_signal_root_group)
demand_signal_root_group.add_command(occm_demand_signal_item_group)
demand_signal_root_group.add_command(occm_demand_signal_group)
demand_signal_root_group.add_command(occm_demand_signal_catalog_resource_group)
demand_signal_root_group.add_command(occm_demand_signal_delivery_collection_group)


@occm_demand_signal_item_group.command(name=cli_util.override('demand_signal.bulk_create_occm_demand_signal_item.command_name', 'bulk-create'), help=u"""This API will help in bulk creation of demand signal items. This API is atomic i.e either all the demand signal item resources will be created or none will be created. \n[Command Reference](bulkCreateOccmDemandSignalItem)""")
@cli_util.option('--ds-id', required=True, help=u"""The OCID of the demand signal in which we want to bulk create these demand signal item resources.""")
@cli_util.option('--create-items', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of demand signal items that we want to bulk create.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'create-items': {'module': 'capacity_management', 'class': 'list[BulkCreateOccmDemandSignalItem]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'create-items': {'module': 'capacity_management', 'class': 'list[BulkCreateOccmDemandSignalItem]'}})
@cli_util.wrap_exceptions
def bulk_create_occm_demand_signal_item(ctx, from_json, ds_id, create_items):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['demandSignalId'] = ds_id
    _details['createOccmDemandSignalItems'] = cli_util.parse_json_parameter("create_items", create_items)

    client = cli_util.build_client('capacity_management', 'demand_signal', ctx)
    result = client.bulk_create_occm_demand_signal_item(
        bulk_create_occm_demand_signal_item_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@occm_demand_signal_group.command(name=cli_util.override('demand_signal.create_occm_demand_signal.command_name', 'create'), help=u"""This is a post API to create occm demand signal. \n[Command Reference](createOccmDemandSignal)""")
@cli_util.option('--compartment-id', required=True, help=u"""The OCID of the tenancy where we would like to create a demand signal.""")
@cli_util.option('--display-name', required=True, help=u"""The user-friendly name of the demand signal. Does not have to be unique. Avoid entering anything confidential.""")
@cli_util.option('--description', help=u"""A short description of the demand signal.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "ACTIVE", "UPDATING", "DELETED", "DELETING", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'capacity_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'capacity_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'capacity_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'capacity_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'capacity_management', 'class': 'OccmDemandSignal'})
@cli_util.wrap_exceptions
def create_occm_demand_signal(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, display_name, description, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('capacity_management', 'demand_signal', ctx)
    result = client.create_occm_demand_signal(
        create_occm_demand_signal_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_occm_demand_signal') and callable(getattr(client, 'get_occm_demand_signal')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_occm_demand_signal(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@occm_demand_signal_item_group.command(name=cli_util.override('demand_signal.create_occm_demand_signal_item.command_name', 'create'), help=u"""This API will create a demand signal item representing a resource request. This needs to be grouped under a demand signal. \n[Command Reference](createOccmDemandSignalItem)""")
@cli_util.option('--compartment-id', required=True, help=u"""The OCID of the tenancy from which the demand signal item was created.""")
@cli_util.option('--ds-id', required=True, help=u"""The OCID of the demand signal under which we need to create this item.""")
@cli_util.option('--ds-catalog-resource-id', required=True, help=u"""The OCID of the correponding demand signal catalog resource.""")
@cli_util.option('--request-type', required=True, type=custom_types.CliCaseInsensitiveChoice(["DEMAND"]), help=u"""The type of request (DEMAND or RETURN) that you want to make for this demand signal item.""")
@cli_util.option('--region-parameterconflict', required=True, help=u"""The name of region for which you want to request the OCI resource.""")
@cli_util.option('--demand-quantity', required=True, type=click.INT, help=u"""The quantity of the resource that you want to demand from OCI.""")
@cli_util.option('--time-needed-before', required=True, type=custom_types.CLI_DATETIME, help=u"""the date before which you would ideally like the OCI resource to be delivered to you.""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--resource-properties', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""A map of various properties associated with the OCI resource.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--ad', help=u"""The name of the availability domain for which you want to request the OCI resource. This is an optional parameter.""")
@cli_util.option('--target-compartment-id', help=u"""The OCID of the tenancy for which you want to request the OCI resource for. This is an optional parameter.""")
@cli_util.option('--notes', help=u"""This field will serve as notes section for you. You can use this section to convey a message to OCI regarding your resource request.

NOTE: The previous value gets overwritten with the new one for this once updated.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'resource-properties': {'module': 'capacity_management', 'class': 'dict(str, string)'}, 'freeform-tags': {'module': 'capacity_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'capacity_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'resource-properties': {'module': 'capacity_management', 'class': 'dict(str, string)'}, 'freeform-tags': {'module': 'capacity_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'capacity_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'capacity_management', 'class': 'OccmDemandSignalItem'})
@cli_util.wrap_exceptions
def create_occm_demand_signal_item(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, ds_id, ds_catalog_resource_id, request_type, region_parameterconflict, demand_quantity, time_needed_before, resource_properties, ad, target_compartment_id, notes, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['demandSignalId'] = ds_id
    _details['demandSignalCatalogResourceId'] = ds_catalog_resource_id
    _details['requestType'] = request_type
    _details['region'] = region_parameterconflict
    _details['demandQuantity'] = demand_quantity
    _details['timeNeededBefore'] = time_needed_before
    _details['resourceProperties'] = cli_util.parse_json_parameter("resource_properties", resource_properties)

    if ad is not None:
        _details['availabilityDomain'] = ad

    if target_compartment_id is not None:
        _details['targetCompartmentId'] = target_compartment_id

    if notes is not None:
        _details['notes'] = notes

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('capacity_management', 'demand_signal', ctx)
    result = client.create_occm_demand_signal_item(
        create_occm_demand_signal_item_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_occm_demand_signal_item') and callable(getattr(client, 'get_occm_demand_signal_item')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_occm_demand_signal_item(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@occm_demand_signal_group.command(name=cli_util.override('demand_signal.delete_occm_demand_signal.command_name', 'delete'), help=u"""This is a DELETE API which deletes a demand signal with the provided demand signal ocid. \n[Command Reference](deleteOccmDemandSignal)""")
@cli_util.option('--ds-id', required=True, help=u"""The OCID of the demand signal.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "ACTIVE", "UPDATING", "DELETED", "DELETING", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_occm_demand_signal(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, ds_id, if_match):

    if isinstance(ds_id, six.string_types) and len(ds_id.strip()) == 0:
        raise click.UsageError('Parameter --ds-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'demand_signal', ctx)
    result = client.delete_occm_demand_signal(
        occm_demand_signal_id=ds_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_occm_demand_signal') and callable(getattr(client, 'get_occm_demand_signal')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                oci.wait_until(client, client.get_occm_demand_signal(ds_id), 'lifecycle_state', wait_for_state, succeed_on_not_found=True, **wait_period_kwargs)
            except oci.exceptions.ServiceError as e:
                # We make an initial service call so we can pass the result to oci.wait_until(), however if we are waiting on the
                # outcome of a delete operation it is possible that the resource is already gone and so the initial service call
                # will result in an exception that reflects a HTTP 404. In this case, we can exit with success (rather than raising
                # the exception) since this would have been the behaviour in the waiter anyway (as for delete we provide the argument
                # succeed_on_not_found=True to the waiter).
                #
                # Any non-404 should still result in the exception being thrown.
                if e.status == 404:
                    pass
                else:
                    raise
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Please retrieve the resource to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@occm_demand_signal_item_group.command(name=cli_util.override('demand_signal.delete_occm_demand_signal_item.command_name', 'delete'), help=u"""This is a DELETE API which deletes a demand signal item with the provided demand signal item ocid. \n[Command Reference](deleteOccmDemandSignalItem)""")
@cli_util.option('--ds-item-id', required=True, help=u"""The OCID of the demand signal item.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_occm_demand_signal_item(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, ds_item_id, if_match):

    if isinstance(ds_item_id, six.string_types) and len(ds_item_id.strip()) == 0:
        raise click.UsageError('Parameter --ds-item-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'demand_signal', ctx)
    result = client.delete_occm_demand_signal_item(
        occm_demand_signal_item_id=ds_item_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_occm_demand_signal_item') and callable(getattr(client, 'get_occm_demand_signal_item')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                oci.wait_until(client, client.get_occm_demand_signal_item(ds_item_id), 'lifecycle_state', wait_for_state, succeed_on_not_found=True, **wait_period_kwargs)
            except oci.exceptions.ServiceError as e:
                # We make an initial service call so we can pass the result to oci.wait_until(), however if we are waiting on the
                # outcome of a delete operation it is possible that the resource is already gone and so the initial service call
                # will result in an exception that reflects a HTTP 404. In this case, we can exit with success (rather than raising
                # the exception) since this would have been the behaviour in the waiter anyway (as for delete we provide the argument
                # succeed_on_not_found=True to the waiter).
                #
                # Any non-404 should still result in the exception being thrown.
                if e.status == 404:
                    pass
                else:
                    raise
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Please retrieve the resource to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@occm_demand_signal_group.command(name=cli_util.override('demand_signal.get_occm_demand_signal.command_name', 'get'), help=u"""This is a GET API which gets the detailed information about a specific demand signal. \n[Command Reference](getOccmDemandSignal)""")
@cli_util.option('--ds-id', required=True, help=u"""The OCID of the demand signal.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'OccmDemandSignal'})
@cli_util.wrap_exceptions
def get_occm_demand_signal(ctx, from_json, ds_id):

    if isinstance(ds_id, six.string_types) and len(ds_id.strip()) == 0:
        raise click.UsageError('Parameter --ds-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'demand_signal', ctx)
    result = client.get_occm_demand_signal(
        occm_demand_signal_id=ds_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@occm_demand_signal_item_group.command(name=cli_util.override('demand_signal.get_occm_demand_signal_item.command_name', 'get'), help=u"""This is a GET API to get the details of a demand signal item resource representing the details of the resource demanded by you. \n[Command Reference](getOccmDemandSignalItem)""")
@cli_util.option('--ds-item-id', required=True, help=u"""The OCID of the demand signal item.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'OccmDemandSignalItem'})
@cli_util.wrap_exceptions
def get_occm_demand_signal_item(ctx, from_json, ds_item_id):

    if isinstance(ds_item_id, six.string_types) and len(ds_item_id.strip()) == 0:
        raise click.UsageError('Parameter --ds-item-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'demand_signal', ctx)
    result = client.get_occm_demand_signal_item(
        occm_demand_signal_item_id=ds_item_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@occm_demand_signal_catalog_resource_group.command(name=cli_util.override('demand_signal.list_occm_demand_signal_catalog_resources.command_name', 'list'), help=u"""This API will list all the  resources across all demand signal catalogs for a given namespace and customer group containing the caller compartment. \n[Command Reference](listOccmDemandSignalCatalogResources)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.""")
@cli_util.option('--name', help=u"""A query parameter to filter the list of demand signal catalog resource based on the resource name.""")
@cli_util.option('--namespace', type=custom_types.CliCaseInsensitiveChoice(["COMPUTE", "NETWORK", "GPU", "STORAGE"]), help=u"""A query parameter to filter the list of demand signal catalog resources based on the namespace.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["name"]), help=u"""The field to sort the response of List Demand catalog resources API. Only one sort order may be provided. The default order for name is case sensitive alphabetical order.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'OccmDemandSignalCatalogResourceCollection'})
@cli_util.wrap_exceptions
def list_occm_demand_signal_catalog_resources(ctx, from_json, all_pages, page_size, compartment_id, name, namespace, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if name is not None:
        kwargs['name'] = name
    if namespace is not None:
        kwargs['demand_signal_namespace'] = namespace
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'demand_signal', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_occm_demand_signal_catalog_resources,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_occm_demand_signal_catalog_resources,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_occm_demand_signal_catalog_resources(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@occm_demand_signal_delivery_collection_group.command(name=cli_util.override('demand_signal.list_occm_demand_signal_deliveries.command_name', 'list'), help=u"""This GET call is used to list all demand signals delivery resources within the compartment passed as a query param. \n[Command Reference](listOccmDemandSignalDeliveries)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.""")
@cli_util.option('--id', help=u"""A query parameter to filter the list of demand signals based on it's OCID.""")
@cli_util.option('--ds-item-id', help=u"""A query parameter to filter the list of demand signal items based on it's OCID.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["resourceName"]), help=u"""The field to sort the response of List Demand Signal Delivery API. Only one sort order may be provided. The default order for resource name is case sensitive alphabetical order.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'OccmDemandSignalDeliveryCollection'})
@cli_util.wrap_exceptions
def list_occm_demand_signal_deliveries(ctx, from_json, all_pages, page_size, compartment_id, id, ds_item_id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if id is not None:
        kwargs['id'] = id
    if ds_item_id is not None:
        kwargs['occm_demand_signal_item_id'] = ds_item_id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'demand_signal', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_occm_demand_signal_deliveries,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_occm_demand_signal_deliveries,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_occm_demand_signal_deliveries(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@occm_demand_signal_item_group.command(name=cli_util.override('demand_signal.list_occm_demand_signal_items.command_name', 'list'), help=u"""This API will list the detailed information about the resources demanded as part of the demand signal. \n[Command Reference](listOccmDemandSignalItems)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.""")
@cli_util.option('--ds-id', help=u"""A query parameter to filter the list of demand signal items based on a demand signal id.""")
@cli_util.option('--resource-name', help=u"""A query parameter to filter the list of demand signal details based on the resource name.""")
@cli_util.option('--namespace', type=custom_types.CliCaseInsensitiveChoice(["COMPUTE", "NETWORK", "GPU", "STORAGE"]), help=u"""A query parameter to filter the list of demand signal details based on the namespace.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["resourceName"]), help=u"""The field to sort the response of List Demand Signal Details API. Only one sort order may be provided. The default order for resource name is case sensitive alphabetical order.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'OccmDemandSignalItemCollection'})
@cli_util.wrap_exceptions
def list_occm_demand_signal_items(ctx, from_json, all_pages, page_size, compartment_id, ds_id, resource_name, namespace, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if ds_id is not None:
        kwargs['occm_demand_signal_id'] = ds_id
    if resource_name is not None:
        kwargs['resource_name'] = resource_name
    if namespace is not None:
        kwargs['demand_signal_namespace'] = namespace
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'demand_signal', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_occm_demand_signal_items,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_occm_demand_signal_items,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_occm_demand_signal_items(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@occm_demand_signal_group.command(name=cli_util.override('demand_signal.list_occm_demand_signals.command_name', 'list'), help=u"""This GET call is used to list all demand signals within the compartment passed as a query parameter. \n[Command Reference](listOccmDemandSignals)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.""")
@cli_util.option('--id', help=u"""A query parameter to filter the list of demand signals based on it's OCID.""")
@cli_util.option('--lifecycle-details', help=u"""A query parameter to filter the list of demand signals based on its state.""")
@cli_util.option('--display-name', help=u"""A filter to return only the resources that match the entire display name. The match is not case sensitive.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort the response of List Demand Signal API. Only one sort order may be provided. The default order for timeCreated is reverse chronological order (latest date at the top). The default order for displayName is case sensitive alphabetical order.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'OccmDemandSignalCollection'})
@cli_util.wrap_exceptions
def list_occm_demand_signals(ctx, from_json, all_pages, page_size, compartment_id, id, lifecycle_details, display_name, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if id is not None:
        kwargs['id'] = id
    if lifecycle_details is not None:
        kwargs['lifecycle_details'] = lifecycle_details
    if display_name is not None:
        kwargs['display_name'] = display_name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'demand_signal', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_occm_demand_signals,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_occm_demand_signals,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_occm_demand_signals(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@occm_demand_signal_group.command(name=cli_util.override('demand_signal.update_occm_demand_signal.command_name', 'update'), help=u"""This is a PUT API which shall be used to update the metadata of the demand signal. \n[Command Reference](updateOccmDemandSignal)""")
@cli_util.option('--ds-id', required=True, help=u"""The OCID of the demand signal.""")
@cli_util.option('--display-name', help=u"""Use this field to update the display name of the demand signal""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--description', help=u"""Use this field to update the description of the demand signal.""")
@cli_util.option('--lifecycle-details', type=custom_types.CliCaseInsensitiveChoice(["SUBMITTED"]), help=u"""The subset of demand signal states available for updating the demand signal.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "ACTIVE", "UPDATING", "DELETED", "DELETING", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'capacity_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'capacity_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'capacity_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'capacity_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'capacity_management', 'class': 'OccmDemandSignal'})
@cli_util.wrap_exceptions
def update_occm_demand_signal(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, ds_id, display_name, freeform_tags, defined_tags, description, lifecycle_details, if_match):

    if isinstance(ds_id, six.string_types) and len(ds_id.strip()) == 0:
        raise click.UsageError('Parameter --ds-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if description is not None:
        _details['description'] = description

    if lifecycle_details is not None:
        _details['lifecycleDetails'] = lifecycle_details

    client = cli_util.build_client('capacity_management', 'demand_signal', ctx)
    result = client.update_occm_demand_signal(
        occm_demand_signal_id=ds_id,
        update_occm_demand_signal_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_occm_demand_signal') and callable(getattr(client, 'get_occm_demand_signal')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_occm_demand_signal(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@occm_demand_signal_item_group.command(name=cli_util.override('demand_signal.update_occm_demand_signal_item.command_name', 'update'), help=u"""This is a PUT API which can be used to update the demand signal item resource. \n[Command Reference](updateOccmDemandSignalItem)""")
@cli_util.option('--ds-item-id', required=True, help=u"""The OCID of the demand signal item.""")
@cli_util.option('--region-parameterconflict', help=u"""The region for which you want to request the resource for.""")
@cli_util.option('--ad', help=u"""The name of the availability domain for which you want to request the OCI resource.""")
@cli_util.option('--target-compartment-id', help=u"""The OCID of the tenancy for which you want to request the OCI resource for.""")
@cli_util.option('--demand-quantity', type=click.INT, help=u"""The quantity of the resource that you want to demand from OCI.""")
@cli_util.option('--time-needed-before', type=custom_types.CLI_DATETIME, help=u"""the date before which you would ideally like the OCI resource to be delivered to you.""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--resource-properties', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A map of various properties associated with the OCI resource. This parameter will act as a replace parameter i.e the existing resource properties will be overridden by this update.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--notes', help=u"""This field will serve as notes section for you. You can use this section to convey a message to OCI regarding your resource request.

NOTE: The previous value gets overwritten with the new one for this once updated.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'resource-properties': {'module': 'capacity_management', 'class': 'dict(str, string)'}, 'freeform-tags': {'module': 'capacity_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'capacity_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'resource-properties': {'module': 'capacity_management', 'class': 'dict(str, string)'}, 'freeform-tags': {'module': 'capacity_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'capacity_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'capacity_management', 'class': 'OccmDemandSignalItem'})
@cli_util.wrap_exceptions
def update_occm_demand_signal_item(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, ds_item_id, region_parameterconflict, ad, target_compartment_id, demand_quantity, time_needed_before, resource_properties, notes, freeform_tags, defined_tags, if_match):

    if isinstance(ds_item_id, six.string_types) and len(ds_item_id.strip()) == 0:
        raise click.UsageError('Parameter --ds-item-id cannot be whitespace or empty string')
    if not force:
        if resource_properties or freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to resource-properties and freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if region_parameterconflict is not None:
        _details['region'] = region_parameterconflict

    if ad is not None:
        _details['availabilityDomain'] = ad

    if target_compartment_id is not None:
        _details['targetCompartmentId'] = target_compartment_id

    if demand_quantity is not None:
        _details['demandQuantity'] = demand_quantity

    if time_needed_before is not None:
        _details['timeNeededBefore'] = time_needed_before

    if resource_properties is not None:
        _details['resourceProperties'] = cli_util.parse_json_parameter("resource_properties", resource_properties)

    if notes is not None:
        _details['notes'] = notes

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('capacity_management', 'demand_signal', ctx)
    result = client.update_occm_demand_signal_item(
        occm_demand_signal_item_id=ds_item_id,
        update_occm_demand_signal_item_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_occm_demand_signal_item') and callable(getattr(client, 'get_occm_demand_signal_item')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_occm_demand_signal_item(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)
