# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.multicloud.src.oci_cli_multicloud.generated import multicloud_service_cli


@click.command(cli_util.override('metadata.metadata_root_group.command_name', 'metadata'), cls=CommandGroupWithAlias, help=cli_util.override('metadata.metadata_root_group.help', """Use the Oracle Multicloud API to retrieve resource anchors and network anchors, and the metadata mappings related a Cloud Service Provider. For more information, see <link to docs>."""), short_help=cli_util.override('metadata.metadata_root_group.short_help', """Oracle Multicloud API"""))
@cli_util.help_option_group
def metadata_root_group():
    pass


@click.command(cli_util.override('metadata.external_location_summaries_metadatum_summary_collection_group.command_name', 'external-location-summaries-metadatum-summary-collection'), cls=CommandGroupWithAlias, help="""External location summary information from OCI primitives to any CSP across all regions""")
@cli_util.help_option_group
def external_location_summaries_metadatum_summary_collection_group():
    pass


@click.command(cli_util.override('metadata.external_location_mapping_metadatum_summary_collection_group.command_name', 'external-location-mapping-metadatum-summary-collection'), cls=CommandGroupWithAlias, help="""External location information from OCI primitives to a CSP""")
@cli_util.help_option_group
def external_location_mapping_metadatum_summary_collection_group():
    pass


@click.command(cli_util.override('metadata.external_locations_metadatum_collection_group.command_name', 'external-locations-metadatum-collection'), cls=CommandGroupWithAlias, help="""External location information from OCI primitives to any CSP""")
@cli_util.help_option_group
def external_locations_metadatum_collection_group():
    pass


multicloud_service_cli.multicloud_service_group.add_command(metadata_root_group)
metadata_root_group.add_command(external_location_summaries_metadatum_summary_collection_group)
metadata_root_group.add_command(external_location_mapping_metadatum_summary_collection_group)
metadata_root_group.add_command(external_locations_metadatum_collection_group)


@external_locations_metadatum_collection_group.command(name=cli_util.override('metadata.list_external_location_details_metadata.command_name', 'list-external-location-details-metadata'), help=u"""List externalLocationDetail metadata from OCI to Cloud  Service Provider for regions, Availability Zones, and Cluster Placement Group ID. examples:   application-json: |     [       {           \"externalLocation\": {             \"cspRegion\": \"East US\",             \"cspPhysicalAz\": \"az1-xyz\",             \"cspPhysicalAzDisplayName\": \"(US) East US 2\",             \"cspLogicalAz\": \"az1\",             \"serviceName\": \"ORACLEDBATAZURE\",             \"cspZoneKeyReferenceId\": {               \"keyName\": \"AzureSubscriptionId or AwsAccountId, GcpProjectName\",               \"keyValue\": \"azure-subscriptionId-1 or aws-account-id-1, gcp-project-id-1\"             }           },           \"ociPhysicalAd\": \"ad1-xyb\",           \"ociLogicalAd\": \"ad2\",           \"ociRegion\": \"us-ashburn-1\",           \"cpgId\": \"cpg-1\"       },         {           \"externalLocation\": {             \"cspRegion\": \"East US\",             \"cspPhysicalAz\": \"az2-abc\",             \"cspPhysicalAzDisplayName\": \"(US) East US 2\",             \"cspLogicalAz\": \"az2\",             \"serviceName\": \"ORACLEDBATAZURE\",             \"cspZoneKeyReferenceId\": {               \"keyName\": \"AzureSubscriptionId or AwsAccountId, GcpProjectName\",               \"keyValue\": \"azure-subscriptionId-2 or aws-account-id-2, gcp-project-id-2\"             }           },           \"ociPhysicalAd\": \"ad2-xby\",           \"ociLogicalAd\": \"ad1\",           \"ociRegion\": \"us-ashburn-1\",           \"cpgId\": \"cpg-2\"         },         {           \"externalLocation\": {             \"cspRegion\": \"East US\",             \"cspPhysicalAz\": \"az3-abz\",             \"cspPhysicalAzDisplayName\": \"(US) East US 2\",             \"cspLogicalAz\": \"az3\",             \"serviceName\": \"ORACLEDBATAZURE\",             \"cspZoneKeyReferenceId\": {               \"keyName\": \"AzureSubscriptionId or AwsAccountId, GcpProjectName\",               \"keyValue\": \"azure-subscriptionId-3 or aws-account-id-3, gcp-project-id-3\"             }           },           \"ociPhysicalAd\": \"ad3-cde\",           \"ociLogicalAd\": \"ad3\",           \"ociRegion\": \"us-ashburn-1\",           \"cpgId\": \"cpg-3\"         },         {           \"externalLocation\": {             \"cspRegion\": \"East US 2\",             \"cspPhysicalAz\": \"az1-def\",             \"cspPhysicalAzDisplayName\": \"(US) East US 2\",             \"cspLogicalAz\": \"az1\",             \"serviceName\": \"ORACLEDBATAZURE\",             \"cspZoneKeyReferenceId\": {               \"keyName\": \"AzureSubscriptionId or AwsAccountId, GcpProjectName\",               \"keyValue\": \"azure-subscriptionId-4 or aws-account-id-4, gcp-project-id-4\"             }           },           \"ociPhysicalAd\": \"ad1-bce\",           \"ociLogicalAd\": \"ad2\",           \"ociRegion\": \"us-ashburn-1\",           \"cpgId\": \"cpg-4\"         },         {           \"externalLocation\": {             \"cspRegion\": \"East US 2\",             \"cspPhysicalAz\": \"az2-uvw\",             \"cspPhysicalAzDisplayName\": \"(US) East US 2\",             \"cspLogicalAz\": \"az2\",             \"serviceName\": \"ORACLEDBATAZURE\",             \"cspZoneKeyReferenceId\": {               \"keyName\": \"AzureSubscriptionId or AwsAccountId, GcpProjectName\",               \"keyValue\": \"azure-subscriptionId-3 or aws-account-id-3, gcp-project-id-3\"             }           },           \"ociPhysicalAd\": \"ad2-ftc\",           \"ociLogicalAd\": \"ad1\",           \"ociRegion\": \"us-ashburn-1\",           \"cpgId\": \"cpg-5\"         },         {           \"externalLocation\": {             \"cspRegion\": \"East US 2\",             \"cspPhysicalAz\": \"az3-uvw\",             \"cspPhysicalAzDisplayName\": \"(US) East US 2\",             \"cspLogicalAz\": \"az3\",             \"serviceName\": \"ORACLEDBATAZURE\",             \"cspZoneKeyReferenceId\": {               \"keyName\": \"AzureSubscriptionId or AwsAccountId, GcpProjectName\",               \"keyValue\": \"azure-subscriptionId-3 or aws-account-id-3, gcp-project-id-3\"             }           },           \"ociPhysicalAd\": \"ad3-stc\",           \"ociLogicalAd\": \"ad3\",           \"ociRegion\": \"us-ashburn-1\",           \"cpgId\": \"cpg-6\"         }       ] \n[Command Reference](listExternalLocationDetailsMetadata)""")
@cli_util.option('--subscription-id', required=True, help=u"""The [OCID] of the subscription in which to list resources.""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment in which to list resources.""")
@cli_util.option('--subscription-service-name', required=True, type=custom_types.CliCaseInsensitiveChoice(["ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS"]), help=u"""The subscription service name values from [ORACLEDBATAZURE, ORACLEDBATGOOGLE, ORACLEDBATAWS]""")
@cli_util.option('--entity-type', type=custom_types.CliCaseInsensitiveChoice(["dbsystem"]), help=u"""The resource type query (i.e. dbsystem, instance etc.)""")
@cli_util.option('--linked-compartment-id', help=u"""The [OCID] of the compartment in which linked to Resource.""")
@cli_util.option('--limit', type=click.INT, help=u"""For list pagination. The maximum number of results per page, or items to return in a paginated \"List\" call. For important details about how pagination works, see [List Pagination].""")
@cli_util.option('--page', help=u"""For list pagination. The value of the opc-next-page response header from the previous \"List\" call. For important details about how pagination works, see [List Pagination].""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either ascending (`ASC`) or descending (`DESC`).""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. You can provide only one sort order. Default order for `timeCreated` is descending. Default order for `displayName` is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'multicloud', 'class': 'ExternalLocationsMetadatumCollection'})
@cli_util.wrap_exceptions
def list_external_location_details_metadata(ctx, from_json, all_pages, page_size, subscription_id, compartment_id, subscription_service_name, entity_type, linked_compartment_id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if entity_type is not None:
        kwargs['entity_type'] = entity_type
    if linked_compartment_id is not None:
        kwargs['linked_compartment_id'] = linked_compartment_id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('multicloud', 'metadata', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_external_location_details_metadata,
            subscription_id=subscription_id,
            compartment_id=compartment_id,
            subscription_service_name=subscription_service_name,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_external_location_details_metadata,
            limit,
            page_size,
            subscription_id=subscription_id,
            compartment_id=compartment_id,
            subscription_service_name=subscription_service_name,
            **kwargs
        )
    else:
        result = client.list_external_location_details_metadata(
            subscription_id=subscription_id,
            compartment_id=compartment_id,
            subscription_service_name=subscription_service_name,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@external_location_mapping_metadatum_summary_collection_group.command(name=cli_util.override('metadata.list_external_location_mapping_metadata.command_name', 'list-external-location-mapping-metadata'), help=u"""List externalLocation metadata from OCI to the Cloud Service Provider for regions, Physical Availability Zones. examples:   application-json: |     [       {         \"externalLocation\": {           \"cspRegion\": \"eastus\",           \"cspPhysicalAz\": \"eastus-az1\",           \"cspPhysicalAzDisplayName\": \"(US) East US 1\",           \"serviceName\": \"ORACLEDBATAZURE\"         },         \"ociPhysicalAd\": \"iad-ad-1\",         \"ociLogicalAd\": \"ad1\",         \"ociRegion\": \"us-ashburn-1\"     },       {         \"externalLocation\": {           \"cspRegion\": \"eastus\",           \"cspPhysicalAz\": \"eastus-az1\",           \"cspPhysicalAzDisplayName\": \"(US) East US 1\",           \"serviceName\": \"ORACLEDBATAZURE\"         },         \"ociPhysicalAd\": \"iad-ad-1\",         \"ociLogicalAd\": \"ad1\",         \"ociRegion\": \"us-ashburn-1\"       },       {         \"externalLocation\": {           \"cspRegion\": \"eastus2\",           \"cspPhysicalAz\": \"eastus2-az3\",           \"cspPhysicalAzDisplayName\": \"(US) East US 1\",           \"serviceName\": \"ORACLEDBATAZURE\"         },         \"ociPhysicalAd\": \"iad-ad-2\",         \"ociLogicalAd\": \"ad1\",         \"ociRegion\": \"us-ashburn-1\"       },       {         \"externalLocation\": {           \"cspRegion\": \"eastus\",           \"cspPhysicalAz\": \"eastus-az3\"           \"cspPhysicalAzDisplayName\": \"(US) East US 1\",           \"serviceName\": \"ORACLEDBATAZURE\"         },         \"ociPhysicalAd\": \"iad-ad-333\",         \"ociLogicalAd\": \"ad1\",         \"ociRegion\": \"us-ashburn-1\"       }     ] \n[Command Reference](listExternalLocationMappingMetadata)""")
@cli_util.option('--subscription-service-name', required=True, type=custom_types.CliCaseInsensitiveChoice(["ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS"]), multiple=True, help=u"""The subscription type values from [ORACLEDBATAZURE, ORACLEDBATGOOGLE, ORACLEDBATAWS]""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment in which to list resources.""")
@cli_util.option('--subscription-id', help=u"""The [OCID] of the subscription in which to list resources.""")
@cli_util.option('--limit', type=click.INT, help=u"""For list pagination. The maximum number of results per page, or items to return in a paginated \"List\" call. For important details about how pagination works, see [List Pagination].""")
@cli_util.option('--page', help=u"""For list pagination. The value of the opc-next-page response header from the previous \"List\" call. For important details about how pagination works, see [List Pagination].""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either ascending (`ASC`) or descending (`DESC`).""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. You can provide only one sort order. Default order for `timeCreated` is descending. Default order for `displayName` is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'multicloud', 'class': 'ExternalLocationMappingMetadatumSummaryCollection'})
@cli_util.wrap_exceptions
def list_external_location_mapping_metadata(ctx, from_json, all_pages, page_size, subscription_service_name, compartment_id, subscription_id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if subscription_id is not None:
        kwargs['subscription_id'] = subscription_id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('multicloud', 'metadata', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_external_location_mapping_metadata,
            subscription_service_name=subscription_service_name,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_external_location_mapping_metadata,
            limit,
            page_size,
            subscription_service_name=subscription_service_name,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_external_location_mapping_metadata(
            subscription_service_name=subscription_service_name,
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@external_location_summaries_metadatum_summary_collection_group.command(name=cli_util.override('metadata.list_external_location_summaries_metadata.command_name', 'list-external-location-summaries-metadata'), help=u"""List externalLocationSummary metadata from OCI Region to the Cloud Service Provider region across all regions. examples:   application-json: |     [       {           \"externalLocation\": {             \"cspRegion\": \"East US\"           },           \"ociRegion\": \"us-ashburn-1\"       },         {           \"externalLocation\": {             \"cspRegion\": \"East US 2\"           },           \"ociRegion\": \"us-ashburn-1\"         },         {           \"externalLocation\": {             \"cspRegion\": \"Germany West Central\"           },           \"ociRegion\": \"eu-frankfurt-1\",         }       ] \n[Command Reference](listExternalLocationSummariesMetadata)""")
@cli_util.option('--subscription-service-name', required=True, type=custom_types.CliCaseInsensitiveChoice(["ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS"]), help=u"""The subscription service name values from [ORACLEDBATAZURE, ORACLEDBATGOOGLE, ORACLEDBATAWS]""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment in which to list resources.""")
@cli_util.option('--subscription-id', help=u"""The [OCID] of the subscription in which to list resources.""")
@cli_util.option('--entity-type', type=custom_types.CliCaseInsensitiveChoice(["dbsystem"]), help=u"""The resource type query (i.e. dbsystem, instance etc.)""")
@cli_util.option('--limit', type=click.INT, help=u"""For list pagination. The maximum number of results per page, or items to return in a paginated \"List\" call. For important details about how pagination works, see [List Pagination].""")
@cli_util.option('--page', help=u"""For list pagination. The value of the opc-next-page response header from the previous \"List\" call. For important details about how pagination works, see [List Pagination].""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either ascending (`ASC`) or descending (`DESC`).""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. You can provide only one sort order. Default order for `timeCreated` is descending. Default order for `displayName` is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'multicloud', 'class': 'ExternalLocationSummariesMetadatumSummaryCollection'})
@cli_util.wrap_exceptions
def list_external_location_summaries_metadata(ctx, from_json, all_pages, page_size, subscription_service_name, compartment_id, subscription_id, entity_type, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if subscription_id is not None:
        kwargs['subscription_id'] = subscription_id
    if entity_type is not None:
        kwargs['entity_type'] = entity_type
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('multicloud', 'metadata', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_external_location_summaries_metadata,
            subscription_service_name=subscription_service_name,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_external_location_summaries_metadata,
            limit,
            page_size,
            subscription_service_name=subscription_service_name,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_external_location_summaries_metadata(
            subscription_service_name=subscription_service_name,
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)
