# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.multicloud.src.oci_cli_multicloud.generated import multicloud_service_cli


@click.command(cli_util.override('multi_clouds_metadata.multi_clouds_metadata_root_group.command_name', 'multi-clouds-metadata'), cls=CommandGroupWithAlias, help=cli_util.override('multi_clouds_metadata.multi_clouds_metadata_root_group.help', """Use the Oracle Multicloud API to retrieve resource anchors and network anchors, and the metadata mappings related a Cloud Service Provider. For more information, see <link to docs>."""), short_help=cli_util.override('multi_clouds_metadata.multi_clouds_metadata_root_group.short_help', """Oracle Multicloud API"""))
@cli_util.help_option_group
def multi_clouds_metadata_root_group():
    pass


@click.command(cli_util.override('multi_clouds_metadata.multi_cloud_metadata_collection_group.command_name', 'multi-cloud-metadata-collection'), cls=CommandGroupWithAlias, help="""Multicloud metadata information across clouds.""")
@cli_util.help_option_group
def multi_cloud_metadata_collection_group():
    pass


@click.command(cli_util.override('multi_clouds_metadata.multi_cloud_metadata_group.command_name', 'multi-cloud-metadata'), cls=CommandGroupWithAlias, help="""Multicloud metadata information including base multicloud compartments information.""")
@cli_util.help_option_group
def multi_cloud_metadata_group():
    pass


multicloud_service_cli.multicloud_service_group.add_command(multi_clouds_metadata_root_group)
multi_clouds_metadata_root_group.add_command(multi_cloud_metadata_collection_group)
multi_clouds_metadata_root_group.add_command(multi_cloud_metadata_group)


@multi_cloud_metadata_group.command(name=cli_util.override('multi_clouds_metadata.get_multi_cloud_metadata.command_name', 'get'), help=u"""Gets information about multicloud base compartment \n[Command Reference](getMultiCloudMetadata)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment in which to list resources.""")
@cli_util.option('--subscription-id', required=True, help=u"""The [OCID] of the OCI subscription.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'multicloud', 'class': 'MultiCloudMetadata'})
@cli_util.wrap_exceptions
def get_multi_cloud_metadata(ctx, from_json, compartment_id, subscription_id):

    if isinstance(subscription_id, six.string_types) and len(subscription_id.strip()) == 0:
        raise click.UsageError('Parameter --subscription-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('multicloud', 'multi_clouds_metadata', ctx)
    result = client.get_multi_cloud_metadata(
        compartment_id=compartment_id,
        subscription_id=subscription_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@multi_cloud_metadata_collection_group.command(name=cli_util.override('multi_clouds_metadata.list_multi_cloud_metadata.command_name', 'list-multi-cloud-metadata'), help=u"""Gets a list of multicloud metadata with multicloud base compartment and subscription across Cloud Service Providers. \n[Command Reference](listMultiCloudMetadata)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment in which to list resources.""")
@cli_util.option('--limit', type=click.INT, help=u"""For list pagination. The maximum number of results per page, or items to return in a paginated \"List\" call. For important details about how pagination works, see [List Pagination].""")
@cli_util.option('--page', help=u"""For list pagination. The value of the opc-next-page response header from the previous \"List\" call. For important details about how pagination works, see [List Pagination].""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either ascending (`ASC`) or descending (`DESC`).""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. You can provide only one sort order. Default order for `timeCreated` is descending. Default order for `displayName` is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'multicloud', 'class': 'MultiCloudMetadataCollection'})
@cli_util.wrap_exceptions
def list_multi_cloud_metadata(ctx, from_json, all_pages, page_size, compartment_id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('multicloud', 'multi_clouds_metadata', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_multi_cloud_metadata,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_multi_cloud_metadata,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_multi_cloud_metadata(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)
