# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241101

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.wlms.src.oci_cli_wlms.generated import wlms_service_cli


@click.command(cli_util.override('weblogic_management_service_configuration.weblogic_management_service_configuration_root_group.command_name', 'weblogic-management-service-configuration'), cls=CommandGroupWithAlias, help=cli_util.override('weblogic_management_service_configuration.weblogic_management_service_configuration_root_group.help', """WebLogic Management Service is an OCI service that enables a unified view and management of WebLogic domains
in Oracle Cloud Infrastructure. Features include on-demand patching of WebLogic domains, rollback of the
last applied patch, discovery and management of WebLogic instances on a compute host."""), short_help=cli_util.override('weblogic_management_service_configuration.weblogic_management_service_configuration_root_group.short_help', """WebLogic Management Service API"""))
@cli_util.help_option_group
def weblogic_management_service_configuration_root_group():
    pass


@click.command(cli_util.override('weblogic_management_service_configuration.configuration_group.command_name', 'configuration'), cls=CommandGroupWithAlias, help="""The configuration for service.""")
@cli_util.help_option_group
def configuration_group():
    pass


wlms_service_cli.wlms_service_group.add_command(weblogic_management_service_configuration_root_group)
weblogic_management_service_configuration_root_group.add_command(configuration_group)


@configuration_group.command(name=cli_util.override('weblogic_management_service_configuration.get_configuration.command_name', 'get'), help=u"""Gets service configuration. \n[Command Reference](getConfiguration)""")
@cli_util.option('--compartment-id', required=True, help=u"""The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'Configuration'})
@cli_util.wrap_exceptions
def get_configuration(ctx, from_json, compartment_id):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service_configuration', ctx)
    result = client.get_configuration(
        compartment_id=compartment_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@configuration_group.command(name=cli_util.override('weblogic_management_service_configuration.update_configuration.command_name', 'update'), help=u"""Updates service configuration. \n[Command Reference](updateConfiguration)""")
@cli_util.option('--compartment-id', required=True, help=u"""The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.""")
@cli_util.option('--discovery-interval', type=click.INT, help=u"""Frequency of domain discovery to be run on the service. The unit is in hours.""")
@cli_util.option('--domain-search-paths', type=custom_types.CLI_COMPLEX_TYPE, help=u"""The whitelisted paths which domain discovery are run against.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the ETag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the ETag you provide matches the resource's current ETag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@json_skeleton_utils.get_cli_json_input_option({'domain-search-paths': {'module': 'wlms', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'domain-search-paths': {'module': 'wlms', 'class': 'list[string]'}}, output_type={'module': 'wlms', 'class': 'Configuration'})
@cli_util.wrap_exceptions
def update_configuration(ctx, from_json, force, compartment_id, discovery_interval, domain_search_paths, if_match):
    if not force:
        if domain_search_paths:
            if not click.confirm("WARNING: Updates to domain-search-paths will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if discovery_interval is not None:
        _details['discoveryInterval'] = discovery_interval

    if domain_search_paths is not None:
        _details['domainSearchPaths'] = cli_util.parse_json_parameter("domain_search_paths", domain_search_paths)

    client = cli_util.build_client('wlms', 'weblogic_management_service_configuration', ctx)
    result = client.update_configuration(
        compartment_id=compartment_id,
        update_configuration_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)
