function GetOciTopLevelCommand_opsi() {
    return 'opsi'
}

function GetOciSubcommands_opsi() {
    $ociSubcommands = @{
        'opsi' = 'awr-hub-objects awr-hub-sources awr-hubs database-insights enterprise-manager-bridges exadata-insights host-insights news-reports operations-insights-warehouse-users operations-insights-warehouses opsi-configurations opsi-data-objects opsi-private-endpoint opsi-warehouse-data-objects work-requests'
        'opsi awr-hub-objects' = 'delete get head list put'
        'opsi awr-hub-sources' = 'change create delete disable enable get list update'
        'opsi awr-hubs' = 'create delete get get-awr-database-report get-awr-database-sql-report get-awr-report list list-awr-database-snapshots list-awr-databases list-awr-snapshots summarize-awr-database-cpu-usages summarize-awr-database-metrics summarize-awr-database-parameter-changes summarize-awr-database-parameters summarize-awr-database-snapshot-ranges summarize-awr-database-sysstats summarize-awr-database-top-wait-events summarize-awr-database-wait-event-buckets summarize-awr-database-wait-events summarize-awr-sources-summaries update'
        'opsi database-insights' = 'change change-autonomous-database-insight-advanced-features-credential-by-iam change-autonomous-database-insight-advanced-features-credential-by-vault change-external-mysql change-macs-managed-autonomous-database-insight-connection-credential-by-named-credentials change-macs-managed-autonomous-database-insight-connection-credential-by-vault change-macs-managed-autonomous-database-insight-connection-credentials-by-source change-macs-managed-cloud-database-insight-connection-credential-by-iam change-macs-managed-cloud-database-insight-connection-credential-by-named-credentials change-macs-managed-cloud-database-insight-connection-credential-by-vault change-pe-comanaged-database-detail create-autonomous-database create-em-external-db create-external-mysql-database-insight create-macs-managed-autonomous-database-insight create-macs-managed-cloud-database-insight create-mds-my-sql-database create-pe-comanged-database delete disable disable-autonomous-database-insight-advanced-features enable-autonomous-database enable-autonomous-database-insight-advanced-features-credential-by-iam enable-autonomous-database-insight-advanced-features-credential-by-vault enable-em-external-db enable-external-mysql-database-insight enable-macs-managed-autonomous-database-insight enable-macs-managed-cloud-database-insight enable-mds-my-sql-database enable-pe-comanaged-database get ingest-addm-reports ingest-database-configuration ingest-my-sql-sql-stats ingest-my-sql-sql-text ingest-sql-bucket ingest-sql-plan-lines ingest-sql-stats ingest-sql-text list list-addm-db-finding-categories list-addm-db-findings-time-series list-addm-db-parameter-categories list-addm-db-recommendation-categories list-addm-db-recommendations-time-series list-addm-dbs list-database-configurations list-sql-plans list-sql-searches list-sql-texts summarize-addm-db-findings summarize-addm-db-parameter-changes summarize-addm-db-parameters summarize-addm-db-recommendations summarize-addm-db-schema-objects summarize-addm-db-sql-statements summarize-database-insight-resource-capacity-trend summarize-database-insight-resource-forecast-trend summarize-database-insight-resource-statistics summarize-database-insight-resource-usage summarize-database-insight-resource-usage-trend summarize-database-insight-resource-utilization-insight summarize-database-insight-tablespace-usage-trend summarize-sql-insights summarize-sql-plan-insights summarize-sql-response-time-distributions summarize-sql-statistics summarize-sql-statistics-time-series summarize-sql-statistics-time-series-by-plan synchronize-autonomous-database-to-exadata test-macs-managed-autonomous-database-insight-connection-credential-by-named-credentials test-macs-managed-cloud-database-insight-connection-credential-by-iam test-macs-managed-cloud-database-insight-connection-credential-by-vault update-autonomous-db update-em-external-db update-external-mysql-database-insight update-macs-external-db update-macs-managed-autonomous-database-insight update-macs-managed-cloud-database-insight update-mds-my-sql-database update-pe-comanaged-database'
        'opsi enterprise-manager-bridges' = 'change create delete get list list-importable-enterprise-manager-entities update'
        'opsi exadata-insights' = 'add-em-external-exadata-members add-macs-managed-cloud-exadata-insight-members add-pe-comanaged-exadata-members change create-em-external-exadata create-macs-managed-cloud-exadata-insight create-pe-comanaged-exadata delete disable enable-em-external-exadata enable-macs-managed-cloud-exadata-insight enable-pe-comanaged-exadata get list list-exadata-configurations summarize-exadata-insight-resource-capacity-trend summarize-exadata-insight-resource-capacity-trend-aggregated summarize-exadata-insight-resource-forecast-trend summarize-exadata-insight-resource-forecast-trend-aggregated summarize-exadata-insight-resource-statistics summarize-exadata-insight-resource-usage summarize-exadata-insight-resource-usage-aggregated summarize-exadata-insight-resource-utilization-insight summarize-exadata-members update-em-external-exadata update-macs-managed-cloud-exadata-insight update-pe-comanaged-exadata'
        'opsi host-insights' = 'change create-em-external-host create-macs-cloud-host create-macs-external-host delete disable enable-em-external-host enable-macs-cloud-host enable-macs-external-host get ingest-host-configuration ingest-host-metrics list list-host-configurations list-hosted-entities list-importable-agent-entities list-macs-cloud-hosts summarize-disk-statistics summarize-host-insight-resource-capacity-trend summarize-host-insight-resource-forecast-trend summarize-host-insight-resource-statistics summarize-host-insight-resource-usage summarize-host-insight-resource-usage-trend summarize-host-insight-resource-utilization-insight summarize-host-recommendation summarize-io-usage-trend summarize-network-usage-trend summarize-storage-usage-trend summarize-top-processes-usage-trend update-em-external-host update-host-insight-update-pe-comanaged-host-insight-details update-macs-cloud-host update-macs-external-host update-macs-managed-database-host-insight'
        'opsi news-reports' = 'change create delete get list update'
        'opsi operations-insights-warehouse-users' = 'create delete get list update'
        'opsi operations-insights-warehouses' = 'change create delete download-warehouse-wallet get list rotate-warehouse-wallet summarize-operations-insights-warehouse-resource-usage update'
        'opsi opsi-configurations' = 'change create-opsi-ux-configuration-details delete get list summarize-configuration-items update-opsi-ux-configuration-details'
        'opsi opsi-data-objects' = 'get list query-data-standard-query query-data-templatized-query'
        'opsi opsi-private-endpoint' = 'change-compartment create delete get list update'
        'opsi opsi-warehouse-data-objects' = 'list query-warehouse-data-standard-query query-warehouse-data-templatized-query'
        'opsi work-requests' = 'get list'
    }
    return $ociSubcommands
}

function GetOciCommandsToLongParams_opsi() {
    $ociCommandsToLongParams = @{
        'opsi awr-hub-objects delete' = 'awr-hub-source-id force from-json help if-match name'
        'opsi awr-hub-objects get' = 'awr-hub-source-id file from-json help name'
        'opsi awr-hub-objects head' = 'awr-hub-source-id from-json help name'
        'opsi awr-hub-objects list' = 'all awr-hub-source-id delimiter end fields from-json help limit page page-size prefix start start-after'
        'opsi awr-hub-objects put' = 'awr-hub-source-id file from-json help if-match name'
        'opsi awr-hub-sources change' = 'awr-hub-source-id compartment-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi awr-hub-sources create' = 'associated-opsi-id associated-resource-id awr-hub-id compartment-id defined-tags freeform-tags from-json help max-wait-seconds name type wait-for-state wait-interval-seconds'
        'opsi awr-hub-sources delete' = 'awr-hub-source-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi awr-hub-sources disable' = 'awr-hub-source-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi awr-hub-sources enable' = 'awr-hub-source-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi awr-hub-sources get' = 'awr-hub-source-id from-json help'
        'opsi awr-hub-sources list' = 'all awr-hub-id awr-hub-source-id compartment-id from-json help lifecycle-state limit name page page-size sort-by sort-order source-type status'
        'opsi awr-hub-sources update' = 'awr-hub-source-id defined-tags force freeform-tags from-json help if-match max-wait-seconds type wait-for-state wait-interval-seconds'
        'opsi awr-hubs create' = 'compartment-id defined-tags display-name freeform-tags from-json help max-wait-seconds object-storage-bucket-name operations-insights-warehouse-id wait-for-state wait-interval-seconds'
        'opsi awr-hubs delete' = 'awr-hub-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi awr-hubs get' = 'awr-hub-id from-json help'
        'opsi awr-hubs get-awr-database-report' = 'awr-hub-id awr-source-database-identifier begin-snapshot-identifier-greater-than-or-equal-to end-snapshot-identifier-less-than-or-equal-to from-json help instance-number report-format report-type time-greater-than-or-equal-to time-less-than-or-equal-to'
        'opsi awr-hubs get-awr-database-sql-report' = 'awr-hub-id awr-source-database-identifier begin-snapshot-identifier-greater-than-or-equal-to end-snapshot-identifier-less-than-or-equal-to from-json help instance-number report-format sql-id time-greater-than-or-equal-to time-less-than-or-equal-to'
        'opsi awr-hubs get-awr-report' = 'awr-hub-id awr-source-database-identifier begin-snapshot-identifier-greater-than-or-equal-to end-snapshot-identifier-less-than-or-equal-to from-json help instance-number report-format time-greater-than-or-equal-to time-less-than-or-equal-to'
        'opsi awr-hubs list' = 'all compartment-id display-name from-json help id lifecycle-state limit operations-insights-warehouse-id page page-size sort-by sort-order'
        'opsi awr-hubs list-awr-database-snapshots' = 'all awr-hub-id awr-source-database-identifier begin-snapshot-identifier-greater-than-or-equal-to end-snapshot-identifier-less-than-or-equal-to from-json help instance-number limit page page-size sort-by sort-order time-greater-than-or-equal-to time-less-than-or-equal-to'
        'opsi awr-hubs list-awr-databases' = 'all awr-hub-id from-json help limit name page page-size sort-by sort-order time-greater-than-or-equal-to time-less-than-or-equal-to'
        'opsi awr-hubs list-awr-snapshots' = 'all awr-hub-id awr-source-database-identifier from-json help limit page page-size sort-by sort-order time-greater-than-or-equal-to time-less-than-or-equal-to'
        'opsi awr-hubs summarize-awr-database-cpu-usages' = 'awr-hub-id awr-source-database-identifier begin-snapshot-identifier-greater-than-or-equal-to end-snapshot-identifier-less-than-or-equal-to from-json help instance-number limit page session-type sort-by sort-order time-greater-than-or-equal-to time-less-than-or-equal-to'
        'opsi awr-hubs summarize-awr-database-metrics' = 'awr-hub-id awr-source-database-identifier begin-snapshot-identifier-greater-than-or-equal-to end-snapshot-identifier-less-than-or-equal-to from-json help instance-number limit name page sort-by sort-order time-greater-than-or-equal-to time-less-than-or-equal-to'
        'opsi awr-hubs summarize-awr-database-parameter-changes' = 'awr-hub-id awr-source-database-identifier begin-snapshot-identifier-greater-than-or-equal-to end-snapshot-identifier-less-than-or-equal-to from-json help instance-number limit name page sort-by sort-order time-greater-than-or-equal-to time-less-than-or-equal-to'
        'opsi awr-hubs summarize-awr-database-parameters' = 'awr-hub-id awr-source-database-identifier begin-snapshot-identifier-greater-than-or-equal-to end-snapshot-identifier-less-than-or-equal-to from-json help instance-number limit name name-contains page sort-by sort-order time-greater-than-or-equal-to time-less-than-or-equal-to value-changed value-default value-modified'
        'opsi awr-hubs summarize-awr-database-snapshot-ranges' = 'awr-hub-id from-json help limit name page sort-by sort-order time-greater-than-or-equal-to time-less-than-or-equal-to'
        'opsi awr-hubs summarize-awr-database-sysstats' = 'awr-hub-id awr-source-database-identifier begin-snapshot-identifier-greater-than-or-equal-to end-snapshot-identifier-less-than-or-equal-to from-json help instance-number limit name page sort-by sort-order time-greater-than-or-equal-to time-less-than-or-equal-to'
        'opsi awr-hubs summarize-awr-database-top-wait-events' = 'awr-hub-id awr-source-database-identifier begin-snapshot-identifier-greater-than-or-equal-to end-snapshot-identifier-less-than-or-equal-to from-json help instance-number session-type sort-by sort-order time-greater-than-or-equal-to time-less-than-or-equal-to top-n'
        'opsi awr-hubs summarize-awr-database-wait-event-buckets' = 'awr-hub-id awr-source-database-identifier begin-snapshot-identifier-greater-than-or-equal-to end-snapshot-identifier-less-than-or-equal-to from-json help instance-number limit max-value min-value name num-bucket page sort-by sort-order time-greater-than-or-equal-to time-less-than-or-equal-to'
        'opsi awr-hubs summarize-awr-database-wait-events' = 'awr-hub-id awr-source-database-identifier begin-snapshot-identifier-greater-than-or-equal-to end-snapshot-identifier-less-than-or-equal-to from-json help instance-number limit name page session-type sort-by sort-order time-greater-than-or-equal-to time-less-than-or-equal-to'
        'opsi awr-hubs summarize-awr-sources-summaries' = 'awr-hub-id compartment-id from-json help limit name page sort-by sort-order'
        'opsi awr-hubs update' = 'awr-hub-id defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights change' = 'compartment-id database-insight-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights change-autonomous-database-insight-advanced-features-credential-by-iam' = 'connection-details credential-details-credential-source-name database-insight-id from-json help if-match max-wait-seconds opsi-private-endpoint-id wait-for-state wait-interval-seconds'
        'opsi database-insights change-autonomous-database-insight-advanced-features-credential-by-vault' = 'connection-details credential-details-wallet-secret-id database-insight-id from-json help if-match max-wait-seconds opsi-private-endpoint-id password-secret-id role user-name wait-for-state wait-interval-seconds'
        'opsi database-insights change-external-mysql' = 'database-connector-id database-insight-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights change-macs-managed-autonomous-database-insight-connection-credential-by-named-credentials' = 'connection-details database-insight-id from-json help if-match management-agent-id max-wait-seconds named-credential-id wait-for-state wait-interval-seconds'
        'opsi database-insights change-macs-managed-autonomous-database-insight-connection-credential-by-vault' = 'connection-credential-details-credential-source-name connection-credential-details-password-secret-id connection-credential-details-role connection-credential-details-user-name connection-credential-details-wallet-secret-id connection-details database-insight-id from-json help if-match management-agent-id max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights change-macs-managed-autonomous-database-insight-connection-credentials-by-source' = 'connection-credential-details-credential-source-name connection-details database-insight-id from-json help if-match management-agent-id max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights change-macs-managed-cloud-database-insight-connection-credential-by-iam' = 'connection-credential-details-credential-source-name connection-details database-insight-id from-json help if-match management-agent-id max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights change-macs-managed-cloud-database-insight-connection-credential-by-named-credentials' = 'connection-credential-details-credential-source-name connection-credential-details-named-credential-id connection-details database-insight-id from-json help if-match management-agent-id max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights change-macs-managed-cloud-database-insight-connection-credential-by-vault' = 'connection-details credential-source-name database-insight-id from-json help if-match management-agent-id max-wait-seconds password-secret-id role user-name wait-for-state wait-interval-seconds wallet-secret-id'
        'opsi database-insights change-pe-comanaged-database-detail' = 'connection-details credential-details-credential-source-name credential-details-password-secret-id credential-details-role credential-details-user-name credential-details-wallet-secret-id database-insight-id from-json help if-match max-wait-seconds opsi-private-endpoint-id service-name wait-for-state wait-interval-seconds'
        'opsi database-insights create-autonomous-database' = 'compartment-id connection-details credential-details database-id database-resource-type defined-tags freeform-tags from-json help is-advanced-features-enabled max-wait-seconds opsi-private-endpoint-id system-tags wait-for-state wait-interval-seconds'
        'opsi database-insights create-em-external-db' = 'compartment-id defined-tags em-bridge-id em-entity-id em-id exadata-insight-id freeform-tags from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights create-external-mysql-database-insight' = 'compartment-id database-connector-id database-id defined-tags freeform-tags from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights create-macs-managed-autonomous-database-insight' = 'compartment-id connection-credential-details connection-details database-id database-resource-type defined-tags deployment-type freeform-tags from-json help management-agent-id max-wait-seconds system-tags wait-for-state wait-interval-seconds'
        'opsi database-insights create-macs-managed-cloud-database-insight' = 'compartment-id connection-credential-details connection-details database-id database-resource-type defined-tags deployment-type freeform-tags from-json help management-agent-id max-wait-seconds system-tags wait-for-state wait-interval-seconds'
        'opsi database-insights create-mds-my-sql-database' = 'compartment-id database-id defined-tags freeform-tags from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights create-pe-comanged-database' = 'compartment-id connection-details credential-details database-id database-resource-type dbm-private-endpoint-id defined-tags deployment-type freeform-tags from-json help max-wait-seconds opsi-private-endpoint-id service-name system-tags wait-for-state wait-interval-seconds'
        'opsi database-insights delete' = 'database-insight-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights disable' = 'database-insight-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights disable-autonomous-database-insight-advanced-features' = 'database-insight-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights enable-autonomous-database' = 'connection-details credential-details database-insight-id database-resource-type defined-tags freeform-tags from-json help if-match is-advanced-features-enabled max-wait-seconds opsi-private-endpoint-id system-tags wait-for-state wait-interval-seconds'
        'opsi database-insights enable-autonomous-database-insight-advanced-features-credential-by-iam' = 'connection-details credential-details-credential-source-name database-insight-id from-json help if-match max-wait-seconds opsi-private-endpoint-id wait-for-state wait-interval-seconds'
        'opsi database-insights enable-autonomous-database-insight-advanced-features-credential-by-vault' = 'connection-details credential-details-wallet-secret-id database-insight-id from-json help if-match max-wait-seconds opsi-private-endpoint-id password-secret-id role user-name wait-for-state wait-interval-seconds'
        'opsi database-insights enable-em-external-db' = 'database-insight-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights enable-external-mysql-database-insight' = 'database-connector-id database-insight-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights enable-macs-managed-autonomous-database-insight' = 'compartment-id connection-credential-details connection-details database-insight-id defined-tags freeform-tags from-json help if-match management-agent-id max-wait-seconds system-tags wait-for-state wait-interval-seconds'
        'opsi database-insights enable-macs-managed-cloud-database-insight' = 'compartment-id connection-credential-details connection-details database-insight-id defined-tags freeform-tags from-json help if-match management-agent-id max-wait-seconds system-tags wait-for-state wait-interval-seconds'
        'opsi database-insights enable-mds-my-sql-database' = 'database-insight-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights enable-pe-comanaged-database' = 'compartment-id connection-details credential-details database-insight-id defined-tags freeform-tags from-json help if-match max-wait-seconds opsi-private-endpoint-id service-name system-tags wait-for-state wait-interval-seconds'
        'opsi database-insights get' = 'database-insight-id from-json help'
        'opsi database-insights ingest-addm-reports' = 'database-id from-json help id if-match items'
        'opsi database-insights ingest-database-configuration' = 'database-id from-json help id if-match items'
        'opsi database-insights ingest-my-sql-sql-stats' = 'database-id from-json help id if-match items'
        'opsi database-insights ingest-my-sql-sql-text' = 'compartment-id database-id from-json help id if-match items'
        'opsi database-insights ingest-sql-bucket' = 'compartment-id database-id from-json help id if-match items'
        'opsi database-insights ingest-sql-plan-lines' = 'compartment-id database-id from-json help id if-match items'
        'opsi database-insights ingest-sql-stats' = 'database-id from-json help id if-match items'
        'opsi database-insights ingest-sql-text' = 'compartment-id database-id from-json help id if-match items'
        'opsi database-insights list' = 'all compartment-id compartment-id-in-subtree database-id database-type em-bridge-id exadata-insight-id fields from-json help id lifecycle-state limit opsi-private-endpoint-id page page-size sort-by sort-order status'
        'opsi database-insights list-addm-db-finding-categories' = 'all compartment-id compartment-id-in-subtree database-id defined-tag-equals defined-tag-exists freeform-tag-equals freeform-tag-exists from-json help id limit page page-size sort-by sort-order'
        'opsi database-insights list-addm-db-findings-time-series' = 'all category-name compartment-id compartment-id-in-subtree database-id defined-tag-equals defined-tag-exists freeform-tag-equals freeform-tag-exists from-json help id instance-number limit page page-size sort-by sort-order time-interval-end time-interval-start'
        'opsi database-insights list-addm-db-parameter-categories' = 'all compartment-id compartment-id-in-subtree database-id defined-tag-equals defined-tag-exists freeform-tag-equals freeform-tag-exists from-json help id limit page page-size sort-by sort-order'
        'opsi database-insights list-addm-db-recommendation-categories' = 'all compartment-id compartment-id-in-subtree database-id defined-tag-equals defined-tag-exists freeform-tag-equals freeform-tag-exists from-json help id limit page page-size sort-by sort-order'
        'opsi database-insights list-addm-db-recommendations-time-series' = 'all category-name compartment-id compartment-id-in-subtree database-id defined-tag-equals defined-tag-exists freeform-tag-equals freeform-tag-exists from-json help id instance-number limit name name-contains owner-or-name-contains page page-size sort-by sort-order sql-identifier time-interval-end time-interval-start'
        'opsi database-insights list-addm-dbs' = 'all compartment-id compartment-id-in-subtree database-id defined-tag-equals defined-tag-exists freeform-tag-equals freeform-tag-exists from-json help id limit page page-size sort-by sort-order time-interval-end time-interval-start'
        'opsi database-insights list-database-configurations' = 'all cdb-name compartment-id compartment-id-in-subtree database-id database-type defined-tag-equals defined-tag-exists em-bridge-id exadata-insight-id freeform-tag-equals freeform-tag-exists from-json help host-name id limit page page-size sort-by sort-order vmcluster-name'
        'opsi database-insights list-sql-plans' = 'all compartment-id database-id from-json help id page plan-hash sql-identifier'
        'opsi database-insights list-sql-searches' = 'all analysis-time-interval compartment-id compartment-id-in-subtree defined-tag-equals defined-tag-exists freeform-tag-equals freeform-tag-exists from-json help page sql-identifier time-interval-end time-interval-start'
        'opsi database-insights list-sql-texts' = 'all compartment-id compartment-id-in-subtree database-id defined-tag-equals defined-tag-exists freeform-tag-equals freeform-tag-exists from-json help id page sql-identifier'
        'opsi database-insights summarize-addm-db-findings' = 'category-name compartment-id compartment-id-in-subtree database-id defined-tag-equals defined-tag-exists freeform-tag-equals freeform-tag-exists from-json help id instance-number limit page sort-by sort-order time-interval-end time-interval-start'
        'opsi database-insights summarize-addm-db-parameter-changes' = 'compartment-id compartment-id-in-subtree database-id defined-tag-equals defined-tag-exists freeform-tag-equals freeform-tag-exists from-json help id instance-number limit name page sort-by sort-order time-interval-end time-interval-start value-contains'
        'opsi database-insights summarize-addm-db-parameters' = 'category-name compartment-id compartment-id-in-subtree database-id defined-tag-equals defined-tag-exists freeform-tag-equals freeform-tag-exists from-json has-recommendations help id instance-number is-changed is-default limit name-or-value-contains page sort-by sort-order time-interval-end time-interval-start'
        'opsi database-insights summarize-addm-db-recommendations' = 'category-name compartment-id compartment-id-in-subtree database-id defined-tag-equals defined-tag-exists finding-identifier freeform-tag-equals freeform-tag-exists from-json help id instance-number limit name name-contains owner-or-name-contains page sort-by sort-order sql-identifier time-interval-end time-interval-start'
        'opsi database-insights summarize-addm-db-schema-objects' = 'compartment-id compartment-id-in-subtree database-id defined-tag-equals defined-tag-exists freeform-tag-equals freeform-tag-exists from-json help id limit object-identifier page time-interval-end time-interval-start'
        'opsi database-insights summarize-addm-db-sql-statements' = 'compartment-id compartment-id-in-subtree database-id defined-tag-equals defined-tag-exists freeform-tag-equals freeform-tag-exists from-json help id limit page sql-identifier time-interval-end time-interval-start'
        'opsi database-insights summarize-database-insight-resource-capacity-trend' = 'analysis-time-interval cdb-name compartment-id compartment-id-in-subtree database-id database-type defined-tag-equals defined-tag-exists exadata-insight-id freeform-tag-equals freeform-tag-exists from-json help high-utilization-threshold host-name id is-database-instance-level-metrics low-utilization-threshold page resource-metric sort-by sort-order tablespace-name time-interval-end time-interval-start utilization-level vmcluster-name'
        'opsi database-insights summarize-database-insight-resource-forecast-trend' = 'analysis-time-interval cdb-name compartment-id compartment-id-in-subtree confidence database-id database-type defined-tag-equals defined-tag-exists exadata-insight-id forecast-days forecast-model freeform-tag-equals freeform-tag-exists from-json help high-utilization-threshold host-name id is-database-instance-level-metrics low-utilization-threshold page resource-metric statistic tablespace-name time-interval-end time-interval-start utilization-level vmcluster-name'
        'opsi database-insights summarize-database-insight-resource-statistics' = 'analysis-time-interval cdb-name compartment-id compartment-id-in-subtree database-id database-type defined-tag-equals defined-tag-exists exadata-insight-id forecast-days freeform-tag-equals freeform-tag-exists from-json help high-utilization-threshold host-name id insight-by is-database-instance-level-metrics limit low-utilization-threshold page percentile resource-metric sort-by sort-order time-interval-end time-interval-start vmcluster-name'
        'opsi database-insights summarize-database-insight-resource-usage' = 'analysis-time-interval cdb-name compartment-id compartment-id-in-subtree database-id database-type defined-tag-equals defined-tag-exists exadata-insight-id freeform-tag-equals freeform-tag-exists from-json help host-name id is-database-instance-level-metrics page percentile resource-metric time-interval-end time-interval-start vmcluster-name'
        'opsi database-insights summarize-database-insight-resource-usage-trend' = 'analysis-time-interval cdb-name compartment-id compartment-id-in-subtree database-id database-type defined-tag-equals defined-tag-exists exadata-insight-id freeform-tag-equals freeform-tag-exists from-json help host-name id is-database-instance-level-metrics page resource-metric sort-by sort-order time-interval-end time-interval-start vmcluster-name'
        'opsi database-insights summarize-database-insight-resource-utilization-insight' = 'analysis-time-interval cdb-name compartment-id compartment-id-in-subtree database-id database-type defined-tag-equals defined-tag-exists exadata-insight-id forecast-days freeform-tag-equals freeform-tag-exists from-json help high-utilization-threshold host-name id is-database-instance-level-metrics low-utilization-threshold page resource-metric time-interval-end time-interval-start vmcluster-name'
        'opsi database-insights summarize-database-insight-tablespace-usage-trend' = 'analysis-time-interval compartment-id database-id from-json help id limit page time-interval-end time-interval-start'
        'opsi database-insights summarize-sql-insights' = 'analysis-time-interval cdb-name compartment-id compartment-id-in-subtree database-id database-time-pct-greater-than database-type defined-tag-equals defined-tag-exists exadata-insight-id freeform-tag-equals freeform-tag-exists from-json help host-name id page time-interval-end time-interval-start vmcluster-name'
        'opsi database-insights summarize-sql-plan-insights' = 'analysis-time-interval compartment-id database-id from-json help id page sql-identifier time-interval-end time-interval-start'
        'opsi database-insights summarize-sql-response-time-distributions' = 'analysis-time-interval compartment-id database-id from-json help id page sql-identifier time-interval-end time-interval-start'
        'opsi database-insights summarize-sql-statistics' = 'analysis-time-interval category cdb-name compartment-id compartment-id-in-subtree database-id database-time-pct-greater-than database-type defined-tag-equals defined-tag-exists exadata-insight-id freeform-tag-equals freeform-tag-exists from-json help host-name id limit page sort-by sort-order sql-identifier time-interval-end time-interval-start vmcluster-name'
        'opsi database-insights summarize-sql-statistics-time-series' = 'analysis-time-interval cdb-name compartment-id compartment-id-in-subtree database-id defined-tag-equals defined-tag-exists exadata-insight-id freeform-tag-equals freeform-tag-exists from-json help host-name id page sql-identifier time-interval-end time-interval-start vmcluster-name'
        'opsi database-insights summarize-sql-statistics-time-series-by-plan' = 'analysis-time-interval compartment-id database-id from-json help id page sql-identifier time-interval-end time-interval-start'
        'opsi database-insights synchronize-autonomous-database-to-exadata' = 'compartment-id database-id entity-source exadata-insight-id from-json help id if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights test-macs-managed-autonomous-database-insight-connection-credential-by-named-credentials' = 'connection-credential-details-credential-source-name connection-details database-id from-json help id management-agent-id max-wait-seconds named-credential-id wait-for-state wait-interval-seconds'
        'opsi database-insights test-macs-managed-cloud-database-insight-connection-credential-by-iam' = 'connection-credential-details-credential-source-name connection-details database-id from-json help id management-agent-id max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights test-macs-managed-cloud-database-insight-connection-credential-by-vault' = 'connection-details credential-source-name database-id from-json help id management-agent-id max-wait-seconds password-secret-id role user-name wait-for-state wait-interval-seconds wallet-secret-id'
        'opsi database-insights update-autonomous-db' = 'database-insight-id defined-tags force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights update-em-external-db' = 'database-insight-id defined-tags force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights update-external-mysql-database-insight' = 'database-insight-id defined-tags force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights update-macs-external-db' = 'database-insight-id defined-tags force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights update-macs-managed-autonomous-database-insight' = 'database-insight-id defined-tags force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights update-macs-managed-cloud-database-insight' = 'database-insight-id defined-tags force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights update-mds-my-sql-database' = 'database-insight-id defined-tags force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi database-insights update-pe-comanaged-database' = 'database-insight-id defined-tags force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi enterprise-manager-bridges change' = 'compartment-id enterprise-manager-bridge-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi enterprise-manager-bridges create' = 'compartment-id defined-tags description display-name freeform-tags from-json help max-wait-seconds object-storage-bucket-name wait-for-state wait-interval-seconds'
        'opsi enterprise-manager-bridges delete' = 'enterprise-manager-bridge-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi enterprise-manager-bridges get' = 'enterprise-manager-bridge-id from-json help'
        'opsi enterprise-manager-bridges list' = 'all compartment-id compartment-id-in-subtree display-name from-json help id lifecycle-state limit page page-size sort-by sort-order'
        'opsi enterprise-manager-bridges list-importable-enterprise-manager-entities' = 'all em-entity-type em-id em-parent-id enterprise-manager-bridge-id from-json help limit page page-size'
        'opsi enterprise-manager-bridges update' = 'defined-tags description display-name enterprise-manager-bridge-id force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi exadata-insights add-em-external-exadata-members' = 'exadata-insight-id from-json help if-match max-wait-seconds member-entity-details wait-for-state wait-interval-seconds'
        'opsi exadata-insights add-macs-managed-cloud-exadata-insight-members' = 'exadata-insight-id from-json help if-match max-wait-seconds member-entity-details wait-for-state wait-interval-seconds'
        'opsi exadata-insights add-pe-comanaged-exadata-members' = 'exadata-insight-id from-json help if-match max-wait-seconds member-entity-details wait-for-state wait-interval-seconds'
        'opsi exadata-insights change' = 'compartment-id exadata-insight-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi exadata-insights create-em-external-exadata' = 'compartment-id defined-tags em-bridge-id em-entity-id em-id freeform-tags from-json help is-auto-sync-enabled max-wait-seconds member-entity-details wait-for-state wait-interval-seconds'
        'opsi exadata-insights create-macs-managed-cloud-exadata-insight' = 'compartment-id defined-tags exadata-infra-id freeform-tags from-json help max-wait-seconds member-vm-cluster-details wait-for-state wait-interval-seconds'
        'opsi exadata-insights create-pe-comanaged-exadata' = 'compartment-id defined-tags exadata-infra-id freeform-tags from-json help max-wait-seconds member-vm-cluster-details wait-for-state wait-interval-seconds'
        'opsi exadata-insights delete' = 'exadata-insight-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi exadata-insights disable' = 'exadata-insight-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi exadata-insights enable-em-external-exadata' = 'exadata-insight-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi exadata-insights enable-macs-managed-cloud-exadata-insight' = 'exadata-insight-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi exadata-insights enable-pe-comanaged-exadata' = 'exadata-insight-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi exadata-insights get' = 'exadata-insight-id from-json help'
        'opsi exadata-insights list' = 'all compartment-id compartment-id-in-subtree em-bridge-id exadata-type from-json help id lifecycle-state limit page page-size sort-by sort-order status'
        'opsi exadata-insights list-exadata-configurations' = 'all compartment-id compartment-id-in-subtree defined-tag-equals defined-tag-exists exadata-insight-id exadata-type freeform-tag-equals freeform-tag-exists from-json help limit page page-size sort-by sort-order'
        'opsi exadata-insights summarize-exadata-insight-resource-capacity-trend' = 'analysis-time-interval cdb-name compartment-id database-insight-id exadata-insight-id exadata-type from-json help host-insight-id host-name limit page resource-metric resource-type sort-by sort-order storage-server-name time-interval-end time-interval-start'
        'opsi exadata-insights summarize-exadata-insight-resource-capacity-trend-aggregated' = 'analysis-time-interval cdb-name compartment-id compartment-id-in-subtree defined-tag-equals defined-tag-exists exadata-insight-id exadata-type freeform-tag-equals freeform-tag-exists from-json help host-name page resource-metric resource-type sort-by sort-order time-interval-end time-interval-start'
        'opsi exadata-insights summarize-exadata-insight-resource-forecast-trend' = 'analysis-time-interval cdb-name confidence database-insight-id exadata-insight-id exadata-type forecast-days forecast-model forecast-start-day from-json help host-insight-id host-name limit page resource-metric resource-type sort-by sort-order statistic storage-server-name time-interval-end time-interval-start'
        'opsi exadata-insights summarize-exadata-insight-resource-forecast-trend-aggregated' = 'analysis-time-interval cdb-name compartment-id compartment-id-in-subtree confidence defined-tag-equals defined-tag-exists exadata-insight-id exadata-type forecast-days forecast-model forecast-start-day freeform-tag-equals freeform-tag-exists from-json help host-name page resource-metric resource-type statistic time-interval-end time-interval-start'
        'opsi exadata-insights summarize-exadata-insight-resource-statistics' = 'analysis-time-interval cdb-name exadata-insight-id exadata-type from-json help host-name limit page percentile resource-metric resource-type sort-by sort-order time-interval-end time-interval-start'
        'opsi exadata-insights summarize-exadata-insight-resource-usage' = 'analysis-time-interval cdb-name compartment-id compartment-id-in-subtree defined-tag-equals defined-tag-exists exadata-insight-id exadata-type freeform-tag-equals freeform-tag-exists from-json help host-name limit page percentile resource-metric resource-type sort-by sort-order time-interval-end time-interval-start'
        'opsi exadata-insights summarize-exadata-insight-resource-usage-aggregated' = 'analysis-time-interval cdb-name compartment-id compartment-id-in-subtree defined-tag-equals defined-tag-exists exadata-insight-id exadata-type freeform-tag-equals freeform-tag-exists from-json help host-name page percentile resource-metric resource-type time-interval-end time-interval-start'
        'opsi exadata-insights summarize-exadata-insight-resource-utilization-insight' = 'analysis-time-interval cdb-name compartment-id compartment-id-in-subtree defined-tag-equals defined-tag-exists exadata-insight-id exadata-type forecast-days forecast-start-day freeform-tag-equals freeform-tag-exists from-json help high-utilization-threshold host-name limit low-utilization-threshold page resource-metric resource-type time-interval-end time-interval-start'
        'opsi exadata-insights summarize-exadata-members' = 'exadata-insight-id exadata-type from-json help limit page sort-by sort-order'
        'opsi exadata-insights update-em-external-exadata' = 'defined-tags exadata-insight-id force freeform-tags from-json help if-match is-auto-sync-enabled max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi exadata-insights update-macs-managed-cloud-exadata-insight' = 'defined-tags exadata-insight-id force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi exadata-insights update-pe-comanaged-exadata' = 'defined-tags exadata-insight-id force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi host-insights change' = 'compartment-id from-json help host-insight-id if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi host-insights create-em-external-host' = 'compartment-id defined-tags em-bridge-id em-entity-id em-id exadata-insight-id freeform-tags from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi host-insights create-macs-cloud-host' = 'compartment-id compute-id defined-tags freeform-tags from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi host-insights create-macs-external-host' = 'compartment-id defined-tags freeform-tags from-json help management-agent-id max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi host-insights delete' = 'force from-json help host-insight-id if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi host-insights disable' = 'from-json help host-insight-id if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi host-insights enable-em-external-host' = 'from-json help host-insight-id if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi host-insights enable-macs-cloud-host' = 'from-json help host-insight-id if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi host-insights enable-macs-external-host' = 'from-json help host-insight-id if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi host-insights get' = 'from-json help host-insight-id'
        'opsi host-insights ingest-host-configuration' = 'from-json help id if-match items'
        'opsi host-insights ingest-host-metrics' = 'from-json help id if-match items'
        'opsi host-insights list' = 'all compartment-id compartment-id-in-subtree em-bridge-id exadata-insight-id from-json help host-type id lifecycle-state limit page page-size platform-type sort-by sort-order status'
        'opsi host-insights list-host-configurations' = 'all compartment-id compartment-id-in-subtree defined-tag-equals defined-tag-exists em-bridge-id exadata-insight-id freeform-tag-equals freeform-tag-exists from-json help host-id host-type id limit page page-size platform-type sort-by sort-order status vmcluster-name'
        'opsi host-insights list-hosted-entities' = 'all analysis-time-interval compartment-id exadata-insight-id from-json help host-id host-type id limit page page-size platform-type sort-by sort-order status time-interval-end time-interval-start'
        'opsi host-insights list-importable-agent-entities' = 'all compartment-id from-json help limit page page-size sort-by sort-order'
        'opsi host-insights list-macs-cloud-hosts' = 'all compartment-id from-json help limit page page-size sort-by sort-order'
        'opsi host-insights summarize-disk-statistics' = 'analysis-time-interval compartment-id from-json help host-id id statistic status time-interval-end time-interval-start'
        'opsi host-insights summarize-host-insight-resource-capacity-trend' = 'analysis-time-interval compartment-id compartment-id-in-subtree defined-tag-equals defined-tag-exists exadata-insight-id freeform-tag-equals freeform-tag-exists from-json help high-utilization-threshold host-id host-type id low-utilization-threshold page platform-type resource-metric sort-by sort-order status time-interval-end time-interval-start utilization-level vmcluster-name'
        'opsi host-insights summarize-host-insight-resource-forecast-trend' = 'analysis-time-interval compartment-id compartment-id-in-subtree confidence defined-tag-equals defined-tag-exists exadata-insight-id forecast-days forecast-model freeform-tag-equals freeform-tag-exists from-json gpu-id help high-utilization-threshold host-id host-type id interface-name low-utilization-threshold mount-point page platform-type resource-metric statistic status time-interval-end time-interval-start utilization-level vmcluster-name'
        'opsi host-insights summarize-host-insight-resource-statistics' = 'analysis-time-interval compartment-id compartment-id-in-subtree defined-tag-equals defined-tag-exists exadata-insight-id forecast-days freeform-tag-equals freeform-tag-exists from-json help high-utilization-threshold host-id host-type id insight-by limit low-utilization-threshold page percentile platform-type resource-metric sort-by sort-order status time-interval-end time-interval-start vmcluster-name'
        'opsi host-insights summarize-host-insight-resource-usage' = 'analysis-time-interval compartment-id compartment-id-in-subtree defined-tag-equals defined-tag-exists exadata-insight-id freeform-tag-equals freeform-tag-exists from-json help host-id host-type id page percentile platform-type resource-metric status time-interval-end time-interval-start vmcluster-name'
        'opsi host-insights summarize-host-insight-resource-usage-trend' = 'analysis-time-interval compartment-id compartment-id-in-subtree defined-tag-equals defined-tag-exists exadata-insight-id freeform-tag-equals freeform-tag-exists from-json help host-id host-type id page platform-type resource-metric sort-by sort-order status time-interval-end time-interval-start vmcluster-name'
        'opsi host-insights summarize-host-insight-resource-utilization-insight' = 'analysis-time-interval compartment-id compartment-id-in-subtree defined-tag-equals defined-tag-exists exadata-insight-id forecast-days freeform-tag-equals freeform-tag-exists from-json help high-utilization-threshold host-id host-type id low-utilization-threshold page platform-type resource-metric status time-interval-end time-interval-start vmcluster-name'
        'opsi host-insights summarize-host-recommendation' = 'analysis-time-interval compartment-id from-json help host-id id limit resource-metric statistic time-interval-end time-interval-start'
        'opsi host-insights summarize-io-usage-trend' = 'analysis-time-interval compartment-id from-json help host-id id limit page statistic status time-interval-end time-interval-start'
        'opsi host-insights summarize-network-usage-trend' = 'analysis-time-interval compartment-id from-json help host-id id limit page statistic status time-interval-end time-interval-start'
        'opsi host-insights summarize-storage-usage-trend' = 'analysis-time-interval compartment-id from-json help host-id id limit page statistic status time-interval-end time-interval-start'
        'opsi host-insights summarize-top-processes-usage-trend' = 'analysis-time-interval compartment-id from-json help host-id host-type id limit page resource-metric statistic status time-interval-end time-interval-start'
        'opsi host-insights update-em-external-host' = 'defined-tags force freeform-tags from-json help host-insight-id if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi host-insights update-host-insight-update-pe-comanaged-host-insight-details' = 'defined-tags force freeform-tags from-json help host-insight-id if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi host-insights update-macs-cloud-host' = 'defined-tags force freeform-tags from-json help host-insight-id if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi host-insights update-macs-external-host' = 'defined-tags force freeform-tags from-json help host-insight-id if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi host-insights update-macs-managed-database-host-insight' = 'defined-tags force freeform-tags from-json help host-insight-id if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'opsi news-reports change' = 'compartment-id from-json help if-match max-wait-seconds news-report-id wait-for-state wait-interval-seconds'
        'opsi news-reports create' = 'are-child-compartments-included compartment-id content-types day-of-week defined-tags description freeform-tags from-json help locale match-rule max-wait-seconds name news-frequency ons-topic-id status tag-filters wait-for-state wait-interval-seconds'
        'opsi news-reports delete' = 'force from-json help if-match max-wait-seconds news-report-id wait-for-state wait-interval-seconds'
        'opsi news-reports get' = 'from-json help news-report-id'
        'opsi news-reports list' = 'all compartment-id compartment-id-in-subtree from-json help lifecycle-state limit news-report-id page page-size sort-by sort-order status'
        'opsi news-reports update' = 'are-child-compartments-included content-types day-of-week defined-tags description force freeform-tags from-json help if-match locale match-rule max-wait-seconds name news-frequency news-report-id ons-topic-id status tag-filters wait-for-state wait-interval-seconds'
        'opsi operations-insights-warehouse-users create' = 'compartment-id connection-password defined-tags freeform-tags from-json help is-awr-data-access is-em-data-access is-opsi-data-access max-wait-seconds name operations-insights-warehouse-id wait-for-state wait-interval-seconds'
        'opsi operations-insights-warehouse-users delete' = 'force from-json help if-match max-wait-seconds operations-insights-warehouse-user-id wait-for-state wait-interval-seconds'
        'opsi operations-insights-warehouse-users get' = 'from-json help operations-insights-warehouse-user-id'
        'opsi operations-insights-warehouse-users list' = 'all compartment-id display-name from-json help id lifecycle-state limit operations-insights-warehouse-id page page-size sort-by sort-order'
        'opsi operations-insights-warehouse-users update' = 'connection-password defined-tags force freeform-tags from-json help if-match is-awr-data-access is-em-data-access is-opsi-data-access max-wait-seconds operations-insights-warehouse-user-id wait-for-state wait-interval-seconds'
        'opsi operations-insights-warehouses change' = 'compartment-id from-json help if-match max-wait-seconds operations-insights-warehouse-id wait-for-state wait-interval-seconds'
        'opsi operations-insights-warehouses create' = 'compartment-id compute-model cpu-allocated defined-tags display-name freeform-tags from-json help max-wait-seconds storage-allocated-in-gbs wait-for-state wait-interval-seconds'
        'opsi operations-insights-warehouses delete' = 'force from-json help if-match max-wait-seconds operations-insights-warehouse-id wait-for-state wait-interval-seconds'
        'opsi operations-insights-warehouses download-warehouse-wallet' = 'file from-json help operations-insights-warehouse-id operations-insights-warehouse-wallet-password'
        'opsi operations-insights-warehouses get' = 'from-json help operations-insights-warehouse-id'
        'opsi operations-insights-warehouses list' = 'all compartment-id display-name from-json help id lifecycle-state limit page page-size sort-by sort-order'
        'opsi operations-insights-warehouses rotate-warehouse-wallet' = 'from-json help if-match max-wait-seconds operations-insights-warehouse-id wait-for-state wait-interval-seconds'
        'opsi operations-insights-warehouses summarize-operations-insights-warehouse-resource-usage' = 'from-json help operations-insights-warehouse-id'
        'opsi operations-insights-warehouses update' = 'compute-model cpu-allocated defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds operations-insights-warehouse-id storage-allocated-in-gbs wait-for-state wait-interval-seconds'
        'opsi opsi-configurations change' = 'compartment-id from-json help if-match max-wait-seconds opsi-configuration-id wait-for-state wait-interval-seconds'
        'opsi opsi-configurations create-opsi-ux-configuration-details' = 'compartment-id config-item-custom-status config-item-field config-items config-items-applicable-context defined-tags description display-name freeform-tags from-json help max-wait-seconds opsi-config-field system-tags wait-for-state wait-interval-seconds'
        'opsi opsi-configurations delete' = 'force from-json help if-match max-wait-seconds opsi-configuration-id wait-for-state wait-interval-seconds'
        'opsi opsi-configurations get' = 'config-item-custom-status config-item-field config-items-applicable-context from-json help opsi-config-field opsi-configuration-id'
        'opsi opsi-configurations list' = 'all compartment-id display-name from-json help lifecycle-state limit opsi-config-type page page-size sort-by sort-order'
        'opsi opsi-configurations summarize-configuration-items' = 'compartment-id config-item-field config-items-applicable-context from-json help limit name opsi-config-type page'
        'opsi opsi-configurations update-opsi-ux-configuration-details' = 'config-items defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds opsi-configuration-id system-tags wait-for-state wait-interval-seconds'
        'opsi opsi-data-objects get' = 'compartment-id from-json help opsi-data-object-identifier'
        'opsi opsi-data-objects list' = 'all compartment-id data-object-type display-name from-json group-name help limit name page page-size sort-by sort-order'
        'opsi opsi-data-objects query-data-standard-query' = 'compartment-id data-object-identifier data-objects from-json help limit page query-bind-params query-query-execution-timeout-in-seconds query-statement query-time-filters resource-filters'
        'opsi opsi-data-objects query-data-templatized-query' = 'compartment-id data-object-identifier data-objects from-json help limit page query-bind-params query-from-clause query-group-by-list query-having-conditions-list query-order-by-list query-query-execution-timeout-in-seconds query-select-list query-time-filters query-where-conditions-list resource-filters'
        'opsi opsi-private-endpoint change-compartment' = 'compartment-id from-json help if-match max-wait-seconds opsi-private-endpoint-id wait-for-state wait-interval-seconds'
        'opsi opsi-private-endpoint create' = 'compartment-id defined-tags description display-name freeform-tags from-json help is-used-for-rac-dbs max-wait-seconds nsg-ids subnet-id vcn-id wait-for-state wait-interval-seconds'
        'opsi opsi-private-endpoint delete' = 'force from-json help if-match max-wait-seconds opsi-private-endpoint-id wait-for-state wait-interval-seconds'
        'opsi opsi-private-endpoint get' = 'from-json help opsi-private-endpoint-id'
        'opsi opsi-private-endpoint list' = 'all compartment-id compartment-id-in-subtree display-name from-json help is-used-for-rac-dbs lifecycle-state limit opsi-private-endpoint-id page page-size sort-by sort-order vcn-id'
        'opsi opsi-private-endpoint update' = 'defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds nsg-ids opsi-private-endpoint-id wait-for-state wait-interval-seconds'
        'opsi opsi-warehouse-data-objects list' = 'all data-object-type from-json help limit name owner page page-size sort-by sort-order summary-field warehouse-id warehouse-type'
        'opsi opsi-warehouse-data-objects query-warehouse-data-standard-query' = 'from-json help limit page query-bind-params query-query-execution-timeout-in-seconds query-statement query-time-filters warehouse-id warehouse-type'
        'opsi opsi-warehouse-data-objects query-warehouse-data-templatized-query' = 'from-json help limit page query-bind-params query-from-clause query-group-by-list query-having-conditions-list query-order-by-list query-query-execution-timeout-in-seconds query-select-list query-time-filters query-where-conditions-list warehouse-id warehouse-type'
        'opsi work-requests get' = 'from-json help work-request-id'
        'opsi work-requests list' = 'all compartment-id from-json help id limit page page-size related-resource-id resource-id sort-by sort-order status'
    }
    return $ociCommandsToLongParams
}

function GetOciCommandsToShortParams_opsi() {
    $ociCommandsToShortParams = @{
        'opsi awr-hub-objects delete' = '? h'
        'opsi awr-hub-objects get' = '? h'
        'opsi awr-hub-objects head' = '? h'
        'opsi awr-hub-objects list' = '? h'
        'opsi awr-hub-objects put' = '? h'
        'opsi awr-hub-sources change' = '? c h'
        'opsi awr-hub-sources create' = '? c h'
        'opsi awr-hub-sources delete' = '? h'
        'opsi awr-hub-sources disable' = '? h'
        'opsi awr-hub-sources enable' = '? h'
        'opsi awr-hub-sources get' = '? h'
        'opsi awr-hub-sources list' = '? c h'
        'opsi awr-hub-sources update' = '? h'
        'opsi awr-hubs create' = '? c h'
        'opsi awr-hubs delete' = '? h'
        'opsi awr-hubs get' = '? h'
        'opsi awr-hubs get-awr-database-report' = '? h'
        'opsi awr-hubs get-awr-database-sql-report' = '? h'
        'opsi awr-hubs get-awr-report' = '? h'
        'opsi awr-hubs list' = '? c h'
        'opsi awr-hubs list-awr-database-snapshots' = '? h'
        'opsi awr-hubs list-awr-databases' = '? h'
        'opsi awr-hubs list-awr-snapshots' = '? h'
        'opsi awr-hubs summarize-awr-database-cpu-usages' = '? h'
        'opsi awr-hubs summarize-awr-database-metrics' = '? h'
        'opsi awr-hubs summarize-awr-database-parameter-changes' = '? h'
        'opsi awr-hubs summarize-awr-database-parameters' = '? h'
        'opsi awr-hubs summarize-awr-database-snapshot-ranges' = '? h'
        'opsi awr-hubs summarize-awr-database-sysstats' = '? h'
        'opsi awr-hubs summarize-awr-database-top-wait-events' = '? h'
        'opsi awr-hubs summarize-awr-database-wait-event-buckets' = '? h'
        'opsi awr-hubs summarize-awr-database-wait-events' = '? h'
        'opsi awr-hubs summarize-awr-sources-summaries' = '? c h'
        'opsi awr-hubs update' = '? h'
        'opsi database-insights change' = '? c h'
        'opsi database-insights change-autonomous-database-insight-advanced-features-credential-by-iam' = '? h'
        'opsi database-insights change-autonomous-database-insight-advanced-features-credential-by-vault' = '? h'
        'opsi database-insights change-external-mysql' = '? h'
        'opsi database-insights change-macs-managed-autonomous-database-insight-connection-credential-by-named-credentials' = '? h'
        'opsi database-insights change-macs-managed-autonomous-database-insight-connection-credential-by-vault' = '? h'
        'opsi database-insights change-macs-managed-autonomous-database-insight-connection-credentials-by-source' = '? h'
        'opsi database-insights change-macs-managed-cloud-database-insight-connection-credential-by-iam' = '? h'
        'opsi database-insights change-macs-managed-cloud-database-insight-connection-credential-by-named-credentials' = '? h'
        'opsi database-insights change-macs-managed-cloud-database-insight-connection-credential-by-vault' = '? h'
        'opsi database-insights change-pe-comanaged-database-detail' = '? h'
        'opsi database-insights create-autonomous-database' = '? c h'
        'opsi database-insights create-em-external-db' = '? c h'
        'opsi database-insights create-external-mysql-database-insight' = '? c h'
        'opsi database-insights create-macs-managed-autonomous-database-insight' = '? c h'
        'opsi database-insights create-macs-managed-cloud-database-insight' = '? c h'
        'opsi database-insights create-mds-my-sql-database' = '? c h'
        'opsi database-insights create-pe-comanged-database' = '? c h'
        'opsi database-insights delete' = '? h'
        'opsi database-insights disable' = '? h'
        'opsi database-insights disable-autonomous-database-insight-advanced-features' = '? h'
        'opsi database-insights enable-autonomous-database' = '? h'
        'opsi database-insights enable-autonomous-database-insight-advanced-features-credential-by-iam' = '? h'
        'opsi database-insights enable-autonomous-database-insight-advanced-features-credential-by-vault' = '? h'
        'opsi database-insights enable-em-external-db' = '? h'
        'opsi database-insights enable-external-mysql-database-insight' = '? h'
        'opsi database-insights enable-macs-managed-autonomous-database-insight' = '? c h'
        'opsi database-insights enable-macs-managed-cloud-database-insight' = '? c h'
        'opsi database-insights enable-mds-my-sql-database' = '? h'
        'opsi database-insights enable-pe-comanaged-database' = '? c h'
        'opsi database-insights get' = '? h'
        'opsi database-insights ingest-addm-reports' = '? h'
        'opsi database-insights ingest-database-configuration' = '? h'
        'opsi database-insights ingest-my-sql-sql-stats' = '? h'
        'opsi database-insights ingest-my-sql-sql-text' = '? c h'
        'opsi database-insights ingest-sql-bucket' = '? c h'
        'opsi database-insights ingest-sql-plan-lines' = '? c h'
        'opsi database-insights ingest-sql-stats' = '? h'
        'opsi database-insights ingest-sql-text' = '? c h'
        'opsi database-insights list' = '? c h'
        'opsi database-insights list-addm-db-finding-categories' = '? c h'
        'opsi database-insights list-addm-db-findings-time-series' = '? c h'
        'opsi database-insights list-addm-db-parameter-categories' = '? c h'
        'opsi database-insights list-addm-db-recommendation-categories' = '? c h'
        'opsi database-insights list-addm-db-recommendations-time-series' = '? c h'
        'opsi database-insights list-addm-dbs' = '? c h'
        'opsi database-insights list-database-configurations' = '? c h'
        'opsi database-insights list-sql-plans' = '? c h'
        'opsi database-insights list-sql-searches' = '? c h'
        'opsi database-insights list-sql-texts' = '? c h'
        'opsi database-insights summarize-addm-db-findings' = '? c h'
        'opsi database-insights summarize-addm-db-parameter-changes' = '? c h'
        'opsi database-insights summarize-addm-db-parameters' = '? c h'
        'opsi database-insights summarize-addm-db-recommendations' = '? c h'
        'opsi database-insights summarize-addm-db-schema-objects' = '? c h'
        'opsi database-insights summarize-addm-db-sql-statements' = '? c h'
        'opsi database-insights summarize-database-insight-resource-capacity-trend' = '? c h'
        'opsi database-insights summarize-database-insight-resource-forecast-trend' = '? c h'
        'opsi database-insights summarize-database-insight-resource-statistics' = '? c h'
        'opsi database-insights summarize-database-insight-resource-usage' = '? c h'
        'opsi database-insights summarize-database-insight-resource-usage-trend' = '? c h'
        'opsi database-insights summarize-database-insight-resource-utilization-insight' = '? c h'
        'opsi database-insights summarize-database-insight-tablespace-usage-trend' = '? c h'
        'opsi database-insights summarize-sql-insights' = '? c h'
        'opsi database-insights summarize-sql-plan-insights' = '? c h'
        'opsi database-insights summarize-sql-response-time-distributions' = '? c h'
        'opsi database-insights summarize-sql-statistics' = '? c h'
        'opsi database-insights summarize-sql-statistics-time-series' = '? c h'
        'opsi database-insights summarize-sql-statistics-time-series-by-plan' = '? c h'
        'opsi database-insights synchronize-autonomous-database-to-exadata' = '? c h'
        'opsi database-insights test-macs-managed-autonomous-database-insight-connection-credential-by-named-credentials' = '? h'
        'opsi database-insights test-macs-managed-cloud-database-insight-connection-credential-by-iam' = '? h'
        'opsi database-insights test-macs-managed-cloud-database-insight-connection-credential-by-vault' = '? h'
        'opsi database-insights update-autonomous-db' = '? h'
        'opsi database-insights update-em-external-db' = '? h'
        'opsi database-insights update-external-mysql-database-insight' = '? h'
        'opsi database-insights update-macs-external-db' = '? h'
        'opsi database-insights update-macs-managed-autonomous-database-insight' = '? h'
        'opsi database-insights update-macs-managed-cloud-database-insight' = '? h'
        'opsi database-insights update-mds-my-sql-database' = '? h'
        'opsi database-insights update-pe-comanaged-database' = '? h'
        'opsi enterprise-manager-bridges change' = '? c h'
        'opsi enterprise-manager-bridges create' = '? c h'
        'opsi enterprise-manager-bridges delete' = '? h'
        'opsi enterprise-manager-bridges get' = '? h'
        'opsi enterprise-manager-bridges list' = '? c h'
        'opsi enterprise-manager-bridges list-importable-enterprise-manager-entities' = '? h'
        'opsi enterprise-manager-bridges update' = '? h'
        'opsi exadata-insights add-em-external-exadata-members' = '? h'
        'opsi exadata-insights add-macs-managed-cloud-exadata-insight-members' = '? h'
        'opsi exadata-insights add-pe-comanaged-exadata-members' = '? h'
        'opsi exadata-insights change' = '? c h'
        'opsi exadata-insights create-em-external-exadata' = '? c h'
        'opsi exadata-insights create-macs-managed-cloud-exadata-insight' = '? c h'
        'opsi exadata-insights create-pe-comanaged-exadata' = '? c h'
        'opsi exadata-insights delete' = '? h'
        'opsi exadata-insights disable' = '? h'
        'opsi exadata-insights enable-em-external-exadata' = '? h'
        'opsi exadata-insights enable-macs-managed-cloud-exadata-insight' = '? h'
        'opsi exadata-insights enable-pe-comanaged-exadata' = '? h'
        'opsi exadata-insights get' = '? h'
        'opsi exadata-insights list' = '? c h'
        'opsi exadata-insights list-exadata-configurations' = '? c h'
        'opsi exadata-insights summarize-exadata-insight-resource-capacity-trend' = '? c h'
        'opsi exadata-insights summarize-exadata-insight-resource-capacity-trend-aggregated' = '? c h'
        'opsi exadata-insights summarize-exadata-insight-resource-forecast-trend' = '? h'
        'opsi exadata-insights summarize-exadata-insight-resource-forecast-trend-aggregated' = '? c h'
        'opsi exadata-insights summarize-exadata-insight-resource-statistics' = '? h'
        'opsi exadata-insights summarize-exadata-insight-resource-usage' = '? c h'
        'opsi exadata-insights summarize-exadata-insight-resource-usage-aggregated' = '? c h'
        'opsi exadata-insights summarize-exadata-insight-resource-utilization-insight' = '? c h'
        'opsi exadata-insights summarize-exadata-members' = '? h'
        'opsi exadata-insights update-em-external-exadata' = '? h'
        'opsi exadata-insights update-macs-managed-cloud-exadata-insight' = '? h'
        'opsi exadata-insights update-pe-comanaged-exadata' = '? h'
        'opsi host-insights change' = '? c h'
        'opsi host-insights create-em-external-host' = '? c h'
        'opsi host-insights create-macs-cloud-host' = '? c h'
        'opsi host-insights create-macs-external-host' = '? c h'
        'opsi host-insights delete' = '? h'
        'opsi host-insights disable' = '? h'
        'opsi host-insights enable-em-external-host' = '? h'
        'opsi host-insights enable-macs-cloud-host' = '? h'
        'opsi host-insights enable-macs-external-host' = '? h'
        'opsi host-insights get' = '? h'
        'opsi host-insights ingest-host-configuration' = '? h'
        'opsi host-insights ingest-host-metrics' = '? h'
        'opsi host-insights list' = '? c h'
        'opsi host-insights list-host-configurations' = '? c h'
        'opsi host-insights list-hosted-entities' = '? c h'
        'opsi host-insights list-importable-agent-entities' = '? c h'
        'opsi host-insights list-macs-cloud-hosts' = '? c h'
        'opsi host-insights summarize-disk-statistics' = '? c h'
        'opsi host-insights summarize-host-insight-resource-capacity-trend' = '? c h'
        'opsi host-insights summarize-host-insight-resource-forecast-trend' = '? c h'
        'opsi host-insights summarize-host-insight-resource-statistics' = '? c h'
        'opsi host-insights summarize-host-insight-resource-usage' = '? c h'
        'opsi host-insights summarize-host-insight-resource-usage-trend' = '? c h'
        'opsi host-insights summarize-host-insight-resource-utilization-insight' = '? c h'
        'opsi host-insights summarize-host-recommendation' = '? c h'
        'opsi host-insights summarize-io-usage-trend' = '? c h'
        'opsi host-insights summarize-network-usage-trend' = '? c h'
        'opsi host-insights summarize-storage-usage-trend' = '? c h'
        'opsi host-insights summarize-top-processes-usage-trend' = '? c h'
        'opsi host-insights update-em-external-host' = '? h'
        'opsi host-insights update-host-insight-update-pe-comanaged-host-insight-details' = '? h'
        'opsi host-insights update-macs-cloud-host' = '? h'
        'opsi host-insights update-macs-external-host' = '? h'
        'opsi host-insights update-macs-managed-database-host-insight' = '? h'
        'opsi news-reports change' = '? c h'
        'opsi news-reports create' = '? c h'
        'opsi news-reports delete' = '? h'
        'opsi news-reports get' = '? h'
        'opsi news-reports list' = '? c h'
        'opsi news-reports update' = '? h'
        'opsi operations-insights-warehouse-users create' = '? c h'
        'opsi operations-insights-warehouse-users delete' = '? h'
        'opsi operations-insights-warehouse-users get' = '? h'
        'opsi operations-insights-warehouse-users list' = '? c h'
        'opsi operations-insights-warehouse-users update' = '? h'
        'opsi operations-insights-warehouses change' = '? c h'
        'opsi operations-insights-warehouses create' = '? c h'
        'opsi operations-insights-warehouses delete' = '? h'
        'opsi operations-insights-warehouses download-warehouse-wallet' = '? h'
        'opsi operations-insights-warehouses get' = '? h'
        'opsi operations-insights-warehouses list' = '? c h'
        'opsi operations-insights-warehouses rotate-warehouse-wallet' = '? h'
        'opsi operations-insights-warehouses summarize-operations-insights-warehouse-resource-usage' = '? h'
        'opsi operations-insights-warehouses update' = '? h'
        'opsi opsi-configurations change' = '? c h'
        'opsi opsi-configurations create-opsi-ux-configuration-details' = '? c h'
        'opsi opsi-configurations delete' = '? h'
        'opsi opsi-configurations get' = '? h'
        'opsi opsi-configurations list' = '? c h'
        'opsi opsi-configurations summarize-configuration-items' = '? c h'
        'opsi opsi-configurations update-opsi-ux-configuration-details' = '? h'
        'opsi opsi-data-objects get' = '? c h'
        'opsi opsi-data-objects list' = '? c h'
        'opsi opsi-data-objects query-data-standard-query' = '? c h'
        'opsi opsi-data-objects query-data-templatized-query' = '? c h'
        'opsi opsi-private-endpoint change-compartment' = '? c h'
        'opsi opsi-private-endpoint create' = '? c h'
        'opsi opsi-private-endpoint delete' = '? h'
        'opsi opsi-private-endpoint get' = '? h'
        'opsi opsi-private-endpoint list' = '? c h'
        'opsi opsi-private-endpoint update' = '? h'
        'opsi opsi-warehouse-data-objects list' = '? h'
        'opsi opsi-warehouse-data-objects query-warehouse-data-standard-query' = '? h'
        'opsi opsi-warehouse-data-objects query-warehouse-data-templatized-query' = '? h'
        'opsi work-requests get' = '? h'
        'opsi work-requests list' = '? c h'
    }
    return $ociCommandsToShortParams
}